/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.llama2;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.llama2.BedrockLlama2ChatProperties;
import org.springframework.ai.bedrock.llama2.BedrockLlama2ChatClient;
import org.springframework.ai.bedrock.llama2.api.Llama2ChatBedrockApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@AutoConfiguration
@ConditionalOnClass(value={Llama2ChatBedrockApi.class})
@EnableConfigurationProperties(value={BedrockLlama2ChatProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.llama2.chat", name={"enabled"}, havingValue="true")
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockLlama2ChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Llama2ChatBedrockApi llama2Api(AwsCredentialsProvider credentialsProvider, BedrockLlama2ChatProperties properties, BedrockAwsConnectionProperties awsProperties) {
        return new Llama2ChatBedrockApi(properties.getModel(), credentialsProvider, awsProperties.getRegion(), new ObjectMapper(), awsProperties.getTimeout());
    }

    @Bean
    public BedrockLlama2ChatClient llama2ChatClient(Llama2ChatBedrockApi llama2Api, BedrockLlama2ChatProperties properties) {
        return new BedrockLlama2ChatClient(llama2Api, properties.getOptions());
    }
}

