/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.ollama;

import org.springframework.ai.autoconfigure.ollama.OllamaChatProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaConnectionDetails;
import org.springframework.ai.autoconfigure.ollama.OllamaConnectionProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaEmbeddingProperties;
import org.springframework.ai.ollama.OllamaChatClient;
import org.springframework.ai.ollama.OllamaEmbeddingClient;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={OllamaApi.class})
@EnableConfigurationProperties(value={OllamaChatProperties.class, OllamaEmbeddingProperties.class, OllamaConnectionProperties.class})
public class OllamaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OllamaConnectionDetails.class})
    public PropertiesOllamaConnectionDetails ollamaConnectionDetails(OllamaConnectionProperties properties) {
        return new PropertiesOllamaConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public OllamaApi ollamaApi(OllamaConnectionDetails connectionDetails, RestClient.Builder restClientBuilder) {
        return new OllamaApi(connectionDetails.getBaseUrl(), restClientBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.ollama.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OllamaChatClient ollamaChatClient(OllamaApi ollamaApi, OllamaChatProperties properties) {
        return new OllamaChatClient(ollamaApi).withModel(properties.getModel()).withDefaultOptions(properties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.ollama.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OllamaEmbeddingClient ollamaEmbeddingClient(OllamaApi ollamaApi, OllamaEmbeddingProperties properties) {
        return new OllamaEmbeddingClient(ollamaApi).withModel(properties.getModel()).withDefaultOptions(properties.getOptions());
    }

    private static class PropertiesOllamaConnectionDetails
    implements OllamaConnectionDetails {
        private final OllamaConnectionProperties properties;

        PropertiesOllamaConnectionDetails(OllamaConnectionProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getBaseUrl() {
            return this.properties.getBaseUrl();
        }
    }
}

