/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.transformers;

import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.onnxruntime.OrtSession;
import org.springframework.ai.autoconfigure.transformers.TransformersEmbeddingClientProperties;
import org.springframework.ai.transformers.TransformersEmbeddingClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={TransformersEmbeddingClientProperties.class})
@ConditionalOnClass(value={OrtSession.class, HuggingFaceTokenizer.class, TransformersEmbeddingClient.class})
public class TransformersEmbeddingClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.embedding.transformer", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public TransformersEmbeddingClient embeddingClient(TransformersEmbeddingClientProperties properties) {
        TransformersEmbeddingClient embeddingClient = new TransformersEmbeddingClient(properties.getMetadataMode());
        embeddingClient.setDisableCaching(!properties.getCache().isEnabled());
        embeddingClient.setResourceCacheDirectory(properties.getCache().getDirectory());
        embeddingClient.setTokenizerResource(properties.getTokenizer().getUri());
        embeddingClient.setTokenizerOptions(properties.getTokenizer().getOptions());
        embeddingClient.setModelResource(properties.getOnnx().getModelUri());
        embeddingClient.setGpuDeviceId(properties.getOnnx().getGpuDeviceId());
        return embeddingClient;
    }
}

