/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.weaviate;

import org.springframework.ai.autoconfigure.vectorstore.weaviate.WeaviateConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.weaviate.WeaviateVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.WeaviateVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={EmbeddingClient.class, WeaviateVectorStore.class})
@EnableConfigurationProperties(value={WeaviateVectorStoreProperties.class})
public class WeaviateVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WeaviateConnectionDetails.class})
    public PropertiesWeaviateConnectionDetails weaviateConnectionDetails(WeaviateVectorStoreProperties properties) {
        return new PropertiesWeaviateConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public WeaviateVectorStore vectorStore(EmbeddingClient embeddingClient, WeaviateVectorStoreProperties properties, WeaviateConnectionDetails connectionDetails) {
        WeaviateVectorStore.WeaviateVectorStoreConfig.Builder configBuilder = WeaviateVectorStore.WeaviateVectorStoreConfig.builder().withScheme(properties.getScheme()).withApiKey(properties.getApiKey()).withHost(connectionDetails.getHost()).withHeaders(properties.getHeaders()).withObjectClass(properties.getObjectClass()).withFilterableMetadataFields(properties.getFilterField().entrySet().stream().map(e -> new WeaviateVectorStore.WeaviateVectorStoreConfig.MetadataField((String)e.getKey(), (WeaviateVectorStore.WeaviateVectorStoreConfig.MetadataField.Type)e.getValue())).toList()).withConsistencyLevel(properties.getConsistencyLevel());
        return new WeaviateVectorStore(configBuilder.build(), embeddingClient);
    }

    private static class PropertiesWeaviateConnectionDetails
    implements WeaviateConnectionDetails {
        private final WeaviateVectorStoreProperties properties;

        PropertiesWeaviateConnectionDetails(WeaviateVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }
    }
}

