/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.zhipuai;

import java.util.List;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.autoconfigure.zhipuai.ZhipuAiChatProperties;
import org.springframework.ai.autoconfigure.zhipuai.ZhipuAiCommonProperties;
import org.springframework.ai.autoconfigure.zhipuai.ZhipuAiEmbeddingProperties;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.zhipuai.ZhipuAiChatClient;
import org.springframework.ai.zhipuai.ZhipuAiEmbeddingClient;
import org.springframework.ai.zhipuai.api.ZhipuAiApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@EnableConfigurationProperties(value={ZhipuAiEmbeddingProperties.class, ZhipuAiCommonProperties.class, ZhipuAiChatProperties.class})
@ConditionalOnClass(value={ZhipuAiApi.class})
public class ZhipuAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.zhipuai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public ZhipuAiEmbeddingClient zhipuAiEmbeddingClient(ZhipuAiCommonProperties commonProperties, ZhipuAiEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        ZhipuAiApi zhipuAiApi = this.zhipuAiApi(embeddingProperties.getApiKey(), commonProperties.getApiKey(), embeddingProperties.getBaseUrl(), commonProperties.getBaseUrl(), restClientBuilder, responseErrorHandler);
        return new ZhipuAiEmbeddingClient(zhipuAiApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.zhipuai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public ZhipuAiChatClient zhipuAiChatClient(ZhipuAiCommonProperties commonProperties, ZhipuAiChatProperties chatProperties, RestClient.Builder restClientBuilder, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        ZhipuAiApi zhipuAiApi = this.zhipuAiApi(chatProperties.getApiKey(), commonProperties.getApiKey(), chatProperties.getBaseUrl(), commonProperties.getBaseUrl(), restClientBuilder, responseErrorHandler);
        if (!CollectionUtils.isEmpty(toolFunctionCallbacks)) {
            chatProperties.getOptions().getFunctionCallbacks().addAll(toolFunctionCallbacks);
        }
        return new ZhipuAiChatClient(zhipuAiApi, chatProperties.getOptions(), functionCallbackContext, retryTemplate);
    }

    private ZhipuAiApi zhipuAiApi(String apiKey, String commonApiKey, String baseUrl, String commonBaseUrl, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        String resoledBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedApiKey, (String)"Zhipu API key must be set");
        Assert.hasText((String)resoledBaseUrl, (String)"Zhipu base URL must be set");
        return new ZhipuAiApi(resoledBaseUrl, resolvedApiKey, restClientBuilder, responseErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }
}

