/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.glossary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.model.annotation.AtlasJSON;
import org.apache.atlas.model.glossary.AtlasGlossaryBaseObject;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermCategorizationHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.CollectionUtils;

@AtlasJSON
public class AtlasGlossaryTerm
extends AtlasGlossaryBaseObject {
    private List<String> examples;
    private String abbreviation;
    private String usage;
    private AtlasGlossaryHeader anchor;
    private Set<AtlasRelatedObjectId> assignedEntities;
    private Set<AtlasTermCategorizationHeader> categories;
    private Set<AtlasRelatedTermHeader> seeAlso;
    private Set<AtlasRelatedTermHeader> synonyms;
    private Set<AtlasRelatedTermHeader> antonyms;
    private Set<AtlasRelatedTermHeader> preferredTerms;
    private Set<AtlasRelatedTermHeader> preferredToTerms;
    private Set<AtlasRelatedTermHeader> replacementTerms;
    private Set<AtlasRelatedTermHeader> replacedBy;
    private Set<AtlasRelatedTermHeader> translationTerms;
    private Set<AtlasRelatedTermHeader> translatedTerms;
    private Set<AtlasRelatedTermHeader> isA;
    private Set<AtlasRelatedTermHeader> classifies;
    private Set<AtlasRelatedTermHeader> validValues;
    private Set<AtlasRelatedTermHeader> validValuesFor;
    private boolean hasTerms = false;

    public AtlasGlossaryTerm() {
    }

    public AtlasGlossaryTerm(AtlasGlossaryTerm other) {
        super(other);
        this.examples = other.examples;
        this.abbreviation = other.abbreviation;
        this.usage = other.usage;
        this.anchor = other.anchor;
        this.assignedEntities = other.assignedEntities;
        this.categories = other.categories;
        this.seeAlso = other.seeAlso;
        this.synonyms = other.synonyms;
        this.antonyms = other.antonyms;
        this.preferredTerms = other.preferredTerms;
        this.preferredToTerms = other.preferredToTerms;
        this.replacementTerms = other.replacementTerms;
        this.replacedBy = other.replacedBy;
        this.translationTerms = other.translationTerms;
        this.translatedTerms = other.translatedTerms;
        this.isA = other.isA;
        this.classifies = other.classifies;
        this.validValues = other.validValues;
        this.validValuesFor = other.validValuesFor;
        this.hasTerms = other.hasTerms;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public void setExamples(List<String> examples) {
        this.examples = examples;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public AtlasGlossaryHeader getAnchor() {
        return this.anchor;
    }

    public void setAnchor(AtlasGlossaryHeader anchor) {
        this.anchor = anchor;
    }

    public Set<AtlasTermCategorizationHeader> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<AtlasTermCategorizationHeader> categories) {
        this.categories = categories;
    }

    public void addCategory(AtlasTermCategorizationHeader category) {
        Set<AtlasTermCategorizationHeader> categories = this.categories;
        if (categories == null) {
            categories = new HashSet<AtlasTermCategorizationHeader>();
        }
        categories.add(category);
        this.setCategories(categories);
    }

    public Set<AtlasRelatedObjectId> getAssignedEntities() {
        return this.assignedEntities;
    }

    public void setAssignedEntities(Set<AtlasRelatedObjectId> assignedEntities) {
        this.assignedEntities = assignedEntities;
    }

    public void addAssignedEntity(AtlasRelatedObjectId atlasObjectId) {
        Set<AtlasRelatedObjectId> assignedEntities = this.assignedEntities;
        if (assignedEntities == null) {
            assignedEntities = new HashSet<AtlasRelatedObjectId>();
        }
        assignedEntities.add(atlasObjectId);
        this.setAssignedEntities(assignedEntities);
    }

    public Set<AtlasRelatedTermHeader> getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(Set<AtlasRelatedTermHeader> seeAlso) {
        this.seeAlso = seeAlso;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Set<AtlasRelatedTermHeader> synonyms) {
        this.synonyms = synonyms;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getAntonyms() {
        return this.antonyms;
    }

    public void setAntonyms(Set<AtlasRelatedTermHeader> antonyms) {
        this.antonyms = antonyms;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getPreferredTerms() {
        return this.preferredTerms;
    }

    public void setPreferredTerms(Set<AtlasRelatedTermHeader> preferredTerms) {
        this.preferredTerms = preferredTerms;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getPreferredToTerms() {
        return this.preferredToTerms;
    }

    public void setPreferredToTerms(Set<AtlasRelatedTermHeader> preferredToTerms) {
        this.preferredToTerms = preferredToTerms;
    }

    public Set<AtlasRelatedTermHeader> getReplacementTerms() {
        return this.replacementTerms;
    }

    public void setReplacementTerms(Set<AtlasRelatedTermHeader> replacementTerms) {
        this.replacementTerms = replacementTerms;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(Set<AtlasRelatedTermHeader> replacedBy) {
        this.replacedBy = replacedBy;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getTranslationTerms() {
        return this.translationTerms;
    }

    public void setTranslationTerms(Set<AtlasRelatedTermHeader> translationTerms) {
        this.translationTerms = translationTerms;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getTranslatedTerms() {
        return this.translatedTerms;
    }

    public void setTranslatedTerms(Set<AtlasRelatedTermHeader> translatedTerms) {
        this.translatedTerms = translatedTerms;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getIsA() {
        return this.isA;
    }

    public void setIsA(Set<AtlasRelatedTermHeader> isA) {
        this.isA = isA;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getClassifies() {
        return this.classifies;
    }

    public void setClassifies(Set<AtlasRelatedTermHeader> classifies) {
        this.classifies = classifies;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getValidValues() {
        return this.validValues;
    }

    public void setValidValues(Set<AtlasRelatedTermHeader> validValues) {
        this.validValues = validValues;
        this.hasTerms = true;
    }

    public Set<AtlasRelatedTermHeader> getValidValuesFor() {
        return this.validValuesFor;
    }

    public void setValidValuesFor(Set<AtlasRelatedTermHeader> validValuesFor) {
        this.validValuesFor = validValuesFor;
        this.hasTerms = true;
    }

    @JsonIgnore
    public String toAuditString() {
        AtlasGlossaryTerm t = new AtlasGlossaryTerm();
        t.setGuid(this.getGuid());
        t.setName(this.getName());
        t.setQualifiedName(this.getQualifiedName());
        return AtlasType.toJson(t);
    }

    @JsonIgnore
    public boolean hasTerms() {
        return this.hasTerms;
    }

    @Override
    @JsonIgnore
    public void setAttribute(String attrName, String attrVal) {
        Objects.requireNonNull(attrName, "AtlasGlossaryTerm attribute name");
        switch (attrName) {
            case "name": {
                this.setName(attrVal);
                break;
            }
            case "shortDescription": {
                this.setShortDescription(attrVal);
                break;
            }
            case "longDescription": {
                this.setLongDescription(attrVal);
                break;
            }
            case "abbreviation": {
                this.setAbbreviation(attrVal);
                break;
            }
            case "usage": {
                this.setUsage(attrVal);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid attribute '" + attrName + "' for object AtlasGlossaryTerm");
            }
        }
    }

    @JsonIgnore
    public Map<Relation, Set<AtlasRelatedTermHeader>> getRelatedTerms() {
        HashMap<Relation, Set<AtlasRelatedTermHeader>> ret = new HashMap<Relation, Set<AtlasRelatedTermHeader>>();
        if (CollectionUtils.isNotEmpty(this.seeAlso)) {
            ret.put(Relation.SEE_ALSO, this.seeAlso);
        }
        if (CollectionUtils.isNotEmpty(this.synonyms)) {
            ret.put(Relation.SYNONYMS, this.synonyms);
        }
        if (CollectionUtils.isNotEmpty(this.antonyms)) {
            ret.put(Relation.ANTONYMS, this.antonyms);
        }
        if (CollectionUtils.isNotEmpty(this.preferredTerms)) {
            ret.put(Relation.PREFERRED_TERMS, this.preferredTerms);
        }
        if (CollectionUtils.isNotEmpty(this.preferredToTerms)) {
            ret.put(Relation.PREFERRED_TO_TERMS, this.preferredToTerms);
        }
        if (CollectionUtils.isNotEmpty(this.replacementTerms)) {
            ret.put(Relation.REPLACEMENT_TERMS, this.replacementTerms);
        }
        if (CollectionUtils.isNotEmpty(this.replacedBy)) {
            ret.put(Relation.REPLACED_BY, this.replacedBy);
        }
        if (CollectionUtils.isNotEmpty(this.translationTerms)) {
            ret.put(Relation.TRANSLATION_TERMS, this.translationTerms);
        }
        if (CollectionUtils.isNotEmpty(this.translatedTerms)) {
            ret.put(Relation.TRANSLATED_TERMS, this.translatedTerms);
        }
        if (CollectionUtils.isNotEmpty(this.isA)) {
            ret.put(Relation.ISA, this.isA);
        }
        if (CollectionUtils.isNotEmpty(this.classifies)) {
            ret.put(Relation.CLASSIFIES, this.classifies);
        }
        if (CollectionUtils.isNotEmpty(this.validValues)) {
            ret.put(Relation.VALID_VALUES, this.validValues);
        }
        if (CollectionUtils.isNotEmpty(this.validValuesFor)) {
            ret.put(Relation.VALID_VALUES_FOR, this.validValuesFor);
        }
        return ret;
    }

    @Override
    protected StringBuilder toString(StringBuilder sb) {
        sb.append("examples=").append(this.examples);
        sb.append(", abbreviation='").append(this.abbreviation).append('\'');
        sb.append(", usage='").append(this.usage).append('\'');
        sb.append(", anchor=").append(this.anchor);
        sb.append(", assignedEntities=").append(this.assignedEntities);
        sb.append(", categories=").append(this.categories);
        sb.append(", seeAlso=").append(this.seeAlso);
        sb.append(", synonyms=").append(this.synonyms);
        sb.append(", antonyms=").append(this.antonyms);
        sb.append(", preferredTerms=").append(this.preferredTerms);
        sb.append(", preferredToTerms=").append(this.preferredToTerms);
        sb.append(", replacementTerms=").append(this.replacementTerms);
        sb.append(", replacedBy=").append(this.replacedBy);
        sb.append(", translationTerms=").append(this.translationTerms);
        sb.append(", translatedTerms=").append(this.translatedTerms);
        sb.append(", isA=").append(this.isA);
        sb.append(", classifies=").append(this.classifies);
        sb.append(", validValues=").append(this.validValues);
        sb.append(", validValuesFor=").append(this.validValuesFor);
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtlasGlossaryTerm)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasGlossaryTerm that = (AtlasGlossaryTerm)o;
        return Objects.equals(this.examples, that.examples) && Objects.equals(this.abbreviation, that.abbreviation) && Objects.equals(this.usage, that.usage) && Objects.equals(this.anchor, that.anchor) && Objects.equals(this.assignedEntities, that.assignedEntities) && Objects.equals(this.categories, that.categories) && Objects.equals(this.seeAlso, that.seeAlso) && Objects.equals(this.synonyms, that.synonyms) && Objects.equals(this.antonyms, that.antonyms) && Objects.equals(this.preferredTerms, that.preferredTerms) && Objects.equals(this.preferredToTerms, that.preferredToTerms) && Objects.equals(this.replacementTerms, that.replacementTerms) && Objects.equals(this.replacedBy, that.replacedBy) && Objects.equals(this.translationTerms, that.translationTerms) && Objects.equals(this.translatedTerms, that.translatedTerms) && Objects.equals(this.isA, that.isA) && Objects.equals(this.classifies, that.classifies) && Objects.equals(this.validValues, that.validValues) && Objects.equals(this.validValuesFor, that.validValuesFor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.examples, this.abbreviation, this.usage, this.anchor, this.assignedEntities, this.categories, this.seeAlso, this.synonyms, this.antonyms, this.preferredTerms, this.preferredToTerms, this.replacementTerms, this.replacedBy, this.translationTerms, this.translatedTerms, this.isA, this.classifies, this.validValues, this.validValuesFor);
    }

    public static enum Relation {
        SEE_ALSO("AtlasGlossaryRelatedTerm", "seeAlso"),
        SYNONYMS("AtlasGlossarySynonym", "synonyms"),
        ANTONYMS("AtlasGlossaryAntonym", "antonyms"),
        PREFERRED_TO_TERMS("AtlasGlossaryPreferredTerm", "preferredToTerms", true),
        PREFERRED_TERMS("AtlasGlossaryPreferredTerm", "preferredTerms"),
        REPLACEMENT_TERMS("AtlasGlossaryReplacementTerm", "replacementTerms", true),
        REPLACED_BY("AtlasGlossaryReplacementTerm", "replacedBy"),
        TRANSLATION_TERMS("AtlasGlossaryTranslation", "translationTerms", true),
        TRANSLATED_TERMS("AtlasGlossaryTranslation", "translatedTerms"),
        ISA("AtlasGlossaryIsARelationship", "isA", true),
        CLASSIFIES("AtlasGlossaryIsARelationship", "classifies"),
        VALID_VALUES("AtlasGlossaryValidValue", "validValues", true),
        VALID_VALUES_FOR("AtlasGlossaryValidValue", "validValuesFor");

        private String name;
        private String attrName;
        private boolean isEnd2Attr;

        private Relation(String name, String attrName) {
            this(name, attrName, false);
        }

        private Relation(String name, String attrName, boolean isEnd2Attr) {
            this.name = name;
            this.attrName = attrName;
            this.isEnd2Attr = isEnd2Attr;
        }

        public String getName() {
            return this.name;
        }

        @JsonValue
        public String getAttrName() {
            return this.attrName;
        }

        public boolean isEnd2Attr() {
            return this.isEnd2Attr;
        }
    }
}

