/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public class FloorOperatorConversion
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.FLOOR;
    }

    @Override
    @Nullable
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexCall call = (RexCall)rexNode;
        RexNode arg = (RexNode)call.getOperands().get(0);
        String druidExpression = DruidExpressions.toDruidExpression(arg, rowType, druidQuery);
        if (druidExpression == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return DruidQuery.format("floor(%s)", druidExpression);
        }
        if (call.getOperands().size() == 2) {
            TimeZone tz = arg.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE ? TimeZone.getTimeZone(druidQuery.getConnectionConfig().timeZone()) : DateTimeUtils.UTC_ZONE;
            Granularity granularity = DruidDateTimeUtils.extractGranularity((RexNode)call, tz.getID());
            if (granularity == null) {
                return null;
            }
            String isoPeriodFormat = DruidDateTimeUtils.toISOPeriodFormat(granularity.getType());
            if (isoPeriodFormat == null) {
                return null;
            }
            return DruidExpressions.applyTimestampFloor(druidExpression, isoPeriodFormat, null, tz);
        }
        return null;
    }
}

