/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import jakarta.activation.FileDataSource;
import jakarta.activation.FileTypeMap;
import java.io.File;
import org.apache.camel.util.MimeTypeHelper;

public class CamelFileDataSource
extends FileDataSource {
    private final String fileName;
    private FileTypeMap typeMap;

    public CamelFileDataSource(File file) {
        this(file, file.getName());
    }

    public CamelFileDataSource(File file, String fileName) {
        super(file);
        this.fileName = fileName;
    }

    public String getContentType() {
        String answer = MimeTypeHelper.probeMimeType((String)this.fileName);
        if (answer == null) {
            answer = this.typeMap == null ? FileTypeMap.getDefaultFileTypeMap().getContentType(this.fileName) : this.typeMap.getContentType(this.fileName);
        }
        return answer;
    }

    public void setFileTypeMap(FileTypeMap map) {
        this.typeMap = map;
    }

    public String getName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return super.getName();
    }
}

