/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;

public abstract class AbstractComponentBuilder<C extends Component> {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public C build() {
        C component = this.buildConcreteComponent();
        this.configureComponentProperties((Component)component);
        return component;
    }

    public C build(CamelContext context) {
        C component = this.buildConcreteComponent();
        this.configureComponentProperties((Component)component, context);
        return component;
    }

    public void register(CamelContext context, String componentName) {
        C component = this.buildConcreteComponent();
        this.configureComponentProperties((Component)component, context);
        context.addComponent(componentName, component);
    }

    public void doSetProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected abstract C buildConcreteComponent();

    protected abstract boolean setPropertyOnComponent(Component var1, String var2, Object var3);

    private void configureComponentProperties(Component component) {
        this.properties.forEach((key, value) -> this.setPropertyOnComponent(component, (String)key, value));
    }

    private void configureComponentProperties(Component component, CamelContext context) {
        this.properties.forEach((key, value) -> this.setPropertyOnComponent(component, (String)key, this.resolvePropertyValue(value, context)));
    }

    private Object resolvePropertyValue(Object value, CamelContext context) {
        if (value instanceof String) {
            return context.resolvePropertyPlaceholders((String)value);
        }
        return value;
    }
}

