/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.NonManagedService;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="event", displayName="Camel Events", description="The most recent Camel events")
@Configurer(extended=true)
public class EventConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="25", description="Maximum capacity of last number of events to capture (capacity must be between 25 and 1000)")
    private int capacity = 25;
    private CamelEvent[] events;
    private final AtomicInteger posEvents = new AtomicInteger();
    private CamelEvent.RouteEvent[] routeEvents;
    private final AtomicInteger posRoutes = new AtomicInteger();
    private CamelEvent.ExchangeEvent[] exchangeEvents;
    private final AtomicInteger posExchanges = new AtomicInteger();
    private final ConsoleEventNotifier listener = new ConsoleEventNotifier();

    public EventConsole() {
        super("camel", "event", "Camel Events", "The most recent Camel events");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    protected void doInit() throws Exception {
        if (this.capacity > 1000 || this.capacity < 25) {
            throw new IllegalArgumentException("Capacity must be between 25 and 1000");
        }
        this.events = new CamelEvent[this.capacity];
        this.routeEvents = new CamelEvent.RouteEvent[this.capacity];
        this.exchangeEvents = new CamelEvent.ExchangeEvent[this.capacity];
    }

    protected void doStart() throws Exception {
        this.getCamelContext().getManagementStrategy().addEventNotifier((EventNotifier)this.listener);
    }

    protected void doStop() throws Exception {
        this.getCamelContext().getManagementStrategy().removeEventNotifier((EventNotifier)this.listener);
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        int pos = this.posEvents.get();
        sb.append(EventConsole.appendTextEvents(this.events, "Camel", pos, this.capacity));
        sb.append("\n");
        pos = this.posRoutes.get();
        sb.append(EventConsole.appendTextEvents((CamelEvent[])this.routeEvents, "Route", pos, this.capacity));
        sb.append("\n");
        pos = this.posExchanges.get();
        sb.append(EventConsole.appendTextEvents((CamelEvent[])this.exchangeEvents, "Exchange", pos, this.capacity));
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        int pos = this.posEvents.get();
        List<JsonObject> arr = EventConsole.appendJSonEvents(this.events, pos, this.capacity);
        if (!arr.isEmpty()) {
            root.put((Object)"events", arr);
        }
        if (!(arr = EventConsole.appendJSonEvents((CamelEvent[])this.routeEvents, pos = this.posRoutes.get(), this.capacity)).isEmpty()) {
            root.put((Object)"routeEvents", arr);
        }
        if (!(arr = EventConsole.appendJSonEvents((CamelEvent[])this.exchangeEvents, pos = this.posExchanges.get(), this.capacity)).isEmpty()) {
            root.put((Object)"exchangeEvents", arr);
        }
        return root;
    }

    private static String appendTextEvents(CamelEvent[] events, String kind, int cursor, int capacity) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int added = 0;
        ++cursor;
        CamelEvent event = events[cursor %= capacity];
        while (pos < capacity) {
            if (event != null) {
                ++added;
                if (event.getTimestamp() > 0L) {
                    sb.append(String.format("    %s (age: %s)\n", event, TimeUtils.printSince((long)event.getTimestamp())));
                } else {
                    sb.append(String.format("    %s\n", event));
                }
            }
            ++pos;
            ++cursor;
            event = events[cursor %= capacity];
        }
        if (added > 0) {
            sb.insert(0, String.format("Last %s %s Events:\n", added, kind));
        }
        return sb.toString();
    }

    private static List<JsonObject> appendJSonEvents(CamelEvent[] events, int cursor, int capacity) {
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        int pos = 0;
        ++cursor;
        CamelEvent event = events[cursor %= capacity];
        while (pos < capacity) {
            if (event != null) {
                JsonObject jo = new JsonObject();
                jo.put((Object)"type", (Object)event.getType().toString());
                if (event.getTimestamp() > 0L) {
                    jo.put((Object)"timestamp", (Object)event.getTimestamp());
                }
                if (event instanceof CamelEvent.ExchangeEvent) {
                    CamelEvent.ExchangeEvent ee = (CamelEvent.ExchangeEvent)event;
                    jo.put((Object)"exchangeId", (Object)ee.getExchange().getExchangeId());
                }
                jo.put((Object)"message", (Object)event.toString());
                arr.add(jo);
            }
            ++pos;
            ++cursor;
            event = events[cursor %= capacity];
        }
        return arr;
    }

    private class ConsoleEventNotifier
    extends EventNotifierSupport
    implements NonManagedService {
        private ConsoleEventNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            if (event instanceof CamelEvent.ExchangeEvent) {
                CamelEvent.ExchangeEvent ce = (CamelEvent.ExchangeEvent)event;
                int pos = EventConsole.this.posExchanges.getAndUpdate(operand -> ++operand % EventConsole.this.capacity);
                EventConsole.this.exchangeEvents[pos] = ce;
            } else if (event instanceof CamelEvent.RouteEvent) {
                CamelEvent.RouteEvent re = (CamelEvent.RouteEvent)event;
                int pos = EventConsole.this.posRoutes.getAndUpdate(operand -> ++operand % EventConsole.this.capacity);
                EventConsole.this.routeEvents[pos] = re;
            } else {
                int pos = EventConsole.this.posEvents.getAndUpdate(operand -> ++operand % EventConsole.this.capacity);
                EventConsole.this.events[pos] = event;
            }
        }
    }
}

