/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DevConsole(name="processor", description="Processor information")
public class ProcessorDevConsole
extends AbstractDevConsole {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorDevConsole.class);
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String ACTION = "action";

    public ProcessorDevConsole() {
        super("camel", "processor", "Processor", "Processor information");
    }

    protected String doCallText(Map<String, Object> options) {
        int max;
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int n = max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return "";
        }
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        StringBuilder sb = new StringBuilder();
        AtomicInteger counter = new AtomicInteger();
        for (Route r : this.getCamelContext().getRoutes()) {
            ManagedRouteMBean mrb = mcc.getManagedRoute(r.getRouteId());
            this.includeProcessorsText(mrb, sb, filter, max, counter);
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    private void includeProcessorsText(ManagedRouteMBean mrb, StringBuilder sb, String filter, int max, AtomicInteger counter) {
        Collection ids;
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return;
        }
        ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null || !ProcessorDevConsole.accept(mp, filter)) continue;
            mps.add(mp);
        }
        mps.sort(Comparator.comparingInt(ManagedProcessorMBean::getIndex));
        for (ManagedProcessorMBean mp : mps) {
            String ago;
            Date last;
            if (counter.incrementAndGet() > max) {
                return;
            }
            sb.append("\n");
            sb.append(String.format("\n        Route Id: %s", mp.getRouteId()));
            sb.append(String.format("\n        Id: %s", mp.getProcessorId()));
            if (mp.getNodePrefixId() != null) {
                sb.append(String.format("\n        Node Prefix Id: %s", mp.getNodePrefixId()));
            }
            if (mp.getDescription() != null) {
                sb.append(String.format("\n        Description: %s", mp.getDescription()));
            }
            sb.append(String.format("\n        Processor: %s", mp.getProcessorName()));
            sb.append(String.format("\n        Level: %d", mp.getLevel()));
            if (mp.getSourceLocation() != null) {
                Object loc = mp.getSourceLocation();
                if (mp.getSourceLineNumber() != null) {
                    loc = (String)loc + ":" + mp.getSourceLineNumber();
                }
                sb.append(String.format("\n        Source: %s", loc));
            }
            sb.append(String.format("\n        State: %s", mp.getState()));
            sb.append(String.format("\n        Disabled: %s", mp.getDisabled()));
            sb.append(String.format("\n        Total: %s", mp.getExchangesTotal()));
            sb.append(String.format("\n        Failed: %s", mp.getExchangesFailed()));
            sb.append(String.format("\n        Inflight: %s", mp.getExchangesInflight()));
            long idle = mp.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n        Idle Since: %s", TimeUtils.printDuration((long)idle)));
            } else {
                sb.append(String.format("\n        Idle Since: %s", ""));
            }
            sb.append(String.format("\n        Mean Time: %s", TimeUtils.printDuration((long)mp.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n        Max Time: %s", TimeUtils.printDuration((long)mp.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n        Min Time: %s", TimeUtils.printDuration((long)mp.getMinProcessingTime(), (boolean)true)));
            if (mp.getExchangesTotal() > 0L) {
                sb.append(String.format("\n        Last Time: %s", TimeUtils.printDuration((long)mp.getLastProcessingTime(), (boolean)true)));
                sb.append(String.format("\n        Delta Time: %s", TimeUtils.printDuration((long)mp.getDeltaProcessingTime(), (boolean)true)));
            }
            if ((last = mp.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n        Since Last Completed: %s", ago));
            }
            if ((last = mp.getLastExchangeFailureTimestamp()) == null) continue;
            ago = TimeUtils.printSince((long)last.getTime());
            sb.append(String.format("\n        Since Last Failed: %s", ago));
        }
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        int max;
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int n = max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return new JsonObject();
        }
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        for (Route r : this.getCamelContext().getRoutes()) {
            ManagedRouteMBean mrb = mcc.getManagedRoute(r.getRouteId());
            this.includeProcessorsJson(mrb, arr, filter, max);
        }
        root.put((Object)"processors", (Object)arr);
        return root;
    }

    private void includeProcessorsJson(ManagedRouteMBean mrb, JsonArray arr, String filter, int max) {
        Collection ids;
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return;
        }
        ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null || !ProcessorDevConsole.accept(mp, filter)) continue;
            mps.add(mp);
        }
        mps.sort(Comparator.comparingInt(ManagedProcessorMBean::getIndex));
        for (ManagedProcessorMBean mp : mps) {
            if (arr.size() > max) {
                return;
            }
            JsonObject jo = new JsonObject();
            arr.add((Object)jo);
            jo.put((Object)"routeId", (Object)mp.getRouteId());
            jo.put((Object)"id", (Object)mp.getProcessorId());
            if (mp.getNodePrefixId() != null) {
                jo.put((Object)"nodePrefixId", (Object)mp.getNodePrefixId());
            }
            if (mp.getDescription() != null) {
                jo.put((Object)"description", (Object)mp.getDescription());
            }
            if (mp.getSourceLocation() != null) {
                Object loc = mp.getSourceLocation();
                if (mp.getSourceLineNumber() != null) {
                    loc = (String)loc + ":" + mp.getSourceLineNumber();
                }
                jo.put((Object)"source", loc);
            }
            jo.put((Object)"state", (Object)mp.getState());
            jo.put((Object)"disabled", (Object)mp.getDisabled());
            String line = ConsoleHelper.loadSourceLine(this.getCamelContext(), mp.getSourceLocation(), mp.getSourceLineNumber());
            if (line != null) {
                JsonArray ca = new JsonArray();
                jo.put((Object)"code", (Object)ca);
                JsonObject c = new JsonObject();
                if (mp.getSourceLineNumber() != null) {
                    c.put((Object)"line", (Object)mp.getSourceLineNumber());
                }
                c.put((Object)"code", (Object)Jsoner.escape((String)line));
                c.put((Object)"match", (Object)true);
                ca.add((Object)c);
            }
            jo.put((Object)"processor", (Object)mp.getProcessorName());
            jo.put((Object)"level", (Object)mp.getLevel());
            JsonObject stats = ProcessorDevConsole.getStatsObject(mp);
            jo.put((Object)"statistics", (Object)stats);
        }
    }

    private static JsonObject getStatsObject(ManagedProcessorMBean mp) {
        Date last;
        JsonObject stats = new JsonObject();
        stats.put((Object)"idleSince", (Object)mp.getIdleSince());
        stats.put((Object)"exchangesTotal", (Object)mp.getExchangesTotal());
        stats.put((Object)"exchangesFailed", (Object)mp.getExchangesFailed());
        stats.put((Object)"exchangesInflight", (Object)mp.getExchangesInflight());
        stats.put((Object)"meanProcessingTime", (Object)mp.getMeanProcessingTime());
        stats.put((Object)"maxProcessingTime", (Object)mp.getMaxProcessingTime());
        stats.put((Object)"minProcessingTime", (Object)mp.getMinProcessingTime());
        if (mp.getExchangesTotal() > 0L) {
            stats.put((Object)"lastProcessingTime", (Object)mp.getLastProcessingTime());
            stats.put((Object)"deltaProcessingTime", (Object)mp.getDeltaProcessingTime());
        }
        if ((last = mp.getLastExchangeCreatedTimestamp()) != null) {
            stats.put((Object)"lastCreatedExchangeTimestamp", (Object)last.getTime());
        }
        if ((last = mp.getLastExchangeCompletedTimestamp()) != null) {
            stats.put((Object)"lastCompletedExchangeTimestamp", (Object)last.getTime());
        }
        if ((last = mp.getLastExchangeFailureTimestamp()) != null) {
            stats.put((Object)"lastFailedExchangeTimestamp", (Object)last.getTime());
        }
        return stats;
    }

    private static boolean accept(ManagedProcessorMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String onlyName = LoggerHelper.sourceNameOnly((String)mrb.getSourceLocation());
        return PatternHelper.matchPattern((String)mrb.getProcessorId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter) || PatternHelper.matchPattern((String)onlyName, (String)filter);
    }

    protected void doAction(CamelContext camelContext, String command, String filter) {
        if (filter == null) {
            filter = "*";
        }
        String[] patterns = filter.split(",");
        List<Object> mps = new ArrayList();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        for (Route route : this.getCamelContext().getRoutes()) {
            ManagedRouteMBean mrb = mcc.getManagedRoute(route.getRouteId());
            try {
                for (String id : mrb.processorIds()) {
                    mps.add(mcc.getManagedProcessor(id));
                }
            }
            catch (Exception exception) {
            }
        }
        mps = mps.stream().filter(mp -> {
            for (String p : patterns) {
                if (!PatternHelper.matchPattern((String)mp.getProcessorId(), (String)p) && !PatternHelper.matchPattern((String)mp.getRouteId(), (String)p)) continue;
                return true;
            }
            return false;
        }).toList();
        for (ManagedProcessorMBean managedProcessorMBean : mps) {
            try {
                if ("start".equals(command)) {
                    managedProcessorMBean.start();
                    continue;
                }
                if ("stop".equals(command)) {
                    managedProcessorMBean.stop();
                    continue;
                }
                if ("disable".equals(command)) {
                    managedProcessorMBean.disable();
                    continue;
                }
                if (!"enable".equals(command)) continue;
                managedProcessorMBean.enable();
            }
            catch (Exception e) {
                LOG.warn("Error {} processor: {} due to: {}. This exception is ignored.", new Object[]{command, managedProcessorMBean.getProcessorId(), e.getMessage(), e});
            }
        }
    }
}

