/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.camel.Route;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spi.annotations.HealthCheck;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.backoff.BackOffTimer;

@HealthCheck(value="route-controller-check")
public class RouteControllerHealthCheck
extends AbstractHealthCheck {
    public RouteControllerHealthCheck() {
        super("camel", "route-controller");
    }

    public int getOrder() {
        return -2147482648;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        boolean up = false;
        RouteController rc = this.getCamelContext().getRouteController();
        if (rc != null) {
            boolean bl = up = !rc.hasUnhealthyRoutes();
            if (!up && rc instanceof SupervisingRouteController) {
                SupervisingRouteController src = (SupervisingRouteController)rc;
                TreeSet<Route> routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
                routes.addAll(src.getRestartingRoutes());
                for (Route route : routes) {
                    this.builderDetails(builder, src, route, false);
                }
                routes = new TreeSet<Route>(Comparator.comparing(Route::getId));
                routes.addAll(src.getExhaustedRoutes());
                for (Route route : routes) {
                    this.builderDetails(builder, src, route, true);
                }
            }
        }
        if (up) {
            builder.up();
        } else {
            builder.detail("route.controller", (Object)"Starting routes in progress");
            builder.down();
        }
    }

    private void builderDetails(HealthCheckResultBuilder builder, SupervisingRouteController src, Route route, boolean exhausted) {
        String routeId = route.getRouteId();
        Throwable cause = src.getRestartException(routeId);
        if (cause != null) {
            String status = src.getRouteStatus(routeId).name();
            String uri = route.getEndpoint().getEndpointBaseUri();
            uri = URISupport.sanitizeUri((String)uri);
            BackOffTimer.Task state = src.getRestartingRouteState(routeId);
            long attempts = state != null ? state.getCurrentAttempts() : 0L;
            long elapsed = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getCurrentElapsedTime() : 0L;
            long last = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getLastAttemptTime() : 0L;
            long next = state != null && BackOffTimer.Task.Status.Active == state.getStatus() ? state.getNextAttemptTime() : 0L;
            String key = "route." + routeId;
            builder.detail(key + ".id", (Object)routeId);
            builder.detail(key + ".status", (Object)status);
            builder.detail(key + ".phase", (Object)(exhausted ? "Exhausted" : "Restarting"));
            builder.detail(key + ".uri", (Object)uri);
            builder.detail(key + ".attempts", (Object)attempts);
            builder.detail(key + ".lastAttempt", (Object)last);
            builder.detail(key + ".nextAttempt", (Object)next);
            builder.detail(key + ".elapsed", (Object)elapsed);
            if (cause.getMessage() != null) {
                builder.detail(key + ".error", (Object)cause.getMessage());
                if (builder.error() == null) {
                    builder.error(cause);
                    String msg = exhausted ? String.format("Restarting route: %s is exhausted after %s attempts due %s. No more attempts will be made and the route is no longer supervised by this route controller and remains as stopped.", routeId, attempts, cause.getMessage()) : String.format("Failed restarting route: %s attempt: %s due: %s", routeId, attempts, cause.getMessage());
                    builder.message(msg);
                }
            }
        }
    }
}

