/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckAware;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.RouteHealthCheck;
import org.apache.camel.spi.HttpResponseAware;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerHealthCheck
extends RouteHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerHealthCheck.class);
    private final Consumer consumer;
    private final String sanitizedUri;

    public ConsumerHealthCheck(Route route, String id) {
        super(route, id);
        this.consumer = route.getConsumer();
        this.sanitizedUri = URISupport.sanitizeUri((String)this.consumer.getEndpoint().getEndpointUri());
    }

    @Override
    protected void doCallCheck(HealthCheckResultBuilder builder, Map<String, Object> options) {
        HealthCheckAware healthCheckAware;
        HealthCheck hc;
        Consumer consumer;
        boolean external;
        boolean up = builder.state().compareTo((Enum)HealthCheck.State.UP) == 0;
        boolean bl = external = this.route.getRouteController() == null && this.route.isAutoStartup() == false;
        if (up && !external && (consumer = this.consumer) instanceof HealthCheckAware && (hc = (healthCheckAware = (HealthCheckAware)consumer).getHealthCheck()) != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Calling HealthCheck on consumer route: {}", (Object)this.route.getRouteId());
            }
            HealthCheck.Result result = hc.call(options);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("HealthCheck consumer route: {} -> {}", (Object)this.route.getRouteId(), (Object)result.getState());
            }
            builder.detail("endpoint.uri", (Object)this.sanitizedUri);
            builder.state(result.getState());
            if (result.getMessage().isPresent()) {
                builder.message((String)result.getMessage().get());
            }
            if (result.getError().isPresent()) {
                HttpResponseAware httpResponseAware;
                int code;
                Throwable cause = (Throwable)result.getError().get();
                builder.error(cause);
                if (cause instanceof HttpResponseAware && (code = (httpResponseAware = (HttpResponseAware)cause).getHttpResponseCode()) > 0) {
                    builder.detail("http.response.code", (Object)code);
                }
            }
            builder.details(result.getDetails());
        }
    }
}

