/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.support.GZIPHelper;

@Converter(generateLoader=true)
public final class HttpConverter {
    private HttpConverter() {
    }

    @Converter
    public static HttpServletRequest toServletRequest(Message message) {
        if (message instanceof HttpMessage) {
            HttpMessage hm = (HttpMessage)message;
            return hm.getRequest();
        }
        return null;
    }

    @Converter
    public static HttpServletResponse toServletResponse(Message message) {
        if (message instanceof HttpMessage) {
            HttpMessage hm = (HttpMessage)message;
            return hm.getResponse();
        }
        return null;
    }

    @Converter
    public static ServletInputStream toServletInputStream(HttpMessage message) throws IOException {
        HttpServletRequest request = HttpConverter.toServletRequest((Message)message);
        if (request != null) {
            return request.getInputStream();
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(HttpMessage message, Exchange exchange) throws Exception {
        return HttpConverter.toInputStream(HttpConverter.toServletRequest((Message)message), exchange);
    }

    @Converter
    public static BufferedReader toReader(HttpMessage message) throws IOException {
        HttpServletRequest request = HttpConverter.toServletRequest((Message)message);
        if (request != null) {
            return request.getReader();
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(HttpServletRequest request, Exchange exchange) throws IOException {
        if (request == null) {
            return null;
        }
        ServletInputStream is = request.getInputStream();
        if (is != null && is.available() <= 0) {
            return is;
        }
        if (exchange == null || !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            String contentEncoding = request.getHeader("Content-Encoding");
            return GZIPHelper.uncompressGzip((String)contentEncoding, (InputStream)is);
        }
        return is;
    }
}

