/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import org.apache.camel.Exchange;
import org.apache.camel.http.common.HttpHeaderFilterStrategy;

public class HttpRestHeaderFilterStrategy
extends HttpHeaderFilterStrategy {
    private final String templateUri;
    private final String queryParameters;

    public HttpRestHeaderFilterStrategy(String templateUri, String queryParameters) {
        this.templateUri = templateUri;
        this.queryParameters = queryParameters;
    }

    public boolean applyFilterToCamelHeaders(String headerName, Object headerValue, Exchange exchange) {
        boolean answer = super.applyFilterToCamelHeaders(headerName, headerValue, exchange);
        if (!answer) {
            String token;
            if (this.templateUri != null && this.templateUri.contains(token = "{" + headerName + "}")) {
                answer = true;
            }
            if (!answer && this.queryParameters != null) {
                String[] tokens = new String[]{"={" + headerName + "}", "={" + headerName + "?}", "=%7B" + headerName + "%7D", "=%7B" + headerName + "%3F%7D"};
                for (String token2 : tokens) {
                    if (!this.queryParameters.contains(token2)) continue;
                    answer = true;
                    break;
                }
            }
        }
        return answer;
    }
}

