/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.util.StringTokenizer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.snmp.OIDList;
import org.apache.camel.util.StringHelper;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

@Converter(generateLoader=true)
public final class SnmpConverters {
    public static final String SNMP_TAG = "snmp";
    public static final String ENTRY_TAG = "entry";
    public static final String OID_TAG = "oid";
    public static final String VALUE_TAG = "value";
    private static final String SNMP_TAG_OPEN = "<snmp>";
    private static final String SNMP_TAG_CLOSE = "</snmp>";
    private static final String ENTRY_TAG_OPEN = "<entry>";
    private static final String ENTRY_TAG_CLOSE = "</entry>";
    private static final String OID_TAG_OPEN = "<oid>";
    private static final String OID_TAG_CLOSE = "</oid>";
    private static final String VALUE_TAG_OPEN = "<value>";
    private static final String VALUE_TAG_CLOSE = "</value>";

    private SnmpConverters() {
    }

    @Converter
    public static OIDList toOIDList(String s, Exchange exchange) {
        try {
            OIDList list = new OIDList();
            if (s != null && s.contains(",")) {
                StringTokenizer strTok = new StringTokenizer(s, ",");
                while (strTok.hasMoreTokens()) {
                    String tok = strTok.nextToken();
                    if (tok == null || tok.isBlank()) continue;
                    list.add(new OID(tok.trim()));
                }
            } else if (s != null) {
                list.add(new OID(s.trim()));
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void entryAppend(StringBuilder sb, String tag, String value) {
        sb.append(ENTRY_TAG_OPEN);
        sb.append('<').append(tag).append('>');
        sb.append(value);
        sb.append("</").append(tag).append('>');
        sb.append(ENTRY_TAG_CLOSE);
    }

    @Converter
    public static String toString(PDU pdu) {
        StringBuilder sb = new StringBuilder();
        if (pdu.getType() == -92) {
            sb.append("<").append(SNMP_TAG).append(" messageType=\"v1\">");
        } else {
            sb.append(SNMP_TAG_OPEN);
        }
        if (pdu.getType() == -92) {
            PDUv1 v1pdu = (PDUv1)pdu;
            SnmpConverters.entryAppend(sb, "enterprise", v1pdu.getEnterprise().toString());
            SnmpConverters.entryAppend(sb, "agent-addr", v1pdu.getAgentAddress().toString());
            SnmpConverters.entryAppend(sb, "generic-trap", Integer.toString(v1pdu.getGenericTrap()));
            SnmpConverters.entryAppend(sb, "specific-trap", Integer.toString(v1pdu.getSpecificTrap()));
            SnmpConverters.entryAppend(sb, "time-stamp", Long.toString(v1pdu.getTimestamp()));
        }
        for (Object o : pdu.getVariableBindings()) {
            VariableBinding b = (VariableBinding)o;
            sb.append(ENTRY_TAG_OPEN);
            sb.append(OID_TAG_OPEN);
            sb.append(b.getOid().toString());
            sb.append(OID_TAG_CLOSE);
            sb.append(VALUE_TAG_OPEN);
            sb.append(StringHelper.xmlEncode((String)b.getVariable().toString()));
            sb.append(VALUE_TAG_CLOSE);
            sb.append(ENTRY_TAG_CLOSE);
        }
        sb.append(SNMP_TAG_CLOSE);
        return sb.toString();
    }
}

