/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.spi.XmlCamelContextConfigurer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringBootXmlCamelContextConfigurer
implements XmlCamelContextConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootXmlCamelContextConfigurer.class);

    public void configure(ApplicationContext applicationContext, SpringCamelContext camelContext) {
        CamelConfigurationProperties config = (CamelConfigurationProperties)applicationContext.getBean(CamelConfigurationProperties.class);
        if (config != null) {
            try {
                LOG.debug("Merging XML based CamelContext with Spring Boot configuration properties");
                CamelAutoConfiguration.doConfigureCamelContext(applicationContext, (CamelContext)camelContext, config);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }
}

