// $ANTLR 3.5.2 Parser.g 2024-10-12 14:40:50

    package org.apache.cassandra.cql3;

    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashSet;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.*;
    import org.apache.cassandra.cql3.conditions.*;
    import org.apache.cassandra.cql3.functions.*;
    import org.apache.cassandra.cql3.functions.masking.*;
    import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;
    import org.apache.cassandra.cql3.selection.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.statements.schema.*;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.schema.ColumnMetadata;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

@SuppressWarnings("all")
public class Cql_Parser extends Parser {
	public static final int EOF=-1;
	public static final int T__207=207;
	public static final int T__208=208;
	public static final int T__209=209;
	public static final int T__210=210;
	public static final int T__211=211;
	public static final int T__212=212;
	public static final int T__213=213;
	public static final int T__214=214;
	public static final int T__215=215;
	public static final int T__216=216;
	public static final int T__217=217;
	public static final int T__218=218;
	public static final int T__219=219;
	public static final int T__220=220;
	public static final int T__221=221;
	public static final int T__222=222;
	public static final int T__223=223;
	public static final int T__224=224;
	public static final int T__225=225;
	public static final int T__226=226;
	public static final int T__227=227;
	public static final int T__228=228;
	public static final int T__229=229;
	public static final int T__230=230;
	public static final int A=4;
	public static final int B=5;
	public static final int BOOLEAN=6;
	public static final int C=7;
	public static final int COMMENT=8;
	public static final int D=9;
	public static final int DIGIT=10;
	public static final int DURATION=11;
	public static final int DURATION_ISO_8601_PERIOD_DESIGNATORS=12;
	public static final int DURATION_ISO_8601_TIME_DESIGNATORS=13;
	public static final int DURATION_ISO_8601_WEEK_PERIOD_DESIGNATOR=14;
	public static final int DURATION_UNIT=15;
	public static final int E=16;
	public static final int EMPTY_QUOTED_NAME=17;
	public static final int EXPONENT=18;
	public static final int F=19;
	public static final int FLOAT=20;
	public static final int G=21;
	public static final int H=22;
	public static final int HEX=23;
	public static final int HEXNUMBER=24;
	public static final int I=25;
	public static final int IDENT=26;
	public static final int INTEGER=27;
	public static final int J=28;
	public static final int K=29;
	public static final int K_ACCESS=30;
	public static final int K_ADD=31;
	public static final int K_AGGREGATE=32;
	public static final int K_AGGREGATES=33;
	public static final int K_ALL=34;
	public static final int K_ALLOW=35;
	public static final int K_ALTER=36;
	public static final int K_AND=37;
	public static final int K_ANN=38;
	public static final int K_APPLY=39;
	public static final int K_AS=40;
	public static final int K_ASC=41;
	public static final int K_ASCII=42;
	public static final int K_AUTHORIZE=43;
	public static final int K_BATCH=44;
	public static final int K_BEGIN=45;
	public static final int K_BIGINT=46;
	public static final int K_BLOB=47;
	public static final int K_BOOLEAN=48;
	public static final int K_BY=49;
	public static final int K_CALLED=50;
	public static final int K_CAST=51;
	public static final int K_CIDRS=52;
	public static final int K_CLUSTER=53;
	public static final int K_CLUSTERING=54;
	public static final int K_COLUMNFAMILY=55;
	public static final int K_COMPACT=56;
	public static final int K_CONTAINS=57;
	public static final int K_COUNT=58;
	public static final int K_COUNTER=59;
	public static final int K_CREATE=60;
	public static final int K_CUSTOM=61;
	public static final int K_DATACENTERS=62;
	public static final int K_DATE=63;
	public static final int K_DECIMAL=64;
	public static final int K_DEFAULT=65;
	public static final int K_DELETE=66;
	public static final int K_DESC=67;
	public static final int K_DESCRIBE=68;
	public static final int K_DISTINCT=69;
	public static final int K_DOUBLE=70;
	public static final int K_DROP=71;
	public static final int K_DURATION=72;
	public static final int K_ENTRIES=73;
	public static final int K_EXECUTE=74;
	public static final int K_EXISTS=75;
	public static final int K_FILTERING=76;
	public static final int K_FINALFUNC=77;
	public static final int K_FLOAT=78;
	public static final int K_FROM=79;
	public static final int K_FROZEN=80;
	public static final int K_FULL=81;
	public static final int K_FUNCTION=82;
	public static final int K_FUNCTIONS=83;
	public static final int K_GRANT=84;
	public static final int K_GROUP=85;
	public static final int K_HASHED=86;
	public static final int K_IDENTITY=87;
	public static final int K_IF=88;
	public static final int K_IN=89;
	public static final int K_INDEX=90;
	public static final int K_INET=91;
	public static final int K_INITCOND=92;
	public static final int K_INPUT=93;
	public static final int K_INSERT=94;
	public static final int K_INT=95;
	public static final int K_INTERNALS=96;
	public static final int K_INTO=97;
	public static final int K_IS=98;
	public static final int K_JSON=99;
	public static final int K_KEY=100;
	public static final int K_KEYS=101;
	public static final int K_KEYSPACE=102;
	public static final int K_KEYSPACES=103;
	public static final int K_LANGUAGE=104;
	public static final int K_LIKE=105;
	public static final int K_LIMIT=106;
	public static final int K_LIST=107;
	public static final int K_LOGIN=108;
	public static final int K_MAP=109;
	public static final int K_MASKED=110;
	public static final int K_MATERIALIZED=111;
	public static final int K_MAXWRITETIME=112;
	public static final int K_MBEAN=113;
	public static final int K_MBEANS=114;
	public static final int K_MODIFY=115;
	public static final int K_NEGATIVE_INFINITY=116;
	public static final int K_NEGATIVE_NAN=117;
	public static final int K_NOLOGIN=118;
	public static final int K_NORECURSIVE=119;
	public static final int K_NOSUPERUSER=120;
	public static final int K_NOT=121;
	public static final int K_NULL=122;
	public static final int K_OF=123;
	public static final int K_ON=124;
	public static final int K_ONLY=125;
	public static final int K_OPTIONS=126;
	public static final int K_OR=127;
	public static final int K_ORDER=128;
	public static final int K_PARTITION=129;
	public static final int K_PASSWORD=130;
	public static final int K_PER=131;
	public static final int K_PERMISSION=132;
	public static final int K_PERMISSIONS=133;
	public static final int K_POSITIVE_INFINITY=134;
	public static final int K_POSITIVE_NAN=135;
	public static final int K_PRIMARY=136;
	public static final int K_RENAME=137;
	public static final int K_REPLACE=138;
	public static final int K_RETURNS=139;
	public static final int K_REVOKE=140;
	public static final int K_ROLE=141;
	public static final int K_ROLES=142;
	public static final int K_SCHEMA=143;
	public static final int K_SELECT=144;
	public static final int K_SELECT_MASKED=145;
	public static final int K_SET=146;
	public static final int K_SFUNC=147;
	public static final int K_SMALLINT=148;
	public static final int K_STATIC=149;
	public static final int K_STORAGE=150;
	public static final int K_STYPE=151;
	public static final int K_SUPERUSER=152;
	public static final int K_TABLES=153;
	public static final int K_TEXT=154;
	public static final int K_TIME=155;
	public static final int K_TIMESTAMP=156;
	public static final int K_TIMEUUID=157;
	public static final int K_TINYINT=158;
	public static final int K_TO=159;
	public static final int K_TOKEN=160;
	public static final int K_TRIGGER=161;
	public static final int K_TRUNCATE=162;
	public static final int K_TTL=163;
	public static final int K_TUPLE=164;
	public static final int K_TYPE=165;
	public static final int K_TYPES=166;
	public static final int K_UNLOGGED=167;
	public static final int K_UNMASK=168;
	public static final int K_UNSET=169;
	public static final int K_UPDATE=170;
	public static final int K_USE=171;
	public static final int K_USER=172;
	public static final int K_USERS=173;
	public static final int K_USING=174;
	public static final int K_UUID=175;
	public static final int K_VALUES=176;
	public static final int K_VARCHAR=177;
	public static final int K_VARINT=178;
	public static final int K_VECTOR=179;
	public static final int K_VIEW=180;
	public static final int K_WHERE=181;
	public static final int K_WITH=182;
	public static final int K_WRITETIME=183;
	public static final int L=184;
	public static final int LETTER=185;
	public static final int M=186;
	public static final int MULTILINE_COMMENT=187;
	public static final int N=188;
	public static final int O=189;
	public static final int P=190;
	public static final int Q=191;
	public static final int QMARK=192;
	public static final int QUOTED_NAME=193;
	public static final int R=194;
	public static final int RANGE=195;
	public static final int S=196;
	public static final int STRING_LITERAL=197;
	public static final int T=198;
	public static final int U=199;
	public static final int UUID=200;
	public static final int V=201;
	public static final int W=202;
	public static final int WS=203;
	public static final int X=204;
	public static final int Y=205;
	public static final int Z=206;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators
	public CqlParser gCql;
	public CqlParser gParent;


	public Cql_Parser(TokenStream input, CqlParser gCql) {
		this(input, new RecognizerSharedState(), gCql);
	}
	public Cql_Parser(TokenStream input, RecognizerSharedState state, CqlParser gCql) {
		super(input, state);
		this.gCql = gCql;
		gParent = gCql;
	}

	@Override public String[] getTokenNames() { return CqlParser.tokenNames; }
	@Override public String getGrammarFileName() { return "Parser.g"; }


	    private final List<ErrorListener> listeners = new ArrayList<ErrorListener>();
	    protected final List<ColumnIdentifier> bindVariables = new ArrayList<ColumnIdentifier>();

	    public static final Set<String> reservedTypeNames = new HashSet<String>()
	    {{
	        add("byte");
	        add("complex");
	        add("enum");
	        add("date");
	        add("interval");
	        add("macaddr");
	        add("bitstring");
	    }};

	    public AbstractMarker.Raw newBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.Raw marker = new AbstractMarker.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public AbstractMarker.INRaw newINBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.INRaw marker = new AbstractMarker.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.Raw newTupleBindVariables(ColumnIdentifier name)
	    {
	        Tuples.Raw marker = new Tuples.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.INRaw newTupleINBindVariables(ColumnIdentifier name)
	    {
	        Tuples.INRaw marker = new Tuples.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Json.Marker newJsonBindVariables(ColumnIdentifier name)
	    {
	        Json.Marker marker = new Json.Marker(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public void addErrorListener(ErrorListener listener)
	    {
	        this.listeners.add(listener);
	    }

	    public void removeErrorListener(ErrorListener listener)
	    {
	        this.listeners.remove(listener);
	    }

	    public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, tokenNames, e);
	    }

	    protected void addRecognitionError(String msg)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, msg);
	    }

	    public Map<String, String> convertPropertyMap(Maps.Literal map)
	    {
	        if (map == null || map.entries == null || map.entries.isEmpty())
	            return Collections.<String, String>emptyMap();

	        Map<String, String> res = new HashMap<>(map.entries.size());

	        for (Pair<Term.Raw, Term.Raw> entry : map.entries)
	        {
	            // Because the parser tries to be smart and recover on error (to
	            // allow displaying more than one error I suppose), we have null
	            // entries in there. Just skip those, a proper error will be thrown in the end.
	            if (entry.left == null || entry.right == null)
	                break;

	            if (!(entry.left instanceof Constants.Literal))
	            {
	                String msg = "Invalid property name: " + entry.left;
	                if (entry.left instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }
	            if (!(entry.right instanceof Constants.Literal))
	            {
	                String msg = "Invalid property value: " + entry.right + " for property: " + entry.left;
	                if (entry.right instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }

	            if (res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText()) != null)
	            {
	                addRecognitionError(String.format("Multiple definition for property " + ((Constants.Literal)entry.left).getRawText()));
	            }
	        }

	        return res;
	    }

	    public void addRawUpdate(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, Operation.RawUpdate update)
	    {
	        for (Pair<ColumnIdentifier, Operation.RawUpdate> p : operations)
	        {
	            if (p.left.equals(key) && !p.right.isCompatibleWith(update))
	                addRecognitionError("Multiple incompatible setting of column " + key);
	        }
	        operations.add(Pair.create(key, update));
	    }

	    public Set<Permission> filterPermissions(Set<Permission> permissions, IResource resource)
	    {
	        if (resource == null)
	            return Collections.emptySet();
	        Set<Permission> filtered = new HashSet<>(permissions);
	        filtered.retainAll(resource.applicablePermissions());
	        if (filtered.isEmpty())
	            addRecognitionError("Resource type " + resource.getClass().getSimpleName() +
	                                    " does not support any of the requested permissions");

	        return filtered;
	    }

	    public String canonicalizeObjectName(String s, boolean enforcePattern)
	    {
	        // these two conditions are here because technically they are valid
	        // ObjectNames, but we want to restrict their use without adding unnecessary
	        // work to JMXResource construction as that also happens on hotter code paths
	        if ("".equals(s))
	            addRecognitionError("Empty JMX object name supplied");

	        if ("*:*".equals(s))
	            addRecognitionError("Please use ALL MBEANS instead of wildcard pattern");

	        try
	        {
	            javax.management.ObjectName objectName = javax.management.ObjectName.getInstance(s);
	            if (enforcePattern && !objectName.isPattern())
	                addRecognitionError("Plural form used, but non-pattern JMX object name specified (" + s + ")");
	            return objectName.getCanonicalName();
	        }
	        catch (javax.management.MalformedObjectNameException e)
	        {
	          addRecognitionError(s + " is not a valid JMX object name");
	          return s;
	        }
	    }

	    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    // Recovery methods are overridden to avoid wasting work on recovering from errors when the result will be
	    // ignored anyway.
	    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	    @Override
	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException
	    {
	        throw new MismatchedTokenException(ttype, input);
	    }

	    @Override
	    public void recover(IntStream input, RecognitionException re)
	    {
	        // Do nothing.
	    }



	// $ANTLR start "cqlStatement"
	// Parser.g:207:1: cqlStatement returns [CQLStatement.Raw stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement |st41= describeStatement |st42= addIdentityStatement |st43= dropIdentityStatement );
	public final CQLStatement.Raw cqlStatement() throws RecognitionException {
		CQLStatement.Raw stmt = null;


		SelectStatement.RawStatement st1 =null;
		ModificationStatement.Parsed st2 =null;
		UpdateStatement.ParsedUpdate st3 =null;
		BatchStatement.Parsed st4 =null;
		DeleteStatement.Parsed st5 =null;
		UseStatement st6 =null;
		TruncateStatement st7 =null;
		CreateKeyspaceStatement.Raw st8 =null;
		CreateTableStatement.Raw st9 =null;
		CreateIndexStatement.Raw st10 =null;
		DropKeyspaceStatement.Raw st11 =null;
		DropTableStatement.Raw st12 =null;
		DropIndexStatement.Raw st13 =null;
		AlterTableStatement.Raw st14 =null;
		AlterKeyspaceStatement.Raw st15 =null;
		GrantPermissionsStatement st16 =null;
		RevokePermissionsStatement st17 =null;
		ListPermissionsStatement st18 =null;
		CreateRoleStatement st19 =null;
		AlterRoleStatement st20 =null;
		DropRoleStatement st21 =null;
		ListRolesStatement st22 =null;
		CreateTriggerStatement.Raw st23 =null;
		DropTriggerStatement.Raw st24 =null;
		CreateTypeStatement.Raw st25 =null;
		AlterTypeStatement.Raw st26 =null;
		DropTypeStatement.Raw st27 =null;
		CreateFunctionStatement.Raw st28 =null;
		DropFunctionStatement.Raw st29 =null;
		CreateAggregateStatement.Raw st30 =null;
		DropAggregateStatement.Raw st31 =null;
		CreateRoleStatement st32 =null;
		AlterRoleStatement st33 =null;
		DropRoleStatement st34 =null;
		ListRolesStatement st35 =null;
		GrantRoleStatement st36 =null;
		RevokeRoleStatement st37 =null;
		CreateViewStatement.Raw st38 =null;
		DropViewStatement.Raw st39 =null;
		AlterViewStatement.Raw st40 =null;
		DescribeStatement st41 =null;
		AddIdentityStatement st42 =null;
		DropIdentityStatement st43 =null;

		try {
			// Parser.g:209:5: (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement |st41= describeStatement |st42= addIdentityStatement |st43= dropIdentityStatement )
			int alt1=43;
			alt1 = dfa1.predict(input);
			switch (alt1) {
				case 1 :
					// Parser.g:209:7: st1= selectStatement
					{
					pushFollow(FOLLOW_selectStatement_in_cqlStatement59);
					st1=selectStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st1; }
					}
					break;
				case 2 :
					// Parser.g:210:7: st2= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_cqlStatement88);
					st2=insertStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st2; }
					}
					break;
				case 3 :
					// Parser.g:211:7: st3= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_cqlStatement117);
					st3=updateStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st3; }
					}
					break;
				case 4 :
					// Parser.g:212:7: st4= batchStatement
					{
					pushFollow(FOLLOW_batchStatement_in_cqlStatement146);
					st4=batchStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st4; }
					}
					break;
				case 5 :
					// Parser.g:213:7: st5= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_cqlStatement176);
					st5=deleteStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st5; }
					}
					break;
				case 6 :
					// Parser.g:214:7: st6= useStatement
					{
					pushFollow(FOLLOW_useStatement_in_cqlStatement205);
					st6=useStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st6; }
					}
					break;
				case 7 :
					// Parser.g:215:7: st7= truncateStatement
					{
					pushFollow(FOLLOW_truncateStatement_in_cqlStatement237);
					st7=truncateStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st7; }
					}
					break;
				case 8 :
					// Parser.g:216:7: st8= createKeyspaceStatement
					{
					pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement264);
					st8=createKeyspaceStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st8; }
					}
					break;
				case 9 :
					// Parser.g:217:7: st9= createTableStatement
					{
					pushFollow(FOLLOW_createTableStatement_in_cqlStatement285);
					st9=createTableStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st9; }
					}
					break;
				case 10 :
					// Parser.g:218:7: st10= createIndexStatement
					{
					pushFollow(FOLLOW_createIndexStatement_in_cqlStatement308);
					st10=createIndexStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st10; }
					}
					break;
				case 11 :
					// Parser.g:219:7: st11= dropKeyspaceStatement
					{
					pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement331);
					st11=dropKeyspaceStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st11; }
					}
					break;
				case 12 :
					// Parser.g:220:7: st12= dropTableStatement
					{
					pushFollow(FOLLOW_dropTableStatement_in_cqlStatement353);
					st12=dropTableStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st12; }
					}
					break;
				case 13 :
					// Parser.g:221:7: st13= dropIndexStatement
					{
					pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement378);
					st13=dropIndexStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st13; }
					}
					break;
				case 14 :
					// Parser.g:222:7: st14= alterTableStatement
					{
					pushFollow(FOLLOW_alterTableStatement_in_cqlStatement403);
					st14=alterTableStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st14; }
					}
					break;
				case 15 :
					// Parser.g:223:7: st15= alterKeyspaceStatement
					{
					pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement427);
					st15=alterKeyspaceStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st15; }
					}
					break;
				case 16 :
					// Parser.g:224:7: st16= grantPermissionsStatement
					{
					pushFollow(FOLLOW_grantPermissionsStatement_in_cqlStatement448);
					st16=grantPermissionsStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st16; }
					}
					break;
				case 17 :
					// Parser.g:225:7: st17= revokePermissionsStatement
					{
					pushFollow(FOLLOW_revokePermissionsStatement_in_cqlStatement466);
					st17=revokePermissionsStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st17; }
					}
					break;
				case 18 :
					// Parser.g:226:7: st18= listPermissionsStatement
					{
					pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement483);
					st18=listPermissionsStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st18; }
					}
					break;
				case 19 :
					// Parser.g:227:7: st19= createUserStatement
					{
					pushFollow(FOLLOW_createUserStatement_in_cqlStatement502);
					st19=createUserStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st19; }
					}
					break;
				case 20 :
					// Parser.g:228:7: st20= alterUserStatement
					{
					pushFollow(FOLLOW_alterUserStatement_in_cqlStatement526);
					st20=alterUserStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st20; }
					}
					break;
				case 21 :
					// Parser.g:229:7: st21= dropUserStatement
					{
					pushFollow(FOLLOW_dropUserStatement_in_cqlStatement551);
					st21=dropUserStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st21; }
					}
					break;
				case 22 :
					// Parser.g:230:7: st22= listUsersStatement
					{
					pushFollow(FOLLOW_listUsersStatement_in_cqlStatement577);
					st22=listUsersStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st22; }
					}
					break;
				case 23 :
					// Parser.g:231:7: st23= createTriggerStatement
					{
					pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement602);
					st23=createTriggerStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st23; }
					}
					break;
				case 24 :
					// Parser.g:232:7: st24= dropTriggerStatement
					{
					pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement623);
					st24=dropTriggerStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st24; }
					}
					break;
				case 25 :
					// Parser.g:233:7: st25= createTypeStatement
					{
					pushFollow(FOLLOW_createTypeStatement_in_cqlStatement646);
					st25=createTypeStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st25; }
					}
					break;
				case 26 :
					// Parser.g:234:7: st26= alterTypeStatement
					{
					pushFollow(FOLLOW_alterTypeStatement_in_cqlStatement670);
					st26=alterTypeStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st26; }
					}
					break;
				case 27 :
					// Parser.g:235:7: st27= dropTypeStatement
					{
					pushFollow(FOLLOW_dropTypeStatement_in_cqlStatement695);
					st27=dropTypeStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st27; }
					}
					break;
				case 28 :
					// Parser.g:236:7: st28= createFunctionStatement
					{
					pushFollow(FOLLOW_createFunctionStatement_in_cqlStatement721);
					st28=createFunctionStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st28; }
					}
					break;
				case 29 :
					// Parser.g:237:7: st29= dropFunctionStatement
					{
					pushFollow(FOLLOW_dropFunctionStatement_in_cqlStatement741);
					st29=dropFunctionStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st29; }
					}
					break;
				case 30 :
					// Parser.g:238:7: st30= createAggregateStatement
					{
					pushFollow(FOLLOW_createAggregateStatement_in_cqlStatement763);
					st30=createAggregateStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st30; }
					}
					break;
				case 31 :
					// Parser.g:239:7: st31= dropAggregateStatement
					{
					pushFollow(FOLLOW_dropAggregateStatement_in_cqlStatement782);
					st31=dropAggregateStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st31; }
					}
					break;
				case 32 :
					// Parser.g:240:7: st32= createRoleStatement
					{
					pushFollow(FOLLOW_createRoleStatement_in_cqlStatement803);
					st32=createRoleStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st32; }
					}
					break;
				case 33 :
					// Parser.g:241:7: st33= alterRoleStatement
					{
					pushFollow(FOLLOW_alterRoleStatement_in_cqlStatement827);
					st33=alterRoleStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st33; }
					}
					break;
				case 34 :
					// Parser.g:242:7: st34= dropRoleStatement
					{
					pushFollow(FOLLOW_dropRoleStatement_in_cqlStatement852);
					st34=dropRoleStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st34; }
					}
					break;
				case 35 :
					// Parser.g:243:7: st35= listRolesStatement
					{
					pushFollow(FOLLOW_listRolesStatement_in_cqlStatement878);
					st35=listRolesStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st35; }
					}
					break;
				case 36 :
					// Parser.g:244:7: st36= grantRoleStatement
					{
					pushFollow(FOLLOW_grantRoleStatement_in_cqlStatement903);
					st36=grantRoleStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st36; }
					}
					break;
				case 37 :
					// Parser.g:245:7: st37= revokeRoleStatement
					{
					pushFollow(FOLLOW_revokeRoleStatement_in_cqlStatement928);
					st37=revokeRoleStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st37; }
					}
					break;
				case 38 :
					// Parser.g:246:7: st38= createMaterializedViewStatement
					{
					pushFollow(FOLLOW_createMaterializedViewStatement_in_cqlStatement952);
					st38=createMaterializedViewStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st38; }
					}
					break;
				case 39 :
					// Parser.g:247:7: st39= dropMaterializedViewStatement
					{
					pushFollow(FOLLOW_dropMaterializedViewStatement_in_cqlStatement964);
					st39=dropMaterializedViewStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st39; }
					}
					break;
				case 40 :
					// Parser.g:248:7: st40= alterMaterializedViewStatement
					{
					pushFollow(FOLLOW_alterMaterializedViewStatement_in_cqlStatement978);
					st40=alterMaterializedViewStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st40; }
					}
					break;
				case 41 :
					// Parser.g:249:7: st41= describeStatement
					{
					pushFollow(FOLLOW_describeStatement_in_cqlStatement991);
					st41=describeStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st41; }
					}
					break;
				case 42 :
					// Parser.g:250:7: st42= addIdentityStatement
					{
					pushFollow(FOLLOW_addIdentityStatement_in_cqlStatement1017);
					st42=addIdentityStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st42; }
					}
					break;
				case 43 :
					// Parser.g:251:7: st43= dropIdentityStatement
					{
					pushFollow(FOLLOW_dropIdentityStatement_in_cqlStatement1040);
					st43=dropIdentityStatement();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = st43; }
					}
					break;

			}
			if ( state.backtracking==0 ) { if (stmt != null) stmt.setBindVariables(bindVariables); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "cqlStatement"



	// $ANTLR start "useStatement"
	// Parser.g:257:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
	public final UseStatement useStatement() throws RecognitionException {
		UseStatement stmt = null;


		String ks =null;

		try {
			// Parser.g:258:5: ( K_USE ks= keyspaceName )
			// Parser.g:258:7: K_USE ks= keyspaceName
			{
			match(input,K_USE,FOLLOW_K_USE_in_useStatement1075); if (state.failed) return stmt;
			pushFollow(FOLLOW_keyspaceName_in_useStatement1079);
			ks=keyspaceName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new UseStatement(ks); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "useStatement"



	// $ANTLR start "selectStatement"
	// Parser.g:267:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT ( ( K_JSON selectClause )=> K_JSON )? sclause= selectClause K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_GROUP K_BY groupByClause[groups] ( ',' groupByClause[groups] )* )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_PER K_PARTITION K_LIMIT rows= intValue )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
	public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
		SelectStatement.RawStatement expr = null;


		ParserRuleReturnScope sclause =null;
		QualifiedName cf =null;
		WhereClause.Builder wclause =null;
		Term.Raw rows =null;


		        Term.Raw limit = null;
		        Term.Raw perPartitionLimit = null;
		        List<Ordering.Raw> orderings = new ArrayList<>();
		        List<Selectable.Raw> groups = new ArrayList<>();
		        boolean allowFiltering = false;
		        boolean isJson = false;
		    
		try {
			// Parser.g:276:5: ( K_SELECT ( ( K_JSON selectClause )=> K_JSON )? sclause= selectClause K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_GROUP K_BY groupByClause[groups] ( ',' groupByClause[groups] )* )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_PER K_PARTITION K_LIMIT rows= intValue )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
			// Parser.g:276:7: K_SELECT ( ( K_JSON selectClause )=> K_JSON )? sclause= selectClause K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_GROUP K_BY groupByClause[groups] ( ',' groupByClause[groups] )* )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_PER K_PARTITION K_LIMIT rows= intValue )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
			{
			match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement1113); if (state.failed) return expr;
			// Parser.g:278:7: ( ( K_JSON selectClause )=> K_JSON )?
			int alt2=2;
			alt2 = dfa2.predict(input);
			switch (alt2) {
				case 1 :
					// Parser.g:278:9: ( K_JSON selectClause )=> K_JSON
					{
					match(input,K_JSON,FOLLOW_K_JSON_in_selectStatement1139); if (state.failed) return expr;
					if ( state.backtracking==0 ) { isJson = true; }
					}
					break;

			}

			pushFollow(FOLLOW_selectClause_in_selectStatement1148);
			sclause=selectClause();
			state._fsp--;
			if (state.failed) return expr;
			match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement1156); if (state.failed) return expr;
			pushFollow(FOLLOW_columnFamilyName_in_selectStatement1160);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:280:7: ( K_WHERE wclause= whereClause )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==K_WHERE) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// Parser.g:280:9: K_WHERE wclause= whereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement1170); if (state.failed) return expr;
					pushFollow(FOLLOW_whereClause_in_selectStatement1174);
					wclause=whereClause();
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

			}

			// Parser.g:281:7: ( K_GROUP K_BY groupByClause[groups] ( ',' groupByClause[groups] )* )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==K_GROUP) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// Parser.g:281:9: K_GROUP K_BY groupByClause[groups] ( ',' groupByClause[groups] )*
					{
					match(input,K_GROUP,FOLLOW_K_GROUP_in_selectStatement1187); if (state.failed) return expr;
					match(input,K_BY,FOLLOW_K_BY_in_selectStatement1189); if (state.failed) return expr;
					pushFollow(FOLLOW_groupByClause_in_selectStatement1191);
					groupByClause(groups);
					state._fsp--;
					if (state.failed) return expr;
					// Parser.g:281:44: ( ',' groupByClause[groups] )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==213) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// Parser.g:281:46: ',' groupByClause[groups]
							{
							match(input,213,FOLLOW_213_in_selectStatement1196); if (state.failed) return expr;
							pushFollow(FOLLOW_groupByClause_in_selectStatement1198);
							groupByClause(groups);
							state._fsp--;
							if (state.failed) return expr;
							}
							break;

						default :
							break loop4;
						}
					}

					}
					break;

			}

			// Parser.g:282:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==K_ORDER) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// Parser.g:282:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
					{
					match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement1215); if (state.failed) return expr;
					match(input,K_BY,FOLLOW_K_BY_in_selectStatement1217); if (state.failed) return expr;
					pushFollow(FOLLOW_orderByClause_in_selectStatement1219);
					orderByClause(orderings);
					state._fsp--;
					if (state.failed) return expr;
					// Parser.g:282:47: ( ',' orderByClause[orderings] )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( (LA6_0==213) ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// Parser.g:282:49: ',' orderByClause[orderings]
							{
							match(input,213,FOLLOW_213_in_selectStatement1224); if (state.failed) return expr;
							pushFollow(FOLLOW_orderByClause_in_selectStatement1226);
							orderByClause(orderings);
							state._fsp--;
							if (state.failed) return expr;
							}
							break;

						default :
							break loop6;
						}
					}

					}
					break;

			}

			// Parser.g:283:7: ( K_PER K_PARTITION K_LIMIT rows= intValue )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==K_PER) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// Parser.g:283:9: K_PER K_PARTITION K_LIMIT rows= intValue
					{
					match(input,K_PER,FOLLOW_K_PER_in_selectStatement1243); if (state.failed) return expr;
					match(input,K_PARTITION,FOLLOW_K_PARTITION_in_selectStatement1245); if (state.failed) return expr;
					match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement1247); if (state.failed) return expr;
					pushFollow(FOLLOW_intValue_in_selectStatement1251);
					rows=intValue();
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { perPartitionLimit = rows; }
					}
					break;

			}

			// Parser.g:284:7: ( K_LIMIT rows= intValue )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==K_LIMIT) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// Parser.g:284:9: K_LIMIT rows= intValue
					{
					match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement1266); if (state.failed) return expr;
					pushFollow(FOLLOW_intValue_in_selectStatement1270);
					rows=intValue();
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { limit = rows; }
					}
					break;

			}

			// Parser.g:285:7: ( K_ALLOW K_FILTERING )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==K_ALLOW) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// Parser.g:285:9: K_ALLOW K_FILTERING
					{
					match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement1285); if (state.failed) return expr;
					match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement1287); if (state.failed) return expr;
					if ( state.backtracking==0 ) { allowFiltering = true; }
					}
					break;

			}

			if ( state.backtracking==0 ) {
			          SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
			                                                                             groups,
			                                                                             (sclause!=null?((Cql_Parser.selectClause_return)sclause).isDistinct:false),
			                                                                             allowFiltering,
			                                                                             isJson);
			          WhereClause where = wclause == null ? WhereClause.empty() : wclause.build();
			          expr = new SelectStatement.RawStatement(cf, params, (sclause!=null?((Cql_Parser.selectClause_return)sclause).selectors:null), where, limit, perPartitionLimit);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectStatement"


	public static class selectClause_return extends ParserRuleReturnScope {
		public boolean isDistinct;
		public List<RawSelector> selectors;
	};


	// $ANTLR start "selectClause"
	// Parser.g:297:1: selectClause returns [boolean isDistinct, List<RawSelector> selectors] : ( ( K_DISTINCT selectors )=> K_DISTINCT s= selectors |s= selectors );
	public final Cql_Parser.selectClause_return selectClause() throws RecognitionException {
		Cql_Parser.selectClause_return retval = new Cql_Parser.selectClause_return();
		retval.start = input.LT(1);

		List<RawSelector> s =null;

		 retval.isDistinct = false; 
		try {
			// Parser.g:300:5: ( ( K_DISTINCT selectors )=> K_DISTINCT s= selectors |s= selectors )
			int alt11=2;
			alt11 = dfa11.predict(input);
			switch (alt11) {
				case 1 :
					// Parser.g:300:7: ( K_DISTINCT selectors )=> K_DISTINCT s= selectors
					{
					match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_selectClause1342); if (state.failed) return retval;
					pushFollow(FOLLOW_selectors_in_selectClause1346);
					s=selectors();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) { retval.isDistinct = true; retval.selectors = s; }
					}
					break;
				case 2 :
					// Parser.g:301:7: s= selectors
					{
					pushFollow(FOLLOW_selectors_in_selectClause1358);
					s=selectors();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) { retval.selectors = s; }
					}
					break;

			}
			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selectors"
	// Parser.g:304:1: selectors returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
	public final List<RawSelector> selectors() throws RecognitionException {
		List<RawSelector> expr = null;


		RawSelector t1 =null;
		RawSelector tN =null;

		try {
			// Parser.g:305:5: (t1= selector ( ',' tN= selector )* | '\\*' )
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==BOOLEAN||LA13_0==DURATION||LA13_0==FLOAT||LA13_0==HEXNUMBER||(LA13_0 >= IDENT && LA13_0 <= INTEGER)||LA13_0==K_ACCESS||(LA13_0 >= K_AGGREGATE && LA13_0 <= K_ALL)||LA13_0==K_ANN||LA13_0==K_AS||LA13_0==K_ASCII||(LA13_0 >= K_BIGINT && LA13_0 <= K_BOOLEAN)||(LA13_0 >= K_CALLED && LA13_0 <= K_CLUSTERING)||(LA13_0 >= K_COMPACT && LA13_0 <= K_COUNTER)||(LA13_0 >= K_CUSTOM && LA13_0 <= K_DEFAULT)||(LA13_0 >= K_DISTINCT && LA13_0 <= K_DOUBLE)||LA13_0==K_DURATION||(LA13_0 >= K_EXISTS && LA13_0 <= K_FLOAT)||LA13_0==K_FROZEN||(LA13_0 >= K_FUNCTION && LA13_0 <= K_FUNCTIONS)||(LA13_0 >= K_GROUP && LA13_0 <= K_IDENTITY)||(LA13_0 >= K_INET && LA13_0 <= K_INPUT)||(LA13_0 >= K_INT && LA13_0 <= K_INTERNALS)||(LA13_0 >= K_JSON && LA13_0 <= K_KEYS)||(LA13_0 >= K_KEYSPACES && LA13_0 <= K_LIKE)||(LA13_0 >= K_LIST && LA13_0 <= K_MASKED)||(LA13_0 >= K_MAXWRITETIME && LA13_0 <= K_MBEANS)||(LA13_0 >= K_NEGATIVE_INFINITY && LA13_0 <= K_NOLOGIN)||LA13_0==K_NOSUPERUSER||LA13_0==K_NULL||(LA13_0 >= K_ONLY && LA13_0 <= K_OPTIONS)||(LA13_0 >= K_PARTITION && LA13_0 <= K_POSITIVE_NAN)||(LA13_0 >= K_REPLACE && LA13_0 <= K_RETURNS)||(LA13_0 >= K_ROLE && LA13_0 <= K_ROLES)||LA13_0==K_SELECT_MASKED||(LA13_0 >= K_SFUNC && LA13_0 <= K_TINYINT)||(LA13_0 >= K_TOKEN && LA13_0 <= K_TRIGGER)||(LA13_0 >= K_TTL && LA13_0 <= K_TYPES)||(LA13_0 >= K_UNMASK && LA13_0 <= K_UNSET)||(LA13_0 >= K_USER && LA13_0 <= K_USERS)||(LA13_0 >= K_UUID && LA13_0 <= K_VECTOR)||LA13_0==K_WRITETIME||(LA13_0 >= QMARK && LA13_0 <= QUOTED_NAME)||LA13_0==STRING_LITERAL||LA13_0==UUID||LA13_0==209||LA13_0==214||LA13_0==218||LA13_0==225||LA13_0==229) ) {
				alt13=1;
			}
			else if ( (LA13_0==226) ) {
				alt13=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return expr;}
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}

			switch (alt13) {
				case 1 :
					// Parser.g:305:7: t1= selector ( ',' tN= selector )*
					{
					pushFollow(FOLLOW_selector_in_selectors1383);
					t1=selector();
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { expr = new ArrayList<RawSelector>(); expr.add(t1); }
					// Parser.g:305:76: ( ',' tN= selector )*
					loop12:
					while (true) {
						int alt12=2;
						int LA12_0 = input.LA(1);
						if ( (LA12_0==213) ) {
							alt12=1;
						}

						switch (alt12) {
						case 1 :
							// Parser.g:305:77: ',' tN= selector
							{
							match(input,213,FOLLOW_213_in_selectors1388); if (state.failed) return expr;
							pushFollow(FOLLOW_selector_in_selectors1392);
							tN=selector();
							state._fsp--;
							if (state.failed) return expr;
							if ( state.backtracking==0 ) { expr.add(tN); }
							}
							break;

						default :
							break loop12;
						}
					}

					}
					break;
				case 2 :
					// Parser.g:306:7: '\\*'
					{
					match(input,226,FOLLOW_226_in_selectors1404); if (state.failed) return expr;
					if ( state.backtracking==0 ) { expr = Collections.<RawSelector>emptyList();}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectors"



	// $ANTLR start "selector"
	// Parser.g:309:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= noncol_ident )? ;
	public final RawSelector selector() throws RecognitionException {
		RawSelector s = null;


		Selectable.Raw us =null;
		ColumnIdentifier c =null;

		 ColumnIdentifier alias = null; 
		try {
			// Parser.g:311:5: (us= unaliasedSelector ( K_AS c= noncol_ident )? )
			// Parser.g:311:7: us= unaliasedSelector ( K_AS c= noncol_ident )?
			{
			pushFollow(FOLLOW_unaliasedSelector_in_selector1437);
			us=unaliasedSelector();
			state._fsp--;
			if (state.failed) return s;
			// Parser.g:311:28: ( K_AS c= noncol_ident )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==K_AS) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// Parser.g:311:29: K_AS c= noncol_ident
					{
					match(input,K_AS,FOLLOW_K_AS_in_selector1440); if (state.failed) return s;
					pushFollow(FOLLOW_noncol_ident_in_selector1444);
					c=noncol_ident();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { alias = c; }
					}
					break;

			}

			if ( state.backtracking==0 ) { s = new RawSelector(us, alias); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selector"



	// $ANTLR start "unaliasedSelector"
	// Parser.g:314:1: unaliasedSelector returns [Selectable.Raw s] : a= selectionAddition ;
	public final Selectable.Raw unaliasedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw a =null;

		try {
			// Parser.g:315:5: (a= selectionAddition )
			// Parser.g:315:7: a= selectionAddition
			{
			pushFollow(FOLLOW_selectionAddition_in_unaliasedSelector1473);
			a=selectionAddition();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) {s = a;}
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "unaliasedSelector"



	// $ANTLR start "selectionAddition"
	// Parser.g:318:1: selectionAddition returns [Selectable.Raw s] : l= selectionMultiplication ( '+' r= selectionMultiplication | '-' r= selectionMultiplication )* ;
	public final Selectable.Raw selectionAddition() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw l =null;
		Selectable.Raw r =null;

		try {
			// Parser.g:319:5: (l= selectionMultiplication ( '+' r= selectionMultiplication | '-' r= selectionMultiplication )* )
			// Parser.g:319:9: l= selectionMultiplication ( '+' r= selectionMultiplication | '-' r= selectionMultiplication )*
			{
			pushFollow(FOLLOW_selectionMultiplication_in_selectionAddition1500);
			l=selectionMultiplication();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) {s = l;}
			// Parser.g:320:9: ( '+' r= selectionMultiplication | '-' r= selectionMultiplication )*
			loop15:
			while (true) {
				int alt15=3;
				int LA15_0 = input.LA(1);
				if ( (LA15_0==211) ) {
					alt15=1;
				}
				else if ( (LA15_0==214) ) {
					alt15=2;
				}

				switch (alt15) {
				case 1 :
					// Parser.g:320:11: '+' r= selectionMultiplication
					{
					match(input,211,FOLLOW_211_in_selectionAddition1516); if (state.failed) return s;
					pushFollow(FOLLOW_selectionMultiplication_in_selectionAddition1520);
					r=selectionMultiplication();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) {s = Selectable.WithFunction.Raw.newOperation('+', s, r);}
					}
					break;
				case 2 :
					// Parser.g:321:11: '-' r= selectionMultiplication
					{
					match(input,214,FOLLOW_214_in_selectionAddition1534); if (state.failed) return s;
					pushFollow(FOLLOW_selectionMultiplication_in_selectionAddition1538);
					r=selectionMultiplication();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) {s = Selectable.WithFunction.Raw.newOperation('-', s, r);}
					}
					break;

				default :
					break loop15;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionAddition"



	// $ANTLR start "selectionMultiplication"
	// Parser.g:325:1: selectionMultiplication returns [Selectable.Raw s] : l= selectionGroup ( '\\*' r= selectionGroup | '/' r= selectionGroup | '%' r= selectionGroup )* ;
	public final Selectable.Raw selectionMultiplication() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw l =null;
		Selectable.Raw r =null;

		try {
			// Parser.g:326:5: (l= selectionGroup ( '\\*' r= selectionGroup | '/' r= selectionGroup | '%' r= selectionGroup )* )
			// Parser.g:326:9: l= selectionGroup ( '\\*' r= selectionGroup | '/' r= selectionGroup | '%' r= selectionGroup )*
			{
			pushFollow(FOLLOW_selectionGroup_in_selectionMultiplication1576);
			l=selectionGroup();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) {s = l;}
			// Parser.g:327:9: ( '\\*' r= selectionGroup | '/' r= selectionGroup | '%' r= selectionGroup )*
			loop16:
			while (true) {
				int alt16=4;
				switch ( input.LA(1) ) {
				case 226:
					{
					alt16=1;
					}
					break;
				case 217:
					{
					alt16=2;
					}
					break;
				case 208:
					{
					alt16=3;
					}
					break;
				}
				switch (alt16) {
				case 1 :
					// Parser.g:327:11: '\\*' r= selectionGroup
					{
					match(input,226,FOLLOW_226_in_selectionMultiplication1592); if (state.failed) return s;
					pushFollow(FOLLOW_selectionGroup_in_selectionMultiplication1596);
					r=selectionGroup();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) {s = Selectable.WithFunction.Raw.newOperation('*', s, r);}
					}
					break;
				case 2 :
					// Parser.g:328:11: '/' r= selectionGroup
					{
					match(input,217,FOLLOW_217_in_selectionMultiplication1610); if (state.failed) return s;
					pushFollow(FOLLOW_selectionGroup_in_selectionMultiplication1614);
					r=selectionGroup();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) {s = Selectable.WithFunction.Raw.newOperation('/', s, r);}
					}
					break;
				case 3 :
					// Parser.g:329:11: '%' r= selectionGroup
					{
					match(input,208,FOLLOW_208_in_selectionMultiplication1628); if (state.failed) return s;
					pushFollow(FOLLOW_selectionGroup_in_selectionMultiplication1632);
					r=selectionGroup();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) {s = Selectable.WithFunction.Raw.newOperation('%', s, r);}
					}
					break;

				default :
					break loop16;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionMultiplication"



	// $ANTLR start "selectionGroup"
	// Parser.g:333:1: selectionGroup returns [Selectable.Raw s] : ( ( selectionGroupWithField )=>f= selectionGroupWithField |g= selectionGroupWithoutField | '-' g= selectionGroup );
	public final Selectable.Raw selectionGroup() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw f =null;
		Selectable.Raw g =null;

		try {
			// Parser.g:334:5: ( ( selectionGroupWithField )=>f= selectionGroupWithField |g= selectionGroupWithoutField | '-' g= selectionGroup )
			int alt17=3;
			alt17 = dfa17.predict(input);
			switch (alt17) {
				case 1 :
					// Parser.g:334:7: ( selectionGroupWithField )=>f= selectionGroupWithField
					{
					pushFollow(FOLLOW_selectionGroupWithField_in_selectionGroup1674);
					f=selectionGroupWithField();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s =f; }
					}
					break;
				case 2 :
					// Parser.g:335:7: g= selectionGroupWithoutField
					{
					pushFollow(FOLLOW_selectionGroupWithoutField_in_selectionGroup1686);
					g=selectionGroupWithoutField();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s =g; }
					}
					break;
				case 3 :
					// Parser.g:336:7: '-' g= selectionGroup
					{
					match(input,214,FOLLOW_214_in_selectionGroup1696); if (state.failed) return s;
					pushFollow(FOLLOW_selectionGroup_in_selectionGroup1700);
					g=selectionGroup();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) {s = Selectable.WithFunction.Raw.newNegation(g);}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionGroup"



	// $ANTLR start "selectionGroupWithField"
	// Parser.g:339:1: selectionGroupWithField returns [Selectable.Raw s] : g= selectionGroupWithoutField m= selectorModifier[g] ;
	public final Selectable.Raw selectionGroupWithField() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw g =null;
		Selectable.Raw m =null;

		try {
			// Parser.g:340:5: (g= selectionGroupWithoutField m= selectorModifier[g] )
			// Parser.g:340:7: g= selectionGroupWithoutField m= selectorModifier[g]
			{
			pushFollow(FOLLOW_selectionGroupWithoutField_in_selectionGroupWithField1725);
			g=selectionGroupWithoutField();
			state._fsp--;
			if (state.failed) return s;
			pushFollow(FOLLOW_selectorModifier_in_selectionGroupWithField1729);
			m=selectorModifier(g);
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) {s = m;}
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionGroupWithField"



	// $ANTLR start "selectorModifier"
	// Parser.g:343:1: selectorModifier[Selectable.Raw receiver] returns [Selectable.Raw s] : (f= fieldSelectorModifier[receiver] m= selectorModifier[f] | '[' ss= collectionSubSelection[receiver] ']' m= selectorModifier[ss] |);
	public final Selectable.Raw selectorModifier(Selectable.Raw receiver) throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw f =null;
		Selectable.Raw m =null;
		Selectable.Raw ss =null;

		try {
			// Parser.g:344:5: (f= fieldSelectorModifier[receiver] m= selectorModifier[f] | '[' ss= collectionSubSelection[receiver] ']' m= selectorModifier[ss] |)
			int alt18=3;
			switch ( input.LA(1) ) {
			case 216:
				{
				alt18=1;
				}
				break;
			case 225:
				{
				alt18=2;
				}
				break;
			case EOF:
			case K_ALLOW:
			case K_AS:
			case K_FROM:
			case K_LIMIT:
			case K_ORDER:
			case K_PER:
			case 208:
			case 210:
			case 211:
			case 213:
			case 214:
			case 217:
			case 218:
			case 226:
			case 227:
			case 230:
				{
				alt18=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return s;}
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}
			switch (alt18) {
				case 1 :
					// Parser.g:344:7: f= fieldSelectorModifier[receiver] m= selectorModifier[f]
					{
					pushFollow(FOLLOW_fieldSelectorModifier_in_selectorModifier1756);
					f=fieldSelectorModifier(receiver);
					state._fsp--;
					if (state.failed) return s;
					pushFollow(FOLLOW_selectorModifier_in_selectorModifier1761);
					m=selectorModifier(f);
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = m; }
					}
					break;
				case 2 :
					// Parser.g:345:7: '[' ss= collectionSubSelection[receiver] ']' m= selectorModifier[ss]
					{
					match(input,225,FOLLOW_225_in_selectorModifier1772); if (state.failed) return s;
					pushFollow(FOLLOW_collectionSubSelection_in_selectorModifier1776);
					ss=collectionSubSelection(receiver);
					state._fsp--;
					if (state.failed) return s;
					match(input,227,FOLLOW_227_in_selectorModifier1779); if (state.failed) return s;
					pushFollow(FOLLOW_selectorModifier_in_selectorModifier1783);
					m=selectorModifier(ss);
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = m; }
					}
					break;
				case 3 :
					// Parser.g:346:7: 
					{
					if ( state.backtracking==0 ) { s = receiver; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectorModifier"



	// $ANTLR start "fieldSelectorModifier"
	// Parser.g:349:1: fieldSelectorModifier[Selectable.Raw receiver] returns [Selectable.Raw s] : '.' fi= fident ;
	public final Selectable.Raw fieldSelectorModifier(Selectable.Raw receiver) throws RecognitionException {
		Selectable.Raw s = null;


		FieldIdentifier fi =null;

		try {
			// Parser.g:350:5: ( '.' fi= fident )
			// Parser.g:350:7: '.' fi= fident
			{
			match(input,216,FOLLOW_216_in_fieldSelectorModifier1816); if (state.failed) return s;
			pushFollow(FOLLOW_fident_in_fieldSelectorModifier1820);
			fi=fident();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) { s = new Selectable.WithFieldSelection.Raw(receiver, fi); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "fieldSelectorModifier"



	// $ANTLR start "collectionSubSelection"
	// Parser.g:353:1: collectionSubSelection[Selectable.Raw receiver] returns [Selectable.Raw s] : (t1= term ( RANGE (t2= term )? )? | RANGE t2= term ) ;
	public final Selectable.Raw collectionSubSelection(Selectable.Raw receiver) throws RecognitionException {
		Selectable.Raw s = null;


		Term.Raw t1 =null;
		Term.Raw t2 =null;

		 boolean isSlice=false; 
		try {
			// Parser.g:355:5: ( (t1= term ( RANGE (t2= term )? )? | RANGE t2= term ) )
			// Parser.g:355:7: (t1= term ( RANGE (t2= term )? )? | RANGE t2= term )
			{
			// Parser.g:355:7: (t1= term ( RANGE (t2= term )? )? | RANGE t2= term )
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==BOOLEAN||LA21_0==DURATION||LA21_0==FLOAT||LA21_0==HEXNUMBER||(LA21_0 >= IDENT && LA21_0 <= INTEGER)||LA21_0==K_ACCESS||(LA21_0 >= K_AGGREGATE && LA21_0 <= K_ALL)||LA21_0==K_ANN||LA21_0==K_AS||LA21_0==K_ASCII||(LA21_0 >= K_BIGINT && LA21_0 <= K_BOOLEAN)||(LA21_0 >= K_CALLED && LA21_0 <= K_CLUSTERING)||(LA21_0 >= K_COMPACT && LA21_0 <= K_COUNTER)||(LA21_0 >= K_CUSTOM && LA21_0 <= K_DEFAULT)||(LA21_0 >= K_DISTINCT && LA21_0 <= K_DOUBLE)||LA21_0==K_DURATION||(LA21_0 >= K_EXISTS && LA21_0 <= K_FLOAT)||LA21_0==K_FROZEN||(LA21_0 >= K_FUNCTION && LA21_0 <= K_FUNCTIONS)||(LA21_0 >= K_GROUP && LA21_0 <= K_IDENTITY)||(LA21_0 >= K_INET && LA21_0 <= K_INPUT)||(LA21_0 >= K_INT && LA21_0 <= K_INTERNALS)||(LA21_0 >= K_JSON && LA21_0 <= K_KEYS)||(LA21_0 >= K_KEYSPACES && LA21_0 <= K_LIKE)||(LA21_0 >= K_LIST && LA21_0 <= K_MASKED)||(LA21_0 >= K_MAXWRITETIME && LA21_0 <= K_MBEANS)||(LA21_0 >= K_NEGATIVE_INFINITY && LA21_0 <= K_NOLOGIN)||LA21_0==K_NOSUPERUSER||LA21_0==K_NULL||(LA21_0 >= K_ONLY && LA21_0 <= K_OPTIONS)||(LA21_0 >= K_PARTITION && LA21_0 <= K_POSITIVE_NAN)||(LA21_0 >= K_REPLACE && LA21_0 <= K_RETURNS)||(LA21_0 >= K_ROLE && LA21_0 <= K_ROLES)||LA21_0==K_SELECT_MASKED||(LA21_0 >= K_SFUNC && LA21_0 <= K_TINYINT)||(LA21_0 >= K_TOKEN && LA21_0 <= K_TRIGGER)||(LA21_0 >= K_TTL && LA21_0 <= K_TYPES)||(LA21_0 >= K_UNMASK && LA21_0 <= K_UNSET)||(LA21_0 >= K_USER && LA21_0 <= K_USERS)||(LA21_0 >= K_UUID && LA21_0 <= K_VECTOR)||LA21_0==K_WRITETIME||(LA21_0 >= QMARK && LA21_0 <= QUOTED_NAME)||LA21_0==STRING_LITERAL||LA21_0==UUID||LA21_0==209||LA21_0==214||LA21_0==218||LA21_0==225||LA21_0==229) ) {
				alt21=1;
			}
			else if ( (LA21_0==RANGE) ) {
				alt21=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return s;}
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// Parser.g:355:9: t1= term ( RANGE (t2= term )? )?
					{
					pushFollow(FOLLOW_term_in_collectionSubSelection1858);
					t1=term();
					state._fsp--;
					if (state.failed) return s;
					// Parser.g:355:17: ( RANGE (t2= term )? )?
					int alt20=2;
					int LA20_0 = input.LA(1);
					if ( (LA20_0==RANGE) ) {
						alt20=1;
					}
					switch (alt20) {
						case 1 :
							// Parser.g:355:19: RANGE (t2= term )?
							{
							if ( state.backtracking==0 ) { isSlice=true; }
							match(input,RANGE,FOLLOW_RANGE_in_collectionSubSelection1864); if (state.failed) return s;
							// Parser.g:355:43: (t2= term )?
							int alt19=2;
							int LA19_0 = input.LA(1);
							if ( (LA19_0==BOOLEAN||LA19_0==DURATION||LA19_0==FLOAT||LA19_0==HEXNUMBER||(LA19_0 >= IDENT && LA19_0 <= INTEGER)||LA19_0==K_ACCESS||(LA19_0 >= K_AGGREGATE && LA19_0 <= K_ALL)||LA19_0==K_ANN||LA19_0==K_AS||LA19_0==K_ASCII||(LA19_0 >= K_BIGINT && LA19_0 <= K_BOOLEAN)||(LA19_0 >= K_CALLED && LA19_0 <= K_CLUSTERING)||(LA19_0 >= K_COMPACT && LA19_0 <= K_COUNTER)||(LA19_0 >= K_CUSTOM && LA19_0 <= K_DEFAULT)||(LA19_0 >= K_DISTINCT && LA19_0 <= K_DOUBLE)||LA19_0==K_DURATION||(LA19_0 >= K_EXISTS && LA19_0 <= K_FLOAT)||LA19_0==K_FROZEN||(LA19_0 >= K_FUNCTION && LA19_0 <= K_FUNCTIONS)||(LA19_0 >= K_GROUP && LA19_0 <= K_IDENTITY)||(LA19_0 >= K_INET && LA19_0 <= K_INPUT)||(LA19_0 >= K_INT && LA19_0 <= K_INTERNALS)||(LA19_0 >= K_JSON && LA19_0 <= K_KEYS)||(LA19_0 >= K_KEYSPACES && LA19_0 <= K_LIKE)||(LA19_0 >= K_LIST && LA19_0 <= K_MASKED)||(LA19_0 >= K_MAXWRITETIME && LA19_0 <= K_MBEANS)||(LA19_0 >= K_NEGATIVE_INFINITY && LA19_0 <= K_NOLOGIN)||LA19_0==K_NOSUPERUSER||LA19_0==K_NULL||(LA19_0 >= K_ONLY && LA19_0 <= K_OPTIONS)||(LA19_0 >= K_PARTITION && LA19_0 <= K_POSITIVE_NAN)||(LA19_0 >= K_REPLACE && LA19_0 <= K_RETURNS)||(LA19_0 >= K_ROLE && LA19_0 <= K_ROLES)||LA19_0==K_SELECT_MASKED||(LA19_0 >= K_SFUNC && LA19_0 <= K_TINYINT)||(LA19_0 >= K_TOKEN && LA19_0 <= K_TRIGGER)||(LA19_0 >= K_TTL && LA19_0 <= K_TYPES)||(LA19_0 >= K_UNMASK && LA19_0 <= K_UNSET)||(LA19_0 >= K_USER && LA19_0 <= K_USERS)||(LA19_0 >= K_UUID && LA19_0 <= K_VECTOR)||LA19_0==K_WRITETIME||(LA19_0 >= QMARK && LA19_0 <= QUOTED_NAME)||LA19_0==STRING_LITERAL||LA19_0==UUID||LA19_0==209||LA19_0==214||LA19_0==218||LA19_0==225||LA19_0==229) ) {
								alt19=1;
							}
							switch (alt19) {
								case 1 :
									// Parser.g:355:44: t2= term
									{
									pushFollow(FOLLOW_term_in_collectionSubSelection1869);
									t2=term();
									state._fsp--;
									if (state.failed) return s;
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 2 :
					// Parser.g:356:9: RANGE t2= term
					{
					match(input,RANGE,FOLLOW_RANGE_in_collectionSubSelection1884); if (state.failed) return s;
					if ( state.backtracking==0 ) { isSlice=true; }
					pushFollow(FOLLOW_term_in_collectionSubSelection1890);
					t2=term();
					state._fsp--;
					if (state.failed) return s;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			          s = isSlice
			             ? new Selectable.WithSliceSelection.Raw(receiver, t1, t2)
			             : new Selectable.WithElementSelection.Raw(receiver, t1);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "collectionSubSelection"



	// $ANTLR start "selectionGroupWithoutField"
	// Parser.g:364:1: selectionGroupWithoutField returns [Selectable.Raw s] : (sn= simpleUnaliasedSelector | ( selectionTypeHint )=>h= selectionTypeHint |t= selectionTupleOrNestedSelector |l= selectionList |m= selectionMapOrSet );
	public final Selectable.Raw selectionGroupWithoutField() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw sn =null;
		Selectable.Raw h =null;
		Selectable.Raw t =null;
		Selectable.Raw l =null;
		Selectable.Raw m =null;

		 Selectable.Raw tmp = null; 
		try {
			// Parser.g:367:5: (sn= simpleUnaliasedSelector | ( selectionTypeHint )=>h= selectionTypeHint |t= selectionTupleOrNestedSelector |l= selectionList |m= selectionMapOrSet )
			int alt22=5;
			alt22 = dfa22.predict(input);
			switch (alt22) {
				case 1 :
					// Parser.g:367:7: sn= simpleUnaliasedSelector
					{
					pushFollow(FOLLOW_simpleUnaliasedSelector_in_selectionGroupWithoutField1942);
					sn=simpleUnaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { tmp=sn; }
					}
					break;
				case 2 :
					// Parser.g:368:7: ( selectionTypeHint )=>h= selectionTypeHint
					{
					pushFollow(FOLLOW_selectionTypeHint_in_selectionGroupWithoutField1960);
					h=selectionTypeHint();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { tmp=h; }
					}
					break;
				case 3 :
					// Parser.g:369:7: t= selectionTupleOrNestedSelector
					{
					pushFollow(FOLLOW_selectionTupleOrNestedSelector_in_selectionGroupWithoutField1972);
					t=selectionTupleOrNestedSelector();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { tmp=t; }
					}
					break;
				case 4 :
					// Parser.g:370:7: l= selectionList
					{
					pushFollow(FOLLOW_selectionList_in_selectionGroupWithoutField1984);
					l=selectionList();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { tmp=l; }
					}
					break;
				case 5 :
					// Parser.g:371:7: m= selectionMapOrSet
					{
					pushFollow(FOLLOW_selectionMapOrSet_in_selectionGroupWithoutField1996);
					m=selectionMapOrSet();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { tmp=m; }
					}
					break;

			}
			if ( state.backtracking==0 ) { s = tmp; }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionGroupWithoutField"



	// $ANTLR start "selectionTypeHint"
	// Parser.g:375:1: selectionTypeHint returns [Selectable.Raw s] : '(' ct= comparatorType ')' a= selectionGroupWithoutField ;
	public final Selectable.Raw selectionTypeHint() throws RecognitionException {
		Selectable.Raw s = null;


		CQL3Type.Raw ct =null;
		Selectable.Raw a =null;

		try {
			// Parser.g:376:5: ( '(' ct= comparatorType ')' a= selectionGroupWithoutField )
			// Parser.g:376:7: '(' ct= comparatorType ')' a= selectionGroupWithoutField
			{
			match(input,209,FOLLOW_209_in_selectionTypeHint2024); if (state.failed) return s;
			pushFollow(FOLLOW_comparatorType_in_selectionTypeHint2028);
			ct=comparatorType();
			state._fsp--;
			if (state.failed) return s;
			match(input,210,FOLLOW_210_in_selectionTypeHint2030); if (state.failed) return s;
			pushFollow(FOLLOW_selectionGroupWithoutField_in_selectionTypeHint2034);
			a=selectionGroupWithoutField();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) { s = new Selectable.WithTypeHint.Raw(ct, a); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionTypeHint"



	// $ANTLR start "selectionList"
	// Parser.g:379:1: selectionList returns [Selectable.Raw s] : '[' (t1= unaliasedSelector ( ',' tn= unaliasedSelector )* )? ']' ;
	public final Selectable.Raw selectionList() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw t1 =null;
		Selectable.Raw tn =null;

		 List<Selectable.Raw> l = new ArrayList<>(); 
		try {
			// Parser.g:382:5: ( '[' (t1= unaliasedSelector ( ',' tn= unaliasedSelector )* )? ']' )
			// Parser.g:382:7: '[' (t1= unaliasedSelector ( ',' tn= unaliasedSelector )* )? ']'
			{
			match(input,225,FOLLOW_225_in_selectionList2075); if (state.failed) return s;
			// Parser.g:382:11: (t1= unaliasedSelector ( ',' tn= unaliasedSelector )* )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==BOOLEAN||LA24_0==DURATION||LA24_0==FLOAT||LA24_0==HEXNUMBER||(LA24_0 >= IDENT && LA24_0 <= INTEGER)||LA24_0==K_ACCESS||(LA24_0 >= K_AGGREGATE && LA24_0 <= K_ALL)||LA24_0==K_ANN||LA24_0==K_AS||LA24_0==K_ASCII||(LA24_0 >= K_BIGINT && LA24_0 <= K_BOOLEAN)||(LA24_0 >= K_CALLED && LA24_0 <= K_CLUSTERING)||(LA24_0 >= K_COMPACT && LA24_0 <= K_COUNTER)||(LA24_0 >= K_CUSTOM && LA24_0 <= K_DEFAULT)||(LA24_0 >= K_DISTINCT && LA24_0 <= K_DOUBLE)||LA24_0==K_DURATION||(LA24_0 >= K_EXISTS && LA24_0 <= K_FLOAT)||LA24_0==K_FROZEN||(LA24_0 >= K_FUNCTION && LA24_0 <= K_FUNCTIONS)||(LA24_0 >= K_GROUP && LA24_0 <= K_IDENTITY)||(LA24_0 >= K_INET && LA24_0 <= K_INPUT)||(LA24_0 >= K_INT && LA24_0 <= K_INTERNALS)||(LA24_0 >= K_JSON && LA24_0 <= K_KEYS)||(LA24_0 >= K_KEYSPACES && LA24_0 <= K_LIKE)||(LA24_0 >= K_LIST && LA24_0 <= K_MASKED)||(LA24_0 >= K_MAXWRITETIME && LA24_0 <= K_MBEANS)||(LA24_0 >= K_NEGATIVE_INFINITY && LA24_0 <= K_NOLOGIN)||LA24_0==K_NOSUPERUSER||LA24_0==K_NULL||(LA24_0 >= K_ONLY && LA24_0 <= K_OPTIONS)||(LA24_0 >= K_PARTITION && LA24_0 <= K_POSITIVE_NAN)||(LA24_0 >= K_REPLACE && LA24_0 <= K_RETURNS)||(LA24_0 >= K_ROLE && LA24_0 <= K_ROLES)||LA24_0==K_SELECT_MASKED||(LA24_0 >= K_SFUNC && LA24_0 <= K_TINYINT)||(LA24_0 >= K_TOKEN && LA24_0 <= K_TRIGGER)||(LA24_0 >= K_TTL && LA24_0 <= K_TYPES)||(LA24_0 >= K_UNMASK && LA24_0 <= K_UNSET)||(LA24_0 >= K_USER && LA24_0 <= K_USERS)||(LA24_0 >= K_UUID && LA24_0 <= K_VECTOR)||LA24_0==K_WRITETIME||(LA24_0 >= QMARK && LA24_0 <= QUOTED_NAME)||LA24_0==STRING_LITERAL||LA24_0==UUID||LA24_0==209||LA24_0==214||LA24_0==218||LA24_0==225||LA24_0==229) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// Parser.g:382:13: t1= unaliasedSelector ( ',' tn= unaliasedSelector )*
					{
					pushFollow(FOLLOW_unaliasedSelector_in_selectionList2081);
					t1=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { l.add(t1); }
					// Parser.g:382:49: ( ',' tn= unaliasedSelector )*
					loop23:
					while (true) {
						int alt23=2;
						int LA23_0 = input.LA(1);
						if ( (LA23_0==213) ) {
							alt23=1;
						}

						switch (alt23) {
						case 1 :
							// Parser.g:382:51: ',' tn= unaliasedSelector
							{
							match(input,213,FOLLOW_213_in_selectionList2087); if (state.failed) return s;
							pushFollow(FOLLOW_unaliasedSelector_in_selectionList2091);
							tn=unaliasedSelector();
							state._fsp--;
							if (state.failed) return s;
							if ( state.backtracking==0 ) { l.add(tn); }
							}
							break;

						default :
							break loop23;
						}
					}

					}
					break;

			}

			match(input,227,FOLLOW_227_in_selectionList2101); if (state.failed) return s;
			}

			if ( state.backtracking==0 ) { s = new Selectable.WithArrayLiteral.Raw(l); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionList"



	// $ANTLR start "selectionMapOrSet"
	// Parser.g:385:1: selectionMapOrSet returns [Selectable.Raw s] : ( '{' t1= unaliasedSelector (m= selectionMap[t1] |st= selectionSet[t1] ) '}' | '{' '}' );
	public final Selectable.Raw selectionMapOrSet() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw t1 =null;
		Selectable.Raw m =null;
		Selectable.Raw st =null;

		try {
			// Parser.g:386:5: ( '{' t1= unaliasedSelector (m= selectionMap[t1] |st= selectionSet[t1] ) '}' | '{' '}' )
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==229) ) {
				int LA26_1 = input.LA(2);
				if ( (LA26_1==230) ) {
					alt26=2;
				}
				else if ( (LA26_1==BOOLEAN||LA26_1==DURATION||LA26_1==FLOAT||LA26_1==HEXNUMBER||(LA26_1 >= IDENT && LA26_1 <= INTEGER)||LA26_1==K_ACCESS||(LA26_1 >= K_AGGREGATE && LA26_1 <= K_ALL)||LA26_1==K_ANN||LA26_1==K_AS||LA26_1==K_ASCII||(LA26_1 >= K_BIGINT && LA26_1 <= K_BOOLEAN)||(LA26_1 >= K_CALLED && LA26_1 <= K_CLUSTERING)||(LA26_1 >= K_COMPACT && LA26_1 <= K_COUNTER)||(LA26_1 >= K_CUSTOM && LA26_1 <= K_DEFAULT)||(LA26_1 >= K_DISTINCT && LA26_1 <= K_DOUBLE)||LA26_1==K_DURATION||(LA26_1 >= K_EXISTS && LA26_1 <= K_FLOAT)||LA26_1==K_FROZEN||(LA26_1 >= K_FUNCTION && LA26_1 <= K_FUNCTIONS)||(LA26_1 >= K_GROUP && LA26_1 <= K_IDENTITY)||(LA26_1 >= K_INET && LA26_1 <= K_INPUT)||(LA26_1 >= K_INT && LA26_1 <= K_INTERNALS)||(LA26_1 >= K_JSON && LA26_1 <= K_KEYS)||(LA26_1 >= K_KEYSPACES && LA26_1 <= K_LIKE)||(LA26_1 >= K_LIST && LA26_1 <= K_MASKED)||(LA26_1 >= K_MAXWRITETIME && LA26_1 <= K_MBEANS)||(LA26_1 >= K_NEGATIVE_INFINITY && LA26_1 <= K_NOLOGIN)||LA26_1==K_NOSUPERUSER||LA26_1==K_NULL||(LA26_1 >= K_ONLY && LA26_1 <= K_OPTIONS)||(LA26_1 >= K_PARTITION && LA26_1 <= K_POSITIVE_NAN)||(LA26_1 >= K_REPLACE && LA26_1 <= K_RETURNS)||(LA26_1 >= K_ROLE && LA26_1 <= K_ROLES)||LA26_1==K_SELECT_MASKED||(LA26_1 >= K_SFUNC && LA26_1 <= K_TINYINT)||(LA26_1 >= K_TOKEN && LA26_1 <= K_TRIGGER)||(LA26_1 >= K_TTL && LA26_1 <= K_TYPES)||(LA26_1 >= K_UNMASK && LA26_1 <= K_UNSET)||(LA26_1 >= K_USER && LA26_1 <= K_USERS)||(LA26_1 >= K_UUID && LA26_1 <= K_VECTOR)||LA26_1==K_WRITETIME||(LA26_1 >= QMARK && LA26_1 <= QUOTED_NAME)||LA26_1==STRING_LITERAL||LA26_1==UUID||LA26_1==209||LA26_1==214||LA26_1==218||LA26_1==225||LA26_1==229) ) {
					alt26=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return s;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 26, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return s;}
				NoViableAltException nvae =
					new NoViableAltException("", 26, 0, input);
				throw nvae;
			}

			switch (alt26) {
				case 1 :
					// Parser.g:386:7: '{' t1= unaliasedSelector (m= selectionMap[t1] |st= selectionSet[t1] ) '}'
					{
					match(input,229,FOLLOW_229_in_selectionMapOrSet2122); if (state.failed) return s;
					pushFollow(FOLLOW_unaliasedSelector_in_selectionMapOrSet2126);
					t1=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					// Parser.g:386:32: (m= selectionMap[t1] |st= selectionSet[t1] )
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==218) ) {
						alt25=1;
					}
					else if ( (LA25_0==213||LA25_0==230) ) {
						alt25=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return s;}
						NoViableAltException nvae =
							new NoViableAltException("", 25, 0, input);
						throw nvae;
					}

					switch (alt25) {
						case 1 :
							// Parser.g:386:34: m= selectionMap[t1]
							{
							pushFollow(FOLLOW_selectionMap_in_selectionMapOrSet2132);
							m=selectionMap(t1);
							state._fsp--;
							if (state.failed) return s;
							if ( state.backtracking==0 ) { s = m; }
							}
							break;
						case 2 :
							// Parser.g:386:67: st= selectionSet[t1]
							{
							pushFollow(FOLLOW_selectionSet_in_selectionMapOrSet2141);
							st=selectionSet(t1);
							state._fsp--;
							if (state.failed) return s;
							if ( state.backtracking==0 ) { s = st; }
							}
							break;

					}

					match(input,230,FOLLOW_230_in_selectionMapOrSet2147); if (state.failed) return s;
					}
					break;
				case 2 :
					// Parser.g:387:7: '{' '}'
					{
					match(input,229,FOLLOW_229_in_selectionMapOrSet2155); if (state.failed) return s;
					match(input,230,FOLLOW_230_in_selectionMapOrSet2157); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WithSet.Raw(Collections.emptyList());}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionMapOrSet"



	// $ANTLR start "selectionMap"
	// Parser.g:390:1: selectionMap[Selectable.Raw k1] returns [Selectable.Raw s] : ':' v1= unaliasedSelector ( ',' kn= unaliasedSelector ':' vn= unaliasedSelector )* ;
	public final Selectable.Raw selectionMap(Selectable.Raw k1) throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw v1 =null;
		Selectable.Raw kn =null;
		Selectable.Raw vn =null;

		 List<Pair<Selectable.Raw, Selectable.Raw>> m = new ArrayList<>(); 
		try {
			// Parser.g:393:7: ( ':' v1= unaliasedSelector ( ',' kn= unaliasedSelector ':' vn= unaliasedSelector )* )
			// Parser.g:393:9: ':' v1= unaliasedSelector ( ',' kn= unaliasedSelector ':' vn= unaliasedSelector )*
			{
			match(input,218,FOLLOW_218_in_selectionMap2202); if (state.failed) return s;
			pushFollow(FOLLOW_unaliasedSelector_in_selectionMap2206);
			v1=unaliasedSelector();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) { m.add(Pair.create(k1, v1)); }
			// Parser.g:393:68: ( ',' kn= unaliasedSelector ':' vn= unaliasedSelector )*
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( (LA27_0==213) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// Parser.g:393:70: ',' kn= unaliasedSelector ':' vn= unaliasedSelector
					{
					match(input,213,FOLLOW_213_in_selectionMap2214); if (state.failed) return s;
					pushFollow(FOLLOW_unaliasedSelector_in_selectionMap2218);
					kn=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					match(input,218,FOLLOW_218_in_selectionMap2220); if (state.failed) return s;
					pushFollow(FOLLOW_unaliasedSelector_in_selectionMap2224);
					vn=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { m.add(Pair.create(kn, vn)); }
					}
					break;

				default :
					break loop27;
				}
			}

			}

			if ( state.backtracking==0 ) { s = new Selectable.WithMapOrUdt.Raw(m); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionMap"



	// $ANTLR start "selectionSet"
	// Parser.g:396:1: selectionSet[Selectable.Raw t1] returns [Selectable.Raw s] : ( ',' tn= unaliasedSelector )* ;
	public final Selectable.Raw selectionSet(Selectable.Raw t1) throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw tn =null;

		 List<Selectable.Raw> l = new ArrayList<>(); l.add(t1); 
		try {
			// Parser.g:399:7: ( ( ',' tn= unaliasedSelector )* )
			// Parser.g:399:9: ( ',' tn= unaliasedSelector )*
			{
			// Parser.g:399:9: ( ',' tn= unaliasedSelector )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==213) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// Parser.g:399:11: ',' tn= unaliasedSelector
					{
					match(input,213,FOLLOW_213_in_selectionSet2276); if (state.failed) return s;
					pushFollow(FOLLOW_unaliasedSelector_in_selectionSet2280);
					tn=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { l.add(tn); }
					}
					break;

				default :
					break loop28;
				}
			}

			}

			if ( state.backtracking==0 ) { s = new Selectable.WithSet.Raw(l); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionSet"



	// $ANTLR start "selectionTupleOrNestedSelector"
	// Parser.g:402:1: selectionTupleOrNestedSelector returns [Selectable.Raw s] : '(' t1= unaliasedSelector ( ',' tn= unaliasedSelector )* ')' ;
	public final Selectable.Raw selectionTupleOrNestedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.Raw t1 =null;
		Selectable.Raw tn =null;

		 List<Selectable.Raw> l = new ArrayList<>(); 
		try {
			// Parser.g:405:5: ( '(' t1= unaliasedSelector ( ',' tn= unaliasedSelector )* ')' )
			// Parser.g:405:7: '(' t1= unaliasedSelector ( ',' tn= unaliasedSelector )* ')'
			{
			match(input,209,FOLLOW_209_in_selectionTupleOrNestedSelector2326); if (state.failed) return s;
			pushFollow(FOLLOW_unaliasedSelector_in_selectionTupleOrNestedSelector2330);
			t1=unaliasedSelector();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) { l.add(t1); }
			// Parser.g:405:47: ( ',' tn= unaliasedSelector )*
			loop29:
			while (true) {
				int alt29=2;
				int LA29_0 = input.LA(1);
				if ( (LA29_0==213) ) {
					alt29=1;
				}

				switch (alt29) {
				case 1 :
					// Parser.g:405:48: ',' tn= unaliasedSelector
					{
					match(input,213,FOLLOW_213_in_selectionTupleOrNestedSelector2335); if (state.failed) return s;
					pushFollow(FOLLOW_unaliasedSelector_in_selectionTupleOrNestedSelector2339);
					tn=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { l.add(tn); }
					}
					break;

				default :
					break loop29;
				}
			}

			match(input,210,FOLLOW_210_in_selectionTupleOrNestedSelector2346); if (state.failed) return s;
			}

			if ( state.backtracking==0 ) { s = new Selectable.BetweenParenthesesOrWithTuple.Raw(l); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionTupleOrNestedSelector"



	// $ANTLR start "simpleUnaliasedSelector"
	// Parser.g:412:1: simpleUnaliasedSelector returns [Selectable.Raw s] : (c= sident |l= selectionLiteral |f= selectionFunction );
	public final Selectable.Raw simpleUnaliasedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.RawIdentifier c =null;
		Term.Raw l =null;
		Selectable.Raw f =null;

		try {
			// Parser.g:413:5: (c= sident |l= selectionLiteral |f= selectionFunction )
			int alt30=3;
			alt30 = dfa30.predict(input);
			switch (alt30) {
				case 1 :
					// Parser.g:413:7: c= sident
					{
					pushFollow(FOLLOW_sident_in_simpleUnaliasedSelector2371);
					c=sident();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = c; }
					}
					break;
				case 2 :
					// Parser.g:414:7: l= selectionLiteral
					{
					pushFollow(FOLLOW_selectionLiteral_in_simpleUnaliasedSelector2417);
					l=selectionLiteral();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WithTerm.Raw(l); }
					}
					break;
				case 3 :
					// Parser.g:415:7: f= selectionFunction
					{
					pushFollow(FOLLOW_selectionFunction_in_simpleUnaliasedSelector2453);
					f=selectionFunction();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = f; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "simpleUnaliasedSelector"



	// $ANTLR start "selectionFunction"
	// Parser.g:418:1: selectionFunction returns [Selectable.Raw s] : ( K_COUNT '(' '\\*' ')' | K_MAXWRITETIME '(' c= sident m= selectorModifier[c] ')' | K_WRITETIME '(' c= sident m= selectorModifier[c] ')' | K_TTL '(' c= sident m= selectorModifier[c] ')' | K_CAST '(' sn= unaliasedSelector K_AS t= native_type ')' |f= functionName args= selectionFunctionArgs );
	public final Selectable.Raw selectionFunction() throws RecognitionException {
		Selectable.Raw s = null;


		Selectable.RawIdentifier c =null;
		Selectable.Raw m =null;
		Selectable.Raw sn =null;
		CQL3Type t =null;
		FunctionName f =null;
		List<Selectable.Raw> args =null;

		try {
			// Parser.g:419:5: ( K_COUNT '(' '\\*' ')' | K_MAXWRITETIME '(' c= sident m= selectorModifier[c] ')' | K_WRITETIME '(' c= sident m= selectorModifier[c] ')' | K_TTL '(' c= sident m= selectorModifier[c] ')' | K_CAST '(' sn= unaliasedSelector K_AS t= native_type ')' |f= functionName args= selectionFunctionArgs )
			int alt31=6;
			alt31 = dfa31.predict(input);
			switch (alt31) {
				case 1 :
					// Parser.g:419:7: K_COUNT '(' '\\*' ')'
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_selectionFunction2499); if (state.failed) return s;
					match(input,209,FOLLOW_209_in_selectionFunction2508); if (state.failed) return s;
					match(input,226,FOLLOW_226_in_selectionFunction2510); if (state.failed) return s;
					match(input,210,FOLLOW_210_in_selectionFunction2512); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = Selectable.WithFunction.Raw.newCountRowsFunction(); }
					}
					break;
				case 2 :
					// Parser.g:420:7: K_MAXWRITETIME '(' c= sident m= selectorModifier[c] ')'
					{
					match(input,K_MAXWRITETIME,FOLLOW_K_MAXWRITETIME_in_selectionFunction2557); if (state.failed) return s;
					match(input,209,FOLLOW_209_in_selectionFunction2559); if (state.failed) return s;
					pushFollow(FOLLOW_sident_in_selectionFunction2563);
					c=sident();
					state._fsp--;
					if (state.failed) return s;
					pushFollow(FOLLOW_selectorModifier_in_selectionFunction2567);
					m=selectorModifier(c);
					state._fsp--;
					if (state.failed) return s;
					match(input,210,FOLLOW_210_in_selectionFunction2570); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WritetimeOrTTL.Raw(c, m, Selectable.WritetimeOrTTL.Kind.MAX_WRITE_TIME); }
					}
					break;
				case 3 :
					// Parser.g:421:7: K_WRITETIME '(' c= sident m= selectorModifier[c] ')'
					{
					match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_selectionFunction2589); if (state.failed) return s;
					match(input,209,FOLLOW_209_in_selectionFunction2594); if (state.failed) return s;
					pushFollow(FOLLOW_sident_in_selectionFunction2598);
					c=sident();
					state._fsp--;
					if (state.failed) return s;
					pushFollow(FOLLOW_selectorModifier_in_selectionFunction2602);
					m=selectorModifier(c);
					state._fsp--;
					if (state.failed) return s;
					match(input,210,FOLLOW_210_in_selectionFunction2605); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WritetimeOrTTL.Raw(c, m, Selectable.WritetimeOrTTL.Kind.WRITE_TIME); }
					}
					break;
				case 4 :
					// Parser.g:422:7: K_TTL '(' c= sident m= selectorModifier[c] ')'
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_selectionFunction2624); if (state.failed) return s;
					match(input,209,FOLLOW_209_in_selectionFunction2635); if (state.failed) return s;
					pushFollow(FOLLOW_sident_in_selectionFunction2639);
					c=sident();
					state._fsp--;
					if (state.failed) return s;
					pushFollow(FOLLOW_selectorModifier_in_selectionFunction2643);
					m=selectorModifier(c);
					state._fsp--;
					if (state.failed) return s;
					match(input,210,FOLLOW_210_in_selectionFunction2646); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WritetimeOrTTL.Raw(c, m, Selectable.WritetimeOrTTL.Kind.TTL); }
					}
					break;
				case 5 :
					// Parser.g:423:7: K_CAST '(' sn= unaliasedSelector K_AS t= native_type ')'
					{
					match(input,K_CAST,FOLLOW_K_CAST_in_selectionFunction2665); if (state.failed) return s;
					match(input,209,FOLLOW_209_in_selectionFunction2675); if (state.failed) return s;
					pushFollow(FOLLOW_unaliasedSelector_in_selectionFunction2679);
					sn=unaliasedSelector();
					state._fsp--;
					if (state.failed) return s;
					match(input,K_AS,FOLLOW_K_AS_in_selectionFunction2681); if (state.failed) return s;
					pushFollow(FOLLOW_native_type_in_selectionFunction2685);
					t=native_type();
					state._fsp--;
					if (state.failed) return s;
					match(input,210,FOLLOW_210_in_selectionFunction2687); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WithCast.Raw(sn, t);}
					}
					break;
				case 6 :
					// Parser.g:424:7: f= functionName args= selectionFunctionArgs
					{
					pushFollow(FOLLOW_functionName_in_selectionFunction2699);
					f=functionName();
					state._fsp--;
					if (state.failed) return s;
					pushFollow(FOLLOW_selectionFunctionArgs_in_selectionFunction2703);
					args=selectionFunctionArgs();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = new Selectable.WithFunction.Raw(f, args); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selectionFunction"



	// $ANTLR start "selectionLiteral"
	// Parser.g:427:1: selectionLiteral returns [Term.Raw value] : (c= constant | K_NULL | ':' id= noncol_ident | QMARK );
	public final Term.Raw selectionLiteral() throws RecognitionException {
		Term.Raw value = null;


		Constants.Literal c =null;
		ColumnIdentifier id =null;

		try {
			// Parser.g:428:5: (c= constant | K_NULL | ':' id= noncol_ident | QMARK )
			int alt32=4;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case DURATION:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_NEGATIVE_INFINITY:
			case K_NEGATIVE_NAN:
			case K_POSITIVE_INFINITY:
			case K_POSITIVE_NAN:
			case STRING_LITERAL:
			case UUID:
				{
				alt32=1;
				}
				break;
			case K_NULL:
				{
				alt32=2;
				}
				break;
			case 218:
				{
				alt32=3;
				}
				break;
			case QMARK:
				{
				alt32=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return value;}
				NoViableAltException nvae =
					new NoViableAltException("", 32, 0, input);
				throw nvae;
			}
			switch (alt32) {
				case 1 :
					// Parser.g:428:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_selectionLiteral2749);
					c=constant();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = c; }
					}
					break;
				case 2 :
					// Parser.g:429:7: K_NULL
					{
					match(input,K_NULL,FOLLOW_K_NULL_in_selectionLiteral2779); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = Constants.NULL_LITERAL; }
					}
					break;
				case 3 :
					// Parser.g:430:7: ':' id= noncol_ident
					{
					match(input,218,FOLLOW_218_in_selectionLiteral2813); if (state.failed) return value;
					pushFollow(FOLLOW_noncol_ident_in_selectionLiteral2817);
					id=noncol_ident();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newBindVariables(id); }
					}
					break;
				case 4 :
					// Parser.g:431:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_selectionLiteral2838); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newBindVariables(null); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "selectionLiteral"



	// $ANTLR start "selectionFunctionArgs"
	// Parser.g:434:1: selectionFunctionArgs returns [List<Selectable.Raw> a] : '(' (s1= unaliasedSelector ( ',' sn= unaliasedSelector )* )? ')' ;
	public final List<Selectable.Raw> selectionFunctionArgs() throws RecognitionException {
		List<Selectable.Raw> a = null;


		Selectable.Raw s1 =null;
		Selectable.Raw sn =null;

		 a = new ArrayList<>(); 
		try {
			// Parser.g:436:5: ( '(' (s1= unaliasedSelector ( ',' sn= unaliasedSelector )* )? ')' )
			// Parser.g:436:7: '(' (s1= unaliasedSelector ( ',' sn= unaliasedSelector )* )? ')'
			{
			match(input,209,FOLLOW_209_in_selectionFunctionArgs2894); if (state.failed) return a;
			// Parser.g:436:11: (s1= unaliasedSelector ( ',' sn= unaliasedSelector )* )?
			int alt34=2;
			int LA34_0 = input.LA(1);
			if ( (LA34_0==BOOLEAN||LA34_0==DURATION||LA34_0==FLOAT||LA34_0==HEXNUMBER||(LA34_0 >= IDENT && LA34_0 <= INTEGER)||LA34_0==K_ACCESS||(LA34_0 >= K_AGGREGATE && LA34_0 <= K_ALL)||LA34_0==K_ANN||LA34_0==K_AS||LA34_0==K_ASCII||(LA34_0 >= K_BIGINT && LA34_0 <= K_BOOLEAN)||(LA34_0 >= K_CALLED && LA34_0 <= K_CLUSTERING)||(LA34_0 >= K_COMPACT && LA34_0 <= K_COUNTER)||(LA34_0 >= K_CUSTOM && LA34_0 <= K_DEFAULT)||(LA34_0 >= K_DISTINCT && LA34_0 <= K_DOUBLE)||LA34_0==K_DURATION||(LA34_0 >= K_EXISTS && LA34_0 <= K_FLOAT)||LA34_0==K_FROZEN||(LA34_0 >= K_FUNCTION && LA34_0 <= K_FUNCTIONS)||(LA34_0 >= K_GROUP && LA34_0 <= K_IDENTITY)||(LA34_0 >= K_INET && LA34_0 <= K_INPUT)||(LA34_0 >= K_INT && LA34_0 <= K_INTERNALS)||(LA34_0 >= K_JSON && LA34_0 <= K_KEYS)||(LA34_0 >= K_KEYSPACES && LA34_0 <= K_LIKE)||(LA34_0 >= K_LIST && LA34_0 <= K_MASKED)||(LA34_0 >= K_MAXWRITETIME && LA34_0 <= K_MBEANS)||(LA34_0 >= K_NEGATIVE_INFINITY && LA34_0 <= K_NOLOGIN)||LA34_0==K_NOSUPERUSER||LA34_0==K_NULL||(LA34_0 >= K_ONLY && LA34_0 <= K_OPTIONS)||(LA34_0 >= K_PARTITION && LA34_0 <= K_POSITIVE_NAN)||(LA34_0 >= K_REPLACE && LA34_0 <= K_RETURNS)||(LA34_0 >= K_ROLE && LA34_0 <= K_ROLES)||LA34_0==K_SELECT_MASKED||(LA34_0 >= K_SFUNC && LA34_0 <= K_TINYINT)||(LA34_0 >= K_TOKEN && LA34_0 <= K_TRIGGER)||(LA34_0 >= K_TTL && LA34_0 <= K_TYPES)||(LA34_0 >= K_UNMASK && LA34_0 <= K_UNSET)||(LA34_0 >= K_USER && LA34_0 <= K_USERS)||(LA34_0 >= K_UUID && LA34_0 <= K_VECTOR)||LA34_0==K_WRITETIME||(LA34_0 >= QMARK && LA34_0 <= QUOTED_NAME)||LA34_0==STRING_LITERAL||LA34_0==UUID||LA34_0==209||LA34_0==214||LA34_0==218||LA34_0==225||LA34_0==229) ) {
				alt34=1;
			}
			switch (alt34) {
				case 1 :
					// Parser.g:436:12: s1= unaliasedSelector ( ',' sn= unaliasedSelector )*
					{
					pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs2899);
					s1=unaliasedSelector();
					state._fsp--;
					if (state.failed) return a;
					if ( state.backtracking==0 ) { a.add(s1); }
					// Parser.g:437:11: ( ',' sn= unaliasedSelector )*
					loop33:
					while (true) {
						int alt33=2;
						int LA33_0 = input.LA(1);
						if ( (LA33_0==213) ) {
							alt33=1;
						}

						switch (alt33) {
						case 1 :
							// Parser.g:437:13: ',' sn= unaliasedSelector
							{
							match(input,213,FOLLOW_213_in_selectionFunctionArgs2915); if (state.failed) return a;
							pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs2919);
							sn=unaliasedSelector();
							state._fsp--;
							if (state.failed) return a;
							if ( state.backtracking==0 ) { a.add(sn); }
							}
							break;

						default :
							break loop33;
						}
					}

					}
					break;

			}

			match(input,210,FOLLOW_210_in_selectionFunctionArgs2934); if (state.failed) return a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return a;
	}
	// $ANTLR end "selectionFunctionArgs"



	// $ANTLR start "sident"
	// Parser.g:441:1: sident returns [Selectable.RawIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final Selectable.RawIdentifier sident() throws RecognitionException {
		Selectable.RawIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// Parser.g:442:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt35=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt35=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt35=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt35=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return id;}
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}
			switch (alt35) {
				case 1 :
					// Parser.g:442:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_sident2957); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = Selectable.RawIdentifier.forUnquoted((t!=null?t.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:443:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_sident2982); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = Selectable.RawIdentifier.forQuoted((t!=null?t.getText():null)); }
					}
					break;
				case 3 :
					// Parser.g:444:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_sident3001);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return id;
					if ( state.backtracking==0 ) { id = Selectable.RawIdentifier.forUnquoted(k); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "sident"



	// $ANTLR start "whereClause"
	// Parser.g:447:1: whereClause returns [WhereClause.Builder clause] : relationOrExpression[$clause] ( K_AND relationOrExpression[$clause] )* ;
	public final WhereClause.Builder whereClause() throws RecognitionException {
		WhereClause.Builder clause = null;


		 clause = new WhereClause.Builder(); 
		try {
			// Parser.g:449:5: ( relationOrExpression[$clause] ( K_AND relationOrExpression[$clause] )* )
			// Parser.g:449:7: relationOrExpression[$clause] ( K_AND relationOrExpression[$clause] )*
			{
			pushFollow(FOLLOW_relationOrExpression_in_whereClause3032);
			relationOrExpression(clause);
			state._fsp--;
			if (state.failed) return clause;
			// Parser.g:449:37: ( K_AND relationOrExpression[$clause] )*
			loop36:
			while (true) {
				int alt36=2;
				int LA36_0 = input.LA(1);
				if ( (LA36_0==K_AND) ) {
					alt36=1;
				}

				switch (alt36) {
				case 1 :
					// Parser.g:449:38: K_AND relationOrExpression[$clause]
					{
					match(input,K_AND,FOLLOW_K_AND_in_whereClause3036); if (state.failed) return clause;
					pushFollow(FOLLOW_relationOrExpression_in_whereClause3038);
					relationOrExpression(clause);
					state._fsp--;
					if (state.failed) return clause;
					}
					break;

				default :
					break loop36;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return clause;
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "relationOrExpression"
	// Parser.g:452:1: relationOrExpression[WhereClause.Builder clause] : ( relation[$clause] | customIndexExpression[$clause] );
	public final void relationOrExpression(WhereClause.Builder clause) throws RecognitionException {
		try {
			// Parser.g:453:5: ( relation[$clause] | customIndexExpression[$clause] )
			int alt37=2;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==EMPTY_QUOTED_NAME||LA37_0==IDENT||LA37_0==K_ACCESS||(LA37_0 >= K_AGGREGATE && LA37_0 <= K_ALL)||LA37_0==K_ANN||LA37_0==K_AS||LA37_0==K_ASCII||(LA37_0 >= K_BIGINT && LA37_0 <= K_BOOLEAN)||(LA37_0 >= K_CALLED && LA37_0 <= K_CLUSTERING)||(LA37_0 >= K_COMPACT && LA37_0 <= K_COUNTER)||(LA37_0 >= K_CUSTOM && LA37_0 <= K_DEFAULT)||(LA37_0 >= K_DISTINCT && LA37_0 <= K_DOUBLE)||LA37_0==K_DURATION||(LA37_0 >= K_EXISTS && LA37_0 <= K_FLOAT)||LA37_0==K_FROZEN||(LA37_0 >= K_FUNCTION && LA37_0 <= K_FUNCTIONS)||(LA37_0 >= K_GROUP && LA37_0 <= K_IDENTITY)||(LA37_0 >= K_INET && LA37_0 <= K_INPUT)||(LA37_0 >= K_INT && LA37_0 <= K_INTERNALS)||(LA37_0 >= K_JSON && LA37_0 <= K_KEYS)||(LA37_0 >= K_KEYSPACES && LA37_0 <= K_LIKE)||(LA37_0 >= K_LIST && LA37_0 <= K_MASKED)||(LA37_0 >= K_MAXWRITETIME && LA37_0 <= K_MBEANS)||LA37_0==K_NOLOGIN||LA37_0==K_NOSUPERUSER||(LA37_0 >= K_ONLY && LA37_0 <= K_OPTIONS)||(LA37_0 >= K_PARTITION && LA37_0 <= K_PERMISSIONS)||(LA37_0 >= K_REPLACE && LA37_0 <= K_RETURNS)||(LA37_0 >= K_ROLE && LA37_0 <= K_ROLES)||LA37_0==K_SELECT_MASKED||(LA37_0 >= K_SFUNC && LA37_0 <= K_TINYINT)||(LA37_0 >= K_TOKEN && LA37_0 <= K_TRIGGER)||(LA37_0 >= K_TTL && LA37_0 <= K_TYPES)||(LA37_0 >= K_UNMASK && LA37_0 <= K_UNSET)||(LA37_0 >= K_USER && LA37_0 <= K_USERS)||(LA37_0 >= K_UUID && LA37_0 <= K_VECTOR)||LA37_0==K_WRITETIME||LA37_0==QUOTED_NAME||LA37_0==209) ) {
				alt37=1;
			}
			else if ( (LA37_0==228) ) {
				alt37=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 37, 0, input);
				throw nvae;
			}

			switch (alt37) {
				case 1 :
					// Parser.g:453:7: relation[$clause]
					{
					pushFollow(FOLLOW_relation_in_relationOrExpression3060);
					relation(clause);
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:454:7: customIndexExpression[$clause]
					{
					pushFollow(FOLLOW_customIndexExpression_in_relationOrExpression3069);
					customIndexExpression(clause);
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "relationOrExpression"



	// $ANTLR start "customIndexExpression"
	// Parser.g:457:1: customIndexExpression[WhereClause.Builder clause] : 'expr(' idxName[name] ',' t= term ')' ;
	public final void customIndexExpression(WhereClause.Builder clause) throws RecognitionException {
		Term.Raw t =null;

		QualifiedName name = new QualifiedName();
		try {
			// Parser.g:459:5: ( 'expr(' idxName[name] ',' t= term ')' )
			// Parser.g:459:7: 'expr(' idxName[name] ',' t= term ')'
			{
			match(input,228,FOLLOW_228_in_customIndexExpression3097); if (state.failed) return;
			pushFollow(FOLLOW_idxName_in_customIndexExpression3099);
			idxName(name);
			state._fsp--;
			if (state.failed) return;
			match(input,213,FOLLOW_213_in_customIndexExpression3102); if (state.failed) return;
			pushFollow(FOLLOW_term_in_customIndexExpression3106);
			t=term();
			state._fsp--;
			if (state.failed) return;
			match(input,210,FOLLOW_210_in_customIndexExpression3108); if (state.failed) return;
			if ( state.backtracking==0 ) { clause.add(new CustomIndexExpression(name, t));}
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "customIndexExpression"



	// $ANTLR start "orderByClause"
	// Parser.g:462:1: orderByClause[List<Ordering.Raw> orderings] : c= cident ( K_ANN K_OF t= term )? ( K_ASC | K_DESC )? ;
	public final void orderByClause(List<Ordering.Raw> orderings) throws RecognitionException {
		ColumnIdentifier c =null;
		Term.Raw t =null;


		        Ordering.Direction direction = Ordering.Direction.ASC;
		    
		try {
			// Parser.g:466:5: (c= cident ( K_ANN K_OF t= term )? ( K_ASC | K_DESC )? )
			// Parser.g:466:7: c= cident ( K_ANN K_OF t= term )? ( K_ASC | K_DESC )?
			{
			pushFollow(FOLLOW_cident_in_orderByClause3138);
			c=cident();
			state._fsp--;
			if (state.failed) return;
			// Parser.g:466:16: ( K_ANN K_OF t= term )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==K_ANN) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// Parser.g:466:17: K_ANN K_OF t= term
					{
					match(input,K_ANN,FOLLOW_K_ANN_in_orderByClause3141); if (state.failed) return;
					match(input,K_OF,FOLLOW_K_OF_in_orderByClause3143); if (state.failed) return;
					pushFollow(FOLLOW_term_in_orderByClause3147);
					t=term();
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}

			// Parser.g:466:37: ( K_ASC | K_DESC )?
			int alt39=3;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==K_ASC) ) {
				alt39=1;
			}
			else if ( (LA39_0==K_DESC) ) {
				alt39=2;
			}
			switch (alt39) {
				case 1 :
					// Parser.g:466:38: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause3152); if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:466:46: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause3156); if (state.failed) return;
					if ( state.backtracking==0 ) { direction = Ordering.Direction.DESC; }
					}
					break;

			}

			if ( state.backtracking==0 ) {
			        Ordering.Raw.Expression expr = (t == null)
			            ? new Ordering.Raw.SingleColumn(c)
			            : new Ordering.Raw.Ann(c, t);
			        orderings.add(new Ordering.Raw(expr, direction));
			    }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderByClause"



	// $ANTLR start "groupByClause"
	// Parser.g:475:1: groupByClause[List<Selectable.Raw> groups] : s= unaliasedSelector ;
	public final void groupByClause(List<Selectable.Raw> groups) throws RecognitionException {
		Selectable.Raw s =null;

		try {
			// Parser.g:476:5: (s= unaliasedSelector )
			// Parser.g:476:7: s= unaliasedSelector
			{
			pushFollow(FOLLOW_unaliasedSelector_in_groupByClause3186);
			s=unaliasedSelector();
			state._fsp--;
			if (state.failed) return;
			if ( state.backtracking==0 ) { groups.add(s); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupByClause"



	// $ANTLR start "insertStatement"
	// Parser.g:485:1: insertStatement returns [ModificationStatement.Parsed expr] : K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] ) ;
	public final ModificationStatement.Parsed insertStatement() throws RecognitionException {
		ModificationStatement.Parsed expr = null;


		QualifiedName cf =null;
		UpdateStatement.ParsedInsert st1 =null;
		UpdateStatement.ParsedInsertJson st2 =null;

		try {
			// Parser.g:486:5: ( K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] ) )
			// Parser.g:486:7: K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] )
			{
			match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement3211); if (state.failed) return expr;
			match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement3213); if (state.failed) return expr;
			pushFollow(FOLLOW_columnFamilyName_in_insertStatement3217);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:487:9: (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==209) ) {
				alt40=1;
			}
			else if ( (LA40_0==K_JSON) ) {
				alt40=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return expr;}
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// Parser.g:487:11: st1= normalInsertStatement[cf]
					{
					pushFollow(FOLLOW_normalInsertStatement_in_insertStatement3231);
					st1=normalInsertStatement(cf);
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { expr = st1; }
					}
					break;
				case 2 :
					// Parser.g:488:11: K_JSON st2= jsonInsertStatement[cf]
					{
					match(input,K_JSON,FOLLOW_K_JSON_in_insertStatement3246); if (state.failed) return expr;
					pushFollow(FOLLOW_jsonInsertStatement_in_insertStatement3250);
					st2=jsonInsertStatement(cf);
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { expr = st2; }
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "insertStatement"



	// $ANTLR start "normalInsertStatement"
	// Parser.g:491:1: normalInsertStatement[QualifiedName qn] returns [UpdateStatement.ParsedInsert expr] : '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsert normalInsertStatement(QualifiedName qn) throws RecognitionException {
		UpdateStatement.ParsedInsert expr = null;


		ColumnIdentifier c1 =null;
		ColumnIdentifier cn =null;
		Term.Raw v1 =null;
		Term.Raw vn =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<ColumnIdentifier> columnNames  = new ArrayList<>();
		        List<Term.Raw> values = new ArrayList<>();
		        boolean ifNotExists = false;
		    
		try {
			// Parser.g:498:5: ( '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// Parser.g:498:7: '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			match(input,209,FOLLOW_209_in_normalInsertStatement3286); if (state.failed) return expr;
			pushFollow(FOLLOW_cident_in_normalInsertStatement3290);
			c1=cident();
			state._fsp--;
			if (state.failed) return expr;
			if ( state.backtracking==0 ) { columnNames.add(c1); }
			// Parser.g:498:47: ( ',' cn= cident )*
			loop41:
			while (true) {
				int alt41=2;
				int LA41_0 = input.LA(1);
				if ( (LA41_0==213) ) {
					alt41=1;
				}

				switch (alt41) {
				case 1 :
					// Parser.g:498:49: ',' cn= cident
					{
					match(input,213,FOLLOW_213_in_normalInsertStatement3297); if (state.failed) return expr;
					pushFollow(FOLLOW_cident_in_normalInsertStatement3301);
					cn=cident();
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { columnNames.add(cn); }
					}
					break;

				default :
					break loop41;
				}
			}

			match(input,210,FOLLOW_210_in_normalInsertStatement3308); if (state.failed) return expr;
			match(input,K_VALUES,FOLLOW_K_VALUES_in_normalInsertStatement3316); if (state.failed) return expr;
			match(input,209,FOLLOW_209_in_normalInsertStatement3324); if (state.failed) return expr;
			pushFollow(FOLLOW_term_in_normalInsertStatement3328);
			v1=term();
			state._fsp--;
			if (state.failed) return expr;
			if ( state.backtracking==0 ) { values.add(v1); }
			// Parser.g:500:39: ( ',' vn= term )*
			loop42:
			while (true) {
				int alt42=2;
				int LA42_0 = input.LA(1);
				if ( (LA42_0==213) ) {
					alt42=1;
				}

				switch (alt42) {
				case 1 :
					// Parser.g:500:41: ',' vn= term
					{
					match(input,213,FOLLOW_213_in_normalInsertStatement3334); if (state.failed) return expr;
					pushFollow(FOLLOW_term_in_normalInsertStatement3338);
					vn=term();
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { values.add(vn); }
					}
					break;

				default :
					break loop42;
				}
			}

			match(input,210,FOLLOW_210_in_normalInsertStatement3345); if (state.failed) return expr;
			// Parser.g:501:7: ( K_IF K_NOT K_EXISTS )?
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==K_IF) ) {
				alt43=1;
			}
			switch (alt43) {
				case 1 :
					// Parser.g:501:9: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_normalInsertStatement3355); if (state.failed) return expr;
					match(input,K_NOT,FOLLOW_K_NOT_in_normalInsertStatement3357); if (state.failed) return expr;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_normalInsertStatement3359); if (state.failed) return expr;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			// Parser.g:502:7: ( usingClause[attrs] )?
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==K_USING) ) {
				alt44=1;
			}
			switch (alt44) {
				case 1 :
					// Parser.g:502:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_normalInsertStatement3374);
					usingClause(attrs);
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			          expr = new UpdateStatement.ParsedInsert(qn, attrs, columnNames, values, ifNotExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "normalInsertStatement"



	// $ANTLR start "jsonInsertStatement"
	// Parser.g:508:1: jsonInsertStatement[QualifiedName qn] returns [UpdateStatement.ParsedInsertJson expr] : val= jsonValue ( K_DEFAULT ( K_NULL | ( K_UNSET ) ) )? ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsertJson jsonInsertStatement(QualifiedName qn) throws RecognitionException {
		UpdateStatement.ParsedInsertJson expr = null;


		Json.Raw val =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        boolean ifNotExists = false;
		        boolean defaultUnset = false;
		    
		try {
			// Parser.g:514:5: (val= jsonValue ( K_DEFAULT ( K_NULL | ( K_UNSET ) ) )? ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// Parser.g:514:7: val= jsonValue ( K_DEFAULT ( K_NULL | ( K_UNSET ) ) )? ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			pushFollow(FOLLOW_jsonValue_in_jsonInsertStatement3420);
			val=jsonValue();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:515:7: ( K_DEFAULT ( K_NULL | ( K_UNSET ) ) )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==K_DEFAULT) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// Parser.g:515:9: K_DEFAULT ( K_NULL | ( K_UNSET ) )
					{
					match(input,K_DEFAULT,FOLLOW_K_DEFAULT_in_jsonInsertStatement3430); if (state.failed) return expr;
					// Parser.g:515:19: ( K_NULL | ( K_UNSET ) )
					int alt45=2;
					int LA45_0 = input.LA(1);
					if ( (LA45_0==K_NULL) ) {
						alt45=1;
					}
					else if ( (LA45_0==K_UNSET) ) {
						alt45=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return expr;}
						NoViableAltException nvae =
							new NoViableAltException("", 45, 0, input);
						throw nvae;
					}

					switch (alt45) {
						case 1 :
							// Parser.g:515:21: K_NULL
							{
							match(input,K_NULL,FOLLOW_K_NULL_in_jsonInsertStatement3434); if (state.failed) return expr;
							}
							break;
						case 2 :
							// Parser.g:515:30: ( K_UNSET )
							{
							// Parser.g:515:30: ( K_UNSET )
							// Parser.g:515:32: K_UNSET
							{
							if ( state.backtracking==0 ) { defaultUnset = true; }
							match(input,K_UNSET,FOLLOW_K_UNSET_in_jsonInsertStatement3442); if (state.failed) return expr;
							}

							}
							break;

					}

					}
					break;

			}

			// Parser.g:516:7: ( K_IF K_NOT K_EXISTS )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==K_IF) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// Parser.g:516:9: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_jsonInsertStatement3458); if (state.failed) return expr;
					match(input,K_NOT,FOLLOW_K_NOT_in_jsonInsertStatement3460); if (state.failed) return expr;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_jsonInsertStatement3462); if (state.failed) return expr;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			// Parser.g:517:7: ( usingClause[attrs] )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==K_USING) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// Parser.g:517:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_jsonInsertStatement3477);
					usingClause(attrs);
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			          expr = new UpdateStatement.ParsedInsertJson(qn, attrs, val, defaultUnset, ifNotExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "jsonInsertStatement"



	// $ANTLR start "jsonValue"
	// Parser.g:523:1: jsonValue returns [Json.Raw value] : (s= STRING_LITERAL | ':' id= noncol_ident | QMARK );
	public final Json.Raw jsonValue() throws RecognitionException {
		Json.Raw value = null;


		Token s=null;
		ColumnIdentifier id =null;

		try {
			// Parser.g:524:5: (s= STRING_LITERAL | ':' id= noncol_ident | QMARK )
			int alt49=3;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt49=1;
				}
				break;
			case 218:
				{
				alt49=2;
				}
				break;
			case QMARK:
				{
				alt49=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return value;}
				NoViableAltException nvae =
					new NoViableAltException("", 49, 0, input);
				throw nvae;
			}
			switch (alt49) {
				case 1 :
					// Parser.g:524:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_jsonValue3512); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = new Json.Literal((s!=null?s.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:525:7: ':' id= noncol_ident
					{
					match(input,218,FOLLOW_218_in_jsonValue3522); if (state.failed) return value;
					pushFollow(FOLLOW_noncol_ident_in_jsonValue3526);
					id=noncol_ident();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newJsonBindVariables(id); }
					}
					break;
				case 3 :
					// Parser.g:526:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_jsonValue3540); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newJsonBindVariables(null); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "jsonValue"



	// $ANTLR start "usingClause"
	// Parser.g:529:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* ;
	public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
		try {
			// Parser.g:530:5: ( K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* )
			// Parser.g:530:7: K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )*
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClause3571); if (state.failed) return;
			pushFollow(FOLLOW_usingClauseObjective_in_usingClause3573);
			usingClauseObjective(attrs);
			state._fsp--;
			if (state.failed) return;
			// Parser.g:530:43: ( K_AND usingClauseObjective[attrs] )*
			loop50:
			while (true) {
				int alt50=2;
				int LA50_0 = input.LA(1);
				if ( (LA50_0==K_AND) ) {
					alt50=1;
				}

				switch (alt50) {
				case 1 :
					// Parser.g:530:45: K_AND usingClauseObjective[attrs]
					{
					match(input,K_AND,FOLLOW_K_AND_in_usingClause3578); if (state.failed) return;
					pushFollow(FOLLOW_usingClauseObjective_in_usingClause3580);
					usingClauseObjective(attrs);
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop50;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "usingClauseObjective"
	// Parser.g:533:1: usingClauseObjective[Attributes.Raw attrs] : ( K_TIMESTAMP ts= intValue | K_TTL t= intValue );
	public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;
		Term.Raw t =null;

		try {
			// Parser.g:534:5: ( K_TIMESTAMP ts= intValue | K_TTL t= intValue )
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==K_TIMESTAMP) ) {
				alt51=1;
			}
			else if ( (LA51_0==K_TTL) ) {
				alt51=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 51, 0, input);
				throw nvae;
			}

			switch (alt51) {
				case 1 :
					// Parser.g:534:7: K_TIMESTAMP ts= intValue
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseObjective3602); if (state.failed) return;
					pushFollow(FOLLOW_intValue_in_usingClauseObjective3606);
					ts=intValue();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { attrs.timestamp = ts; }
					}
					break;
				case 2 :
					// Parser.g:535:7: K_TTL t= intValue
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective3616); if (state.failed) return;
					pushFollow(FOLLOW_intValue_in_usingClauseObjective3620);
					t=intValue();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { attrs.timeToLive = t; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseObjective"



	// $ANTLR start "updateStatement"
	// Parser.g:545:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
		UpdateStatement.ParsedUpdate expr = null;


		QualifiedName cf =null;
		WhereClause.Builder wclause =null;
		List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations = new ArrayList<>();
		        boolean ifExists = false;
		    
		try {
			// Parser.g:551:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// Parser.g:551:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement3654); if (state.failed) return expr;
			pushFollow(FOLLOW_columnFamilyName_in_updateStatement3658);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:552:7: ( usingClause[attrs] )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==K_USING) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// Parser.g:552:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_updateStatement3668);
					usingClause(attrs);
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

			}

			match(input,K_SET,FOLLOW_K_SET_in_updateStatement3680); if (state.failed) return expr;
			pushFollow(FOLLOW_columnOperation_in_updateStatement3682);
			columnOperation(operations);
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:553:41: ( ',' columnOperation[operations] )*
			loop53:
			while (true) {
				int alt53=2;
				int LA53_0 = input.LA(1);
				if ( (LA53_0==213) ) {
					alt53=1;
				}

				switch (alt53) {
				case 1 :
					// Parser.g:553:42: ',' columnOperation[operations]
					{
					match(input,213,FOLLOW_213_in_updateStatement3686); if (state.failed) return expr;
					pushFollow(FOLLOW_columnOperation_in_updateStatement3688);
					columnOperation(operations);
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

				default :
					break loop53;
				}
			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement3699); if (state.failed) return expr;
			pushFollow(FOLLOW_whereClause_in_updateStatement3703);
			wclause=whereClause();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:555:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==K_IF) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// Parser.g:555:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_updateStatement3713); if (state.failed) return expr;
					// Parser.g:555:14: ( K_EXISTS |conditions= updateConditions )
					int alt54=2;
					int LA54_0 = input.LA(1);
					if ( (LA54_0==K_EXISTS) ) {
						int LA54_1 = input.LA(2);
						if ( (LA54_1==EOF||LA54_1==K_APPLY||LA54_1==K_DELETE||LA54_1==K_INSERT||LA54_1==K_UPDATE||LA54_1==219) ) {
							alt54=1;
						}
						else if ( (LA54_1==K_CONTAINS||LA54_1==K_IN||LA54_1==207||LA54_1==216||(LA54_1 >= 220 && LA54_1 <= 225)) ) {
							alt54=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return expr;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 54, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA54_0==EMPTY_QUOTED_NAME||LA54_0==IDENT||LA54_0==K_ACCESS||(LA54_0 >= K_AGGREGATE && LA54_0 <= K_ALL)||LA54_0==K_ANN||LA54_0==K_AS||LA54_0==K_ASCII||(LA54_0 >= K_BIGINT && LA54_0 <= K_BOOLEAN)||(LA54_0 >= K_CALLED && LA54_0 <= K_CLUSTERING)||(LA54_0 >= K_COMPACT && LA54_0 <= K_COUNTER)||(LA54_0 >= K_CUSTOM && LA54_0 <= K_DEFAULT)||(LA54_0 >= K_DISTINCT && LA54_0 <= K_DOUBLE)||LA54_0==K_DURATION||(LA54_0 >= K_FILTERING && LA54_0 <= K_FLOAT)||LA54_0==K_FROZEN||(LA54_0 >= K_FUNCTION && LA54_0 <= K_FUNCTIONS)||(LA54_0 >= K_GROUP && LA54_0 <= K_IDENTITY)||(LA54_0 >= K_INET && LA54_0 <= K_INPUT)||(LA54_0 >= K_INT && LA54_0 <= K_INTERNALS)||(LA54_0 >= K_JSON && LA54_0 <= K_KEYS)||(LA54_0 >= K_KEYSPACES && LA54_0 <= K_LIKE)||(LA54_0 >= K_LIST && LA54_0 <= K_MASKED)||(LA54_0 >= K_MAXWRITETIME && LA54_0 <= K_MBEANS)||LA54_0==K_NOLOGIN||LA54_0==K_NOSUPERUSER||(LA54_0 >= K_ONLY && LA54_0 <= K_OPTIONS)||(LA54_0 >= K_PARTITION && LA54_0 <= K_PERMISSIONS)||(LA54_0 >= K_REPLACE && LA54_0 <= K_RETURNS)||(LA54_0 >= K_ROLE && LA54_0 <= K_ROLES)||LA54_0==K_SELECT_MASKED||(LA54_0 >= K_SFUNC && LA54_0 <= K_TINYINT)||LA54_0==K_TRIGGER||(LA54_0 >= K_TTL && LA54_0 <= K_TYPES)||(LA54_0 >= K_UNMASK && LA54_0 <= K_UNSET)||(LA54_0 >= K_USER && LA54_0 <= K_USERS)||(LA54_0 >= K_UUID && LA54_0 <= K_VECTOR)||LA54_0==K_WRITETIME||LA54_0==QUOTED_NAME) ) {
						alt54=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return expr;}
						NoViableAltException nvae =
							new NoViableAltException("", 54, 0, input);
						throw nvae;
					}

					switch (alt54) {
						case 1 :
							// Parser.g:555:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_updateStatement3717); if (state.failed) return expr;
							if ( state.backtracking==0 ) { ifExists = true; }
							}
							break;
						case 2 :
							// Parser.g:555:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_updateStatement3725);
							conditions=updateConditions();
							state._fsp--;
							if (state.failed) return expr;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          expr = new UpdateStatement.ParsedUpdate(cf,
			                                                   attrs,
			                                                   operations,
			                                                   wclause.build(),
			                                                   conditions == null ? Collections.<Pair<ColumnIdentifier, ColumnCondition.Raw>>emptyList() : conditions,
			                                                   ifExists);
			     }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "updateStatement"



	// $ANTLR start "updateConditions"
	// Parser.g:566:1: updateConditions returns [List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions] : columnCondition[conditions] ( K_AND columnCondition[conditions] )* ;
	public final List<Pair<ColumnIdentifier, ColumnCondition.Raw>> updateConditions() throws RecognitionException {
		List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions = null;


		 conditions = new ArrayList<Pair<ColumnIdentifier, ColumnCondition.Raw>>(); 
		try {
			// Parser.g:568:5: ( columnCondition[conditions] ( K_AND columnCondition[conditions] )* )
			// Parser.g:568:7: columnCondition[conditions] ( K_AND columnCondition[conditions] )*
			{
			pushFollow(FOLLOW_columnCondition_in_updateConditions3767);
			columnCondition(conditions);
			state._fsp--;
			if (state.failed) return conditions;
			// Parser.g:568:35: ( K_AND columnCondition[conditions] )*
			loop56:
			while (true) {
				int alt56=2;
				int LA56_0 = input.LA(1);
				if ( (LA56_0==K_AND) ) {
					alt56=1;
				}

				switch (alt56) {
				case 1 :
					// Parser.g:568:37: K_AND columnCondition[conditions]
					{
					match(input,K_AND,FOLLOW_K_AND_in_updateConditions3772); if (state.failed) return conditions;
					pushFollow(FOLLOW_columnCondition_in_updateConditions3774);
					columnCondition(conditions);
					state._fsp--;
					if (state.failed) return conditions;
					}
					break;

				default :
					break loop56;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return conditions;
	}
	// $ANTLR end "updateConditions"



	// $ANTLR start "deleteStatement"
	// Parser.g:579:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
		DeleteStatement.Parsed expr = null;


		List<Operation.RawDeletion> dels =null;
		QualifiedName cf =null;
		WhereClause.Builder wclause =null;
		List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
		        boolean ifExists = false;
		    
		try {
			// Parser.g:585:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// Parser.g:585:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement3811); if (state.failed) return expr;
			// Parser.g:585:16: (dels= deleteSelection )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==EMPTY_QUOTED_NAME||LA57_0==IDENT||LA57_0==K_ACCESS||(LA57_0 >= K_AGGREGATE && LA57_0 <= K_ALL)||LA57_0==K_ANN||LA57_0==K_AS||LA57_0==K_ASCII||(LA57_0 >= K_BIGINT && LA57_0 <= K_BOOLEAN)||(LA57_0 >= K_CALLED && LA57_0 <= K_CLUSTERING)||(LA57_0 >= K_COMPACT && LA57_0 <= K_COUNTER)||(LA57_0 >= K_CUSTOM && LA57_0 <= K_DEFAULT)||(LA57_0 >= K_DISTINCT && LA57_0 <= K_DOUBLE)||LA57_0==K_DURATION||(LA57_0 >= K_EXISTS && LA57_0 <= K_FLOAT)||LA57_0==K_FROZEN||(LA57_0 >= K_FUNCTION && LA57_0 <= K_FUNCTIONS)||(LA57_0 >= K_GROUP && LA57_0 <= K_IDENTITY)||(LA57_0 >= K_INET && LA57_0 <= K_INPUT)||(LA57_0 >= K_INT && LA57_0 <= K_INTERNALS)||(LA57_0 >= K_JSON && LA57_0 <= K_KEYS)||(LA57_0 >= K_KEYSPACES && LA57_0 <= K_LIKE)||(LA57_0 >= K_LIST && LA57_0 <= K_MASKED)||(LA57_0 >= K_MAXWRITETIME && LA57_0 <= K_MBEANS)||LA57_0==K_NOLOGIN||LA57_0==K_NOSUPERUSER||(LA57_0 >= K_ONLY && LA57_0 <= K_OPTIONS)||(LA57_0 >= K_PARTITION && LA57_0 <= K_PERMISSIONS)||(LA57_0 >= K_REPLACE && LA57_0 <= K_RETURNS)||(LA57_0 >= K_ROLE && LA57_0 <= K_ROLES)||LA57_0==K_SELECT_MASKED||(LA57_0 >= K_SFUNC && LA57_0 <= K_TINYINT)||LA57_0==K_TRIGGER||(LA57_0 >= K_TTL && LA57_0 <= K_TYPES)||(LA57_0 >= K_UNMASK && LA57_0 <= K_UNSET)||(LA57_0 >= K_USER && LA57_0 <= K_USERS)||(LA57_0 >= K_UUID && LA57_0 <= K_VECTOR)||LA57_0==K_WRITETIME||LA57_0==QUOTED_NAME) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// Parser.g:585:18: dels= deleteSelection
					{
					pushFollow(FOLLOW_deleteSelection_in_deleteStatement3817);
					dels=deleteSelection();
					state._fsp--;
					if (state.failed) return expr;
					if ( state.backtracking==0 ) { columnDeletions = dels; }
					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement3830); if (state.failed) return expr;
			pushFollow(FOLLOW_columnFamilyName_in_deleteStatement3834);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:587:7: ( usingClauseDelete[attrs] )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==K_USING) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// Parser.g:587:9: usingClauseDelete[attrs]
					{
					pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement3844);
					usingClauseDelete(attrs);
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement3856); if (state.failed) return expr;
			pushFollow(FOLLOW_whereClause_in_deleteStatement3860);
			wclause=whereClause();
			state._fsp--;
			if (state.failed) return expr;
			// Parser.g:589:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==K_IF) ) {
				alt60=1;
			}
			switch (alt60) {
				case 1 :
					// Parser.g:589:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_deleteStatement3870); if (state.failed) return expr;
					// Parser.g:589:14: ( K_EXISTS |conditions= updateConditions )
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==K_EXISTS) ) {
						int LA59_1 = input.LA(2);
						if ( (LA59_1==EOF||LA59_1==K_APPLY||LA59_1==K_DELETE||LA59_1==K_INSERT||LA59_1==K_UPDATE||LA59_1==219) ) {
							alt59=1;
						}
						else if ( (LA59_1==K_CONTAINS||LA59_1==K_IN||LA59_1==207||LA59_1==216||(LA59_1 >= 220 && LA59_1 <= 225)) ) {
							alt59=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return expr;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 59, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA59_0==EMPTY_QUOTED_NAME||LA59_0==IDENT||LA59_0==K_ACCESS||(LA59_0 >= K_AGGREGATE && LA59_0 <= K_ALL)||LA59_0==K_ANN||LA59_0==K_AS||LA59_0==K_ASCII||(LA59_0 >= K_BIGINT && LA59_0 <= K_BOOLEAN)||(LA59_0 >= K_CALLED && LA59_0 <= K_CLUSTERING)||(LA59_0 >= K_COMPACT && LA59_0 <= K_COUNTER)||(LA59_0 >= K_CUSTOM && LA59_0 <= K_DEFAULT)||(LA59_0 >= K_DISTINCT && LA59_0 <= K_DOUBLE)||LA59_0==K_DURATION||(LA59_0 >= K_FILTERING && LA59_0 <= K_FLOAT)||LA59_0==K_FROZEN||(LA59_0 >= K_FUNCTION && LA59_0 <= K_FUNCTIONS)||(LA59_0 >= K_GROUP && LA59_0 <= K_IDENTITY)||(LA59_0 >= K_INET && LA59_0 <= K_INPUT)||(LA59_0 >= K_INT && LA59_0 <= K_INTERNALS)||(LA59_0 >= K_JSON && LA59_0 <= K_KEYS)||(LA59_0 >= K_KEYSPACES && LA59_0 <= K_LIKE)||(LA59_0 >= K_LIST && LA59_0 <= K_MASKED)||(LA59_0 >= K_MAXWRITETIME && LA59_0 <= K_MBEANS)||LA59_0==K_NOLOGIN||LA59_0==K_NOSUPERUSER||(LA59_0 >= K_ONLY && LA59_0 <= K_OPTIONS)||(LA59_0 >= K_PARTITION && LA59_0 <= K_PERMISSIONS)||(LA59_0 >= K_REPLACE && LA59_0 <= K_RETURNS)||(LA59_0 >= K_ROLE && LA59_0 <= K_ROLES)||LA59_0==K_SELECT_MASKED||(LA59_0 >= K_SFUNC && LA59_0 <= K_TINYINT)||LA59_0==K_TRIGGER||(LA59_0 >= K_TTL && LA59_0 <= K_TYPES)||(LA59_0 >= K_UNMASK && LA59_0 <= K_UNSET)||(LA59_0 >= K_USER && LA59_0 <= K_USERS)||(LA59_0 >= K_UUID && LA59_0 <= K_VECTOR)||LA59_0==K_WRITETIME||LA59_0==QUOTED_NAME) ) {
						alt59=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return expr;}
						NoViableAltException nvae =
							new NoViableAltException("", 59, 0, input);
						throw nvae;
					}

					switch (alt59) {
						case 1 :
							// Parser.g:589:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_deleteStatement3874); if (state.failed) return expr;
							if ( state.backtracking==0 ) { ifExists = true; }
							}
							break;
						case 2 :
							// Parser.g:589:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_deleteStatement3882);
							conditions=updateConditions();
							state._fsp--;
							if (state.failed) return expr;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          expr = new DeleteStatement.Parsed(cf,
			                                             attrs,
			                                             columnDeletions,
			                                             wclause.build(),
			                                             conditions == null ? Collections.<Pair<ColumnIdentifier, ColumnCondition.Raw>>emptyList() : conditions,
			                                             ifExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "deleteStatement"



	// $ANTLR start "deleteSelection"
	// Parser.g:600:1: deleteSelection returns [List<Operation.RawDeletion> operations] :t1= deleteOp ( ',' tN= deleteOp )* ;
	public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
		List<Operation.RawDeletion> operations = null;


		Operation.RawDeletion t1 =null;
		Operation.RawDeletion tN =null;

		try {
			// Parser.g:601:5: (t1= deleteOp ( ',' tN= deleteOp )* )
			// Parser.g:601:7: t1= deleteOp ( ',' tN= deleteOp )*
			{
			if ( state.backtracking==0 ) { operations = new ArrayList<Operation.RawDeletion>(); }
			pushFollow(FOLLOW_deleteOp_in_deleteSelection3929);
			t1=deleteOp();
			state._fsp--;
			if (state.failed) return operations;
			if ( state.backtracking==0 ) { operations.add(t1); }
			// Parser.g:603:11: ( ',' tN= deleteOp )*
			loop61:
			while (true) {
				int alt61=2;
				int LA61_0 = input.LA(1);
				if ( (LA61_0==213) ) {
					alt61=1;
				}

				switch (alt61) {
				case 1 :
					// Parser.g:603:12: ',' tN= deleteOp
					{
					match(input,213,FOLLOW_213_in_deleteSelection3944); if (state.failed) return operations;
					pushFollow(FOLLOW_deleteOp_in_deleteSelection3948);
					tN=deleteOp();
					state._fsp--;
					if (state.failed) return operations;
					if ( state.backtracking==0 ) { operations.add(tN); }
					}
					break;

				default :
					break loop61;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return operations;
	}
	// $ANTLR end "deleteSelection"



	// $ANTLR start "deleteOp"
	// Parser.g:606:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' |c= cident '.' field= fident );
	public final Operation.RawDeletion deleteOp() throws RecognitionException {
		Operation.RawDeletion op = null;


		ColumnIdentifier c =null;
		Term.Raw t =null;
		FieldIdentifier field =null;

		try {
			// Parser.g:607:5: (c= cident |c= cident '[' t= term ']' |c= cident '.' field= fident )
			int alt62=3;
			alt62 = dfa62.predict(input);
			switch (alt62) {
				case 1 :
					// Parser.g:607:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_deleteOp3975);
					c=cident();
					state._fsp--;
					if (state.failed) return op;
					if ( state.backtracking==0 ) { op = new Operation.ColumnDeletion(c); }
					}
					break;
				case 2 :
					// Parser.g:608:7: c= cident '[' t= term ']'
					{
					pushFollow(FOLLOW_cident_in_deleteOp4002);
					c=cident();
					state._fsp--;
					if (state.failed) return op;
					match(input,225,FOLLOW_225_in_deleteOp4004); if (state.failed) return op;
					pushFollow(FOLLOW_term_in_deleteOp4008);
					t=term();
					state._fsp--;
					if (state.failed) return op;
					match(input,227,FOLLOW_227_in_deleteOp4010); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = new Operation.ElementDeletion(c, t); }
					}
					break;
				case 3 :
					// Parser.g:609:7: c= cident '.' field= fident
					{
					pushFollow(FOLLOW_cident_in_deleteOp4022);
					c=cident();
					state._fsp--;
					if (state.failed) return op;
					match(input,216,FOLLOW_216_in_deleteOp4024); if (state.failed) return op;
					pushFollow(FOLLOW_fident_in_deleteOp4028);
					field=fident();
					state._fsp--;
					if (state.failed) return op;
					if ( state.backtracking==0 ) { op = new Operation.FieldDeletion(c, field); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "deleteOp"



	// $ANTLR start "usingClauseDelete"
	// Parser.g:612:1: usingClauseDelete[Attributes.Raw attrs] : K_USING K_TIMESTAMP ts= intValue ;
	public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;

		try {
			// Parser.g:613:5: ( K_USING K_TIMESTAMP ts= intValue )
			// Parser.g:613:7: K_USING K_TIMESTAMP ts= intValue
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete4048); if (state.failed) return;
			match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDelete4050); if (state.failed) return;
			pushFollow(FOLLOW_intValue_in_usingClauseDelete4054);
			ts=intValue();
			state._fsp--;
			if (state.failed) return;
			if ( state.backtracking==0 ) { attrs.timestamp = ts; }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseDelete"



	// $ANTLR start "batchStatement"
	// Parser.g:640:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
	public final BatchStatement.Parsed batchStatement() throws RecognitionException {
		BatchStatement.Parsed expr = null;


		ModificationStatement.Parsed s =null;


		        BatchStatement.Type type = BatchStatement.Type.LOGGED;
		        List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
		        Attributes.Raw attrs = new Attributes.Raw();
		    
		try {
			// Parser.g:646:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
			// Parser.g:646:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
			{
			match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement4088); if (state.failed) return expr;
			// Parser.g:647:7: ( K_UNLOGGED | K_COUNTER )?
			int alt63=3;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==K_UNLOGGED) ) {
				alt63=1;
			}
			else if ( (LA63_0==K_COUNTER) ) {
				alt63=2;
			}
			switch (alt63) {
				case 1 :
					// Parser.g:647:9: K_UNLOGGED
					{
					match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement4098); if (state.failed) return expr;
					if ( state.backtracking==0 ) { type = BatchStatement.Type.UNLOGGED; }
					}
					break;
				case 2 :
					// Parser.g:647:63: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement4104); if (state.failed) return expr;
					if ( state.backtracking==0 ) { type = BatchStatement.Type.COUNTER; }
					}
					break;

			}

			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement4117); if (state.failed) return expr;
			// Parser.g:648:15: ( usingClause[attrs] )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==K_USING) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// Parser.g:648:17: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_batchStatement4121);
					usingClause(attrs);
					state._fsp--;
					if (state.failed) return expr;
					}
					break;

			}

			// Parser.g:649:11: (s= batchStatementObjective ( ';' )? )*
			loop66:
			while (true) {
				int alt66=2;
				int LA66_0 = input.LA(1);
				if ( (LA66_0==K_DELETE||LA66_0==K_INSERT||LA66_0==K_UPDATE) ) {
					alt66=1;
				}

				switch (alt66) {
				case 1 :
					// Parser.g:649:13: s= batchStatementObjective ( ';' )?
					{
					pushFollow(FOLLOW_batchStatementObjective_in_batchStatement4141);
					s=batchStatementObjective();
					state._fsp--;
					if (state.failed) return expr;
					// Parser.g:649:39: ( ';' )?
					int alt65=2;
					int LA65_0 = input.LA(1);
					if ( (LA65_0==219) ) {
						alt65=1;
					}
					switch (alt65) {
						case 1 :
							// Parser.g:649:39: ';'
							{
							match(input,219,FOLLOW_219_in_batchStatement4143); if (state.failed) return expr;
							}
							break;

					}

					if ( state.backtracking==0 ) { statements.add(s); }
					}
					break;

				default :
					break loop66;
				}
			}

			match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement4157); if (state.failed) return expr;
			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement4159); if (state.failed) return expr;
			if ( state.backtracking==0 ) {
			          expr = new BatchStatement.Parsed(type, attrs, statements);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "batchStatement"



	// $ANTLR start "batchStatementObjective"
	// Parser.g:656:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement |u= updateStatement |d= deleteStatement );
	public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
		ModificationStatement.Parsed statement = null;


		ModificationStatement.Parsed i =null;
		UpdateStatement.ParsedUpdate u =null;
		DeleteStatement.Parsed d =null;

		try {
			// Parser.g:657:5: (i= insertStatement |u= updateStatement |d= deleteStatement )
			int alt67=3;
			switch ( input.LA(1) ) {
			case K_INSERT:
				{
				alt67=1;
				}
				break;
			case K_UPDATE:
				{
				alt67=2;
				}
				break;
			case K_DELETE:
				{
				alt67=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return statement;}
				NoViableAltException nvae =
					new NoViableAltException("", 67, 0, input);
				throw nvae;
			}
			switch (alt67) {
				case 1 :
					// Parser.g:657:7: i= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_batchStatementObjective4190);
					i=insertStatement();
					state._fsp--;
					if (state.failed) return statement;
					if ( state.backtracking==0 ) { statement = i; }
					}
					break;
				case 2 :
					// Parser.g:658:7: u= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_batchStatementObjective4203);
					u=updateStatement();
					state._fsp--;
					if (state.failed) return statement;
					if ( state.backtracking==0 ) { statement = u; }
					}
					break;
				case 3 :
					// Parser.g:659:7: d= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective4216);
					d=deleteStatement();
					state._fsp--;
					if (state.failed) return statement;
					if ( state.backtracking==0 ) { statement = d; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return statement;
	}
	// $ANTLR end "batchStatementObjective"



	// $ANTLR start "createAggregateStatement"
	// Parser.g:662:1: createAggregateStatement returns [CreateAggregateStatement.Raw stmt] : K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= allowedFunctionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= allowedFunctionName )? ( K_INITCOND ival= term )? ;
	public final CreateAggregateStatement.Raw createAggregateStatement() throws RecognitionException {
		CreateAggregateStatement.Raw stmt = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;
		String sfunc =null;
		CQL3Type.Raw stype =null;
		String ffunc =null;
		Term.Raw ival =null;


		        boolean orReplace = false;
		        boolean ifNotExists = false;

		        List<CQL3Type.Raw> argTypes = new ArrayList<>();
		    
		try {
			// Parser.g:669:5: ( K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= allowedFunctionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= allowedFunctionName )? ( K_INITCOND ival= term )? )
			// Parser.g:669:7: K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= allowedFunctionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= allowedFunctionName )? ( K_INITCOND ival= term )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createAggregateStatement4249); if (state.failed) return stmt;
			// Parser.g:669:16: ( K_OR K_REPLACE )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==K_OR) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// Parser.g:669:17: K_OR K_REPLACE
					{
					match(input,K_OR,FOLLOW_K_OR_in_createAggregateStatement4252); if (state.failed) return stmt;
					match(input,K_REPLACE,FOLLOW_K_REPLACE_in_createAggregateStatement4254); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { orReplace = true; }
					}
					break;

			}

			match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_createAggregateStatement4266); if (state.failed) return stmt;
			// Parser.g:671:7: ( K_IF K_NOT K_EXISTS )?
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==K_IF) ) {
				alt69=1;
			}
			switch (alt69) {
				case 1 :
					// Parser.g:671:8: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createAggregateStatement4275); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createAggregateStatement4277); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createAggregateStatement4279); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_createAggregateStatement4293);
			fn=functionName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,209,FOLLOW_209_in_createAggregateStatement4301); if (state.failed) return stmt;
			// Parser.g:674:9: (v= comparatorType ( ',' v= comparatorType )* )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==IDENT||LA71_0==K_ACCESS||(LA71_0 >= K_AGGREGATE && LA71_0 <= K_ALL)||LA71_0==K_ANN||LA71_0==K_AS||LA71_0==K_ASCII||(LA71_0 >= K_BIGINT && LA71_0 <= K_BOOLEAN)||(LA71_0 >= K_CALLED && LA71_0 <= K_CLUSTERING)||(LA71_0 >= K_COMPACT && LA71_0 <= K_COUNTER)||(LA71_0 >= K_CUSTOM && LA71_0 <= K_DEFAULT)||(LA71_0 >= K_DISTINCT && LA71_0 <= K_DOUBLE)||LA71_0==K_DURATION||(LA71_0 >= K_EXISTS && LA71_0 <= K_FLOAT)||LA71_0==K_FROZEN||(LA71_0 >= K_FUNCTION && LA71_0 <= K_FUNCTIONS)||(LA71_0 >= K_GROUP && LA71_0 <= K_IDENTITY)||(LA71_0 >= K_INET && LA71_0 <= K_INPUT)||(LA71_0 >= K_INT && LA71_0 <= K_INTERNALS)||(LA71_0 >= K_JSON && LA71_0 <= K_KEYS)||(LA71_0 >= K_KEYSPACES && LA71_0 <= K_LIKE)||(LA71_0 >= K_LIST && LA71_0 <= K_MASKED)||(LA71_0 >= K_MAXWRITETIME && LA71_0 <= K_MBEANS)||LA71_0==K_NOLOGIN||LA71_0==K_NOSUPERUSER||(LA71_0 >= K_ONLY && LA71_0 <= K_OPTIONS)||(LA71_0 >= K_PARTITION && LA71_0 <= K_PERMISSIONS)||(LA71_0 >= K_REPLACE && LA71_0 <= K_RETURNS)||(LA71_0 >= K_ROLE && LA71_0 <= K_ROLES)||(LA71_0 >= K_SELECT_MASKED && LA71_0 <= K_TINYINT)||LA71_0==K_TRIGGER||(LA71_0 >= K_TTL && LA71_0 <= K_TYPES)||(LA71_0 >= K_UNMASK && LA71_0 <= K_UNSET)||(LA71_0 >= K_USER && LA71_0 <= K_USERS)||(LA71_0 >= K_UUID && LA71_0 <= K_VECTOR)||LA71_0==K_WRITETIME||LA71_0==QUOTED_NAME||LA71_0==STRING_LITERAL) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// Parser.g:675:11: v= comparatorType ( ',' v= comparatorType )*
					{
					pushFollow(FOLLOW_comparatorType_in_createAggregateStatement4325);
					v=comparatorType();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { argTypes.add(v); }
					// Parser.g:676:11: ( ',' v= comparatorType )*
					loop70:
					while (true) {
						int alt70=2;
						int LA70_0 = input.LA(1);
						if ( (LA70_0==213) ) {
							alt70=1;
						}

						switch (alt70) {
						case 1 :
							// Parser.g:676:13: ',' v= comparatorType
							{
							match(input,213,FOLLOW_213_in_createAggregateStatement4341); if (state.failed) return stmt;
							pushFollow(FOLLOW_comparatorType_in_createAggregateStatement4345);
							v=comparatorType();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { argTypes.add(v); }
							}
							break;

						default :
							break loop70;
						}
					}

					}
					break;

			}

			match(input,210,FOLLOW_210_in_createAggregateStatement4369); if (state.failed) return stmt;
			match(input,K_SFUNC,FOLLOW_K_SFUNC_in_createAggregateStatement4377); if (state.failed) return stmt;
			pushFollow(FOLLOW_allowedFunctionName_in_createAggregateStatement4383);
			sfunc=allowedFunctionName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_STYPE,FOLLOW_K_STYPE_in_createAggregateStatement4391); if (state.failed) return stmt;
			pushFollow(FOLLOW_comparatorType_in_createAggregateStatement4397);
			stype=comparatorType();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:681:7: ( K_FINALFUNC ffunc= allowedFunctionName )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==K_FINALFUNC) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// Parser.g:682:9: K_FINALFUNC ffunc= allowedFunctionName
					{
					match(input,K_FINALFUNC,FOLLOW_K_FINALFUNC_in_createAggregateStatement4415); if (state.failed) return stmt;
					pushFollow(FOLLOW_allowedFunctionName_in_createAggregateStatement4421);
					ffunc=allowedFunctionName();
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			// Parser.g:684:7: ( K_INITCOND ival= term )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==K_INITCOND) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// Parser.g:685:9: K_INITCOND ival= term
					{
					match(input,K_INITCOND,FOLLOW_K_INITCOND_in_createAggregateStatement4448); if (state.failed) return stmt;
					pushFollow(FOLLOW_term_in_createAggregateStatement4454);
					ival=term();
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt = new CreateAggregateStatement.Raw(fn, argTypes, stype, sfunc, ffunc, ival, orReplace, ifNotExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createAggregateStatement"



	// $ANTLR start "dropAggregateStatement"
	// Parser.g:690:1: dropAggregateStatement returns [DropAggregateStatement.Raw stmt] : K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? ;
	public final DropAggregateStatement.Raw dropAggregateStatement() throws RecognitionException {
		DropAggregateStatement.Raw stmt = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        boolean ifExists = false;
		        List<CQL3Type.Raw> argTypes = new ArrayList<>();
		        boolean argsSpecified = false;
		    
		try {
			// Parser.g:696:5: ( K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? )
			// Parser.g:696:7: K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropAggregateStatement4501); if (state.failed) return stmt;
			match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_dropAggregateStatement4503); if (state.failed) return stmt;
			// Parser.g:697:7: ( K_IF K_EXISTS )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==K_IF) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// Parser.g:697:8: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropAggregateStatement4512); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropAggregateStatement4514); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_dropAggregateStatement4529);
			fn=functionName();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:699:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==209) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// Parser.g:700:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,209,FOLLOW_209_in_dropAggregateStatement4547); if (state.failed) return stmt;
					// Parser.g:701:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==IDENT||LA76_0==K_ACCESS||(LA76_0 >= K_AGGREGATE && LA76_0 <= K_ALL)||LA76_0==K_ANN||LA76_0==K_AS||LA76_0==K_ASCII||(LA76_0 >= K_BIGINT && LA76_0 <= K_BOOLEAN)||(LA76_0 >= K_CALLED && LA76_0 <= K_CLUSTERING)||(LA76_0 >= K_COMPACT && LA76_0 <= K_COUNTER)||(LA76_0 >= K_CUSTOM && LA76_0 <= K_DEFAULT)||(LA76_0 >= K_DISTINCT && LA76_0 <= K_DOUBLE)||LA76_0==K_DURATION||(LA76_0 >= K_EXISTS && LA76_0 <= K_FLOAT)||LA76_0==K_FROZEN||(LA76_0 >= K_FUNCTION && LA76_0 <= K_FUNCTIONS)||(LA76_0 >= K_GROUP && LA76_0 <= K_IDENTITY)||(LA76_0 >= K_INET && LA76_0 <= K_INPUT)||(LA76_0 >= K_INT && LA76_0 <= K_INTERNALS)||(LA76_0 >= K_JSON && LA76_0 <= K_KEYS)||(LA76_0 >= K_KEYSPACES && LA76_0 <= K_LIKE)||(LA76_0 >= K_LIST && LA76_0 <= K_MASKED)||(LA76_0 >= K_MAXWRITETIME && LA76_0 <= K_MBEANS)||LA76_0==K_NOLOGIN||LA76_0==K_NOSUPERUSER||(LA76_0 >= K_ONLY && LA76_0 <= K_OPTIONS)||(LA76_0 >= K_PARTITION && LA76_0 <= K_PERMISSIONS)||(LA76_0 >= K_REPLACE && LA76_0 <= K_RETURNS)||(LA76_0 >= K_ROLE && LA76_0 <= K_ROLES)||(LA76_0 >= K_SELECT_MASKED && LA76_0 <= K_TINYINT)||LA76_0==K_TRIGGER||(LA76_0 >= K_TTL && LA76_0 <= K_TYPES)||(LA76_0 >= K_UNMASK && LA76_0 <= K_UNSET)||(LA76_0 >= K_USER && LA76_0 <= K_USERS)||(LA76_0 >= K_UUID && LA76_0 <= K_VECTOR)||LA76_0==K_WRITETIME||LA76_0==QUOTED_NAME||LA76_0==STRING_LITERAL) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// Parser.g:702:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_dropAggregateStatement4575);
							v=comparatorType();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { argTypes.add(v); }
							// Parser.g:703:13: ( ',' v= comparatorType )*
							loop75:
							while (true) {
								int alt75=2;
								int LA75_0 = input.LA(1);
								if ( (LA75_0==213) ) {
									alt75=1;
								}

								switch (alt75) {
								case 1 :
									// Parser.g:703:15: ',' v= comparatorType
									{
									match(input,213,FOLLOW_213_in_dropAggregateStatement4593); if (state.failed) return stmt;
									pushFollow(FOLLOW_comparatorType_in_dropAggregateStatement4597);
									v=comparatorType();
									state._fsp--;
									if (state.failed) return stmt;
									if ( state.backtracking==0 ) { argTypes.add(v); }
									}
									break;

								default :
									break loop75;
								}
							}

							}
							break;

					}

					match(input,210,FOLLOW_210_in_dropAggregateStatement4625); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { argsSpecified = true; }
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt = new DropAggregateStatement.Raw(fn, argTypes, argsSpecified, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropAggregateStatement"



	// $ANTLR start "createFunctionStatement"
	// Parser.g:711:1: createFunctionStatement returns [CreateFunctionStatement.Raw stmt] : K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS returnType= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL ;
	public final CreateFunctionStatement.Raw createFunctionStatement() throws RecognitionException {
		CreateFunctionStatement.Raw stmt = null;


		Token language=null;
		Token body=null;
		FunctionName fn =null;
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		CQL3Type.Raw returnType =null;


		        boolean orReplace = false;
		        boolean ifNotExists = false;

		        List<ColumnIdentifier> argNames = new ArrayList<>();
		        List<CQL3Type.Raw> argTypes = new ArrayList<>();
		        boolean calledOnNullInput = false;
		    
		try {
			// Parser.g:720:5: ( K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS returnType= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL )
			// Parser.g:720:7: K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS returnType= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createFunctionStatement4682); if (state.failed) return stmt;
			// Parser.g:720:16: ( K_OR K_REPLACE )?
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==K_OR) ) {
				alt78=1;
			}
			switch (alt78) {
				case 1 :
					// Parser.g:720:17: K_OR K_REPLACE
					{
					match(input,K_OR,FOLLOW_K_OR_in_createFunctionStatement4685); if (state.failed) return stmt;
					match(input,K_REPLACE,FOLLOW_K_REPLACE_in_createFunctionStatement4687); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { orReplace = true; }
					}
					break;

			}

			match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_createFunctionStatement4699); if (state.failed) return stmt;
			// Parser.g:722:7: ( K_IF K_NOT K_EXISTS )?
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==K_IF) ) {
				alt79=1;
			}
			switch (alt79) {
				case 1 :
					// Parser.g:722:8: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createFunctionStatement4708); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createFunctionStatement4710); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createFunctionStatement4712); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_createFunctionStatement4726);
			fn=functionName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,209,FOLLOW_209_in_createFunctionStatement4734); if (state.failed) return stmt;
			// Parser.g:725:9: (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )?
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==IDENT||LA81_0==K_ACCESS||(LA81_0 >= K_AGGREGATE && LA81_0 <= K_ALL)||LA81_0==K_ANN||LA81_0==K_AS||LA81_0==K_ASCII||(LA81_0 >= K_BIGINT && LA81_0 <= K_BOOLEAN)||(LA81_0 >= K_CALLED && LA81_0 <= K_CLUSTERING)||(LA81_0 >= K_COMPACT && LA81_0 <= K_COUNTER)||(LA81_0 >= K_CUSTOM && LA81_0 <= K_DEFAULT)||(LA81_0 >= K_DISTINCT && LA81_0 <= K_DOUBLE)||LA81_0==K_DURATION||(LA81_0 >= K_EXISTS && LA81_0 <= K_FLOAT)||LA81_0==K_FROZEN||(LA81_0 >= K_FUNCTION && LA81_0 <= K_FUNCTIONS)||(LA81_0 >= K_GROUP && LA81_0 <= K_IDENTITY)||(LA81_0 >= K_INET && LA81_0 <= K_INPUT)||(LA81_0 >= K_INT && LA81_0 <= K_INTERNALS)||(LA81_0 >= K_JSON && LA81_0 <= K_KEYS)||(LA81_0 >= K_KEYSPACES && LA81_0 <= K_LIKE)||(LA81_0 >= K_LIST && LA81_0 <= K_MASKED)||(LA81_0 >= K_MAXWRITETIME && LA81_0 <= K_MBEANS)||LA81_0==K_NOLOGIN||LA81_0==K_NOSUPERUSER||(LA81_0 >= K_ONLY && LA81_0 <= K_OPTIONS)||(LA81_0 >= K_PARTITION && LA81_0 <= K_PERMISSIONS)||(LA81_0 >= K_REPLACE && LA81_0 <= K_RETURNS)||(LA81_0 >= K_ROLE && LA81_0 <= K_ROLES)||LA81_0==K_SELECT_MASKED||(LA81_0 >= K_SFUNC && LA81_0 <= K_TINYINT)||LA81_0==K_TRIGGER||(LA81_0 >= K_TTL && LA81_0 <= K_TYPES)||(LA81_0 >= K_UNMASK && LA81_0 <= K_UNSET)||(LA81_0 >= K_USER && LA81_0 <= K_USERS)||(LA81_0 >= K_UUID && LA81_0 <= K_VECTOR)||LA81_0==K_WRITETIME||LA81_0==QUOTED_NAME) ) {
				alt81=1;
			}
			switch (alt81) {
				case 1 :
					// Parser.g:726:11: k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )*
					{
					pushFollow(FOLLOW_noncol_ident_in_createFunctionStatement4758);
					k=noncol_ident();
					state._fsp--;
					if (state.failed) return stmt;
					pushFollow(FOLLOW_comparatorType_in_createFunctionStatement4762);
					v=comparatorType();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { argNames.add(k); argTypes.add(v); }
					// Parser.g:727:11: ( ',' k= noncol_ident v= comparatorType )*
					loop80:
					while (true) {
						int alt80=2;
						int LA80_0 = input.LA(1);
						if ( (LA80_0==213) ) {
							alt80=1;
						}

						switch (alt80) {
						case 1 :
							// Parser.g:727:13: ',' k= noncol_ident v= comparatorType
							{
							match(input,213,FOLLOW_213_in_createFunctionStatement4778); if (state.failed) return stmt;
							pushFollow(FOLLOW_noncol_ident_in_createFunctionStatement4782);
							k=noncol_ident();
							state._fsp--;
							if (state.failed) return stmt;
							pushFollow(FOLLOW_comparatorType_in_createFunctionStatement4786);
							v=comparatorType();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { argNames.add(k); argTypes.add(v); }
							}
							break;

						default :
							break loop80;
						}
					}

					}
					break;

			}

			match(input,210,FOLLOW_210_in_createFunctionStatement4810); if (state.failed) return stmt;
			// Parser.g:730:7: ( ( K_RETURNS K_NULL ) | ( K_CALLED ) )
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==K_RETURNS) ) {
				alt82=1;
			}
			else if ( (LA82_0==K_CALLED) ) {
				alt82=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return stmt;}
				NoViableAltException nvae =
					new NoViableAltException("", 82, 0, input);
				throw nvae;
			}

			switch (alt82) {
				case 1 :
					// Parser.g:730:9: ( K_RETURNS K_NULL )
					{
					// Parser.g:730:9: ( K_RETURNS K_NULL )
					// Parser.g:730:10: K_RETURNS K_NULL
					{
					match(input,K_RETURNS,FOLLOW_K_RETURNS_in_createFunctionStatement4821); if (state.failed) return stmt;
					match(input,K_NULL,FOLLOW_K_NULL_in_createFunctionStatement4823); if (state.failed) return stmt;
					}

					}
					break;
				case 2 :
					// Parser.g:730:30: ( K_CALLED )
					{
					// Parser.g:730:30: ( K_CALLED )
					// Parser.g:730:31: K_CALLED
					{
					match(input,K_CALLED,FOLLOW_K_CALLED_in_createFunctionStatement4829); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { calledOnNullInput=true; }
					}

					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createFunctionStatement4835); if (state.failed) return stmt;
			match(input,K_NULL,FOLLOW_K_NULL_in_createFunctionStatement4837); if (state.failed) return stmt;
			match(input,K_INPUT,FOLLOW_K_INPUT_in_createFunctionStatement4839); if (state.failed) return stmt;
			match(input,K_RETURNS,FOLLOW_K_RETURNS_in_createFunctionStatement4847); if (state.failed) return stmt;
			pushFollow(FOLLOW_comparatorType_in_createFunctionStatement4853);
			returnType=comparatorType();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_LANGUAGE,FOLLOW_K_LANGUAGE_in_createFunctionStatement4861); if (state.failed) return stmt;
			language=(Token)match(input,IDENT,FOLLOW_IDENT_in_createFunctionStatement4867); if (state.failed) return stmt;
			match(input,K_AS,FOLLOW_K_AS_in_createFunctionStatement4875); if (state.failed) return stmt;
			body=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createFunctionStatement4881); if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new CreateFunctionStatement.Raw(
			          fn, argNames, argTypes, returnType, calledOnNullInput, (language!=null?language.getText():null).toLowerCase(), (body!=null?body.getText():null), orReplace, ifNotExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createFunctionStatement"



	// $ANTLR start "dropFunctionStatement"
	// Parser.g:739:1: dropFunctionStatement returns [DropFunctionStatement.Raw stmt] : K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? ;
	public final DropFunctionStatement.Raw dropFunctionStatement() throws RecognitionException {
		DropFunctionStatement.Raw stmt = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        boolean ifExists = false;
		        List<CQL3Type.Raw> argTypes = new ArrayList<>();
		        boolean argsSpecified = false;
		    
		try {
			// Parser.g:745:5: ( K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? )
			// Parser.g:745:7: K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropFunctionStatement4919); if (state.failed) return stmt;
			match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_dropFunctionStatement4921); if (state.failed) return stmt;
			// Parser.g:746:7: ( K_IF K_EXISTS )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==K_IF) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// Parser.g:746:8: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropFunctionStatement4930); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropFunctionStatement4932); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_dropFunctionStatement4947);
			fn=functionName();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:748:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==209) ) {
				alt86=1;
			}
			switch (alt86) {
				case 1 :
					// Parser.g:749:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,209,FOLLOW_209_in_dropFunctionStatement4965); if (state.failed) return stmt;
					// Parser.g:750:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt85=2;
					int LA85_0 = input.LA(1);
					if ( (LA85_0==IDENT||LA85_0==K_ACCESS||(LA85_0 >= K_AGGREGATE && LA85_0 <= K_ALL)||LA85_0==K_ANN||LA85_0==K_AS||LA85_0==K_ASCII||(LA85_0 >= K_BIGINT && LA85_0 <= K_BOOLEAN)||(LA85_0 >= K_CALLED && LA85_0 <= K_CLUSTERING)||(LA85_0 >= K_COMPACT && LA85_0 <= K_COUNTER)||(LA85_0 >= K_CUSTOM && LA85_0 <= K_DEFAULT)||(LA85_0 >= K_DISTINCT && LA85_0 <= K_DOUBLE)||LA85_0==K_DURATION||(LA85_0 >= K_EXISTS && LA85_0 <= K_FLOAT)||LA85_0==K_FROZEN||(LA85_0 >= K_FUNCTION && LA85_0 <= K_FUNCTIONS)||(LA85_0 >= K_GROUP && LA85_0 <= K_IDENTITY)||(LA85_0 >= K_INET && LA85_0 <= K_INPUT)||(LA85_0 >= K_INT && LA85_0 <= K_INTERNALS)||(LA85_0 >= K_JSON && LA85_0 <= K_KEYS)||(LA85_0 >= K_KEYSPACES && LA85_0 <= K_LIKE)||(LA85_0 >= K_LIST && LA85_0 <= K_MASKED)||(LA85_0 >= K_MAXWRITETIME && LA85_0 <= K_MBEANS)||LA85_0==K_NOLOGIN||LA85_0==K_NOSUPERUSER||(LA85_0 >= K_ONLY && LA85_0 <= K_OPTIONS)||(LA85_0 >= K_PARTITION && LA85_0 <= K_PERMISSIONS)||(LA85_0 >= K_REPLACE && LA85_0 <= K_RETURNS)||(LA85_0 >= K_ROLE && LA85_0 <= K_ROLES)||(LA85_0 >= K_SELECT_MASKED && LA85_0 <= K_TINYINT)||LA85_0==K_TRIGGER||(LA85_0 >= K_TTL && LA85_0 <= K_TYPES)||(LA85_0 >= K_UNMASK && LA85_0 <= K_UNSET)||(LA85_0 >= K_USER && LA85_0 <= K_USERS)||(LA85_0 >= K_UUID && LA85_0 <= K_VECTOR)||LA85_0==K_WRITETIME||LA85_0==QUOTED_NAME||LA85_0==STRING_LITERAL) ) {
						alt85=1;
					}
					switch (alt85) {
						case 1 :
							// Parser.g:751:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_dropFunctionStatement4993);
							v=comparatorType();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { argTypes.add(v); }
							// Parser.g:752:13: ( ',' v= comparatorType )*
							loop84:
							while (true) {
								int alt84=2;
								int LA84_0 = input.LA(1);
								if ( (LA84_0==213) ) {
									alt84=1;
								}

								switch (alt84) {
								case 1 :
									// Parser.g:752:15: ',' v= comparatorType
									{
									match(input,213,FOLLOW_213_in_dropFunctionStatement5011); if (state.failed) return stmt;
									pushFollow(FOLLOW_comparatorType_in_dropFunctionStatement5015);
									v=comparatorType();
									state._fsp--;
									if (state.failed) return stmt;
									if ( state.backtracking==0 ) { argTypes.add(v); }
									}
									break;

								default :
									break loop84;
								}
							}

							}
							break;

					}

					match(input,210,FOLLOW_210_in_dropFunctionStatement5043); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { argsSpecified = true; }
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt = new DropFunctionStatement.Raw(fn, argTypes, argsSpecified, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropFunctionStatement"



	// $ANTLR start "createKeyspaceStatement"
	// Parser.g:763:1: createKeyspaceStatement returns [CreateKeyspaceStatement.Raw stmt] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
	public final CreateKeyspaceStatement.Raw createKeyspaceStatement() throws RecognitionException {
		CreateKeyspaceStatement.Raw stmt = null;


		String ks =null;


		        KeyspaceAttributes attrs = new KeyspaceAttributes();
		        boolean ifNotExists = false;
		    
		try {
			// Parser.g:768:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
			// Parser.g:768:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement5102); if (state.failed) return stmt;
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement5104); if (state.failed) return stmt;
			// Parser.g:768:27: ( K_IF K_NOT K_EXISTS )?
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==K_IF) ) {
				alt87=1;
			}
			switch (alt87) {
				case 1 :
					// Parser.g:768:28: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement5107); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement5109); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement5111); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement5120);
			ks=keyspaceName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement5128); if (state.failed) return stmt;
			pushFollow(FOLLOW_properties_in_createKeyspaceStatement5130);
			properties(attrs);
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new CreateKeyspaceStatement.Raw(ks, attrs, ifNotExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createKeyspaceStatement"



	// $ANTLR start "createTableStatement"
	// Parser.g:779:1: createTableStatement returns [CreateTableStatement.Raw stmt] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName tableDefinition[stmt] ;
	public final CreateTableStatement.Raw createTableStatement() throws RecognitionException {
		CreateTableStatement.Raw stmt = null;


		QualifiedName cf =null;

		 boolean ifNotExists = false; 
		try {
			// Parser.g:781:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName tableDefinition[stmt] )
			// Parser.g:781:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName tableDefinition[stmt]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement5165); if (state.failed) return stmt;
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement5167); if (state.failed) return stmt;
			// Parser.g:781:31: ( K_IF K_NOT K_EXISTS )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==K_IF) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// Parser.g:781:32: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTableStatement5170); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement5172); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement5174); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createTableStatement5189);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new CreateTableStatement.Raw(cf, ifNotExists); }
			pushFollow(FOLLOW_tableDefinition_in_createTableStatement5199);
			tableDefinition(stmt);
			state._fsp--;
			if (state.failed) return stmt;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createTableStatement"



	// $ANTLR start "tableDefinition"
	// Parser.g:786:1: tableDefinition[CreateTableStatement.Raw stmt] : '(' tableColumns[stmt] ( ',' ( tableColumns[stmt] )? )* ')' ( K_WITH tableProperty[stmt] ( K_AND tableProperty[stmt] )* )? ;
	public final void tableDefinition(CreateTableStatement.Raw stmt) throws RecognitionException {
		try {
			// Parser.g:787:5: ( '(' tableColumns[stmt] ( ',' ( tableColumns[stmt] )? )* ')' ( K_WITH tableProperty[stmt] ( K_AND tableProperty[stmt] )* )? )
			// Parser.g:787:7: '(' tableColumns[stmt] ( ',' ( tableColumns[stmt] )? )* ')' ( K_WITH tableProperty[stmt] ( K_AND tableProperty[stmt] )* )?
			{
			match(input,209,FOLLOW_209_in_tableDefinition5218); if (state.failed) return;
			pushFollow(FOLLOW_tableColumns_in_tableDefinition5220);
			tableColumns(stmt);
			state._fsp--;
			if (state.failed) return;
			// Parser.g:787:30: ( ',' ( tableColumns[stmt] )? )*
			loop90:
			while (true) {
				int alt90=2;
				int LA90_0 = input.LA(1);
				if ( (LA90_0==213) ) {
					alt90=1;
				}

				switch (alt90) {
				case 1 :
					// Parser.g:787:32: ',' ( tableColumns[stmt] )?
					{
					match(input,213,FOLLOW_213_in_tableDefinition5225); if (state.failed) return;
					// Parser.g:787:36: ( tableColumns[stmt] )?
					int alt89=2;
					int LA89_0 = input.LA(1);
					if ( (LA89_0==IDENT||LA89_0==K_ACCESS||(LA89_0 >= K_AGGREGATE && LA89_0 <= K_ALL)||LA89_0==K_ANN||LA89_0==K_AS||LA89_0==K_ASCII||(LA89_0 >= K_BIGINT && LA89_0 <= K_BOOLEAN)||(LA89_0 >= K_CALLED && LA89_0 <= K_CLUSTERING)||(LA89_0 >= K_COMPACT && LA89_0 <= K_COUNTER)||(LA89_0 >= K_CUSTOM && LA89_0 <= K_DEFAULT)||(LA89_0 >= K_DISTINCT && LA89_0 <= K_DOUBLE)||LA89_0==K_DURATION||(LA89_0 >= K_EXISTS && LA89_0 <= K_FLOAT)||LA89_0==K_FROZEN||(LA89_0 >= K_FUNCTION && LA89_0 <= K_FUNCTIONS)||(LA89_0 >= K_GROUP && LA89_0 <= K_IDENTITY)||(LA89_0 >= K_INET && LA89_0 <= K_INPUT)||(LA89_0 >= K_INT && LA89_0 <= K_INTERNALS)||(LA89_0 >= K_JSON && LA89_0 <= K_KEYS)||(LA89_0 >= K_KEYSPACES && LA89_0 <= K_LIKE)||(LA89_0 >= K_LIST && LA89_0 <= K_MASKED)||(LA89_0 >= K_MAXWRITETIME && LA89_0 <= K_MBEANS)||LA89_0==K_NOLOGIN||LA89_0==K_NOSUPERUSER||(LA89_0 >= K_ONLY && LA89_0 <= K_OPTIONS)||(LA89_0 >= K_PARTITION && LA89_0 <= K_PERMISSIONS)||LA89_0==K_PRIMARY||(LA89_0 >= K_REPLACE && LA89_0 <= K_RETURNS)||(LA89_0 >= K_ROLE && LA89_0 <= K_ROLES)||LA89_0==K_SELECT_MASKED||(LA89_0 >= K_SFUNC && LA89_0 <= K_TINYINT)||LA89_0==K_TRIGGER||(LA89_0 >= K_TTL && LA89_0 <= K_TYPES)||(LA89_0 >= K_UNMASK && LA89_0 <= K_UNSET)||(LA89_0 >= K_USER && LA89_0 <= K_USERS)||(LA89_0 >= K_UUID && LA89_0 <= K_VECTOR)||LA89_0==K_WRITETIME||LA89_0==QUOTED_NAME) ) {
						alt89=1;
					}
					switch (alt89) {
						case 1 :
							// Parser.g:787:36: tableColumns[stmt]
							{
							pushFollow(FOLLOW_tableColumns_in_tableDefinition5227);
							tableColumns(stmt);
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					}
					break;

				default :
					break loop90;
				}
			}

			match(input,210,FOLLOW_210_in_tableDefinition5234); if (state.failed) return;
			// Parser.g:788:7: ( K_WITH tableProperty[stmt] ( K_AND tableProperty[stmt] )* )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==K_WITH) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// Parser.g:788:9: K_WITH tableProperty[stmt] ( K_AND tableProperty[stmt] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_tableDefinition5244); if (state.failed) return;
					pushFollow(FOLLOW_tableProperty_in_tableDefinition5246);
					tableProperty(stmt);
					state._fsp--;
					if (state.failed) return;
					// Parser.g:788:36: ( K_AND tableProperty[stmt] )*
					loop91:
					while (true) {
						int alt91=2;
						int LA91_0 = input.LA(1);
						if ( (LA91_0==K_AND) ) {
							alt91=1;
						}

						switch (alt91) {
						case 1 :
							// Parser.g:788:38: K_AND tableProperty[stmt]
							{
							match(input,K_AND,FOLLOW_K_AND_in_tableDefinition5251); if (state.failed) return;
							pushFollow(FOLLOW_tableProperty_in_tableDefinition5253);
							tableProperty(stmt);
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop91;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "tableDefinition"



	// $ANTLR start "tableColumns"
	// Parser.g:791:1: tableColumns[CreateTableStatement.Raw stmt] : (k= ident v= comparatorType ( K_STATIC )? (mask= columnMask )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' tablePartitionKey[stmt] ( ',' c= ident )* ')' );
	public final void tableColumns(CreateTableStatement.Raw stmt) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		ColumnMask.Raw mask =null;
		ColumnIdentifier c =null;

		 boolean isStatic = false; 
		try {
			// Parser.g:793:5: (k= ident v= comparatorType ( K_STATIC )? (mask= columnMask )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' tablePartitionKey[stmt] ( ',' c= ident )* ')' )
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==IDENT||LA97_0==K_ACCESS||(LA97_0 >= K_AGGREGATE && LA97_0 <= K_ALL)||LA97_0==K_ANN||LA97_0==K_AS||LA97_0==K_ASCII||(LA97_0 >= K_BIGINT && LA97_0 <= K_BOOLEAN)||(LA97_0 >= K_CALLED && LA97_0 <= K_CLUSTERING)||(LA97_0 >= K_COMPACT && LA97_0 <= K_COUNTER)||(LA97_0 >= K_CUSTOM && LA97_0 <= K_DEFAULT)||(LA97_0 >= K_DISTINCT && LA97_0 <= K_DOUBLE)||LA97_0==K_DURATION||(LA97_0 >= K_EXISTS && LA97_0 <= K_FLOAT)||LA97_0==K_FROZEN||(LA97_0 >= K_FUNCTION && LA97_0 <= K_FUNCTIONS)||(LA97_0 >= K_GROUP && LA97_0 <= K_IDENTITY)||(LA97_0 >= K_INET && LA97_0 <= K_INPUT)||(LA97_0 >= K_INT && LA97_0 <= K_INTERNALS)||(LA97_0 >= K_JSON && LA97_0 <= K_KEYS)||(LA97_0 >= K_KEYSPACES && LA97_0 <= K_LIKE)||(LA97_0 >= K_LIST && LA97_0 <= K_MASKED)||(LA97_0 >= K_MAXWRITETIME && LA97_0 <= K_MBEANS)||LA97_0==K_NOLOGIN||LA97_0==K_NOSUPERUSER||(LA97_0 >= K_ONLY && LA97_0 <= K_OPTIONS)||(LA97_0 >= K_PARTITION && LA97_0 <= K_PERMISSIONS)||(LA97_0 >= K_REPLACE && LA97_0 <= K_RETURNS)||(LA97_0 >= K_ROLE && LA97_0 <= K_ROLES)||LA97_0==K_SELECT_MASKED||(LA97_0 >= K_SFUNC && LA97_0 <= K_TINYINT)||LA97_0==K_TRIGGER||(LA97_0 >= K_TTL && LA97_0 <= K_TYPES)||(LA97_0 >= K_UNMASK && LA97_0 <= K_UNSET)||(LA97_0 >= K_USER && LA97_0 <= K_USERS)||(LA97_0 >= K_UUID && LA97_0 <= K_VECTOR)||LA97_0==K_WRITETIME||LA97_0==QUOTED_NAME) ) {
				alt97=1;
			}
			else if ( (LA97_0==K_PRIMARY) ) {
				alt97=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 97, 0, input);
				throw nvae;
			}

			switch (alt97) {
				case 1 :
					// Parser.g:793:7: k= ident v= comparatorType ( K_STATIC )? (mask= columnMask )? ( K_PRIMARY K_KEY )?
					{
					pushFollow(FOLLOW_ident_in_tableColumns5288);
					k=ident();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_comparatorType_in_tableColumns5292);
					v=comparatorType();
					state._fsp--;
					if (state.failed) return;
					// Parser.g:793:32: ( K_STATIC )?
					int alt93=2;
					int LA93_0 = input.LA(1);
					if ( (LA93_0==K_STATIC) ) {
						alt93=1;
					}
					switch (alt93) {
						case 1 :
							// Parser.g:793:33: K_STATIC
							{
							match(input,K_STATIC,FOLLOW_K_STATIC_in_tableColumns5295); if (state.failed) return;
							if ( state.backtracking==0 ) { isStatic = true; }
							}
							break;

					}

					// Parser.g:793:65: (mask= columnMask )?
					int alt94=2;
					int LA94_0 = input.LA(1);
					if ( (LA94_0==K_MASKED) ) {
						alt94=1;
					}
					switch (alt94) {
						case 1 :
							// Parser.g:793:66: mask= columnMask
							{
							pushFollow(FOLLOW_columnMask_in_tableColumns5304);
							mask=columnMask();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					if ( state.backtracking==0 ) { stmt.addColumn(k, v, isStatic, mask); }
					// Parser.g:794:9: ( K_PRIMARY K_KEY )?
					int alt95=2;
					int LA95_0 = input.LA(1);
					if ( (LA95_0==K_PRIMARY) ) {
						alt95=1;
					}
					switch (alt95) {
						case 1 :
							// Parser.g:794:10: K_PRIMARY K_KEY
							{
							match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_tableColumns5319); if (state.failed) return;
							match(input,K_KEY,FOLLOW_K_KEY_in_tableColumns5321); if (state.failed) return;
							if ( state.backtracking==0 ) { stmt.setPartitionKeyColumn(k); }
							}
							break;

					}

					}
					break;
				case 2 :
					// Parser.g:795:7: K_PRIMARY K_KEY '(' tablePartitionKey[stmt] ( ',' c= ident )* ')'
					{
					match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_tableColumns5333); if (state.failed) return;
					match(input,K_KEY,FOLLOW_K_KEY_in_tableColumns5335); if (state.failed) return;
					match(input,209,FOLLOW_209_in_tableColumns5337); if (state.failed) return;
					pushFollow(FOLLOW_tablePartitionKey_in_tableColumns5339);
					tablePartitionKey(stmt);
					state._fsp--;
					if (state.failed) return;
					// Parser.g:795:51: ( ',' c= ident )*
					loop96:
					while (true) {
						int alt96=2;
						int LA96_0 = input.LA(1);
						if ( (LA96_0==213) ) {
							alt96=1;
						}

						switch (alt96) {
						case 1 :
							// Parser.g:795:52: ',' c= ident
							{
							match(input,213,FOLLOW_213_in_tableColumns5343); if (state.failed) return;
							pushFollow(FOLLOW_ident_in_tableColumns5347);
							c=ident();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { stmt.markClusteringColumn(c); }
							}
							break;

						default :
							break loop96;
						}
					}

					match(input,210,FOLLOW_210_in_tableColumns5354); if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "tableColumns"



	// $ANTLR start "columnMask"
	// Parser.g:798:1: columnMask returns [ColumnMask.Raw mask] : ( K_MASKED K_WITH name= functionName columnMaskArguments[arguments] | K_MASKED K_WITH K_DEFAULT );
	public final ColumnMask.Raw columnMask() throws RecognitionException {
		ColumnMask.Raw mask = null;


		FunctionName name =null;

		 List<Term.Raw> arguments = new ArrayList<>(); 
		try {
			// Parser.g:800:5: ( K_MASKED K_WITH name= functionName columnMaskArguments[arguments] | K_MASKED K_WITH K_DEFAULT )
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==K_MASKED) ) {
				int LA98_1 = input.LA(2);
				if ( (LA98_1==K_WITH) ) {
					int LA98_2 = input.LA(3);
					if ( (LA98_2==K_DEFAULT) ) {
						int LA98_3 = input.LA(4);
						if ( (LA98_3==EOF||LA98_3==K_PRIMARY||LA98_3==210||LA98_3==213||LA98_3==219) ) {
							alt98=2;
						}
						else if ( (LA98_3==209||LA98_3==216) ) {
							alt98=1;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return mask;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 98, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA98_2==IDENT||LA98_2==K_ACCESS||(LA98_2 >= K_AGGREGATE && LA98_2 <= K_ALL)||LA98_2==K_ANN||LA98_2==K_AS||LA98_2==K_ASCII||(LA98_2 >= K_BIGINT && LA98_2 <= K_BOOLEAN)||(LA98_2 >= K_CALLED && LA98_2 <= K_CLUSTERING)||(LA98_2 >= K_COMPACT && LA98_2 <= K_COUNTER)||(LA98_2 >= K_CUSTOM && LA98_2 <= K_DECIMAL)||(LA98_2 >= K_DISTINCT && LA98_2 <= K_DOUBLE)||LA98_2==K_DURATION||(LA98_2 >= K_EXISTS && LA98_2 <= K_FLOAT)||LA98_2==K_FROZEN||(LA98_2 >= K_FUNCTION && LA98_2 <= K_FUNCTIONS)||(LA98_2 >= K_GROUP && LA98_2 <= K_IDENTITY)||(LA98_2 >= K_INET && LA98_2 <= K_INPUT)||(LA98_2 >= K_INT && LA98_2 <= K_INTERNALS)||(LA98_2 >= K_JSON && LA98_2 <= K_KEYS)||(LA98_2 >= K_KEYSPACES && LA98_2 <= K_LIKE)||(LA98_2 >= K_LIST && LA98_2 <= K_MASKED)||(LA98_2 >= K_MAXWRITETIME && LA98_2 <= K_MBEANS)||LA98_2==K_NOLOGIN||LA98_2==K_NOSUPERUSER||(LA98_2 >= K_ONLY && LA98_2 <= K_OPTIONS)||(LA98_2 >= K_PARTITION && LA98_2 <= K_PERMISSIONS)||(LA98_2 >= K_REPLACE && LA98_2 <= K_RETURNS)||(LA98_2 >= K_ROLE && LA98_2 <= K_ROLES)||LA98_2==K_SELECT_MASKED||(LA98_2 >= K_SFUNC && LA98_2 <= K_TINYINT)||(LA98_2 >= K_TOKEN && LA98_2 <= K_TRIGGER)||(LA98_2 >= K_TTL && LA98_2 <= K_TYPES)||(LA98_2 >= K_UNMASK && LA98_2 <= K_UNSET)||(LA98_2 >= K_USER && LA98_2 <= K_USERS)||(LA98_2 >= K_UUID && LA98_2 <= K_VECTOR)||LA98_2==K_WRITETIME||(LA98_2 >= QMARK && LA98_2 <= QUOTED_NAME)) ) {
						alt98=1;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return mask;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 98, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return mask;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 98, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return mask;}
				NoViableAltException nvae =
					new NoViableAltException("", 98, 0, input);
				throw nvae;
			}

			switch (alt98) {
				case 1 :
					// Parser.g:800:7: K_MASKED K_WITH name= functionName columnMaskArguments[arguments]
					{
					match(input,K_MASKED,FOLLOW_K_MASKED_in_columnMask5384); if (state.failed) return mask;
					match(input,K_WITH,FOLLOW_K_WITH_in_columnMask5386); if (state.failed) return mask;
					pushFollow(FOLLOW_functionName_in_columnMask5390);
					name=functionName();
					state._fsp--;
					if (state.failed) return mask;
					pushFollow(FOLLOW_columnMaskArguments_in_columnMask5392);
					columnMaskArguments(arguments);
					state._fsp--;
					if (state.failed) return mask;
					if ( state.backtracking==0 ) { mask = new ColumnMask.Raw(name, arguments); }
					}
					break;
				case 2 :
					// Parser.g:801:7: K_MASKED K_WITH K_DEFAULT
					{
					match(input,K_MASKED,FOLLOW_K_MASKED_in_columnMask5403); if (state.failed) return mask;
					match(input,K_WITH,FOLLOW_K_WITH_in_columnMask5405); if (state.failed) return mask;
					match(input,K_DEFAULT,FOLLOW_K_DEFAULT_in_columnMask5407); if (state.failed) return mask;
					if ( state.backtracking==0 ) { mask = new ColumnMask.Raw(FunctionName.nativeFunction("mask_default"), arguments); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return mask;
	}
	// $ANTLR end "columnMask"



	// $ANTLR start "columnMaskArguments"
	// Parser.g:804:1: columnMaskArguments[List<Term.Raw> arguments] : ( '(' ')' | '(' c= term ( ',' cn= term )* ')' );
	public final void columnMaskArguments(List<Term.Raw> arguments) throws RecognitionException {
		Term.Raw c =null;
		Term.Raw cn =null;

		try {
			// Parser.g:805:5: ( '(' ')' | '(' c= term ( ',' cn= term )* ')' )
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==209) ) {
				int LA100_1 = input.LA(2);
				if ( (LA100_1==210) ) {
					alt100=1;
				}
				else if ( (LA100_1==BOOLEAN||LA100_1==DURATION||LA100_1==FLOAT||LA100_1==HEXNUMBER||(LA100_1 >= IDENT && LA100_1 <= INTEGER)||LA100_1==K_ACCESS||(LA100_1 >= K_AGGREGATE && LA100_1 <= K_ALL)||LA100_1==K_ANN||LA100_1==K_AS||LA100_1==K_ASCII||(LA100_1 >= K_BIGINT && LA100_1 <= K_BOOLEAN)||(LA100_1 >= K_CALLED && LA100_1 <= K_CLUSTERING)||(LA100_1 >= K_COMPACT && LA100_1 <= K_COUNTER)||(LA100_1 >= K_CUSTOM && LA100_1 <= K_DEFAULT)||(LA100_1 >= K_DISTINCT && LA100_1 <= K_DOUBLE)||LA100_1==K_DURATION||(LA100_1 >= K_EXISTS && LA100_1 <= K_FLOAT)||LA100_1==K_FROZEN||(LA100_1 >= K_FUNCTION && LA100_1 <= K_FUNCTIONS)||(LA100_1 >= K_GROUP && LA100_1 <= K_IDENTITY)||(LA100_1 >= K_INET && LA100_1 <= K_INPUT)||(LA100_1 >= K_INT && LA100_1 <= K_INTERNALS)||(LA100_1 >= K_JSON && LA100_1 <= K_KEYS)||(LA100_1 >= K_KEYSPACES && LA100_1 <= K_LIKE)||(LA100_1 >= K_LIST && LA100_1 <= K_MASKED)||(LA100_1 >= K_MAXWRITETIME && LA100_1 <= K_MBEANS)||(LA100_1 >= K_NEGATIVE_INFINITY && LA100_1 <= K_NOLOGIN)||LA100_1==K_NOSUPERUSER||LA100_1==K_NULL||(LA100_1 >= K_ONLY && LA100_1 <= K_OPTIONS)||(LA100_1 >= K_PARTITION && LA100_1 <= K_POSITIVE_NAN)||(LA100_1 >= K_REPLACE && LA100_1 <= K_RETURNS)||(LA100_1 >= K_ROLE && LA100_1 <= K_ROLES)||LA100_1==K_SELECT_MASKED||(LA100_1 >= K_SFUNC && LA100_1 <= K_TINYINT)||(LA100_1 >= K_TOKEN && LA100_1 <= K_TRIGGER)||(LA100_1 >= K_TTL && LA100_1 <= K_TYPES)||(LA100_1 >= K_UNMASK && LA100_1 <= K_UNSET)||(LA100_1 >= K_USER && LA100_1 <= K_USERS)||(LA100_1 >= K_UUID && LA100_1 <= K_VECTOR)||LA100_1==K_WRITETIME||(LA100_1 >= QMARK && LA100_1 <= QUOTED_NAME)||LA100_1==STRING_LITERAL||LA100_1==UUID||LA100_1==209||LA100_1==214||LA100_1==218||LA100_1==225||LA100_1==229) ) {
					alt100=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 100, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 100, 0, input);
				throw nvae;
			}

			switch (alt100) {
				case 1 :
					// Parser.g:805:7: '(' ')'
					{
					match(input,209,FOLLOW_209_in_columnMaskArguments5427); if (state.failed) return;
					match(input,210,FOLLOW_210_in_columnMaskArguments5430); if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:805:18: '(' c= term ( ',' cn= term )* ')'
					{
					match(input,209,FOLLOW_209_in_columnMaskArguments5434); if (state.failed) return;
					pushFollow(FOLLOW_term_in_columnMaskArguments5438);
					c=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { arguments.add(c); }
					// Parser.g:805:51: ( ',' cn= term )*
					loop99:
					while (true) {
						int alt99=2;
						int LA99_0 = input.LA(1);
						if ( (LA99_0==213) ) {
							alt99=1;
						}

						switch (alt99) {
						case 1 :
							// Parser.g:805:52: ',' cn= term
							{
							match(input,213,FOLLOW_213_in_columnMaskArguments5443); if (state.failed) return;
							pushFollow(FOLLOW_term_in_columnMaskArguments5447);
							cn=term();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { arguments.add(cn); }
							}
							break;

						default :
							break loop99;
						}
					}

					match(input,210,FOLLOW_210_in_columnMaskArguments5453); if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnMaskArguments"



	// $ANTLR start "tablePartitionKey"
	// Parser.g:808:1: tablePartitionKey[CreateTableStatement.Raw stmt] : (k1= ident | '(' k1= ident ( ',' kn= ident )* ')' );
	public final void tablePartitionKey(CreateTableStatement.Raw stmt) throws RecognitionException {
		ColumnIdentifier k1 =null;
		ColumnIdentifier kn =null;

		List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>();
		try {
			// Parser.g:811:5: (k1= ident | '(' k1= ident ( ',' kn= ident )* ')' )
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==IDENT||LA102_0==K_ACCESS||(LA102_0 >= K_AGGREGATE && LA102_0 <= K_ALL)||LA102_0==K_ANN||LA102_0==K_AS||LA102_0==K_ASCII||(LA102_0 >= K_BIGINT && LA102_0 <= K_BOOLEAN)||(LA102_0 >= K_CALLED && LA102_0 <= K_CLUSTERING)||(LA102_0 >= K_COMPACT && LA102_0 <= K_COUNTER)||(LA102_0 >= K_CUSTOM && LA102_0 <= K_DEFAULT)||(LA102_0 >= K_DISTINCT && LA102_0 <= K_DOUBLE)||LA102_0==K_DURATION||(LA102_0 >= K_EXISTS && LA102_0 <= K_FLOAT)||LA102_0==K_FROZEN||(LA102_0 >= K_FUNCTION && LA102_0 <= K_FUNCTIONS)||(LA102_0 >= K_GROUP && LA102_0 <= K_IDENTITY)||(LA102_0 >= K_INET && LA102_0 <= K_INPUT)||(LA102_0 >= K_INT && LA102_0 <= K_INTERNALS)||(LA102_0 >= K_JSON && LA102_0 <= K_KEYS)||(LA102_0 >= K_KEYSPACES && LA102_0 <= K_LIKE)||(LA102_0 >= K_LIST && LA102_0 <= K_MASKED)||(LA102_0 >= K_MAXWRITETIME && LA102_0 <= K_MBEANS)||LA102_0==K_NOLOGIN||LA102_0==K_NOSUPERUSER||(LA102_0 >= K_ONLY && LA102_0 <= K_OPTIONS)||(LA102_0 >= K_PARTITION && LA102_0 <= K_PERMISSIONS)||(LA102_0 >= K_REPLACE && LA102_0 <= K_RETURNS)||(LA102_0 >= K_ROLE && LA102_0 <= K_ROLES)||LA102_0==K_SELECT_MASKED||(LA102_0 >= K_SFUNC && LA102_0 <= K_TINYINT)||LA102_0==K_TRIGGER||(LA102_0 >= K_TTL && LA102_0 <= K_TYPES)||(LA102_0 >= K_UNMASK && LA102_0 <= K_UNSET)||(LA102_0 >= K_USER && LA102_0 <= K_USERS)||(LA102_0 >= K_UUID && LA102_0 <= K_VECTOR)||LA102_0==K_WRITETIME||LA102_0==QUOTED_NAME) ) {
				alt102=1;
			}
			else if ( (LA102_0==209) ) {
				alt102=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 102, 0, input);
				throw nvae;
			}

			switch (alt102) {
				case 1 :
					// Parser.g:811:7: k1= ident
					{
					pushFollow(FOLLOW_ident_in_tablePartitionKey5490);
					k1=ident();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { l.add(k1);}
					}
					break;
				case 2 :
					// Parser.g:812:7: '(' k1= ident ( ',' kn= ident )* ')'
					{
					match(input,209,FOLLOW_209_in_tablePartitionKey5500); if (state.failed) return;
					pushFollow(FOLLOW_ident_in_tablePartitionKey5504);
					k1=ident();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { l.add(k1); }
					// Parser.g:812:35: ( ',' kn= ident )*
					loop101:
					while (true) {
						int alt101=2;
						int LA101_0 = input.LA(1);
						if ( (LA101_0==213) ) {
							alt101=1;
						}

						switch (alt101) {
						case 1 :
							// Parser.g:812:37: ',' kn= ident
							{
							match(input,213,FOLLOW_213_in_tablePartitionKey5510); if (state.failed) return;
							pushFollow(FOLLOW_ident_in_tablePartitionKey5514);
							kn=ident();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { l.add(kn); }
							}
							break;

						default :
							break loop101;
						}
					}

					match(input,210,FOLLOW_210_in_tablePartitionKey5521); if (state.failed) return;
					}
					break;

			}
			if ( state.backtracking==0 ) { stmt.setPartitionKeyColumns(l); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "tablePartitionKey"



	// $ANTLR start "tableProperty"
	// Parser.g:815:1: tableProperty[CreateTableStatement.Raw stmt] : ( property[stmt.attrs] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' tableClusteringOrder[stmt] ( ',' tableClusteringOrder[stmt] )* ')' );
	public final void tableProperty(CreateTableStatement.Raw stmt) throws RecognitionException {
		try {
			// Parser.g:816:5: ( property[stmt.attrs] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' tableClusteringOrder[stmt] ( ',' tableClusteringOrder[stmt] )* ')' )
			int alt104=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt104=1;
				}
				break;
			case K_COMPACT:
				{
				int LA104_2 = input.LA(2);
				if ( (LA104_2==K_STORAGE) ) {
					alt104=2;
				}
				else if ( (LA104_2==222) ) {
					alt104=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 104, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_CLUSTERING:
				{
				int LA104_3 = input.LA(2);
				if ( (LA104_3==K_ORDER) ) {
					alt104=3;
				}
				else if ( (LA104_3==222) ) {
					alt104=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 104, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}
			switch (alt104) {
				case 1 :
					// Parser.g:816:7: property[stmt.attrs]
					{
					pushFollow(FOLLOW_property_in_tableProperty5539);
					property(stmt.attrs);
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:817:7: K_COMPACT K_STORAGE
					{
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_tableProperty5548); if (state.failed) return;
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_tableProperty5550); if (state.failed) return;
					if ( state.backtracking==0 ) { stmt.setCompactStorage(); }
					}
					break;
				case 3 :
					// Parser.g:818:7: K_CLUSTERING K_ORDER K_BY '(' tableClusteringOrder[stmt] ( ',' tableClusteringOrder[stmt] )* ')'
					{
					match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_tableProperty5560); if (state.failed) return;
					match(input,K_ORDER,FOLLOW_K_ORDER_in_tableProperty5562); if (state.failed) return;
					match(input,K_BY,FOLLOW_K_BY_in_tableProperty5564); if (state.failed) return;
					match(input,209,FOLLOW_209_in_tableProperty5566); if (state.failed) return;
					pushFollow(FOLLOW_tableClusteringOrder_in_tableProperty5568);
					tableClusteringOrder(stmt);
					state._fsp--;
					if (state.failed) return;
					// Parser.g:818:64: ( ',' tableClusteringOrder[stmt] )*
					loop103:
					while (true) {
						int alt103=2;
						int LA103_0 = input.LA(1);
						if ( (LA103_0==213) ) {
							alt103=1;
						}

						switch (alt103) {
						case 1 :
							// Parser.g:818:65: ',' tableClusteringOrder[stmt]
							{
							match(input,213,FOLLOW_213_in_tableProperty5572); if (state.failed) return;
							pushFollow(FOLLOW_tableClusteringOrder_in_tableProperty5574);
							tableClusteringOrder(stmt);
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop103;
						}
					}

					match(input,210,FOLLOW_210_in_tableProperty5579); if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "tableProperty"



	// $ANTLR start "tableClusteringOrder"
	// Parser.g:821:1: tableClusteringOrder[CreateTableStatement.Raw stmt] : k= ident ( K_ASC | K_DESC ) ;
	public final void tableClusteringOrder(CreateTableStatement.Raw stmt) throws RecognitionException {
		ColumnIdentifier k =null;

		 boolean ascending = true; 
		try {
			// Parser.g:823:5: (k= ident ( K_ASC | K_DESC ) )
			// Parser.g:823:7: k= ident ( K_ASC | K_DESC )
			{
			pushFollow(FOLLOW_ident_in_tableClusteringOrder5607);
			k=ident();
			state._fsp--;
			if (state.failed) return;
			// Parser.g:823:15: ( K_ASC | K_DESC )
			int alt105=2;
			int LA105_0 = input.LA(1);
			if ( (LA105_0==K_ASC) ) {
				alt105=1;
			}
			else if ( (LA105_0==K_DESC) ) {
				alt105=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 105, 0, input);
				throw nvae;
			}

			switch (alt105) {
				case 1 :
					// Parser.g:823:16: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_tableClusteringOrder5610); if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:823:24: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_tableClusteringOrder5614); if (state.failed) return;
					if ( state.backtracking==0 ) { ascending = false; }
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt.extendClusteringOrder(k, ascending); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "tableClusteringOrder"



	// $ANTLR start "createTypeStatement"
	// Parser.g:833:1: createTypeStatement returns [CreateTypeStatement.Raw stmt] : K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[stmt] ( ',' ( typeColumns[stmt] )? )* ')' ;
	public final CreateTypeStatement.Raw createTypeStatement() throws RecognitionException {
		CreateTypeStatement.Raw stmt = null;


		UTName tn =null;

		 boolean ifNotExists = false; 
		try {
			// Parser.g:835:5: ( K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[stmt] ( ',' ( typeColumns[stmt] )? )* ')' )
			// Parser.g:835:7: K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[stmt] ( ',' ( typeColumns[stmt] )? )* ')'
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTypeStatement5652); if (state.failed) return stmt;
			match(input,K_TYPE,FOLLOW_K_TYPE_in_createTypeStatement5654); if (state.failed) return stmt;
			// Parser.g:835:23: ( K_IF K_NOT K_EXISTS )?
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==K_IF) ) {
				alt106=1;
			}
			switch (alt106) {
				case 1 :
					// Parser.g:835:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTypeStatement5657); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createTypeStatement5659); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTypeStatement5661); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_createTypeStatement5679);
			tn=userTypeName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new CreateTypeStatement.Raw(tn, ifNotExists); }
			match(input,209,FOLLOW_209_in_createTypeStatement5692); if (state.failed) return stmt;
			pushFollow(FOLLOW_typeColumns_in_createTypeStatement5694);
			typeColumns(stmt);
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:837:32: ( ',' ( typeColumns[stmt] )? )*
			loop108:
			while (true) {
				int alt108=2;
				int LA108_0 = input.LA(1);
				if ( (LA108_0==213) ) {
					alt108=1;
				}

				switch (alt108) {
				case 1 :
					// Parser.g:837:34: ',' ( typeColumns[stmt] )?
					{
					match(input,213,FOLLOW_213_in_createTypeStatement5699); if (state.failed) return stmt;
					// Parser.g:837:38: ( typeColumns[stmt] )?
					int alt107=2;
					int LA107_0 = input.LA(1);
					if ( (LA107_0==IDENT||LA107_0==K_ACCESS||(LA107_0 >= K_AGGREGATE && LA107_0 <= K_ALL)||LA107_0==K_ANN||LA107_0==K_AS||LA107_0==K_ASCII||(LA107_0 >= K_BIGINT && LA107_0 <= K_BOOLEAN)||(LA107_0 >= K_CALLED && LA107_0 <= K_CLUSTERING)||(LA107_0 >= K_COMPACT && LA107_0 <= K_COUNTER)||(LA107_0 >= K_CUSTOM && LA107_0 <= K_DEFAULT)||(LA107_0 >= K_DISTINCT && LA107_0 <= K_DOUBLE)||LA107_0==K_DURATION||(LA107_0 >= K_EXISTS && LA107_0 <= K_FLOAT)||LA107_0==K_FROZEN||(LA107_0 >= K_FUNCTION && LA107_0 <= K_FUNCTIONS)||(LA107_0 >= K_GROUP && LA107_0 <= K_IDENTITY)||(LA107_0 >= K_INET && LA107_0 <= K_INPUT)||(LA107_0 >= K_INT && LA107_0 <= K_INTERNALS)||(LA107_0 >= K_JSON && LA107_0 <= K_KEYS)||(LA107_0 >= K_KEYSPACES && LA107_0 <= K_LIKE)||(LA107_0 >= K_LIST && LA107_0 <= K_MASKED)||(LA107_0 >= K_MAXWRITETIME && LA107_0 <= K_MBEANS)||LA107_0==K_NOLOGIN||LA107_0==K_NOSUPERUSER||(LA107_0 >= K_ONLY && LA107_0 <= K_OPTIONS)||(LA107_0 >= K_PARTITION && LA107_0 <= K_PERMISSIONS)||(LA107_0 >= K_REPLACE && LA107_0 <= K_RETURNS)||(LA107_0 >= K_ROLE && LA107_0 <= K_ROLES)||LA107_0==K_SELECT_MASKED||(LA107_0 >= K_SFUNC && LA107_0 <= K_TINYINT)||LA107_0==K_TRIGGER||(LA107_0 >= K_TTL && LA107_0 <= K_TYPES)||(LA107_0 >= K_UNMASK && LA107_0 <= K_UNSET)||(LA107_0 >= K_USER && LA107_0 <= K_USERS)||(LA107_0 >= K_UUID && LA107_0 <= K_VECTOR)||LA107_0==K_WRITETIME||LA107_0==QUOTED_NAME) ) {
						alt107=1;
					}
					switch (alt107) {
						case 1 :
							// Parser.g:837:38: typeColumns[stmt]
							{
							pushFollow(FOLLOW_typeColumns_in_createTypeStatement5701);
							typeColumns(stmt);
							state._fsp--;
							if (state.failed) return stmt;
							}
							break;

					}

					}
					break;

				default :
					break loop108;
				}
			}

			match(input,210,FOLLOW_210_in_createTypeStatement5708); if (state.failed) return stmt;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createTypeStatement"



	// $ANTLR start "typeColumns"
	// Parser.g:840:1: typeColumns[CreateTypeStatement.Raw stmt] : k= fident v= comparatorType ;
	public final void typeColumns(CreateTypeStatement.Raw stmt) throws RecognitionException {
		FieldIdentifier k =null;
		CQL3Type.Raw v =null;

		try {
			// Parser.g:841:5: (k= fident v= comparatorType )
			// Parser.g:841:7: k= fident v= comparatorType
			{
			pushFollow(FOLLOW_fident_in_typeColumns5728);
			k=fident();
			state._fsp--;
			if (state.failed) return;
			pushFollow(FOLLOW_comparatorType_in_typeColumns5732);
			v=comparatorType();
			state._fsp--;
			if (state.failed) return;
			if ( state.backtracking==0 ) { stmt.addField(k, v); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "typeColumns"



	// $ANTLR start "createIndexStatement"
	// Parser.g:848:1: createIndexStatement returns [CreateIndexStatement.Raw stmt] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' ( indexIdent[targets] ( ',' indexIdent[targets] )* )? ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? ;
	public final CreateIndexStatement.Raw createIndexStatement() throws RecognitionException {
		CreateIndexStatement.Raw stmt = null;


		Token cls=null;
		QualifiedName cf =null;


		        IndexAttributes props = new IndexAttributes();
		        boolean ifNotExists = false;
		        QualifiedName name = new QualifiedName();
		        List<IndexTarget.Raw> targets = new ArrayList<>();
		    
		try {
			// Parser.g:855:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' ( indexIdent[targets] ( ',' indexIdent[targets] )* )? ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? )
			// Parser.g:855:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' ( indexIdent[targets] ( ',' indexIdent[targets] )* )? ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement5766); if (state.failed) return stmt;
			// Parser.g:855:16: ( K_CUSTOM )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==K_CUSTOM) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// Parser.g:855:17: K_CUSTOM
					{
					match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement5769); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { props.isCustom = true; }
					}
					break;

			}

			match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement5775); if (state.failed) return stmt;
			// Parser.g:855:63: ( K_IF K_NOT K_EXISTS )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==K_IF) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// Parser.g:855:64: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement5778); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement5780); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement5782); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			// Parser.g:856:9: ( idxName[name] )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==IDENT||LA111_0==K_ACCESS||(LA111_0 >= K_AGGREGATE && LA111_0 <= K_ALL)||LA111_0==K_ANN||LA111_0==K_AS||LA111_0==K_ASCII||(LA111_0 >= K_BIGINT && LA111_0 <= K_BOOLEAN)||(LA111_0 >= K_CALLED && LA111_0 <= K_CLUSTERING)||(LA111_0 >= K_COMPACT && LA111_0 <= K_COUNTER)||(LA111_0 >= K_CUSTOM && LA111_0 <= K_DEFAULT)||(LA111_0 >= K_DISTINCT && LA111_0 <= K_DOUBLE)||LA111_0==K_DURATION||(LA111_0 >= K_EXISTS && LA111_0 <= K_FLOAT)||LA111_0==K_FROZEN||(LA111_0 >= K_FUNCTION && LA111_0 <= K_FUNCTIONS)||(LA111_0 >= K_GROUP && LA111_0 <= K_IDENTITY)||(LA111_0 >= K_INET && LA111_0 <= K_INPUT)||(LA111_0 >= K_INT && LA111_0 <= K_INTERNALS)||(LA111_0 >= K_JSON && LA111_0 <= K_KEYS)||(LA111_0 >= K_KEYSPACES && LA111_0 <= K_LIKE)||(LA111_0 >= K_LIST && LA111_0 <= K_MASKED)||(LA111_0 >= K_MAXWRITETIME && LA111_0 <= K_MBEANS)||LA111_0==K_NOLOGIN||LA111_0==K_NOSUPERUSER||(LA111_0 >= K_ONLY && LA111_0 <= K_OPTIONS)||(LA111_0 >= K_PARTITION && LA111_0 <= K_PERMISSIONS)||(LA111_0 >= K_REPLACE && LA111_0 <= K_RETURNS)||(LA111_0 >= K_ROLE && LA111_0 <= K_ROLES)||LA111_0==K_SELECT_MASKED||(LA111_0 >= K_SFUNC && LA111_0 <= K_TINYINT)||LA111_0==K_TRIGGER||(LA111_0 >= K_TTL && LA111_0 <= K_TYPES)||(LA111_0 >= K_UNMASK && LA111_0 <= K_UNSET)||(LA111_0 >= K_USER && LA111_0 <= K_USERS)||(LA111_0 >= K_UUID && LA111_0 <= K_VECTOR)||LA111_0==K_WRITETIME||(LA111_0 >= QMARK && LA111_0 <= QUOTED_NAME)) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// Parser.g:856:10: idxName[name]
					{
					pushFollow(FOLLOW_idxName_in_createIndexStatement5798);
					idxName(name);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement5803); if (state.failed) return stmt;
			pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement5807);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,209,FOLLOW_209_in_createIndexStatement5809); if (state.failed) return stmt;
			// Parser.g:856:55: ( indexIdent[targets] ( ',' indexIdent[targets] )* )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==EMPTY_QUOTED_NAME||LA113_0==IDENT||LA113_0==K_ACCESS||(LA113_0 >= K_AGGREGATE && LA113_0 <= K_ALL)||LA113_0==K_ANN||LA113_0==K_AS||LA113_0==K_ASCII||(LA113_0 >= K_BIGINT && LA113_0 <= K_BOOLEAN)||(LA113_0 >= K_CALLED && LA113_0 <= K_CLUSTERING)||(LA113_0 >= K_COMPACT && LA113_0 <= K_COUNTER)||(LA113_0 >= K_CUSTOM && LA113_0 <= K_DEFAULT)||(LA113_0 >= K_DISTINCT && LA113_0 <= K_DOUBLE)||(LA113_0 >= K_DURATION && LA113_0 <= K_ENTRIES)||(LA113_0 >= K_EXISTS && LA113_0 <= K_FLOAT)||(LA113_0 >= K_FROZEN && LA113_0 <= K_FUNCTIONS)||(LA113_0 >= K_GROUP && LA113_0 <= K_IDENTITY)||(LA113_0 >= K_INET && LA113_0 <= K_INPUT)||(LA113_0 >= K_INT && LA113_0 <= K_INTERNALS)||(LA113_0 >= K_JSON && LA113_0 <= K_KEYS)||(LA113_0 >= K_KEYSPACES && LA113_0 <= K_LIKE)||(LA113_0 >= K_LIST && LA113_0 <= K_MASKED)||(LA113_0 >= K_MAXWRITETIME && LA113_0 <= K_MBEANS)||LA113_0==K_NOLOGIN||LA113_0==K_NOSUPERUSER||(LA113_0 >= K_ONLY && LA113_0 <= K_OPTIONS)||(LA113_0 >= K_PARTITION && LA113_0 <= K_PERMISSIONS)||(LA113_0 >= K_REPLACE && LA113_0 <= K_RETURNS)||(LA113_0 >= K_ROLE && LA113_0 <= K_ROLES)||LA113_0==K_SELECT_MASKED||(LA113_0 >= K_SFUNC && LA113_0 <= K_TINYINT)||LA113_0==K_TRIGGER||(LA113_0 >= K_TTL && LA113_0 <= K_TYPES)||(LA113_0 >= K_UNMASK && LA113_0 <= K_UNSET)||(LA113_0 >= K_USER && LA113_0 <= K_USERS)||(LA113_0 >= K_UUID && LA113_0 <= K_VECTOR)||LA113_0==K_WRITETIME||LA113_0==QUOTED_NAME) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// Parser.g:856:56: indexIdent[targets] ( ',' indexIdent[targets] )*
					{
					pushFollow(FOLLOW_indexIdent_in_createIndexStatement5812);
					indexIdent(targets);
					state._fsp--;
					if (state.failed) return stmt;
					// Parser.g:856:76: ( ',' indexIdent[targets] )*
					loop112:
					while (true) {
						int alt112=2;
						int LA112_0 = input.LA(1);
						if ( (LA112_0==213) ) {
							alt112=1;
						}

						switch (alt112) {
						case 1 :
							// Parser.g:856:77: ',' indexIdent[targets]
							{
							match(input,213,FOLLOW_213_in_createIndexStatement5816); if (state.failed) return stmt;
							pushFollow(FOLLOW_indexIdent_in_createIndexStatement5818);
							indexIdent(targets);
							state._fsp--;
							if (state.failed) return stmt;
							}
							break;

						default :
							break loop112;
						}
					}

					}
					break;

			}

			match(input,210,FOLLOW_210_in_createIndexStatement5825); if (state.failed) return stmt;
			// Parser.g:857:9: ( K_USING cls= STRING_LITERAL )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==K_USING) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// Parser.g:857:10: K_USING cls= STRING_LITERAL
					{
					match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement5836); if (state.failed) return stmt;
					cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement5840); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { props.customClass = (cls!=null?cls.getText():null); }
					}
					break;

			}

			// Parser.g:858:9: ( K_WITH properties[props] )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==K_WITH) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// Parser.g:858:10: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement5855); if (state.failed) return stmt;
					pushFollow(FOLLOW_properties_in_createIndexStatement5857);
					properties(props);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt = new CreateIndexStatement.Raw(cf, name, targets, props, ifNotExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createIndexStatement"



	// $ANTLR start "indexIdent"
	// Parser.g:862:1: indexIdent[List<IndexTarget.Raw> targets] : (c= cident | K_VALUES '(' c= cident ')' | K_KEYS '(' c= cident ')' | K_ENTRIES '(' c= cident ')' | K_FULL '(' c= cident ')' );
	public final void indexIdent(List<IndexTarget.Raw> targets) throws RecognitionException {
		ColumnIdentifier c =null;

		try {
			// Parser.g:863:5: (c= cident | K_VALUES '(' c= cident ')' | K_KEYS '(' c= cident ')' | K_ENTRIES '(' c= cident ')' | K_FULL '(' c= cident ')' )
			int alt116=5;
			switch ( input.LA(1) ) {
			case EMPTY_QUOTED_NAME:
			case IDENT:
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt116=1;
				}
				break;
			case K_VALUES:
				{
				int LA116_2 = input.LA(2);
				if ( (LA116_2==209) ) {
					alt116=2;
				}
				else if ( (LA116_2==210||LA116_2==213) ) {
					alt116=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_KEYS:
				{
				int LA116_3 = input.LA(2);
				if ( (LA116_3==209) ) {
					alt116=3;
				}
				else if ( (LA116_3==210||LA116_3==213) ) {
					alt116=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ENTRIES:
				{
				alt116=4;
				}
				break;
			case K_FULL:
				{
				alt116=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}
			switch (alt116) {
				case 1 :
					// Parser.g:863:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_indexIdent5889);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { targets.add(IndexTarget.Raw.simpleIndexOn(c)); }
					}
					break;
				case 2 :
					// Parser.g:864:7: K_VALUES '(' c= cident ')'
					{
					match(input,K_VALUES,FOLLOW_K_VALUES_in_indexIdent5917); if (state.failed) return;
					match(input,209,FOLLOW_209_in_indexIdent5919); if (state.failed) return;
					pushFollow(FOLLOW_cident_in_indexIdent5923);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,210,FOLLOW_210_in_indexIdent5925); if (state.failed) return;
					if ( state.backtracking==0 ) { targets.add(IndexTarget.Raw.valuesOf(c)); }
					}
					break;
				case 3 :
					// Parser.g:865:7: K_KEYS '(' c= cident ')'
					{
					match(input,K_KEYS,FOLLOW_K_KEYS_in_indexIdent5936); if (state.failed) return;
					match(input,209,FOLLOW_209_in_indexIdent5938); if (state.failed) return;
					pushFollow(FOLLOW_cident_in_indexIdent5942);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,210,FOLLOW_210_in_indexIdent5944); if (state.failed) return;
					if ( state.backtracking==0 ) { targets.add(IndexTarget.Raw.keysOf(c)); }
					}
					break;
				case 4 :
					// Parser.g:866:7: K_ENTRIES '(' c= cident ')'
					{
					match(input,K_ENTRIES,FOLLOW_K_ENTRIES_in_indexIdent5957); if (state.failed) return;
					match(input,209,FOLLOW_209_in_indexIdent5959); if (state.failed) return;
					pushFollow(FOLLOW_cident_in_indexIdent5963);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,210,FOLLOW_210_in_indexIdent5965); if (state.failed) return;
					if ( state.backtracking==0 ) { targets.add(IndexTarget.Raw.keysAndValuesOf(c)); }
					}
					break;
				case 5 :
					// Parser.g:867:7: K_FULL '(' c= cident ')'
					{
					match(input,K_FULL,FOLLOW_K_FULL_in_indexIdent5975); if (state.failed) return;
					match(input,209,FOLLOW_209_in_indexIdent5977); if (state.failed) return;
					pushFollow(FOLLOW_cident_in_indexIdent5981);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,210,FOLLOW_210_in_indexIdent5983); if (state.failed) return;
					if ( state.backtracking==0 ) { targets.add(IndexTarget.Raw.fullCollection(c)); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "indexIdent"



	// $ANTLR start "createMaterializedViewStatement"
	// Parser.g:878:1: createMaterializedViewStatement returns [CreateViewStatement.Raw stmt] : K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectors K_FROM basecf= columnFamilyName ( K_WHERE wclause= whereClause )? viewPrimaryKey[stmt] ( K_WITH viewProperty[stmt] ( K_AND viewProperty[stmt] )* )? ;
	public final CreateViewStatement.Raw createMaterializedViewStatement() throws RecognitionException {
		CreateViewStatement.Raw stmt = null;


		QualifiedName cf =null;
		List<RawSelector> sclause =null;
		QualifiedName basecf =null;
		WhereClause.Builder wclause =null;


		        boolean ifNotExists = false;
		    
		try {
			// Parser.g:882:5: ( K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectors K_FROM basecf= columnFamilyName ( K_WHERE wclause= whereClause )? viewPrimaryKey[stmt] ( K_WITH viewProperty[stmt] ( K_AND viewProperty[stmt] )* )? )
			// Parser.g:882:7: K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectors K_FROM basecf= columnFamilyName ( K_WHERE wclause= whereClause )? viewPrimaryKey[stmt] ( K_WITH viewProperty[stmt] ( K_AND viewProperty[stmt] )* )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createMaterializedViewStatement6020); if (state.failed) return stmt;
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_createMaterializedViewStatement6022); if (state.failed) return stmt;
			match(input,K_VIEW,FOLLOW_K_VIEW_in_createMaterializedViewStatement6024); if (state.failed) return stmt;
			// Parser.g:882:38: ( K_IF K_NOT K_EXISTS )?
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==K_IF) ) {
				alt117=1;
			}
			switch (alt117) {
				case 1 :
					// Parser.g:882:39: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createMaterializedViewStatement6027); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createMaterializedViewStatement6029); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createMaterializedViewStatement6031); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createMaterializedViewStatement6039);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_AS,FOLLOW_K_AS_in_createMaterializedViewStatement6041); if (state.failed) return stmt;
			match(input,K_SELECT,FOLLOW_K_SELECT_in_createMaterializedViewStatement6051); if (state.failed) return stmt;
			pushFollow(FOLLOW_selectors_in_createMaterializedViewStatement6055);
			sclause=selectors();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_FROM,FOLLOW_K_FROM_in_createMaterializedViewStatement6057); if (state.failed) return stmt;
			pushFollow(FOLLOW_columnFamilyName_in_createMaterializedViewStatement6061);
			basecf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:884:9: ( K_WHERE wclause= whereClause )?
			int alt118=2;
			int LA118_0 = input.LA(1);
			if ( (LA118_0==K_WHERE) ) {
				alt118=1;
			}
			switch (alt118) {
				case 1 :
					// Parser.g:884:10: K_WHERE wclause= whereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_createMaterializedViewStatement6072); if (state.failed) return stmt;
					pushFollow(FOLLOW_whereClause_in_createMaterializedViewStatement6076);
					wclause=whereClause();
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			             WhereClause where = wclause == null ? WhereClause.empty() : wclause.build();
			             stmt = new CreateViewStatement.Raw(basecf, cf, sclause, where, ifNotExists);
			        }
			pushFollow(FOLLOW_viewPrimaryKey_in_createMaterializedViewStatement6098);
			viewPrimaryKey(stmt);
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:890:9: ( K_WITH viewProperty[stmt] ( K_AND viewProperty[stmt] )* )?
			int alt120=2;
			int LA120_0 = input.LA(1);
			if ( (LA120_0==K_WITH) ) {
				alt120=1;
			}
			switch (alt120) {
				case 1 :
					// Parser.g:890:11: K_WITH viewProperty[stmt] ( K_AND viewProperty[stmt] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createMaterializedViewStatement6111); if (state.failed) return stmt;
					pushFollow(FOLLOW_viewProperty_in_createMaterializedViewStatement6113);
					viewProperty(stmt);
					state._fsp--;
					if (state.failed) return stmt;
					// Parser.g:890:37: ( K_AND viewProperty[stmt] )*
					loop119:
					while (true) {
						int alt119=2;
						int LA119_0 = input.LA(1);
						if ( (LA119_0==K_AND) ) {
							alt119=1;
						}

						switch (alt119) {
						case 1 :
							// Parser.g:890:39: K_AND viewProperty[stmt]
							{
							match(input,K_AND,FOLLOW_K_AND_in_createMaterializedViewStatement6118); if (state.failed) return stmt;
							pushFollow(FOLLOW_viewProperty_in_createMaterializedViewStatement6120);
							viewProperty(stmt);
							state._fsp--;
							if (state.failed) return stmt;
							}
							break;

						default :
							break loop119;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createMaterializedViewStatement"



	// $ANTLR start "viewPrimaryKey"
	// Parser.g:893:1: viewPrimaryKey[CreateViewStatement.Raw stmt] : K_PRIMARY K_KEY '(' viewPartitionKey[stmt] ( ',' c= ident )* ')' ;
	public final void viewPrimaryKey(CreateViewStatement.Raw stmt) throws RecognitionException {
		ColumnIdentifier c =null;

		try {
			// Parser.g:894:5: ( K_PRIMARY K_KEY '(' viewPartitionKey[stmt] ( ',' c= ident )* ')' )
			// Parser.g:894:7: K_PRIMARY K_KEY '(' viewPartitionKey[stmt] ( ',' c= ident )* ')'
			{
			match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_viewPrimaryKey6144); if (state.failed) return;
			match(input,K_KEY,FOLLOW_K_KEY_in_viewPrimaryKey6146); if (state.failed) return;
			match(input,209,FOLLOW_209_in_viewPrimaryKey6148); if (state.failed) return;
			pushFollow(FOLLOW_viewPartitionKey_in_viewPrimaryKey6150);
			viewPartitionKey(stmt);
			state._fsp--;
			if (state.failed) return;
			// Parser.g:894:50: ( ',' c= ident )*
			loop121:
			while (true) {
				int alt121=2;
				int LA121_0 = input.LA(1);
				if ( (LA121_0==213) ) {
					alt121=1;
				}

				switch (alt121) {
				case 1 :
					// Parser.g:894:51: ',' c= ident
					{
					match(input,213,FOLLOW_213_in_viewPrimaryKey6154); if (state.failed) return;
					pushFollow(FOLLOW_ident_in_viewPrimaryKey6158);
					c=ident();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { stmt.markClusteringColumn(c); }
					}
					break;

				default :
					break loop121;
				}
			}

			match(input,210,FOLLOW_210_in_viewPrimaryKey6165); if (state.failed) return;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "viewPrimaryKey"



	// $ANTLR start "viewPartitionKey"
	// Parser.g:897:1: viewPartitionKey[CreateViewStatement.Raw stmt] : (k1= ident | '(' k1= ident ( ',' kn= ident )* ')' );
	public final void viewPartitionKey(CreateViewStatement.Raw stmt) throws RecognitionException {
		ColumnIdentifier k1 =null;
		ColumnIdentifier kn =null;

		List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>();
		try {
			// Parser.g:900:5: (k1= ident | '(' k1= ident ( ',' kn= ident )* ')' )
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==IDENT||LA123_0==K_ACCESS||(LA123_0 >= K_AGGREGATE && LA123_0 <= K_ALL)||LA123_0==K_ANN||LA123_0==K_AS||LA123_0==K_ASCII||(LA123_0 >= K_BIGINT && LA123_0 <= K_BOOLEAN)||(LA123_0 >= K_CALLED && LA123_0 <= K_CLUSTERING)||(LA123_0 >= K_COMPACT && LA123_0 <= K_COUNTER)||(LA123_0 >= K_CUSTOM && LA123_0 <= K_DEFAULT)||(LA123_0 >= K_DISTINCT && LA123_0 <= K_DOUBLE)||LA123_0==K_DURATION||(LA123_0 >= K_EXISTS && LA123_0 <= K_FLOAT)||LA123_0==K_FROZEN||(LA123_0 >= K_FUNCTION && LA123_0 <= K_FUNCTIONS)||(LA123_0 >= K_GROUP && LA123_0 <= K_IDENTITY)||(LA123_0 >= K_INET && LA123_0 <= K_INPUT)||(LA123_0 >= K_INT && LA123_0 <= K_INTERNALS)||(LA123_0 >= K_JSON && LA123_0 <= K_KEYS)||(LA123_0 >= K_KEYSPACES && LA123_0 <= K_LIKE)||(LA123_0 >= K_LIST && LA123_0 <= K_MASKED)||(LA123_0 >= K_MAXWRITETIME && LA123_0 <= K_MBEANS)||LA123_0==K_NOLOGIN||LA123_0==K_NOSUPERUSER||(LA123_0 >= K_ONLY && LA123_0 <= K_OPTIONS)||(LA123_0 >= K_PARTITION && LA123_0 <= K_PERMISSIONS)||(LA123_0 >= K_REPLACE && LA123_0 <= K_RETURNS)||(LA123_0 >= K_ROLE && LA123_0 <= K_ROLES)||LA123_0==K_SELECT_MASKED||(LA123_0 >= K_SFUNC && LA123_0 <= K_TINYINT)||LA123_0==K_TRIGGER||(LA123_0 >= K_TTL && LA123_0 <= K_TYPES)||(LA123_0 >= K_UNMASK && LA123_0 <= K_UNSET)||(LA123_0 >= K_USER && LA123_0 <= K_USERS)||(LA123_0 >= K_UUID && LA123_0 <= K_VECTOR)||LA123_0==K_WRITETIME||LA123_0==QUOTED_NAME) ) {
				alt123=1;
			}
			else if ( (LA123_0==209) ) {
				alt123=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 123, 0, input);
				throw nvae;
			}

			switch (alt123) {
				case 1 :
					// Parser.g:900:7: k1= ident
					{
					pushFollow(FOLLOW_ident_in_viewPartitionKey6202);
					k1=ident();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { l.add(k1);}
					}
					break;
				case 2 :
					// Parser.g:901:7: '(' k1= ident ( ',' kn= ident )* ')'
					{
					match(input,209,FOLLOW_209_in_viewPartitionKey6212); if (state.failed) return;
					pushFollow(FOLLOW_ident_in_viewPartitionKey6216);
					k1=ident();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { l.add(k1); }
					// Parser.g:901:35: ( ',' kn= ident )*
					loop122:
					while (true) {
						int alt122=2;
						int LA122_0 = input.LA(1);
						if ( (LA122_0==213) ) {
							alt122=1;
						}

						switch (alt122) {
						case 1 :
							// Parser.g:901:37: ',' kn= ident
							{
							match(input,213,FOLLOW_213_in_viewPartitionKey6222); if (state.failed) return;
							pushFollow(FOLLOW_ident_in_viewPartitionKey6226);
							kn=ident();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { l.add(kn); }
							}
							break;

						default :
							break loop122;
						}
					}

					match(input,210,FOLLOW_210_in_viewPartitionKey6233); if (state.failed) return;
					}
					break;

			}
			if ( state.backtracking==0 ) { stmt.setPartitionKeyColumns(l); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "viewPartitionKey"



	// $ANTLR start "viewProperty"
	// Parser.g:904:1: viewProperty[CreateViewStatement.Raw stmt] : ( property[stmt.attrs] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' viewClusteringOrder[stmt] ( ',' viewClusteringOrder[stmt] )* ')' );
	public final void viewProperty(CreateViewStatement.Raw stmt) throws RecognitionException {
		try {
			// Parser.g:905:5: ( property[stmt.attrs] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' viewClusteringOrder[stmt] ( ',' viewClusteringOrder[stmt] )* ')' )
			int alt125=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt125=1;
				}
				break;
			case K_COMPACT:
				{
				int LA125_2 = input.LA(2);
				if ( (LA125_2==K_STORAGE) ) {
					alt125=2;
				}
				else if ( (LA125_2==222) ) {
					alt125=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 125, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_CLUSTERING:
				{
				int LA125_3 = input.LA(2);
				if ( (LA125_3==K_ORDER) ) {
					alt125=3;
				}
				else if ( (LA125_3==222) ) {
					alt125=1;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 125, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 125, 0, input);
				throw nvae;
			}
			switch (alt125) {
				case 1 :
					// Parser.g:905:7: property[stmt.attrs]
					{
					pushFollow(FOLLOW_property_in_viewProperty6251);
					property(stmt.attrs);
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:906:7: K_COMPACT K_STORAGE
					{
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_viewProperty6260); if (state.failed) return;
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_viewProperty6262); if (state.failed) return;
					if ( state.backtracking==0 ) { throw new SyntaxException("COMPACT STORAGE tables are not allowed starting with version 4.0"); }
					}
					break;
				case 3 :
					// Parser.g:907:7: K_CLUSTERING K_ORDER K_BY '(' viewClusteringOrder[stmt] ( ',' viewClusteringOrder[stmt] )* ')'
					{
					match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_viewProperty6272); if (state.failed) return;
					match(input,K_ORDER,FOLLOW_K_ORDER_in_viewProperty6274); if (state.failed) return;
					match(input,K_BY,FOLLOW_K_BY_in_viewProperty6276); if (state.failed) return;
					match(input,209,FOLLOW_209_in_viewProperty6278); if (state.failed) return;
					pushFollow(FOLLOW_viewClusteringOrder_in_viewProperty6280);
					viewClusteringOrder(stmt);
					state._fsp--;
					if (state.failed) return;
					// Parser.g:907:63: ( ',' viewClusteringOrder[stmt] )*
					loop124:
					while (true) {
						int alt124=2;
						int LA124_0 = input.LA(1);
						if ( (LA124_0==213) ) {
							alt124=1;
						}

						switch (alt124) {
						case 1 :
							// Parser.g:907:64: ',' viewClusteringOrder[stmt]
							{
							match(input,213,FOLLOW_213_in_viewProperty6284); if (state.failed) return;
							pushFollow(FOLLOW_viewClusteringOrder_in_viewProperty6286);
							viewClusteringOrder(stmt);
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop124;
						}
					}

					match(input,210,FOLLOW_210_in_viewProperty6291); if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "viewProperty"



	// $ANTLR start "viewClusteringOrder"
	// Parser.g:910:1: viewClusteringOrder[CreateViewStatement.Raw stmt] : k= ident ( K_ASC | K_DESC ) ;
	public final void viewClusteringOrder(CreateViewStatement.Raw stmt) throws RecognitionException {
		ColumnIdentifier k =null;

		 boolean ascending = true; 
		try {
			// Parser.g:912:5: (k= ident ( K_ASC | K_DESC ) )
			// Parser.g:912:7: k= ident ( K_ASC | K_DESC )
			{
			pushFollow(FOLLOW_ident_in_viewClusteringOrder6319);
			k=ident();
			state._fsp--;
			if (state.failed) return;
			// Parser.g:912:15: ( K_ASC | K_DESC )
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==K_ASC) ) {
				alt126=1;
			}
			else if ( (LA126_0==K_DESC) ) {
				alt126=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 126, 0, input);
				throw nvae;
			}

			switch (alt126) {
				case 1 :
					// Parser.g:912:16: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_viewClusteringOrder6322); if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:912:24: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_viewClusteringOrder6326); if (state.failed) return;
					if ( state.backtracking==0 ) { ascending = false; }
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt.extendClusteringOrder(k, ascending); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "viewClusteringOrder"



	// $ANTLR start "createTriggerStatement"
	// Parser.g:918:1: createTriggerStatement returns [CreateTriggerStatement.Raw stmt] : K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= ident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL ;
	public final CreateTriggerStatement.Raw createTriggerStatement() throws RecognitionException {
		CreateTriggerStatement.Raw stmt = null;


		Token cls=null;
		ColumnIdentifier name =null;
		QualifiedName cf =null;


		        boolean ifNotExists = false;
		    
		try {
			// Parser.g:922:5: ( K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= ident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL )
			// Parser.g:922:7: K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= ident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement6364); if (state.failed) return stmt;
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement6366); if (state.failed) return stmt;
			// Parser.g:922:26: ( K_IF K_NOT K_EXISTS )?
			int alt127=2;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==K_IF) ) {
				alt127=1;
			}
			switch (alt127) {
				case 1 :
					// Parser.g:922:27: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTriggerStatement6369); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createTriggerStatement6371); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTriggerStatement6373); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			// Parser.g:922:74: (name= ident )
			// Parser.g:922:75: name= ident
			{
			pushFollow(FOLLOW_ident_in_createTriggerStatement6383);
			name=ident();
			state._fsp--;
			if (state.failed) return stmt;
			}

			match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement6394); if (state.failed) return stmt;
			pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement6398);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement6400); if (state.failed) return stmt;
			cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement6404); if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new CreateTriggerStatement.Raw(cf, name.toString(), (cls!=null?cls.getText():null), ifNotExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createTriggerStatement"



	// $ANTLR start "dropTriggerStatement"
	// Parser.g:930:1: dropTriggerStatement returns [DropTriggerStatement.Raw stmt] : K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= ident ) K_ON cf= columnFamilyName ;
	public final DropTriggerStatement.Raw dropTriggerStatement() throws RecognitionException {
		DropTriggerStatement.Raw stmt = null;


		ColumnIdentifier name =null;
		QualifiedName cf =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:932:5: ( K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= ident ) K_ON cf= columnFamilyName )
			// Parser.g:932:7: K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= ident ) K_ON cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement6445); if (state.failed) return stmt;
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement6447); if (state.failed) return stmt;
			// Parser.g:932:24: ( K_IF K_EXISTS )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==K_IF) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// Parser.g:932:25: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTriggerStatement6450); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTriggerStatement6452); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			// Parser.g:932:63: (name= ident )
			// Parser.g:932:64: name= ident
			{
			pushFollow(FOLLOW_ident_in_dropTriggerStatement6462);
			name=ident();
			state._fsp--;
			if (state.failed) return stmt;
			}

			match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement6465); if (state.failed) return stmt;
			pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement6469);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropTriggerStatement.Raw(cf, name.toString(), ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTriggerStatement"



	// $ANTLR start "alterKeyspaceStatement"
	// Parser.g:939:1: alterKeyspaceStatement returns [AlterKeyspaceStatement.Raw stmt] : K_ALTER K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
	public final AlterKeyspaceStatement.Raw alterKeyspaceStatement() throws RecognitionException {
		AlterKeyspaceStatement.Raw stmt = null;


		String ks =null;


		     KeyspaceAttributes attrs = new KeyspaceAttributes();
		     boolean ifExists = false;
		    
		try {
			// Parser.g:944:5: ( K_ALTER K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
			// Parser.g:944:7: K_ALTER K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement6509); if (state.failed) return stmt;
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement6511); if (state.failed) return stmt;
			// Parser.g:944:26: ( K_IF K_EXISTS )?
			int alt129=2;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==K_IF) ) {
				alt129=1;
			}
			switch (alt129) {
				case 1 :
					// Parser.g:944:27: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_alterKeyspaceStatement6514); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterKeyspaceStatement6516); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement6525);
			ks=keyspaceName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement6535); if (state.failed) return stmt;
			pushFollow(FOLLOW_properties_in_alterKeyspaceStatement6537);
			properties(attrs);
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new AlterKeyspaceStatement.Raw(ks, attrs, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterKeyspaceStatement"



	// $ANTLR start "alterTableStatement"
	// Parser.g:957:1: alterTableStatement returns [AlterTableStatement.Raw stmt] : K_ALTER K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ALTER ( K_IF K_EXISTS )? id= cident (mask= columnMask | K_DROP K_MASKED ) | K_ADD ( K_IF K_NOT K_EXISTS )? (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) ) | K_DROP ( K_IF K_EXISTS )? (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) ) ( K_USING K_TIMESTAMP t= INTEGER )? | K_RENAME ( K_IF K_EXISTS )? (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) | K_DROP K_COMPACT K_STORAGE | K_WITH properties[$stmt.attrs] ) ;
	public final AlterTableStatement.Raw alterTableStatement() throws RecognitionException {
		AlterTableStatement.Raw stmt = null;


		Token t=null;
		QualifiedName cf =null;
		ColumnIdentifier id =null;
		CQL3Type.Raw v =null;
		ColumnMask.Raw mask =null;
		boolean b =false;
		ColumnMask.Raw m =null;
		ColumnIdentifier id1 =null;
		CQL3Type.Raw v1 =null;
		boolean b1 =false;
		ColumnMask.Raw m1 =null;
		ColumnIdentifier idn =null;
		CQL3Type.Raw vn =null;
		boolean bn =false;
		ColumnMask.Raw mn =null;
		ColumnIdentifier toId1 =null;
		ColumnIdentifier toIdn =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:959:5: ( K_ALTER K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ALTER ( K_IF K_EXISTS )? id= cident (mask= columnMask | K_DROP K_MASKED ) | K_ADD ( K_IF K_NOT K_EXISTS )? (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) ) | K_DROP ( K_IF K_EXISTS )? (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) ) ( K_USING K_TIMESTAMP t= INTEGER )? | K_RENAME ( K_IF K_EXISTS )? (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) | K_DROP K_COMPACT K_STORAGE | K_WITH properties[$stmt.attrs] ) )
			// Parser.g:959:7: K_ALTER K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ALTER ( K_IF K_EXISTS )? id= cident (mask= columnMask | K_DROP K_MASKED ) | K_ADD ( K_IF K_NOT K_EXISTS )? (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) ) | K_DROP ( K_IF K_EXISTS )? (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) ) ( K_USING K_TIMESTAMP t= INTEGER )? | K_RENAME ( K_IF K_EXISTS )? (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) | K_DROP K_COMPACT K_STORAGE | K_WITH properties[$stmt.attrs] )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement6572); if (state.failed) return stmt;
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement6574); if (state.failed) return stmt;
			// Parser.g:959:30: ( K_IF K_EXISTS )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==K_IF) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// Parser.g:959:31: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_alterTableStatement6577); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTableStatement6579); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement6594);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new AlterTableStatement.Raw(cf, ifExists); }
			// Parser.g:961:7: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ALTER ( K_IF K_EXISTS )? id= cident (mask= columnMask | K_DROP K_MASKED ) | K_ADD ( K_IF K_NOT K_EXISTS )? (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) ) | K_DROP ( K_IF K_EXISTS )? (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) ) ( K_USING K_TIMESTAMP t= INTEGER )? | K_RENAME ( K_IF K_EXISTS )? (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) | K_DROP K_COMPACT K_STORAGE | K_WITH properties[$stmt.attrs] )
			int alt145=7;
			alt145 = dfa145.predict(input);
			switch (alt145) {
				case 1 :
					// Parser.g:962:9: K_ALTER id= cident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement6614); if (state.failed) return stmt;
					pushFollow(FOLLOW_cident_in_alterTableStatement6618);
					id=cident();
					state._fsp--;
					if (state.failed) return stmt;
					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement6620); if (state.failed) return stmt;
					pushFollow(FOLLOW_comparatorType_in_alterTableStatement6624);
					v=comparatorType();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.alter(id, v); }
					}
					break;
				case 2 :
					// Parser.g:964:9: K_ALTER ( K_IF K_EXISTS )? id= cident (mask= columnMask | K_DROP K_MASKED )
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement6637); if (state.failed) return stmt;
					// Parser.g:964:17: ( K_IF K_EXISTS )?
					int alt131=2;
					int LA131_0 = input.LA(1);
					if ( (LA131_0==K_IF) ) {
						alt131=1;
					}
					switch (alt131) {
						case 1 :
							// Parser.g:964:19: K_IF K_EXISTS
							{
							match(input,K_IF,FOLLOW_K_IF_in_alterTableStatement6641); if (state.failed) return stmt;
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTableStatement6643); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.ifColumnExists(true); }
							}
							break;

					}

					pushFollow(FOLLOW_cident_in_alterTableStatement6652);
					id=cident();
					state._fsp--;
					if (state.failed) return stmt;
					// Parser.g:965:15: (mask= columnMask | K_DROP K_MASKED )
					int alt132=2;
					int LA132_0 = input.LA(1);
					if ( (LA132_0==K_MASKED) ) {
						alt132=1;
					}
					else if ( (LA132_0==K_DROP) ) {
						alt132=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return stmt;}
						NoViableAltException nvae =
							new NoViableAltException("", 132, 0, input);
						throw nvae;
					}

					switch (alt132) {
						case 1 :
							// Parser.g:965:17: mask= columnMask
							{
							pushFollow(FOLLOW_columnMask_in_alterTableStatement6672);
							mask=columnMask();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.mask(id, mask); }
							}
							break;
						case 2 :
							// Parser.g:966:17: K_DROP K_MASKED
							{
							match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement6692); if (state.failed) return stmt;
							match(input,K_MASKED,FOLLOW_K_MASKED_in_alterTableStatement6694); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.mask(id, null); }
							}
							break;

					}

					}
					break;
				case 3 :
					// Parser.g:968:9: K_ADD ( K_IF K_NOT K_EXISTS )? (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) )
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement6709); if (state.failed) return stmt;
					// Parser.g:968:15: ( K_IF K_NOT K_EXISTS )?
					int alt133=2;
					int LA133_0 = input.LA(1);
					if ( (LA133_0==K_IF) ) {
						alt133=1;
					}
					switch (alt133) {
						case 1 :
							// Parser.g:968:17: K_IF K_NOT K_EXISTS
							{
							match(input,K_IF,FOLLOW_K_IF_in_alterTableStatement6713); if (state.failed) return stmt;
							match(input,K_NOT,FOLLOW_K_NOT_in_alterTableStatement6715); if (state.failed) return stmt;
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTableStatement6717); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.ifColumnNotExists(true); }
							}
							break;

					}

					// Parser.g:969:15: (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) )
					int alt138=2;
					int LA138_0 = input.LA(1);
					if ( (LA138_0==IDENT||LA138_0==K_ACCESS||(LA138_0 >= K_AGGREGATE && LA138_0 <= K_ALL)||LA138_0==K_ANN||LA138_0==K_AS||LA138_0==K_ASCII||(LA138_0 >= K_BIGINT && LA138_0 <= K_BOOLEAN)||(LA138_0 >= K_CALLED && LA138_0 <= K_CLUSTERING)||(LA138_0 >= K_COMPACT && LA138_0 <= K_COUNTER)||(LA138_0 >= K_CUSTOM && LA138_0 <= K_DEFAULT)||(LA138_0 >= K_DISTINCT && LA138_0 <= K_DOUBLE)||LA138_0==K_DURATION||(LA138_0 >= K_EXISTS && LA138_0 <= K_FLOAT)||LA138_0==K_FROZEN||(LA138_0 >= K_FUNCTION && LA138_0 <= K_FUNCTIONS)||(LA138_0 >= K_GROUP && LA138_0 <= K_IDENTITY)||(LA138_0 >= K_INET && LA138_0 <= K_INPUT)||(LA138_0 >= K_INT && LA138_0 <= K_INTERNALS)||(LA138_0 >= K_JSON && LA138_0 <= K_KEYS)||(LA138_0 >= K_KEYSPACES && LA138_0 <= K_LIKE)||(LA138_0 >= K_LIST && LA138_0 <= K_MASKED)||(LA138_0 >= K_MAXWRITETIME && LA138_0 <= K_MBEANS)||LA138_0==K_NOLOGIN||LA138_0==K_NOSUPERUSER||(LA138_0 >= K_ONLY && LA138_0 <= K_OPTIONS)||(LA138_0 >= K_PARTITION && LA138_0 <= K_PERMISSIONS)||(LA138_0 >= K_REPLACE && LA138_0 <= K_RETURNS)||(LA138_0 >= K_ROLE && LA138_0 <= K_ROLES)||LA138_0==K_SELECT_MASKED||(LA138_0 >= K_SFUNC && LA138_0 <= K_TINYINT)||LA138_0==K_TRIGGER||(LA138_0 >= K_TTL && LA138_0 <= K_TYPES)||(LA138_0 >= K_UNMASK && LA138_0 <= K_UNSET)||(LA138_0 >= K_USER && LA138_0 <= K_USERS)||(LA138_0 >= K_UUID && LA138_0 <= K_VECTOR)||LA138_0==K_WRITETIME||LA138_0==QUOTED_NAME) ) {
						alt138=1;
					}
					else if ( (LA138_0==209) ) {
						alt138=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return stmt;}
						NoViableAltException nvae =
							new NoViableAltException("", 138, 0, input);
						throw nvae;
					}

					switch (alt138) {
						case 1 :
							// Parser.g:969:24: id= ident v= comparatorType b= isStaticColumn (m= columnMask )?
							{
							pushFollow(FOLLOW_ident_in_alterTableStatement6749);
							id=ident();
							state._fsp--;
							if (state.failed) return stmt;
							pushFollow(FOLLOW_comparatorType_in_alterTableStatement6754);
							v=comparatorType();
							state._fsp--;
							if (state.failed) return stmt;
							pushFollow(FOLLOW_isStaticColumn_in_alterTableStatement6759);
							b=isStaticColumn();
							state._fsp--;
							if (state.failed) return stmt;
							// Parser.g:969:69: (m= columnMask )?
							int alt134=2;
							int LA134_0 = input.LA(1);
							if ( (LA134_0==K_MASKED) ) {
								alt134=1;
							}
							switch (alt134) {
								case 1 :
									// Parser.g:969:70: m= columnMask
									{
									pushFollow(FOLLOW_columnMask_in_alterTableStatement6764);
									m=columnMask();
									state._fsp--;
									if (state.failed) return stmt;
									}
									break;

							}

							if ( state.backtracking==0 ) { stmt.add(id,  v,  b, m);  }
							}
							break;
						case 2 :
							// Parser.g:970:18: ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' )
							{
							// Parser.g:970:18: ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' )
							// Parser.g:970:19: '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')'
							{
							match(input,209,FOLLOW_209_in_alterTableStatement6788); if (state.failed) return stmt;
							pushFollow(FOLLOW_ident_in_alterTableStatement6793);
							id1=ident();
							state._fsp--;
							if (state.failed) return stmt;
							pushFollow(FOLLOW_comparatorType_in_alterTableStatement6797);
							v1=comparatorType();
							state._fsp--;
							if (state.failed) return stmt;
							pushFollow(FOLLOW_isStaticColumn_in_alterTableStatement6801);
							b1=isStaticColumn();
							state._fsp--;
							if (state.failed) return stmt;
							// Parser.g:970:70: (m1= columnMask )?
							int alt135=2;
							int LA135_0 = input.LA(1);
							if ( (LA135_0==K_MASKED) ) {
								alt135=1;
							}
							switch (alt135) {
								case 1 :
									// Parser.g:970:71: m1= columnMask
									{
									pushFollow(FOLLOW_columnMask_in_alterTableStatement6806);
									m1=columnMask();
									state._fsp--;
									if (state.failed) return stmt;
									}
									break;

							}

							if ( state.backtracking==0 ) { stmt.add(id1, v1, b1, m1); }
							// Parser.g:971:18: ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )*
							loop137:
							while (true) {
								int alt137=2;
								int LA137_0 = input.LA(1);
								if ( (LA137_0==213) ) {
									alt137=1;
								}

								switch (alt137) {
								case 1 :
									// Parser.g:971:20: ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )?
									{
									match(input,213,FOLLOW_213_in_alterTableStatement6831); if (state.failed) return stmt;
									pushFollow(FOLLOW_ident_in_alterTableStatement6835);
									idn=ident();
									state._fsp--;
									if (state.failed) return stmt;
									pushFollow(FOLLOW_comparatorType_in_alterTableStatement6839);
									vn=comparatorType();
									state._fsp--;
									if (state.failed) return stmt;
									pushFollow(FOLLOW_isStaticColumn_in_alterTableStatement6843);
									bn=isStaticColumn();
									state._fsp--;
									if (state.failed) return stmt;
									// Parser.g:971:70: (mn= columnMask )?
									int alt136=2;
									int LA136_0 = input.LA(1);
									if ( (LA136_0==K_MASKED) ) {
										alt136=1;
									}
									switch (alt136) {
										case 1 :
											// Parser.g:971:71: mn= columnMask
											{
											pushFollow(FOLLOW_columnMask_in_alterTableStatement6848);
											mn=columnMask();
											state._fsp--;
											if (state.failed) return stmt;
											}
											break;

									}

									if ( state.backtracking==0 ) { stmt.add(idn, vn, bn, mn); mn=null; }
									}
									break;

								default :
									break loop137;
								}
							}

							match(input,210,FOLLOW_210_in_alterTableStatement6857); if (state.failed) return stmt;
							}

							}
							break;

					}

					}
					break;
				case 4 :
					// Parser.g:973:9: K_DROP ( K_IF K_EXISTS )? (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) ) ( K_USING K_TIMESTAMP t= INTEGER )?
					{
					match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement6871); if (state.failed) return stmt;
					// Parser.g:973:16: ( K_IF K_EXISTS )?
					int alt139=2;
					int LA139_0 = input.LA(1);
					if ( (LA139_0==K_IF) ) {
						alt139=1;
					}
					switch (alt139) {
						case 1 :
							// Parser.g:973:18: K_IF K_EXISTS
							{
							match(input,K_IF,FOLLOW_K_IF_in_alterTableStatement6875); if (state.failed) return stmt;
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTableStatement6877); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.ifColumnExists(true); }
							}
							break;

					}

					// Parser.g:974:16: (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) )
					int alt141=2;
					int LA141_0 = input.LA(1);
					if ( (LA141_0==IDENT||LA141_0==K_ACCESS||(LA141_0 >= K_AGGREGATE && LA141_0 <= K_ALL)||LA141_0==K_ANN||LA141_0==K_AS||LA141_0==K_ASCII||(LA141_0 >= K_BIGINT && LA141_0 <= K_BOOLEAN)||(LA141_0 >= K_CALLED && LA141_0 <= K_CLUSTERING)||(LA141_0 >= K_COMPACT && LA141_0 <= K_COUNTER)||(LA141_0 >= K_CUSTOM && LA141_0 <= K_DEFAULT)||(LA141_0 >= K_DISTINCT && LA141_0 <= K_DOUBLE)||LA141_0==K_DURATION||(LA141_0 >= K_EXISTS && LA141_0 <= K_FLOAT)||LA141_0==K_FROZEN||(LA141_0 >= K_FUNCTION && LA141_0 <= K_FUNCTIONS)||(LA141_0 >= K_GROUP && LA141_0 <= K_IDENTITY)||(LA141_0 >= K_INET && LA141_0 <= K_INPUT)||(LA141_0 >= K_INT && LA141_0 <= K_INTERNALS)||(LA141_0 >= K_JSON && LA141_0 <= K_KEYS)||(LA141_0 >= K_KEYSPACES && LA141_0 <= K_LIKE)||(LA141_0 >= K_LIST && LA141_0 <= K_MASKED)||(LA141_0 >= K_MAXWRITETIME && LA141_0 <= K_MBEANS)||LA141_0==K_NOLOGIN||LA141_0==K_NOSUPERUSER||(LA141_0 >= K_ONLY && LA141_0 <= K_OPTIONS)||(LA141_0 >= K_PARTITION && LA141_0 <= K_PERMISSIONS)||(LA141_0 >= K_REPLACE && LA141_0 <= K_RETURNS)||(LA141_0 >= K_ROLE && LA141_0 <= K_ROLES)||LA141_0==K_SELECT_MASKED||(LA141_0 >= K_SFUNC && LA141_0 <= K_TINYINT)||LA141_0==K_TRIGGER||(LA141_0 >= K_TTL && LA141_0 <= K_TYPES)||(LA141_0 >= K_UNMASK && LA141_0 <= K_UNSET)||(LA141_0 >= K_USER && LA141_0 <= K_USERS)||(LA141_0 >= K_UUID && LA141_0 <= K_VECTOR)||LA141_0==K_WRITETIME||LA141_0==QUOTED_NAME) ) {
						alt141=1;
					}
					else if ( (LA141_0==209) ) {
						alt141=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return stmt;}
						NoViableAltException nvae =
							new NoViableAltException("", 141, 0, input);
						throw nvae;
					}

					switch (alt141) {
						case 1 :
							// Parser.g:974:24: id= ident
							{
							pushFollow(FOLLOW_ident_in_alterTableStatement6909);
							id=ident();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.drop(id);  }
							}
							break;
						case 2 :
							// Parser.g:975:18: ( '(' id1= ident ( ',' idn= ident )* ')' )
							{
							// Parser.g:975:18: ( '(' id1= ident ( ',' idn= ident )* ')' )
							// Parser.g:975:19: '(' id1= ident ( ',' idn= ident )* ')'
							{
							match(input,209,FOLLOW_209_in_alterTableStatement6931); if (state.failed) return stmt;
							pushFollow(FOLLOW_ident_in_alterTableStatement6936);
							id1=ident();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.drop(id1); }
							// Parser.g:976:18: ( ',' idn= ident )*
							loop140:
							while (true) {
								int alt140=2;
								int LA140_0 = input.LA(1);
								if ( (LA140_0==213) ) {
									alt140=1;
								}

								switch (alt140) {
								case 1 :
									// Parser.g:976:20: ',' idn= ident
									{
									match(input,213,FOLLOW_213_in_alterTableStatement6959); if (state.failed) return stmt;
									pushFollow(FOLLOW_ident_in_alterTableStatement6963);
									idn=ident();
									state._fsp--;
									if (state.failed) return stmt;
									if ( state.backtracking==0 ) { stmt.drop(idn); }
									}
									break;

								default :
									break loop140;
								}
							}

							match(input,210,FOLLOW_210_in_alterTableStatement6970); if (state.failed) return stmt;
							}

							}
							break;

					}

					// Parser.g:977:16: ( K_USING K_TIMESTAMP t= INTEGER )?
					int alt142=2;
					int LA142_0 = input.LA(1);
					if ( (LA142_0==K_USING) ) {
						alt142=1;
					}
					switch (alt142) {
						case 1 :
							// Parser.g:977:18: K_USING K_TIMESTAMP t= INTEGER
							{
							match(input,K_USING,FOLLOW_K_USING_in_alterTableStatement6992); if (state.failed) return stmt;
							match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_alterTableStatement6994); if (state.failed) return stmt;
							t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_alterTableStatement6998); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.timestamp(Long.parseLong(Constants.Literal.integer((t!=null?t.getText():null)).getText())); }
							}
							break;

					}

					}
					break;
				case 5 :
					// Parser.g:979:9: K_RENAME ( K_IF K_EXISTS )? (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* )
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement7014); if (state.failed) return stmt;
					// Parser.g:979:18: ( K_IF K_EXISTS )?
					int alt143=2;
					int LA143_0 = input.LA(1);
					if ( (LA143_0==K_IF) ) {
						alt143=1;
					}
					switch (alt143) {
						case 1 :
							// Parser.g:979:20: K_IF K_EXISTS
							{
							match(input,K_IF,FOLLOW_K_IF_in_alterTableStatement7018); if (state.failed) return stmt;
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTableStatement7020); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.ifColumnExists(true); }
							}
							break;

					}

					// Parser.g:980:16: (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* )
					// Parser.g:980:25: id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )*
					{
					pushFollow(FOLLOW_ident_in_alterTableStatement7053);
					id1=ident();
					state._fsp--;
					if (state.failed) return stmt;
					match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement7055); if (state.failed) return stmt;
					pushFollow(FOLLOW_ident_in_alterTableStatement7059);
					toId1=ident();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.rename(id1, toId1); }
					// Parser.g:981:17: ( K_AND idn= ident K_TO toIdn= ident )*
					loop144:
					while (true) {
						int alt144=2;
						int LA144_0 = input.LA(1);
						if ( (LA144_0==K_AND) ) {
							alt144=1;
						}

						switch (alt144) {
						case 1 :
							// Parser.g:981:19: K_AND idn= ident K_TO toIdn= ident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement7081); if (state.failed) return stmt;
							pushFollow(FOLLOW_ident_in_alterTableStatement7085);
							idn=ident();
							state._fsp--;
							if (state.failed) return stmt;
							match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement7087); if (state.failed) return stmt;
							pushFollow(FOLLOW_ident_in_alterTableStatement7091);
							toIdn=ident();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.rename(idn, toIdn); }
							}
							break;

						default :
							break loop144;
						}
					}

					}

					}
					break;
				case 6 :
					// Parser.g:983:9: K_DROP K_COMPACT K_STORAGE
					{
					match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement7109); if (state.failed) return stmt;
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_alterTableStatement7111); if (state.failed) return stmt;
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_alterTableStatement7113); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.dropCompactStorage(); }
					}
					break;
				case 7 :
					// Parser.g:985:9: K_WITH properties[$stmt.attrs]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement7126); if (state.failed) return stmt;
					pushFollow(FOLLOW_properties_in_alterTableStatement7128);
					properties(stmt.attrs);
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.attrs(); }
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterTableStatement"



	// $ANTLR start "isStaticColumn"
	// Parser.g:989:1: isStaticColumn returns [boolean isStaticColumn] : ( K_STATIC )? ;
	public final boolean isStaticColumn() throws RecognitionException {
		boolean isStaticColumn = false;


		 boolean isStatic = false; 
		try {
			// Parser.g:991:5: ( ( K_STATIC )? )
			// Parser.g:991:7: ( K_STATIC )?
			{
			// Parser.g:991:7: ( K_STATIC )?
			int alt146=2;
			int LA146_0 = input.LA(1);
			if ( (LA146_0==K_STATIC) ) {
				alt146=1;
			}
			switch (alt146) {
				case 1 :
					// Parser.g:991:8: K_STATIC
					{
					match(input,K_STATIC,FOLLOW_K_STATIC_in_isStaticColumn7170); if (state.failed) return isStaticColumn;
					if ( state.backtracking==0 ) { isStatic=true; }
					}
					break;

			}

			if ( state.backtracking==0 ) { isStaticColumn = isStatic; }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return isStaticColumn;
	}
	// $ANTLR end "isStaticColumn"



	// $ANTLR start "alterMaterializedViewStatement"
	// Parser.g:994:1: alterMaterializedViewStatement returns [AlterViewStatement.Raw stmt] : K_ALTER K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? name= columnFamilyName K_WITH properties[attrs] ;
	public final AlterViewStatement.Raw alterMaterializedViewStatement() throws RecognitionException {
		AlterViewStatement.Raw stmt = null;


		QualifiedName name =null;


		        TableAttributes attrs = new TableAttributes();
		        boolean ifExists = false;
		    
		try {
			// Parser.g:999:5: ( K_ALTER K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? name= columnFamilyName K_WITH properties[attrs] )
			// Parser.g:999:7: K_ALTER K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? name= columnFamilyName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterMaterializedViewStatement7206); if (state.failed) return stmt;
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_alterMaterializedViewStatement7208); if (state.failed) return stmt;
			match(input,K_VIEW,FOLLOW_K_VIEW_in_alterMaterializedViewStatement7210); if (state.failed) return stmt;
			// Parser.g:999:37: ( K_IF K_EXISTS )?
			int alt147=2;
			int LA147_0 = input.LA(1);
			if ( (LA147_0==K_IF) ) {
				alt147=1;
			}
			switch (alt147) {
				case 1 :
					// Parser.g:999:38: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_alterMaterializedViewStatement7213); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterMaterializedViewStatement7215); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_alterMaterializedViewStatement7224);
			name=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_WITH,FOLLOW_K_WITH_in_alterMaterializedViewStatement7236); if (state.failed) return stmt;
			pushFollow(FOLLOW_properties_in_alterMaterializedViewStatement7238);
			properties(attrs);
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) {
			        stmt = new AlterViewStatement.Raw(name, attrs, ifExists);
			    }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterMaterializedViewStatement"



	// $ANTLR start "alterTypeStatement"
	// Parser.g:1012:1: alterTypeStatement returns [AlterTypeStatement.Raw stmt] : K_ALTER K_TYPE ( K_IF K_EXISTS )? name= userTypeName ( K_ALTER f= fident K_TYPE v= comparatorType | K_ADD ( K_IF K_NOT K_EXISTS )? f= fident v= comparatorType | K_RENAME ( K_IF K_EXISTS )? f1= fident K_TO toF1= fident ( K_AND fn= fident K_TO toFn= fident )* ) ;
	public final AlterTypeStatement.Raw alterTypeStatement() throws RecognitionException {
		AlterTypeStatement.Raw stmt = null;


		UTName name =null;
		FieldIdentifier f =null;
		CQL3Type.Raw v =null;
		FieldIdentifier f1 =null;
		FieldIdentifier toF1 =null;
		FieldIdentifier fn =null;
		FieldIdentifier toFn =null;


		        boolean ifExists = false;
		    
		try {
			// Parser.g:1016:5: ( K_ALTER K_TYPE ( K_IF K_EXISTS )? name= userTypeName ( K_ALTER f= fident K_TYPE v= comparatorType | K_ADD ( K_IF K_NOT K_EXISTS )? f= fident v= comparatorType | K_RENAME ( K_IF K_EXISTS )? f1= fident K_TO toF1= fident ( K_AND fn= fident K_TO toFn= fident )* ) )
			// Parser.g:1016:7: K_ALTER K_TYPE ( K_IF K_EXISTS )? name= userTypeName ( K_ALTER f= fident K_TYPE v= comparatorType | K_ADD ( K_IF K_NOT K_EXISTS )? f= fident v= comparatorType | K_RENAME ( K_IF K_EXISTS )? f1= fident K_TO toF1= fident ( K_AND fn= fident K_TO toFn= fident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement7278); if (state.failed) return stmt;
			match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement7280); if (state.failed) return stmt;
			// Parser.g:1016:22: ( K_IF K_EXISTS )?
			int alt148=2;
			int LA148_0 = input.LA(1);
			if ( (LA148_0==K_IF) ) {
				alt148=1;
			}
			switch (alt148) {
				case 1 :
					// Parser.g:1016:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_alterTypeStatement7283); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTypeStatement7285); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_alterTypeStatement7294);
			name=userTypeName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new AlterTypeStatement.Raw(name, ifExists); }
			// Parser.g:1017:7: ( K_ALTER f= fident K_TYPE v= comparatorType | K_ADD ( K_IF K_NOT K_EXISTS )? f= fident v= comparatorType | K_RENAME ( K_IF K_EXISTS )? f1= fident K_TO toF1= fident ( K_AND fn= fident K_TO toFn= fident )* )
			int alt152=3;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt152=1;
				}
				break;
			case K_ADD:
				{
				alt152=2;
				}
				break;
			case K_RENAME:
				{
				alt152=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return stmt;}
				NoViableAltException nvae =
					new NoViableAltException("", 152, 0, input);
				throw nvae;
			}
			switch (alt152) {
				case 1 :
					// Parser.g:1018:9: K_ALTER f= fident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement7314); if (state.failed) return stmt;
					pushFollow(FOLLOW_fident_in_alterTypeStatement7320);
					f=fident();
					state._fsp--;
					if (state.failed) return stmt;
					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement7322); if (state.failed) return stmt;
					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement7326);
					v=comparatorType();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.alter(f, v); }
					}
					break;
				case 2 :
					// Parser.g:1020:9: K_ADD ( K_IF K_NOT K_EXISTS )? f= fident v= comparatorType
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTypeStatement7339); if (state.failed) return stmt;
					// Parser.g:1020:15: ( K_IF K_NOT K_EXISTS )?
					int alt149=2;
					int LA149_0 = input.LA(1);
					if ( (LA149_0==K_IF) ) {
						alt149=1;
					}
					switch (alt149) {
						case 1 :
							// Parser.g:1020:16: K_IF K_NOT K_EXISTS
							{
							match(input,K_IF,FOLLOW_K_IF_in_alterTypeStatement7342); if (state.failed) return stmt;
							match(input,K_NOT,FOLLOW_K_NOT_in_alterTypeStatement7344); if (state.failed) return stmt;
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTypeStatement7346); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.ifFieldNotExists(true); }
							}
							break;

					}

					pushFollow(FOLLOW_fident_in_alterTypeStatement7359);
					f=fident();
					state._fsp--;
					if (state.failed) return stmt;
					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement7363);
					v=comparatorType();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.add(f, v); }
					}
					break;
				case 3 :
					// Parser.g:1022:9: K_RENAME ( K_IF K_EXISTS )? f1= fident K_TO toF1= fident ( K_AND fn= fident K_TO toFn= fident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTypeStatement7383); if (state.failed) return stmt;
					// Parser.g:1022:18: ( K_IF K_EXISTS )?
					int alt150=2;
					int LA150_0 = input.LA(1);
					if ( (LA150_0==K_IF) ) {
						alt150=1;
					}
					switch (alt150) {
						case 1 :
							// Parser.g:1022:19: K_IF K_EXISTS
							{
							match(input,K_IF,FOLLOW_K_IF_in_alterTypeStatement7386); if (state.failed) return stmt;
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterTypeStatement7388); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.ifFieldExists(true); }
							}
							break;

					}

					pushFollow(FOLLOW_fident_in_alterTypeStatement7397);
					f1=fident();
					state._fsp--;
					if (state.failed) return stmt;
					match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement7399); if (state.failed) return stmt;
					pushFollow(FOLLOW_fident_in_alterTypeStatement7403);
					toF1=fident();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.rename(f1, toF1); }
					// Parser.g:1023:10: ( K_AND fn= fident K_TO toFn= fident )*
					loop151:
					while (true) {
						int alt151=2;
						int LA151_0 = input.LA(1);
						if ( (LA151_0==K_AND) ) {
							alt151=1;
						}

						switch (alt151) {
						case 1 :
							// Parser.g:1023:12: K_AND fn= fident K_TO toFn= fident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTypeStatement7425); if (state.failed) return stmt;
							pushFollow(FOLLOW_fident_in_alterTypeStatement7429);
							fn=fident();
							state._fsp--;
							if (state.failed) return stmt;
							match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement7431); if (state.failed) return stmt;
							pushFollow(FOLLOW_fident_in_alterTypeStatement7435);
							toFn=fident();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { stmt.rename(fn, toFn); }
							}
							break;

						default :
							break loop151;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterTypeStatement"



	// $ANTLR start "dropKeyspaceStatement"
	// Parser.g:1030:1: dropKeyspaceStatement returns [DropKeyspaceStatement.Raw stmt] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
	public final DropKeyspaceStatement.Raw dropKeyspaceStatement() throws RecognitionException {
		DropKeyspaceStatement.Raw stmt = null;


		String ks =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:1032:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
			// Parser.g:1032:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement7487); if (state.failed) return stmt;
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement7489); if (state.failed) return stmt;
			// Parser.g:1032:25: ( K_IF K_EXISTS )?
			int alt153=2;
			int LA153_0 = input.LA(1);
			if ( (LA153_0==K_IF) ) {
				alt153=1;
			}
			switch (alt153) {
				case 1 :
					// Parser.g:1032:26: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement7492); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement7494); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement7503);
			ks=keyspaceName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropKeyspaceStatement.Raw(ks, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropKeyspaceStatement"



	// $ANTLR start "dropTableStatement"
	// Parser.g:1038:1: dropTableStatement returns [DropTableStatement.Raw stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? name= columnFamilyName ;
	public final DropTableStatement.Raw dropTableStatement() throws RecognitionException {
		DropTableStatement.Raw stmt = null;


		QualifiedName name =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:1040:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? name= columnFamilyName )
			// Parser.g:1040:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? name= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement7537); if (state.failed) return stmt;
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement7539); if (state.failed) return stmt;
			// Parser.g:1040:29: ( K_IF K_EXISTS )?
			int alt154=2;
			int LA154_0 = input.LA(1);
			if ( (LA154_0==K_IF) ) {
				alt154=1;
			}
			switch (alt154) {
				case 1 :
					// Parser.g:1040:30: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement7542); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement7544); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement7553);
			name=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropTableStatement.Raw(name, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTableStatement"



	// $ANTLR start "dropTypeStatement"
	// Parser.g:1046:1: dropTypeStatement returns [DropTypeStatement.Raw stmt] : K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName ;
	public final DropTypeStatement.Raw dropTypeStatement() throws RecognitionException {
		DropTypeStatement.Raw stmt = null;


		UTName name =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:1048:5: ( K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName )
			// Parser.g:1048:7: K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTypeStatement7587); if (state.failed) return stmt;
			match(input,K_TYPE,FOLLOW_K_TYPE_in_dropTypeStatement7589); if (state.failed) return stmt;
			// Parser.g:1048:21: ( K_IF K_EXISTS )?
			int alt155=2;
			int LA155_0 = input.LA(1);
			if ( (LA155_0==K_IF) ) {
				alt155=1;
			}
			switch (alt155) {
				case 1 :
					// Parser.g:1048:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTypeStatement7592); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTypeStatement7594); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_dropTypeStatement7603);
			name=userTypeName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropTypeStatement.Raw(name, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTypeStatement"



	// $ANTLR start "dropIndexStatement"
	// Parser.g:1054:1: dropIndexStatement returns [DropIndexStatement.Raw stmt] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName ;
	public final DropIndexStatement.Raw dropIndexStatement() throws RecognitionException {
		DropIndexStatement.Raw stmt = null;


		QualifiedName index =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:1056:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName )
			// Parser.g:1056:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement7637); if (state.failed) return stmt;
			match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement7639); if (state.failed) return stmt;
			// Parser.g:1056:22: ( K_IF K_EXISTS )?
			int alt156=2;
			int LA156_0 = input.LA(1);
			if ( (LA156_0==K_IF) ) {
				alt156=1;
			}
			switch (alt156) {
				case 1 :
					// Parser.g:1056:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement7642); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement7644); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_indexName_in_dropIndexStatement7653);
			index=indexName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropIndexStatement.Raw(index, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropIndexStatement"



	// $ANTLR start "dropMaterializedViewStatement"
	// Parser.g:1063:1: dropMaterializedViewStatement returns [DropViewStatement.Raw stmt] : K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropViewStatement.Raw dropMaterializedViewStatement() throws RecognitionException {
		DropViewStatement.Raw stmt = null;


		QualifiedName cf =null;

		 boolean ifExists = false; 
		try {
			// Parser.g:1065:5: ( K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName )
			// Parser.g:1065:7: K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropMaterializedViewStatement7693); if (state.failed) return stmt;
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_dropMaterializedViewStatement7695); if (state.failed) return stmt;
			match(input,K_VIEW,FOLLOW_K_VIEW_in_dropMaterializedViewStatement7697); if (state.failed) return stmt;
			// Parser.g:1065:36: ( K_IF K_EXISTS )?
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==K_IF) ) {
				alt157=1;
			}
			switch (alt157) {
				case 1 :
					// Parser.g:1065:37: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropMaterializedViewStatement7700); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropMaterializedViewStatement7702); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropMaterializedViewStatement7711);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropViewStatement.Raw(cf, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropMaterializedViewStatement"



	// $ANTLR start "truncateStatement"
	// Parser.g:1072:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE ( K_COLUMNFAMILY )? cf= columnFamilyName ;
	public final TruncateStatement truncateStatement() throws RecognitionException {
		TruncateStatement stmt = null;


		QualifiedName cf =null;

		try {
			// Parser.g:1073:5: ( K_TRUNCATE ( K_COLUMNFAMILY )? cf= columnFamilyName )
			// Parser.g:1073:7: K_TRUNCATE ( K_COLUMNFAMILY )? cf= columnFamilyName
			{
			match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement7742); if (state.failed) return stmt;
			// Parser.g:1073:18: ( K_COLUMNFAMILY )?
			int alt158=2;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==K_COLUMNFAMILY) ) {
				alt158=1;
			}
			switch (alt158) {
				case 1 :
					// Parser.g:1073:19: K_COLUMNFAMILY
					{
					match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_truncateStatement7745); if (state.failed) return stmt;
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_truncateStatement7751);
			cf=columnFamilyName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new TruncateStatement(cf); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "truncateStatement"



	// $ANTLR start "grantPermissionsStatement"
	// Parser.g:1079:1: grantPermissionsStatement returns [GrantPermissionsStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName ;
	public final GrantPermissionsStatement grantPermissionsStatement() throws RecognitionException {
		GrantPermissionsStatement stmt = null;


		RoleName grantee =null;
		Set<Permission> permissionOrAll1 =null;
		IResource resource2 =null;

		try {
			// Parser.g:1080:5: ( K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName )
			// Parser.g:1080:7: K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantPermissionsStatement7776); if (state.failed) return stmt;
			pushFollow(FOLLOW_permissionOrAll_in_grantPermissionsStatement7788);
			permissionOrAll1=permissionOrAll();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_ON,FOLLOW_K_ON_in_grantPermissionsStatement7796); if (state.failed) return stmt;
			pushFollow(FOLLOW_resource_in_grantPermissionsStatement7808);
			resource2=resource();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_TO,FOLLOW_K_TO_in_grantPermissionsStatement7816); if (state.failed) return stmt;
			pushFollow(FOLLOW_userOrRoleName_in_grantPermissionsStatement7830);
			grantee=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new GrantPermissionsStatement(filterPermissions(permissionOrAll1, resource2), resource2, grantee); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantPermissionsStatement"



	// $ANTLR start "revokePermissionsStatement"
	// Parser.g:1092:1: revokePermissionsStatement returns [RevokePermissionsStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName ;
	public final RevokePermissionsStatement revokePermissionsStatement() throws RecognitionException {
		RevokePermissionsStatement stmt = null;


		RoleName revokee =null;
		Set<Permission> permissionOrAll3 =null;
		IResource resource4 =null;

		try {
			// Parser.g:1093:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName )
			// Parser.g:1093:7: K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokePermissionsStatement7861); if (state.failed) return stmt;
			pushFollow(FOLLOW_permissionOrAll_in_revokePermissionsStatement7873);
			permissionOrAll3=permissionOrAll();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_ON,FOLLOW_K_ON_in_revokePermissionsStatement7881); if (state.failed) return stmt;
			pushFollow(FOLLOW_resource_in_revokePermissionsStatement7893);
			resource4=resource();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_FROM,FOLLOW_K_FROM_in_revokePermissionsStatement7901); if (state.failed) return stmt;
			pushFollow(FOLLOW_userOrRoleName_in_revokePermissionsStatement7915);
			revokee=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new RevokePermissionsStatement(filterPermissions(permissionOrAll3, resource4), resource4, revokee); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokePermissionsStatement"



	// $ANTLR start "grantRoleStatement"
	// Parser.g:1105:1: grantRoleStatement returns [GrantRoleStatement stmt] : K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName ;
	public final GrantRoleStatement grantRoleStatement() throws RecognitionException {
		GrantRoleStatement stmt = null;


		RoleName role =null;
		RoleName grantee =null;

		try {
			// Parser.g:1106:5: ( K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName )
			// Parser.g:1106:7: K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantRoleStatement7946); if (state.failed) return stmt;
			pushFollow(FOLLOW_userOrRoleName_in_grantRoleStatement7960);
			role=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_TO,FOLLOW_K_TO_in_grantRoleStatement7968); if (state.failed) return stmt;
			pushFollow(FOLLOW_userOrRoleName_in_grantRoleStatement7982);
			grantee=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new GrantRoleStatement(role, grantee); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantRoleStatement"



	// $ANTLR start "revokeRoleStatement"
	// Parser.g:1116:1: revokeRoleStatement returns [RevokeRoleStatement stmt] : K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName ;
	public final RevokeRoleStatement revokeRoleStatement() throws RecognitionException {
		RevokeRoleStatement stmt = null;


		RoleName role =null;
		RoleName revokee =null;

		try {
			// Parser.g:1117:5: ( K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName )
			// Parser.g:1117:7: K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeRoleStatement8013); if (state.failed) return stmt;
			pushFollow(FOLLOW_userOrRoleName_in_revokeRoleStatement8027);
			role=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			match(input,K_FROM,FOLLOW_K_FROM_in_revokeRoleStatement8035); if (state.failed) return stmt;
			pushFollow(FOLLOW_userOrRoleName_in_revokeRoleStatement8049);
			revokee=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new RevokeRoleStatement(role, revokee); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokeRoleStatement"



	// $ANTLR start "listPermissionsStatement"
	// Parser.g:1124:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? ;
	public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
		ListPermissionsStatement stmt = null;


		IResource resource5 =null;
		Set<Permission> permissionOrAll6 =null;


		        IResource resource = null;
		        boolean recursive = true;
		        RoleName grantee = new RoleName();
		    
		try {
			// Parser.g:1130:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? )
			// Parser.g:1130:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement8087); if (state.failed) return stmt;
			pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement8099);
			permissionOrAll6=permissionOrAll();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:1132:7: ( K_ON resource )?
			int alt159=2;
			int LA159_0 = input.LA(1);
			if ( (LA159_0==K_ON) ) {
				alt159=1;
			}
			switch (alt159) {
				case 1 :
					// Parser.g:1132:9: K_ON resource
					{
					match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement8109); if (state.failed) return stmt;
					pushFollow(FOLLOW_resource_in_listPermissionsStatement8111);
					resource5=resource();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { resource = resource5; }
					}
					break;

			}

			// Parser.g:1133:7: ( K_OF roleName[grantee] )?
			int alt160=2;
			int LA160_0 = input.LA(1);
			if ( (LA160_0==K_OF) ) {
				alt160=1;
			}
			switch (alt160) {
				case 1 :
					// Parser.g:1133:9: K_OF roleName[grantee]
					{
					match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement8126); if (state.failed) return stmt;
					pushFollow(FOLLOW_roleName_in_listPermissionsStatement8128);
					roleName(grantee);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			// Parser.g:1134:7: ( K_NORECURSIVE )?
			int alt161=2;
			int LA161_0 = input.LA(1);
			if ( (LA161_0==K_NORECURSIVE) ) {
				alt161=1;
			}
			switch (alt161) {
				case 1 :
					// Parser.g:1134:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement8142); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { recursive = false; }
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt = new ListPermissionsStatement(permissionOrAll6, resource, grantee, recursive); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listPermissionsStatement"



	// $ANTLR start "permission"
	// Parser.g:1138:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE | K_UNMASK | K_SELECT_MASKED ) ;
	public final Permission permission() throws RecognitionException {
		Permission perm = null;


		Token p=null;

		try {
			// Parser.g:1139:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE | K_UNMASK | K_SELECT_MASKED ) )
			// Parser.g:1139:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE | K_UNMASK | K_SELECT_MASKED )
			{
			p=input.LT(1);
			if ( input.LA(1)==K_ALTER||input.LA(1)==K_AUTHORIZE||input.LA(1)==K_CREATE||input.LA(1)==K_DESCRIBE||input.LA(1)==K_DROP||input.LA(1)==K_EXECUTE||input.LA(1)==K_MODIFY||(input.LA(1) >= K_SELECT && input.LA(1) <= K_SELECT_MASKED)||input.LA(1)==K_UNMASK ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return perm;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			if ( state.backtracking==0 ) { perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perm;
	}
	// $ANTLR end "permission"



	// $ANTLR start "permissionOrAll"
	// Parser.g:1143:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? ( ',' p= permission ( K_PERMISSION )? )* );
	public final Set<Permission> permissionOrAll() throws RecognitionException {
		Set<Permission> perms = null;


		Permission p =null;

		try {
			// Parser.g:1144:5: ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? ( ',' p= permission ( K_PERMISSION )? )* )
			int alt166=2;
			int LA166_0 = input.LA(1);
			if ( (LA166_0==K_ALL) ) {
				alt166=1;
			}
			else if ( (LA166_0==K_ALTER||LA166_0==K_AUTHORIZE||LA166_0==K_CREATE||LA166_0==K_DESCRIBE||LA166_0==K_DROP||LA166_0==K_EXECUTE||LA166_0==K_MODIFY||(LA166_0 >= K_SELECT && LA166_0 <= K_SELECT_MASKED)||LA166_0==K_UNMASK) ) {
				alt166=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return perms;}
				NoViableAltException nvae =
					new NoViableAltException("", 166, 0, input);
				throw nvae;
			}

			switch (alt166) {
				case 1 :
					// Parser.g:1144:7: K_ALL ( K_PERMISSIONS )?
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll8243); if (state.failed) return perms;
					// Parser.g:1144:13: ( K_PERMISSIONS )?
					int alt162=2;
					int LA162_0 = input.LA(1);
					if ( (LA162_0==K_PERMISSIONS) ) {
						alt162=1;
					}
					switch (alt162) {
						case 1 :
							// Parser.g:1144:15: K_PERMISSIONS
							{
							match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll8247); if (state.failed) return perms;
							}
							break;

					}

					if ( state.backtracking==0 ) { perms = Permission.ALL; }
					}
					break;
				case 2 :
					// Parser.g:1145:7: p= permission ( K_PERMISSION )? ( ',' p= permission ( K_PERMISSION )? )*
					{
					pushFollow(FOLLOW_permission_in_permissionOrAll8268);
					p=permission();
					state._fsp--;
					if (state.failed) return perms;
					// Parser.g:1145:20: ( K_PERMISSION )?
					int alt163=2;
					int LA163_0 = input.LA(1);
					if ( (LA163_0==K_PERMISSION) ) {
						alt163=1;
					}
					switch (alt163) {
						case 1 :
							// Parser.g:1145:22: K_PERMISSION
							{
							match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll8272); if (state.failed) return perms;
							}
							break;

					}

					if ( state.backtracking==0 ) { perms = EnumSet.of(p); }
					// Parser.g:1145:72: ( ',' p= permission ( K_PERMISSION )? )*
					loop165:
					while (true) {
						int alt165=2;
						int LA165_0 = input.LA(1);
						if ( (LA165_0==213) ) {
							alt165=1;
						}

						switch (alt165) {
						case 1 :
							// Parser.g:1145:74: ',' p= permission ( K_PERMISSION )?
							{
							match(input,213,FOLLOW_213_in_permissionOrAll8281); if (state.failed) return perms;
							pushFollow(FOLLOW_permission_in_permissionOrAll8285);
							p=permission();
							state._fsp--;
							if (state.failed) return perms;
							// Parser.g:1145:91: ( K_PERMISSION )?
							int alt164=2;
							int LA164_0 = input.LA(1);
							if ( (LA164_0==K_PERMISSION) ) {
								alt164=1;
							}
							switch (alt164) {
								case 1 :
									// Parser.g:1145:93: K_PERMISSION
									{
									match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll8289); if (state.failed) return perms;
									}
									break;

							}

							if ( state.backtracking==0 ) { perms.add(p); }
							}
							break;

						default :
							break loop165;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perms;
	}
	// $ANTLR end "permissionOrAll"



	// $ANTLR start "resource"
	// Parser.g:1148:1: resource returns [IResource res] : (d= dataResource |r= roleResource |f= functionResource |j= jmxResource );
	public final IResource resource() throws RecognitionException {
		IResource res = null;


		DataResource d =null;
		RoleResource r =null;
		FunctionResource f =null;
		JMXResource j =null;

		try {
			// Parser.g:1149:5: (d= dataResource |r= roleResource |f= functionResource |j= jmxResource )
			int alt167=4;
			alt167 = dfa167.predict(input);
			switch (alt167) {
				case 1 :
					// Parser.g:1149:7: d= dataResource
					{
					pushFollow(FOLLOW_dataResource_in_resource8320);
					d=dataResource();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = d; }
					}
					break;
				case 2 :
					// Parser.g:1150:7: r= roleResource
					{
					pushFollow(FOLLOW_roleResource_in_resource8332);
					r=roleResource();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = r; }
					}
					break;
				case 3 :
					// Parser.g:1151:7: f= functionResource
					{
					pushFollow(FOLLOW_functionResource_in_resource8344);
					f=functionResource();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = f; }
					}
					break;
				case 4 :
					// Parser.g:1152:7: j= jmxResource
					{
					pushFollow(FOLLOW_jmxResource_in_resource8356);
					j=jmxResource();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = j; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "resource"



	// $ANTLR start "dataResource"
	// Parser.g:1155:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName | K_ALL K_TABLES K_IN K_KEYSPACE ks= keyspaceName );
	public final DataResource dataResource() throws RecognitionException {
		DataResource res = null;


		String ks =null;
		QualifiedName cf =null;

		try {
			// Parser.g:1156:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName | K_ALL K_TABLES K_IN K_KEYSPACE ks= keyspaceName )
			int alt169=4;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				switch ( input.LA(2) ) {
				case K_KEYSPACES:
					{
					alt169=1;
					}
					break;
				case K_TABLES:
					{
					alt169=4;
					}
					break;
				case EOF:
				case K_FROM:
				case K_NORECURSIVE:
				case K_OF:
				case K_TO:
				case 216:
				case 219:
					{
					alt169=3;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return res;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 169, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_KEYSPACE:
				{
				alt169=2;
				}
				break;
			case IDENT:
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
			case QMARK:
			case QUOTED_NAME:
				{
				alt169=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return res;}
				NoViableAltException nvae =
					new NoViableAltException("", 169, 0, input);
				throw nvae;
			}
			switch (alt169) {
				case 1 :
					// Parser.g:1156:7: K_ALL K_KEYSPACES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_dataResource8379); if (state.failed) return res;
					match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource8381); if (state.failed) return res;
					if ( state.backtracking==0 ) { res = DataResource.root(); }
					}
					break;
				case 2 :
					// Parser.g:1157:7: K_KEYSPACE ks= keyspaceName
					{
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource8391); if (state.failed) return res;
					pushFollow(FOLLOW_keyspaceName_in_dataResource8397);
					ks=keyspaceName();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = DataResource.keyspace(ks); }
					}
					break;
				case 3 :
					// Parser.g:1158:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
					{
					// Parser.g:1158:7: ( K_COLUMNFAMILY )?
					int alt168=2;
					int LA168_0 = input.LA(1);
					if ( (LA168_0==K_COLUMNFAMILY) ) {
						alt168=1;
					}
					switch (alt168) {
						case 1 :
							// Parser.g:1158:9: K_COLUMNFAMILY
							{
							match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource8409); if (state.failed) return res;
							}
							break;

					}

					pushFollow(FOLLOW_columnFamilyName_in_dataResource8418);
					cf=columnFamilyName();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = DataResource.table(cf.getKeyspace(), cf.getName()); }
					}
					break;
				case 4 :
					// Parser.g:1159:7: K_ALL K_TABLES K_IN K_KEYSPACE ks= keyspaceName
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_dataResource8428); if (state.failed) return res;
					match(input,K_TABLES,FOLLOW_K_TABLES_in_dataResource8430); if (state.failed) return res;
					match(input,K_IN,FOLLOW_K_IN_in_dataResource8432); if (state.failed) return res;
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource8434); if (state.failed) return res;
					pushFollow(FOLLOW_keyspaceName_in_dataResource8440);
					ks=keyspaceName();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = DataResource.allTables(ks); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "dataResource"



	// $ANTLR start "jmxResource"
	// Parser.g:1162:1: jmxResource returns [JMXResource res] : ( K_ALL K_MBEANS | K_MBEAN mbean | K_MBEANS mbean );
	public final JMXResource jmxResource() throws RecognitionException {
		JMXResource res = null;


		ParserRuleReturnScope mbean7 =null;
		ParserRuleReturnScope mbean8 =null;

		try {
			// Parser.g:1163:5: ( K_ALL K_MBEANS | K_MBEAN mbean | K_MBEANS mbean )
			int alt170=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				alt170=1;
				}
				break;
			case K_MBEAN:
				{
				alt170=2;
				}
				break;
			case K_MBEANS:
				{
				alt170=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return res;}
				NoViableAltException nvae =
					new NoViableAltException("", 170, 0, input);
				throw nvae;
			}
			switch (alt170) {
				case 1 :
					// Parser.g:1163:7: K_ALL K_MBEANS
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_jmxResource8463); if (state.failed) return res;
					match(input,K_MBEANS,FOLLOW_K_MBEANS_in_jmxResource8465); if (state.failed) return res;
					if ( state.backtracking==0 ) { res = JMXResource.root(); }
					}
					break;
				case 2 :
					// Parser.g:1166:7: K_MBEAN mbean
					{
					match(input,K_MBEAN,FOLLOW_K_MBEAN_in_jmxResource8485); if (state.failed) return res;
					pushFollow(FOLLOW_mbean_in_jmxResource8487);
					mbean7=mbean();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = JMXResource.mbean(canonicalizeObjectName((mbean7!=null?input.toString(mbean7.start,mbean7.stop):null), false)); }
					}
					break;
				case 3 :
					// Parser.g:1167:7: K_MBEANS mbean
					{
					match(input,K_MBEANS,FOLLOW_K_MBEANS_in_jmxResource8497); if (state.failed) return res;
					pushFollow(FOLLOW_mbean_in_jmxResource8499);
					mbean8=mbean();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = JMXResource.mbean(canonicalizeObjectName((mbean8!=null?input.toString(mbean8.start,mbean8.stop):null), true)); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "jmxResource"



	// $ANTLR start "roleResource"
	// Parser.g:1170:1: roleResource returns [RoleResource res] : ( K_ALL K_ROLES | K_ROLE role= userOrRoleName );
	public final RoleResource roleResource() throws RecognitionException {
		RoleResource res = null;


		RoleName role =null;

		try {
			// Parser.g:1171:5: ( K_ALL K_ROLES | K_ROLE role= userOrRoleName )
			int alt171=2;
			int LA171_0 = input.LA(1);
			if ( (LA171_0==K_ALL) ) {
				alt171=1;
			}
			else if ( (LA171_0==K_ROLE) ) {
				alt171=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return res;}
				NoViableAltException nvae =
					new NoViableAltException("", 171, 0, input);
				throw nvae;
			}

			switch (alt171) {
				case 1 :
					// Parser.g:1171:7: K_ALL K_ROLES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_roleResource8522); if (state.failed) return res;
					match(input,K_ROLES,FOLLOW_K_ROLES_in_roleResource8524); if (state.failed) return res;
					if ( state.backtracking==0 ) { res = RoleResource.root(); }
					}
					break;
				case 2 :
					// Parser.g:1172:7: K_ROLE role= userOrRoleName
					{
					match(input,K_ROLE,FOLLOW_K_ROLE_in_roleResource8534); if (state.failed) return res;
					pushFollow(FOLLOW_userOrRoleName_in_roleResource8540);
					role=userOrRoleName();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = RoleResource.role(role.getName()); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "roleResource"



	// $ANTLR start "functionResource"
	// Parser.g:1175:1: functionResource returns [FunctionResource res] : ( K_ALL K_FUNCTIONS | K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName | K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' ) );
	public final FunctionResource functionResource() throws RecognitionException {
		FunctionResource res = null;


		String ks =null;
		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		    
		try {
			// Parser.g:1179:5: ( K_ALL K_FUNCTIONS | K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName | K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' ) )
			int alt174=3;
			int LA174_0 = input.LA(1);
			if ( (LA174_0==K_ALL) ) {
				int LA174_1 = input.LA(2);
				if ( (LA174_1==K_FUNCTIONS) ) {
					int LA174_3 = input.LA(3);
					if ( (LA174_3==K_IN) ) {
						alt174=2;
					}
					else if ( (LA174_3==EOF||LA174_3==K_FROM||LA174_3==K_NORECURSIVE||LA174_3==K_OF||LA174_3==K_TO||LA174_3==219) ) {
						alt174=1;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return res;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 174, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return res;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 174, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA174_0==K_FUNCTION) ) {
				alt174=3;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return res;}
				NoViableAltException nvae =
					new NoViableAltException("", 174, 0, input);
				throw nvae;
			}

			switch (alt174) {
				case 1 :
					// Parser.g:1179:7: K_ALL K_FUNCTIONS
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_functionResource8572); if (state.failed) return res;
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_functionResource8574); if (state.failed) return res;
					if ( state.backtracking==0 ) { res = FunctionResource.root(); }
					}
					break;
				case 2 :
					// Parser.g:1180:7: K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_functionResource8584); if (state.failed) return res;
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_functionResource8586); if (state.failed) return res;
					match(input,K_IN,FOLLOW_K_IN_in_functionResource8588); if (state.failed) return res;
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_functionResource8590); if (state.failed) return res;
					pushFollow(FOLLOW_keyspaceName_in_functionResource8596);
					ks=keyspaceName();
					state._fsp--;
					if (state.failed) return res;
					if ( state.backtracking==0 ) { res = FunctionResource.keyspace(ks); }
					}
					break;
				case 3 :
					// Parser.g:1182:7: K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )
					{
					match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_functionResource8611); if (state.failed) return res;
					pushFollow(FOLLOW_functionName_in_functionResource8615);
					fn=functionName();
					state._fsp--;
					if (state.failed) return res;
					// Parser.g:1183:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )
					// Parser.g:1184:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,209,FOLLOW_209_in_functionResource8633); if (state.failed) return res;
					// Parser.g:1185:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt173=2;
					int LA173_0 = input.LA(1);
					if ( (LA173_0==IDENT||LA173_0==K_ACCESS||(LA173_0 >= K_AGGREGATE && LA173_0 <= K_ALL)||LA173_0==K_ANN||LA173_0==K_AS||LA173_0==K_ASCII||(LA173_0 >= K_BIGINT && LA173_0 <= K_BOOLEAN)||(LA173_0 >= K_CALLED && LA173_0 <= K_CLUSTERING)||(LA173_0 >= K_COMPACT && LA173_0 <= K_COUNTER)||(LA173_0 >= K_CUSTOM && LA173_0 <= K_DEFAULT)||(LA173_0 >= K_DISTINCT && LA173_0 <= K_DOUBLE)||LA173_0==K_DURATION||(LA173_0 >= K_EXISTS && LA173_0 <= K_FLOAT)||LA173_0==K_FROZEN||(LA173_0 >= K_FUNCTION && LA173_0 <= K_FUNCTIONS)||(LA173_0 >= K_GROUP && LA173_0 <= K_IDENTITY)||(LA173_0 >= K_INET && LA173_0 <= K_INPUT)||(LA173_0 >= K_INT && LA173_0 <= K_INTERNALS)||(LA173_0 >= K_JSON && LA173_0 <= K_KEYS)||(LA173_0 >= K_KEYSPACES && LA173_0 <= K_LIKE)||(LA173_0 >= K_LIST && LA173_0 <= K_MASKED)||(LA173_0 >= K_MAXWRITETIME && LA173_0 <= K_MBEANS)||LA173_0==K_NOLOGIN||LA173_0==K_NOSUPERUSER||(LA173_0 >= K_ONLY && LA173_0 <= K_OPTIONS)||(LA173_0 >= K_PARTITION && LA173_0 <= K_PERMISSIONS)||(LA173_0 >= K_REPLACE && LA173_0 <= K_RETURNS)||(LA173_0 >= K_ROLE && LA173_0 <= K_ROLES)||(LA173_0 >= K_SELECT_MASKED && LA173_0 <= K_TINYINT)||LA173_0==K_TRIGGER||(LA173_0 >= K_TTL && LA173_0 <= K_TYPES)||(LA173_0 >= K_UNMASK && LA173_0 <= K_UNSET)||(LA173_0 >= K_USER && LA173_0 <= K_USERS)||(LA173_0 >= K_UUID && LA173_0 <= K_VECTOR)||LA173_0==K_WRITETIME||LA173_0==QUOTED_NAME||LA173_0==STRING_LITERAL) ) {
						alt173=1;
					}
					switch (alt173) {
						case 1 :
							// Parser.g:1186:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_functionResource8661);
							v=comparatorType();
							state._fsp--;
							if (state.failed) return res;
							if ( state.backtracking==0 ) { argsTypes.add(v); }
							// Parser.g:1187:13: ( ',' v= comparatorType )*
							loop172:
							while (true) {
								int alt172=2;
								int LA172_0 = input.LA(1);
								if ( (LA172_0==213) ) {
									alt172=1;
								}

								switch (alt172) {
								case 1 :
									// Parser.g:1187:15: ',' v= comparatorType
									{
									match(input,213,FOLLOW_213_in_functionResource8679); if (state.failed) return res;
									pushFollow(FOLLOW_comparatorType_in_functionResource8683);
									v=comparatorType();
									state._fsp--;
									if (state.failed) return res;
									if ( state.backtracking==0 ) { argsTypes.add(v); }
									}
									break;

								default :
									break loop172;
								}
							}

							}
							break;

					}

					match(input,210,FOLLOW_210_in_functionResource8711); if (state.failed) return res;
					}

					if ( state.backtracking==0 ) { res = FunctionResource.functionFromCql(fn.keyspace, fn.name, argsTypes); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "functionResource"



	// $ANTLR start "createUserStatement"
	// Parser.g:1197:1: createUserStatement returns [CreateRoleStatement stmt] : K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final CreateRoleStatement createUserStatement() throws RecognitionException {
		CreateRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        RoleOptions opts = new RoleOptions();
		        opts.setOption(IRoleManager.Option.LOGIN, true);
		        boolean superuser = false;
		        boolean ifNotExists = false;
		        RoleName name = new RoleName();
		    
		try {
			// Parser.g:1205:5: ( K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// Parser.g:1205:7: K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement8759); if (state.failed) return stmt;
			match(input,K_USER,FOLLOW_K_USER_in_createUserStatement8761); if (state.failed) return stmt;
			// Parser.g:1205:23: ( K_IF K_NOT K_EXISTS )?
			int alt175=2;
			int LA175_0 = input.LA(1);
			if ( (LA175_0==K_IF) ) {
				alt175=1;
			}
			switch (alt175) {
				case 1 :
					// Parser.g:1205:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createUserStatement8764); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createUserStatement8766); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createUserStatement8768); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_username_in_createUserStatement8776);
			u=username();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { name.setName((u!=null?input.toString(u.start,u.stop):null), true); }
			// Parser.g:1206:7: ( K_WITH userPassword[opts] )?
			int alt176=2;
			int LA176_0 = input.LA(1);
			if ( (LA176_0==K_WITH) ) {
				alt176=1;
			}
			switch (alt176) {
				case 1 :
					// Parser.g:1206:9: K_WITH userPassword[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement8788); if (state.failed) return stmt;
					pushFollow(FOLLOW_userPassword_in_createUserStatement8790);
					userPassword(opts);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			// Parser.g:1207:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt177=3;
			int LA177_0 = input.LA(1);
			if ( (LA177_0==K_SUPERUSER) ) {
				alt177=1;
			}
			else if ( (LA177_0==K_NOSUPERUSER) ) {
				alt177=2;
			}
			switch (alt177) {
				case 1 :
					// Parser.g:1207:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement8804); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { superuser = true; }
					}
					break;
				case 2 :
					// Parser.g:1207:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement8810); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { superuser = false; }
					}
					break;

			}

			if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.SUPERUSER, superuser);
			        if (opts.getPassword().isPresent() && opts.getHashedPassword().isPresent())
			        {
			           throw new SyntaxException("Options 'password' and 'hashed password' are mutually exclusive");
			        }
			        stmt = new CreateRoleStatement(name, opts, DCPermissions.all(), CIDRPermissions.all(), ifNotExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createUserStatement"



	// $ANTLR start "alterUserStatement"
	// Parser.g:1219:1: alterUserStatement returns [AlterRoleStatement stmt] : K_ALTER K_USER ( K_IF K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final AlterRoleStatement alterUserStatement() throws RecognitionException {
		AlterRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        RoleOptions opts = new RoleOptions();
		        RoleName name = new RoleName();
		        boolean ifExists = false;
		    
		try {
			// Parser.g:1225:5: ( K_ALTER K_USER ( K_IF K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// Parser.g:1225:7: K_ALTER K_USER ( K_IF K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement8855); if (state.failed) return stmt;
			match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement8857); if (state.failed) return stmt;
			// Parser.g:1225:22: ( K_IF K_EXISTS )?
			int alt178=2;
			int LA178_0 = input.LA(1);
			if ( (LA178_0==K_IF) ) {
				alt178=1;
			}
			switch (alt178) {
				case 1 :
					// Parser.g:1225:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_alterUserStatement8860); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterUserStatement8862); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_username_in_alterUserStatement8870);
			u=username();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { name.setName((u!=null?input.toString(u.start,u.stop):null), true); }
			// Parser.g:1226:7: ( K_WITH userPassword[opts] )?
			int alt179=2;
			int LA179_0 = input.LA(1);
			if ( (LA179_0==K_WITH) ) {
				alt179=1;
			}
			switch (alt179) {
				case 1 :
					// Parser.g:1226:9: K_WITH userPassword[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement8882); if (state.failed) return stmt;
					pushFollow(FOLLOW_userPassword_in_alterUserStatement8884);
					userPassword(opts);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			// Parser.g:1227:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt180=3;
			int LA180_0 = input.LA(1);
			if ( (LA180_0==K_SUPERUSER) ) {
				alt180=1;
			}
			else if ( (LA180_0==K_NOSUPERUSER) ) {
				alt180=2;
			}
			switch (alt180) {
				case 1 :
					// Parser.g:1227:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement8898); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.SUPERUSER, true); }
					}
					break;
				case 2 :
					// Parser.g:1228:11: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement8912); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.SUPERUSER, false); }
					}
					break;

			}

			if ( state.backtracking==0 ) {
			         if (opts.getPassword().isPresent() && opts.getHashedPassword().isPresent())
			         {
			            throw new SyntaxException("Options 'password' and 'hashed password' are mutually exclusive");
			         }
			         stmt = new AlterRoleStatement(name, opts, null, null, ifExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterUserStatement"



	// $ANTLR start "dropUserStatement"
	// Parser.g:1241:1: dropUserStatement returns [DropRoleStatement stmt] : K_DROP K_USER ( K_IF K_EXISTS )? u= username ;
	public final DropRoleStatement dropUserStatement() throws RecognitionException {
		DropRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        boolean ifExists = false;
		        RoleName name = new RoleName();
		    
		try {
			// Parser.g:1246:5: ( K_DROP K_USER ( K_IF K_EXISTS )? u= username )
			// Parser.g:1246:7: K_DROP K_USER ( K_IF K_EXISTS )? u= username
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement8958); if (state.failed) return stmt;
			match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement8960); if (state.failed) return stmt;
			// Parser.g:1246:21: ( K_IF K_EXISTS )?
			int alt181=2;
			int LA181_0 = input.LA(1);
			if ( (LA181_0==K_IF) ) {
				alt181=1;
			}
			switch (alt181) {
				case 1 :
					// Parser.g:1246:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropUserStatement8963); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropUserStatement8965); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_username_in_dropUserStatement8973);
			u=username();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { name.setName((u!=null?input.toString(u.start,u.stop):null), true); stmt = new DropRoleStatement(name, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropUserStatement"



	// $ANTLR start "addIdentityStatement"
	// Parser.g:1251:1: addIdentityStatement returns [AddIdentityStatement stmt] : K_ADD K_IDENTITY ( K_IF K_NOT K_EXISTS )? u= identity K_TO K_ROLE r= identity ;
	public final AddIdentityStatement addIdentityStatement() throws RecognitionException {
		AddIdentityStatement stmt = null;


		ParserRuleReturnScope u =null;
		ParserRuleReturnScope r =null;


		        String identity = null;
		        String role = null;
		        boolean ifNotExists = false;
		    
		try {
			// Parser.g:1257:5: ( K_ADD K_IDENTITY ( K_IF K_NOT K_EXISTS )? u= identity K_TO K_ROLE r= identity )
			// Parser.g:1257:7: K_ADD K_IDENTITY ( K_IF K_NOT K_EXISTS )? u= identity K_TO K_ROLE r= identity
			{
			match(input,K_ADD,FOLLOW_K_ADD_in_addIdentityStatement9006); if (state.failed) return stmt;
			match(input,K_IDENTITY,FOLLOW_K_IDENTITY_in_addIdentityStatement9008); if (state.failed) return stmt;
			// Parser.g:1257:24: ( K_IF K_NOT K_EXISTS )?
			int alt182=2;
			int LA182_0 = input.LA(1);
			if ( (LA182_0==K_IF) ) {
				alt182=1;
			}
			switch (alt182) {
				case 1 :
					// Parser.g:1257:25: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_addIdentityStatement9011); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_addIdentityStatement9013); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_addIdentityStatement9015); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_identity_in_addIdentityStatement9023);
			u=identity();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { identity= (u!=null?input.toString(u.start,u.stop):null); }
			match(input,K_TO,FOLLOW_K_TO_in_addIdentityStatement9027); if (state.failed) return stmt;
			match(input,K_ROLE,FOLLOW_K_ROLE_in_addIdentityStatement9029); if (state.failed) return stmt;
			pushFollow(FOLLOW_identity_in_addIdentityStatement9033);
			r=identity();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { role=(r!=null?input.toString(r.start,r.stop):null); stmt = new AddIdentityStatement(identity, role, ifNotExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "addIdentityStatement"



	// $ANTLR start "dropIdentityStatement"
	// Parser.g:1263:2: dropIdentityStatement returns [DropIdentityStatement stmt] : K_DROP K_IDENTITY ( K_IF K_EXISTS )? u= identity ;
	public final DropIdentityStatement dropIdentityStatement() throws RecognitionException {
		DropIdentityStatement stmt = null;


		ParserRuleReturnScope u =null;


		          boolean ifExists = false;
		          String identity = null;
		      
		try {
			// Parser.g:1268:7: ( K_DROP K_IDENTITY ( K_IF K_EXISTS )? u= identity )
			// Parser.g:1268:9: K_DROP K_IDENTITY ( K_IF K_EXISTS )? u= identity
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropIdentityStatement9072); if (state.failed) return stmt;
			match(input,K_IDENTITY,FOLLOW_K_IDENTITY_in_dropIdentityStatement9074); if (state.failed) return stmt;
			// Parser.g:1268:27: ( K_IF K_EXISTS )?
			int alt183=2;
			int LA183_0 = input.LA(1);
			if ( (LA183_0==K_IF) ) {
				alt183=1;
			}
			switch (alt183) {
				case 1 :
					// Parser.g:1268:28: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropIdentityStatement9077); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIdentityStatement9079); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_identity_in_dropIdentityStatement9087);
			u=identity();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { identity= (u!=null?input.toString(u.start,u.stop):null); stmt = new DropIdentityStatement(identity, ifExists);}
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropIdentityStatement"



	// $ANTLR start "listUsersStatement"
	// Parser.g:1274:1: listUsersStatement returns [ListRolesStatement stmt] : K_LIST K_USERS ;
	public final ListRolesStatement listUsersStatement() throws RecognitionException {
		ListRolesStatement stmt = null;


		try {
			// Parser.g:1275:5: ( K_LIST K_USERS )
			// Parser.g:1275:7: K_LIST K_USERS
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement9114); if (state.failed) return stmt;
			match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement9116); if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new ListUsersStatement(); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listUsersStatement"



	// $ANTLR start "createRoleStatement"
	// Parser.g:1291:1: createRoleStatement returns [CreateRoleStatement stmt] : K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts, dcperms, cidrperms] )? ;
	public final CreateRoleStatement createRoleStatement() throws RecognitionException {
		CreateRoleStatement stmt = null;


		RoleName name =null;


		        RoleOptions opts = new RoleOptions();
		        DCPermissions.Builder dcperms = DCPermissions.builder();
		        CIDRPermissions.Builder cidrperms = CIDRPermissions.builder();
		        boolean ifNotExists = false;
		    
		try {
			// Parser.g:1298:5: ( K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts, dcperms, cidrperms] )? )
			// Parser.g:1298:7: K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts, dcperms, cidrperms] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createRoleStatement9150); if (state.failed) return stmt;
			match(input,K_ROLE,FOLLOW_K_ROLE_in_createRoleStatement9152); if (state.failed) return stmt;
			// Parser.g:1298:23: ( K_IF K_NOT K_EXISTS )?
			int alt184=2;
			int LA184_0 = input.LA(1);
			if ( (LA184_0==K_IF) ) {
				alt184=1;
			}
			switch (alt184) {
				case 1 :
					// Parser.g:1298:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createRoleStatement9155); if (state.failed) return stmt;
					match(input,K_NOT,FOLLOW_K_NOT_in_createRoleStatement9157); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createRoleStatement9159); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifNotExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_createRoleStatement9167);
			name=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:1299:7: ( K_WITH roleOptions[opts, dcperms, cidrperms] )?
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==K_WITH) ) {
				alt185=1;
			}
			switch (alt185) {
				case 1 :
					// Parser.g:1299:9: K_WITH roleOptions[opts, dcperms, cidrperms]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createRoleStatement9177); if (state.failed) return stmt;
					pushFollow(FOLLOW_roleOptions_in_createRoleStatement9179);
					roleOptions(opts, dcperms, cidrperms);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			        // set defaults if they weren't explictly supplied
			        if (!opts.getLogin().isPresent())
			        {
			            opts.setOption(IRoleManager.Option.LOGIN, false);
			        }
			        if (!opts.getSuperuser().isPresent())
			        {
			            opts.setOption(IRoleManager.Option.SUPERUSER, false);
			        }
			        if (opts.getPassword().isPresent() && opts.getHashedPassword().isPresent())
			        {
			            throw new SyntaxException("Options 'password' and 'hashed password' are mutually exclusive");
			        }
			        stmt = new CreateRoleStatement(name, opts, dcperms.build(), cidrperms.build(), ifNotExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createRoleStatement"



	// $ANTLR start "alterRoleStatement"
	// Parser.g:1331:1: alterRoleStatement returns [AlterRoleStatement stmt] : K_ALTER K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts, dcperms, cidrperms] )? ;
	public final AlterRoleStatement alterRoleStatement() throws RecognitionException {
		AlterRoleStatement stmt = null;


		RoleName name =null;


		        RoleOptions opts = new RoleOptions();
		        DCPermissions.Builder dcperms = DCPermissions.builder();
		        CIDRPermissions.Builder cidrperms = CIDRPermissions.builder();
		        boolean ifExists = false;
		    
		try {
			// Parser.g:1338:5: ( K_ALTER K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts, dcperms, cidrperms] )? )
			// Parser.g:1338:7: K_ALTER K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts, dcperms, cidrperms] )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterRoleStatement9223); if (state.failed) return stmt;
			match(input,K_ROLE,FOLLOW_K_ROLE_in_alterRoleStatement9225); if (state.failed) return stmt;
			// Parser.g:1338:22: ( K_IF K_EXISTS )?
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==K_IF) ) {
				alt186=1;
			}
			switch (alt186) {
				case 1 :
					// Parser.g:1338:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_alterRoleStatement9228); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_alterRoleStatement9230); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_alterRoleStatement9238);
			name=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			// Parser.g:1339:7: ( K_WITH roleOptions[opts, dcperms, cidrperms] )?
			int alt187=2;
			int LA187_0 = input.LA(1);
			if ( (LA187_0==K_WITH) ) {
				alt187=1;
			}
			switch (alt187) {
				case 1 :
					// Parser.g:1339:9: K_WITH roleOptions[opts, dcperms, cidrperms]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterRoleStatement9248); if (state.failed) return stmt;
					pushFollow(FOLLOW_roleOptions_in_alterRoleStatement9250);
					roleOptions(opts, dcperms, cidrperms);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			if ( state.backtracking==0 ) {
			         if (opts.getPassword().isPresent() && opts.getHashedPassword().isPresent())
			         {
			            throw new SyntaxException("Options 'password' and 'hashed password' are mutually exclusive");
			         }
			         stmt = new AlterRoleStatement(name, opts, dcperms.isModified() ? dcperms.build() : null, cidrperms.isModified() ? cidrperms.build() : null, ifExists);
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterRoleStatement"



	// $ANTLR start "dropRoleStatement"
	// Parser.g:1352:1: dropRoleStatement returns [DropRoleStatement stmt] : K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName ;
	public final DropRoleStatement dropRoleStatement() throws RecognitionException {
		DropRoleStatement stmt = null;


		RoleName name =null;


		        boolean ifExists = false;
		    
		try {
			// Parser.g:1356:5: ( K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName )
			// Parser.g:1356:7: K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropRoleStatement9294); if (state.failed) return stmt;
			match(input,K_ROLE,FOLLOW_K_ROLE_in_dropRoleStatement9296); if (state.failed) return stmt;
			// Parser.g:1356:21: ( K_IF K_EXISTS )?
			int alt188=2;
			int LA188_0 = input.LA(1);
			if ( (LA188_0==K_IF) ) {
				alt188=1;
			}
			switch (alt188) {
				case 1 :
					// Parser.g:1356:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropRoleStatement9299); if (state.failed) return stmt;
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropRoleStatement9301); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { ifExists = true; }
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_dropRoleStatement9309);
			name=userOrRoleName();
			state._fsp--;
			if (state.failed) return stmt;
			if ( state.backtracking==0 ) { stmt = new DropRoleStatement(name, ifExists); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropRoleStatement"



	// $ANTLR start "listRolesStatement"
	// Parser.g:1363:1: listRolesStatement returns [ListRolesStatement stmt] : K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? ;
	public final ListRolesStatement listRolesStatement() throws RecognitionException {
		ListRolesStatement stmt = null;



		        boolean recursive = true;
		        RoleName grantee = new RoleName();
		    
		try {
			// Parser.g:1368:5: ( K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? )
			// Parser.g:1368:7: K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listRolesStatement9349); if (state.failed) return stmt;
			match(input,K_ROLES,FOLLOW_K_ROLES_in_listRolesStatement9351); if (state.failed) return stmt;
			// Parser.g:1369:7: ( K_OF roleName[grantee] )?
			int alt189=2;
			int LA189_0 = input.LA(1);
			if ( (LA189_0==K_OF) ) {
				alt189=1;
			}
			switch (alt189) {
				case 1 :
					// Parser.g:1369:9: K_OF roleName[grantee]
					{
					match(input,K_OF,FOLLOW_K_OF_in_listRolesStatement9361); if (state.failed) return stmt;
					pushFollow(FOLLOW_roleName_in_listRolesStatement9363);
					roleName(grantee);
					state._fsp--;
					if (state.failed) return stmt;
					}
					break;

			}

			// Parser.g:1370:7: ( K_NORECURSIVE )?
			int alt190=2;
			int LA190_0 = input.LA(1);
			if ( (LA190_0==K_NORECURSIVE) ) {
				alt190=1;
			}
			switch (alt190) {
				case 1 :
					// Parser.g:1370:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listRolesStatement9376); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { recursive = false; }
					}
					break;

			}

			if ( state.backtracking==0 ) { stmt = new ListRolesStatement(grantee, recursive); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listRolesStatement"



	// $ANTLR start "roleOptions"
	// Parser.g:1374:1: roleOptions[RoleOptions opts, DCPermissions.Builder dcperms, CIDRPermissions.Builder cidrperms] : roleOption[opts, dcperms, cidrperms] ( K_AND roleOption[opts, dcperms, cidrperms] )* ;
	public final void roleOptions(RoleOptions opts, DCPermissions.Builder dcperms, CIDRPermissions.Builder cidrperms) throws RecognitionException {
		try {
			// Parser.g:1375:5: ( roleOption[opts, dcperms, cidrperms] ( K_AND roleOption[opts, dcperms, cidrperms] )* )
			// Parser.g:1375:7: roleOption[opts, dcperms, cidrperms] ( K_AND roleOption[opts, dcperms, cidrperms] )*
			{
			pushFollow(FOLLOW_roleOption_in_roleOptions9407);
			roleOption(opts, dcperms, cidrperms);
			state._fsp--;
			if (state.failed) return;
			// Parser.g:1375:44: ( K_AND roleOption[opts, dcperms, cidrperms] )*
			loop191:
			while (true) {
				int alt191=2;
				int LA191_0 = input.LA(1);
				if ( (LA191_0==K_AND) ) {
					alt191=1;
				}

				switch (alt191) {
				case 1 :
					// Parser.g:1375:45: K_AND roleOption[opts, dcperms, cidrperms]
					{
					match(input,K_AND,FOLLOW_K_AND_in_roleOptions9411); if (state.failed) return;
					pushFollow(FOLLOW_roleOption_in_roleOptions9413);
					roleOption(opts, dcperms, cidrperms);
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop191;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleOptions"



	// $ANTLR start "roleOption"
	// Parser.g:1378:1: roleOption[RoleOptions opts, DCPermissions.Builder dcperms, CIDRPermissions.Builder cidrperms] : ( K_PASSWORD '=' v= STRING_LITERAL | K_HASHED K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= fullMapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN | K_ACCESS K_TO K_ALL K_DATACENTERS | K_ACCESS K_TO K_DATACENTERS '{' dcPermission[dcperms] ( ',' dcPermission[dcperms] )* '}' | K_ACCESS K_FROM K_ALL K_CIDRS | K_ACCESS K_FROM K_CIDRS '{' cidrPermission[cidrperms] ( ',' cidrPermission[cidrperms] )* '}' );
	public final void roleOption(RoleOptions opts, DCPermissions.Builder dcperms, CIDRPermissions.Builder cidrperms) throws RecognitionException {
		Token v=null;
		Token b=null;
		Maps.Literal m =null;

		try {
			// Parser.g:1379:5: ( K_PASSWORD '=' v= STRING_LITERAL | K_HASHED K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= fullMapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN | K_ACCESS K_TO K_ALL K_DATACENTERS | K_ACCESS K_TO K_DATACENTERS '{' dcPermission[dcperms] ( ',' dcPermission[dcperms] )* '}' | K_ACCESS K_FROM K_ALL K_CIDRS | K_ACCESS K_FROM K_CIDRS '{' cidrPermission[cidrperms] ( ',' cidrPermission[cidrperms] )* '}' )
			int alt194=9;
			alt194 = dfa194.predict(input);
			switch (alt194) {
				case 1 :
					// Parser.g:1379:8: K_PASSWORD '=' v= STRING_LITERAL
					{
					match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_roleOption9435); if (state.failed) return;
					match(input,222,FOLLOW_222_in_roleOption9437); if (state.failed) return;
					v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_roleOption9441); if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.PASSWORD, (v!=null?v.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:1380:8: K_HASHED K_PASSWORD '=' v= STRING_LITERAL
					{
					match(input,K_HASHED,FOLLOW_K_HASHED_in_roleOption9452); if (state.failed) return;
					match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_roleOption9454); if (state.failed) return;
					match(input,222,FOLLOW_222_in_roleOption9456); if (state.failed) return;
					v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_roleOption9460); if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.HASHED_PASSWORD, (v!=null?v.getText():null)); }
					}
					break;
				case 3 :
					// Parser.g:1381:8: K_OPTIONS '=' m= fullMapLiteral
					{
					match(input,K_OPTIONS,FOLLOW_K_OPTIONS_in_roleOption9471); if (state.failed) return;
					match(input,222,FOLLOW_222_in_roleOption9473); if (state.failed) return;
					pushFollow(FOLLOW_fullMapLiteral_in_roleOption9477);
					m=fullMapLiteral();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.OPTIONS, convertPropertyMap(m)); }
					}
					break;
				case 4 :
					// Parser.g:1382:8: K_SUPERUSER '=' b= BOOLEAN
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_roleOption9488); if (state.failed) return;
					match(input,222,FOLLOW_222_in_roleOption9490); if (state.failed) return;
					b=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_roleOption9494); if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.SUPERUSER, Boolean.valueOf((b!=null?b.getText():null))); }
					}
					break;
				case 5 :
					// Parser.g:1383:8: K_LOGIN '=' b= BOOLEAN
					{
					match(input,K_LOGIN,FOLLOW_K_LOGIN_in_roleOption9505); if (state.failed) return;
					match(input,222,FOLLOW_222_in_roleOption9507); if (state.failed) return;
					b=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_roleOption9511); if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.LOGIN, Boolean.valueOf((b!=null?b.getText():null))); }
					}
					break;
				case 6 :
					// Parser.g:1384:8: K_ACCESS K_TO K_ALL K_DATACENTERS
					{
					match(input,K_ACCESS,FOLLOW_K_ACCESS_in_roleOption9522); if (state.failed) return;
					match(input,K_TO,FOLLOW_K_TO_in_roleOption9524); if (state.failed) return;
					match(input,K_ALL,FOLLOW_K_ALL_in_roleOption9526); if (state.failed) return;
					match(input,K_DATACENTERS,FOLLOW_K_DATACENTERS_in_roleOption9528); if (state.failed) return;
					if ( state.backtracking==0 ) { dcperms.all(); }
					}
					break;
				case 7 :
					// Parser.g:1385:8: K_ACCESS K_TO K_DATACENTERS '{' dcPermission[dcperms] ( ',' dcPermission[dcperms] )* '}'
					{
					match(input,K_ACCESS,FOLLOW_K_ACCESS_in_roleOption9539); if (state.failed) return;
					match(input,K_TO,FOLLOW_K_TO_in_roleOption9541); if (state.failed) return;
					match(input,K_DATACENTERS,FOLLOW_K_DATACENTERS_in_roleOption9543); if (state.failed) return;
					match(input,229,FOLLOW_229_in_roleOption9545); if (state.failed) return;
					pushFollow(FOLLOW_dcPermission_in_roleOption9547);
					dcPermission(dcperms);
					state._fsp--;
					if (state.failed) return;
					// Parser.g:1385:62: ( ',' dcPermission[dcperms] )*
					loop192:
					while (true) {
						int alt192=2;
						int LA192_0 = input.LA(1);
						if ( (LA192_0==213) ) {
							alt192=1;
						}

						switch (alt192) {
						case 1 :
							// Parser.g:1385:63: ',' dcPermission[dcperms]
							{
							match(input,213,FOLLOW_213_in_roleOption9551); if (state.failed) return;
							pushFollow(FOLLOW_dcPermission_in_roleOption9553);
							dcPermission(dcperms);
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop192;
						}
					}

					match(input,230,FOLLOW_230_in_roleOption9558); if (state.failed) return;
					}
					break;
				case 8 :
					// Parser.g:1386:8: K_ACCESS K_FROM K_ALL K_CIDRS
					{
					match(input,K_ACCESS,FOLLOW_K_ACCESS_in_roleOption9567); if (state.failed) return;
					match(input,K_FROM,FOLLOW_K_FROM_in_roleOption9569); if (state.failed) return;
					match(input,K_ALL,FOLLOW_K_ALL_in_roleOption9571); if (state.failed) return;
					match(input,K_CIDRS,FOLLOW_K_CIDRS_in_roleOption9573); if (state.failed) return;
					if ( state.backtracking==0 ) { cidrperms.all(); }
					}
					break;
				case 9 :
					// Parser.g:1387:8: K_ACCESS K_FROM K_CIDRS '{' cidrPermission[cidrperms] ( ',' cidrPermission[cidrperms] )* '}'
					{
					match(input,K_ACCESS,FOLLOW_K_ACCESS_in_roleOption9584); if (state.failed) return;
					match(input,K_FROM,FOLLOW_K_FROM_in_roleOption9586); if (state.failed) return;
					match(input,K_CIDRS,FOLLOW_K_CIDRS_in_roleOption9588); if (state.failed) return;
					match(input,229,FOLLOW_229_in_roleOption9590); if (state.failed) return;
					pushFollow(FOLLOW_cidrPermission_in_roleOption9592);
					cidrPermission(cidrperms);
					state._fsp--;
					if (state.failed) return;
					// Parser.g:1387:62: ( ',' cidrPermission[cidrperms] )*
					loop193:
					while (true) {
						int alt193=2;
						int LA193_0 = input.LA(1);
						if ( (LA193_0==213) ) {
							alt193=1;
						}

						switch (alt193) {
						case 1 :
							// Parser.g:1387:63: ',' cidrPermission[cidrperms]
							{
							match(input,213,FOLLOW_213_in_roleOption9596); if (state.failed) return;
							pushFollow(FOLLOW_cidrPermission_in_roleOption9598);
							cidrPermission(cidrperms);
							state._fsp--;
							if (state.failed) return;
							}
							break;

						default :
							break loop193;
						}
					}

					match(input,230,FOLLOW_230_in_roleOption9603); if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleOption"



	// $ANTLR start "dcPermission"
	// Parser.g:1390:1: dcPermission[DCPermissions.Builder builder] : dc= STRING_LITERAL ;
	public final void dcPermission(DCPermissions.Builder builder) throws RecognitionException {
		Token dc=null;

		try {
			// Parser.g:1391:5: (dc= STRING_LITERAL )
			// Parser.g:1391:7: dc= STRING_LITERAL
			{
			dc=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_dcPermission9623); if (state.failed) return;
			if ( state.backtracking==0 ) { builder.add((dc!=null?dc.getText():null)); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dcPermission"



	// $ANTLR start "cidrPermission"
	// Parser.g:1394:1: cidrPermission[CIDRPermissions.Builder builder] : cidr= STRING_LITERAL ;
	public final void cidrPermission(CIDRPermissions.Builder builder) throws RecognitionException {
		Token cidr=null;

		try {
			// Parser.g:1395:5: (cidr= STRING_LITERAL )
			// Parser.g:1395:7: cidr= STRING_LITERAL
			{
			cidr=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_cidrPermission9645); if (state.failed) return;
			if ( state.backtracking==0 ) { builder.add((cidr!=null?cidr.getText():null)); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cidrPermission"



	// $ANTLR start "userPassword"
	// Parser.g:1399:1: userPassword[RoleOptions opts] : ( K_PASSWORD v= STRING_LITERAL | K_HASHED K_PASSWORD v= STRING_LITERAL );
	public final void userPassword(RoleOptions opts) throws RecognitionException {
		Token v=null;

		try {
			// Parser.g:1400:5: ( K_PASSWORD v= STRING_LITERAL | K_HASHED K_PASSWORD v= STRING_LITERAL )
			int alt195=2;
			int LA195_0 = input.LA(1);
			if ( (LA195_0==K_PASSWORD) ) {
				alt195=1;
			}
			else if ( (LA195_0==K_HASHED) ) {
				alt195=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 195, 0, input);
				throw nvae;
			}

			switch (alt195) {
				case 1 :
					// Parser.g:1400:8: K_PASSWORD v= STRING_LITERAL
					{
					match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userPassword9667); if (state.failed) return;
					v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userPassword9671); if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.PASSWORD, (v!=null?v.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:1401:8: K_HASHED K_PASSWORD v= STRING_LITERAL
					{
					match(input,K_HASHED,FOLLOW_K_HASHED_in_userPassword9682); if (state.failed) return;
					match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userPassword9684); if (state.failed) return;
					v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userPassword9688); if (state.failed) return;
					if ( state.backtracking==0 ) { opts.setOption(IRoleManager.Option.HASHED_PASSWORD, (v!=null?v.getText():null)); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userPassword"



	// $ANTLR start "describeStatement"
	// Parser.g:1410:1: describeStatement returns [DescribeStatement stmt] : ( K_DESCRIBE | K_DESC ) ( ( K_CLUSTER )=> K_CLUSTER | ( K_FULL )? K_SCHEMA | ( K_KEYSPACES )=> K_KEYSPACES | ( K_ONLY )? K_KEYSPACE (ks= keyspaceName )? | ( K_TABLES )=> K_TABLES | K_COLUMNFAMILY cf= columnFamilyName | K_INDEX idx= columnFamilyName | K_MATERIALIZED K_VIEW view= columnFamilyName | ( K_TYPES )=> K_TYPES | K_TYPE tn= userTypeName | ( K_FUNCTIONS )=> K_FUNCTIONS | K_FUNCTION fn= functionName | ( K_AGGREGATES )=> K_AGGREGATES | K_AGGREGATE ag= functionName | ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )? (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword ) ) ( K_WITH K_INTERNALS )? ;
	public final DescribeStatement describeStatement() throws RecognitionException {
		DescribeStatement stmt = null;


		Token ksT=null;
		Token tT=null;
		String ks =null;
		QualifiedName cf =null;
		QualifiedName idx =null;
		QualifiedName view =null;
		UTName tn =null;
		FunctionName fn =null;
		FunctionName ag =null;
		String ksK =null;
		String tK =null;


		        boolean fullSchema = false;
		        boolean pending = false;
		        boolean config = false;
		        boolean only = false;
		        QualifiedName gen = new QualifiedName();
		    
		try {
			// Parser.g:1418:5: ( ( K_DESCRIBE | K_DESC ) ( ( K_CLUSTER )=> K_CLUSTER | ( K_FULL )? K_SCHEMA | ( K_KEYSPACES )=> K_KEYSPACES | ( K_ONLY )? K_KEYSPACE (ks= keyspaceName )? | ( K_TABLES )=> K_TABLES | K_COLUMNFAMILY cf= columnFamilyName | K_INDEX idx= columnFamilyName | K_MATERIALIZED K_VIEW view= columnFamilyName | ( K_TYPES )=> K_TYPES | K_TYPE tn= userTypeName | ( K_FUNCTIONS )=> K_FUNCTIONS | K_FUNCTION fn= functionName | ( K_AGGREGATES )=> K_AGGREGATES | K_AGGREGATE ag= functionName | ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )? (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword ) ) ( K_WITH K_INTERNALS )? )
			// Parser.g:1418:7: ( K_DESCRIBE | K_DESC ) ( ( K_CLUSTER )=> K_CLUSTER | ( K_FULL )? K_SCHEMA | ( K_KEYSPACES )=> K_KEYSPACES | ( K_ONLY )? K_KEYSPACE (ks= keyspaceName )? | ( K_TABLES )=> K_TABLES | K_COLUMNFAMILY cf= columnFamilyName | K_INDEX idx= columnFamilyName | K_MATERIALIZED K_VIEW view= columnFamilyName | ( K_TYPES )=> K_TYPES | K_TYPE tn= userTypeName | ( K_FUNCTIONS )=> K_FUNCTIONS | K_FUNCTION fn= functionName | ( K_AGGREGATES )=> K_AGGREGATES | K_AGGREGATE ag= functionName | ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )? (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword ) ) ( K_WITH K_INTERNALS )?
			{
			if ( (input.LA(1) >= K_DESC && input.LA(1) <= K_DESCRIBE) ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return stmt;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			// Parser.g:1419:5: ( ( K_CLUSTER )=> K_CLUSTER | ( K_FULL )? K_SCHEMA | ( K_KEYSPACES )=> K_KEYSPACES | ( K_ONLY )? K_KEYSPACE (ks= keyspaceName )? | ( K_TABLES )=> K_TABLES | K_COLUMNFAMILY cf= columnFamilyName | K_INDEX idx= columnFamilyName | K_MATERIALIZED K_VIEW view= columnFamilyName | ( K_TYPES )=> K_TYPES | K_TYPE tn= userTypeName | ( K_FUNCTIONS )=> K_FUNCTIONS | K_FUNCTION fn= functionName | ( K_AGGREGATES )=> K_AGGREGATES | K_AGGREGATE ag= functionName | ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )? (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword ) )
			int alt202=15;
			alt202 = dfa202.predict(input);
			switch (alt202) {
				case 1 :
					// Parser.g:1419:7: ( K_CLUSTER )=> K_CLUSTER
					{
					match(input,K_CLUSTER,FOLLOW_K_CLUSTER_in_describeStatement9743); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.cluster(); }
					}
					break;
				case 2 :
					// Parser.g:1420:7: ( K_FULL )? K_SCHEMA
					{
					// Parser.g:1420:7: ( K_FULL )?
					int alt196=2;
					int LA196_0 = input.LA(1);
					if ( (LA196_0==K_FULL) ) {
						alt196=1;
					}
					switch (alt196) {
						case 1 :
							// Parser.g:1420:8: K_FULL
							{
							match(input,K_FULL,FOLLOW_K_FULL_in_describeStatement9774); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { fullSchema=true; }
							}
							break;

					}

					match(input,K_SCHEMA,FOLLOW_K_SCHEMA_in_describeStatement9780); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.schema(fullSchema); }
					}
					break;
				case 3 :
					// Parser.g:1421:7: ( K_KEYSPACES )=> K_KEYSPACES
					{
					match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_describeStatement9799); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.keyspaces(); }
					}
					break;
				case 4 :
					// Parser.g:1422:7: ( K_ONLY )? K_KEYSPACE (ks= keyspaceName )?
					{
					// Parser.g:1422:7: ( K_ONLY )?
					int alt197=2;
					int LA197_0 = input.LA(1);
					if ( (LA197_0==K_ONLY) ) {
						alt197=1;
					}
					switch (alt197) {
						case 1 :
							// Parser.g:1422:8: K_ONLY
							{
							match(input,K_ONLY,FOLLOW_K_ONLY_in_describeStatement9826); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { only=true; }
							}
							break;

					}

					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_describeStatement9832); if (state.failed) return stmt;
					// Parser.g:1422:43: (ks= keyspaceName )?
					int alt198=2;
					int LA198_0 = input.LA(1);
					if ( (LA198_0==IDENT||LA198_0==K_ACCESS||(LA198_0 >= K_AGGREGATE && LA198_0 <= K_ALL)||LA198_0==K_ANN||LA198_0==K_AS||LA198_0==K_ASCII||(LA198_0 >= K_BIGINT && LA198_0 <= K_BOOLEAN)||(LA198_0 >= K_CALLED && LA198_0 <= K_CLUSTERING)||(LA198_0 >= K_COMPACT && LA198_0 <= K_COUNTER)||(LA198_0 >= K_CUSTOM && LA198_0 <= K_DEFAULT)||(LA198_0 >= K_DISTINCT && LA198_0 <= K_DOUBLE)||LA198_0==K_DURATION||(LA198_0 >= K_EXISTS && LA198_0 <= K_FLOAT)||LA198_0==K_FROZEN||(LA198_0 >= K_FUNCTION && LA198_0 <= K_FUNCTIONS)||(LA198_0 >= K_GROUP && LA198_0 <= K_IDENTITY)||(LA198_0 >= K_INET && LA198_0 <= K_INPUT)||(LA198_0 >= K_INT && LA198_0 <= K_INTERNALS)||(LA198_0 >= K_JSON && LA198_0 <= K_KEYS)||(LA198_0 >= K_KEYSPACES && LA198_0 <= K_LIKE)||(LA198_0 >= K_LIST && LA198_0 <= K_MASKED)||(LA198_0 >= K_MAXWRITETIME && LA198_0 <= K_MBEANS)||LA198_0==K_NOLOGIN||LA198_0==K_NOSUPERUSER||(LA198_0 >= K_ONLY && LA198_0 <= K_OPTIONS)||(LA198_0 >= K_PARTITION && LA198_0 <= K_PERMISSIONS)||(LA198_0 >= K_REPLACE && LA198_0 <= K_RETURNS)||(LA198_0 >= K_ROLE && LA198_0 <= K_ROLES)||LA198_0==K_SELECT_MASKED||(LA198_0 >= K_SFUNC && LA198_0 <= K_TINYINT)||LA198_0==K_TRIGGER||(LA198_0 >= K_TTL && LA198_0 <= K_TYPES)||(LA198_0 >= K_UNMASK && LA198_0 <= K_UNSET)||(LA198_0 >= K_USER && LA198_0 <= K_USERS)||(LA198_0 >= K_UUID && LA198_0 <= K_VECTOR)||LA198_0==K_WRITETIME||(LA198_0 >= QMARK && LA198_0 <= QUOTED_NAME)) ) {
						alt198=1;
					}
					switch (alt198) {
						case 1 :
							// Parser.g:1422:45: ks= keyspaceName
							{
							pushFollow(FOLLOW_keyspaceName_in_describeStatement9838);
							ks=keyspaceName();
							state._fsp--;
							if (state.failed) return stmt;
							}
							break;

					}

					if ( state.backtracking==0 ) { stmt = DescribeStatement.keyspace(ks, only); }
					}
					break;
				case 5 :
					// Parser.g:1424:7: ( K_TABLES )=> K_TABLES
					{
					match(input,K_TABLES,FOLLOW_K_TABLES_in_describeStatement9907); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.tables(); }
					}
					break;
				case 6 :
					// Parser.g:1425:7: K_COLUMNFAMILY cf= columnFamilyName
					{
					match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_describeStatement9938); if (state.failed) return stmt;
					pushFollow(FOLLOW_columnFamilyName_in_describeStatement9942);
					cf=columnFamilyName();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.table(cf.getKeyspace(), cf.getName()); }
					}
					break;
				case 7 :
					// Parser.g:1426:7: K_INDEX idx= columnFamilyName
					{
					match(input,K_INDEX,FOLLOW_K_INDEX_in_describeStatement9961); if (state.failed) return stmt;
					pushFollow(FOLLOW_columnFamilyName_in_describeStatement9965);
					idx=columnFamilyName();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.index(idx.getKeyspace(), idx.getName()); }
					}
					break;
				case 8 :
					// Parser.g:1427:7: K_MATERIALIZED K_VIEW view= columnFamilyName
					{
					match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_describeStatement9990); if (state.failed) return stmt;
					match(input,K_VIEW,FOLLOW_K_VIEW_in_describeStatement9992); if (state.failed) return stmt;
					pushFollow(FOLLOW_columnFamilyName_in_describeStatement9996);
					view=columnFamilyName();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.view(view.getKeyspace(), view.getName()); }
					}
					break;
				case 9 :
					// Parser.g:1428:7: ( K_TYPES )=> K_TYPES
					{
					match(input,K_TYPES,FOLLOW_K_TYPES_in_describeStatement10012); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.types(); }
					}
					break;
				case 10 :
					// Parser.g:1429:7: K_TYPE tn= userTypeName
					{
					match(input,K_TYPE,FOLLOW_K_TYPE_in_describeStatement10045); if (state.failed) return stmt;
					pushFollow(FOLLOW_userTypeName_in_describeStatement10049);
					tn=userTypeName();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.type(tn.getKeyspace(), tn.getStringTypeName()); }
					}
					break;
				case 11 :
					// Parser.g:1430:7: ( K_FUNCTIONS )=> K_FUNCTIONS
					{
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_describeStatement10086); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.functions(); }
					}
					break;
				case 12 :
					// Parser.g:1431:7: K_FUNCTION fn= functionName
					{
					match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_describeStatement10111); if (state.failed) return stmt;
					pushFollow(FOLLOW_functionName_in_describeStatement10115);
					fn=functionName();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.function(fn.keyspace, fn.name); }
					}
					break;
				case 13 :
					// Parser.g:1432:7: ( K_AGGREGATES )=> K_AGGREGATES
					{
					match(input,K_AGGREGATES,FOLLOW_K_AGGREGATES_in_describeStatement10148); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.aggregates(); }
					}
					break;
				case 14 :
					// Parser.g:1433:7: K_AGGREGATE ag= functionName
					{
					match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_describeStatement10171); if (state.failed) return stmt;
					pushFollow(FOLLOW_functionName_in_describeStatement10175);
					ag=functionName();
					state._fsp--;
					if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt = DescribeStatement.aggregate(ag.keyspace, ag.name); }
					}
					break;
				case 15 :
					// Parser.g:1434:7: ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )? (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword )
					{
					// Parser.g:1434:7: ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )?
					int alt200=2;
					alt200 = dfa200.predict(input);
					switch (alt200) {
						case 1 :
							// Parser.g:1434:9: (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.'
							{
							// Parser.g:1434:9: (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword )
							int alt199=3;
							switch ( input.LA(1) ) {
							case IDENT:
								{
								alt199=1;
								}
								break;
							case QUOTED_NAME:
								{
								alt199=2;
								}
								break;
							case K_ACCESS:
							case K_AGGREGATE:
							case K_AGGREGATES:
							case K_ALL:
							case K_ANN:
							case K_AS:
							case K_ASCII:
							case K_BIGINT:
							case K_BLOB:
							case K_BOOLEAN:
							case K_CALLED:
							case K_CAST:
							case K_CIDRS:
							case K_CLUSTER:
							case K_CLUSTERING:
							case K_COMPACT:
							case K_CONTAINS:
							case K_COUNT:
							case K_COUNTER:
							case K_CUSTOM:
							case K_DATACENTERS:
							case K_DATE:
							case K_DECIMAL:
							case K_DEFAULT:
							case K_DISTINCT:
							case K_DOUBLE:
							case K_DURATION:
							case K_EXISTS:
							case K_FILTERING:
							case K_FINALFUNC:
							case K_FLOAT:
							case K_FROZEN:
							case K_FUNCTION:
							case K_FUNCTIONS:
							case K_GROUP:
							case K_HASHED:
							case K_IDENTITY:
							case K_INET:
							case K_INITCOND:
							case K_INPUT:
							case K_INT:
							case K_INTERNALS:
							case K_JSON:
							case K_KEY:
							case K_KEYS:
							case K_KEYSPACES:
							case K_LANGUAGE:
							case K_LIKE:
							case K_LIST:
							case K_LOGIN:
							case K_MAP:
							case K_MASKED:
							case K_MAXWRITETIME:
							case K_MBEAN:
							case K_MBEANS:
							case K_NOLOGIN:
							case K_NOSUPERUSER:
							case K_ONLY:
							case K_OPTIONS:
							case K_PARTITION:
							case K_PASSWORD:
							case K_PER:
							case K_PERMISSION:
							case K_PERMISSIONS:
							case K_REPLACE:
							case K_RETURNS:
							case K_ROLE:
							case K_ROLES:
							case K_SELECT_MASKED:
							case K_SFUNC:
							case K_SMALLINT:
							case K_STATIC:
							case K_STORAGE:
							case K_STYPE:
							case K_SUPERUSER:
							case K_TABLES:
							case K_TEXT:
							case K_TIME:
							case K_TIMESTAMP:
							case K_TIMEUUID:
							case K_TINYINT:
							case K_TRIGGER:
							case K_TTL:
							case K_TUPLE:
							case K_TYPE:
							case K_TYPES:
							case K_UNMASK:
							case K_UNSET:
							case K_USER:
							case K_USERS:
							case K_UUID:
							case K_VALUES:
							case K_VARCHAR:
							case K_VARINT:
							case K_VECTOR:
							case K_WRITETIME:
								{
								alt199=3;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return stmt;}
								NoViableAltException nvae =
									new NoViableAltException("", 199, 0, input);
								throw nvae;
							}
							switch (alt199) {
								case 1 :
									// Parser.g:1434:11: ksT= IDENT
									{
									ksT=(Token)match(input,IDENT,FOLLOW_IDENT_in_describeStatement10207); if (state.failed) return stmt;
									if ( state.backtracking==0 ) { gen.setKeyspace((ksT!=null?ksT.getText():null), false);}
									}
									break;
								case 2 :
									// Parser.g:1435:13: ksT= QUOTED_NAME
									{
									ksT=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_describeStatement10247); if (state.failed) return stmt;
									if ( state.backtracking==0 ) { gen.setKeyspace((ksT!=null?ksT.getText():null), true);}
									}
									break;
								case 3 :
									// Parser.g:1436:13: ksK= unreserved_keyword
									{
									pushFollow(FOLLOW_unreserved_keyword_in_describeStatement10281);
									ksK=unreserved_keyword();
									state._fsp--;
									if (state.failed) return stmt;
									if ( state.backtracking==0 ) { gen.setKeyspace(ksK, false);}
									}
									break;

							}

							match(input,216,FOLLOW_216_in_describeStatement10296); if (state.failed) return stmt;
							}
							break;

					}

					// Parser.g:1437:9: (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword )
					int alt201=3;
					switch ( input.LA(1) ) {
					case IDENT:
						{
						alt201=1;
						}
						break;
					case QUOTED_NAME:
						{
						alt201=2;
						}
						break;
					case K_ACCESS:
					case K_AGGREGATE:
					case K_AGGREGATES:
					case K_ALL:
					case K_ANN:
					case K_AS:
					case K_ASCII:
					case K_BIGINT:
					case K_BLOB:
					case K_BOOLEAN:
					case K_CALLED:
					case K_CAST:
					case K_CIDRS:
					case K_CLUSTER:
					case K_CLUSTERING:
					case K_COMPACT:
					case K_CONTAINS:
					case K_COUNT:
					case K_COUNTER:
					case K_CUSTOM:
					case K_DATACENTERS:
					case K_DATE:
					case K_DECIMAL:
					case K_DEFAULT:
					case K_DISTINCT:
					case K_DOUBLE:
					case K_DURATION:
					case K_EXISTS:
					case K_FILTERING:
					case K_FINALFUNC:
					case K_FLOAT:
					case K_FROZEN:
					case K_FUNCTION:
					case K_FUNCTIONS:
					case K_GROUP:
					case K_HASHED:
					case K_IDENTITY:
					case K_INET:
					case K_INITCOND:
					case K_INPUT:
					case K_INT:
					case K_INTERNALS:
					case K_JSON:
					case K_KEY:
					case K_KEYS:
					case K_KEYSPACES:
					case K_LANGUAGE:
					case K_LIKE:
					case K_LIST:
					case K_LOGIN:
					case K_MAP:
					case K_MASKED:
					case K_MAXWRITETIME:
					case K_MBEAN:
					case K_MBEANS:
					case K_NOLOGIN:
					case K_NOSUPERUSER:
					case K_ONLY:
					case K_OPTIONS:
					case K_PARTITION:
					case K_PASSWORD:
					case K_PER:
					case K_PERMISSION:
					case K_PERMISSIONS:
					case K_REPLACE:
					case K_RETURNS:
					case K_ROLE:
					case K_ROLES:
					case K_SELECT_MASKED:
					case K_SFUNC:
					case K_SMALLINT:
					case K_STATIC:
					case K_STORAGE:
					case K_STYPE:
					case K_SUPERUSER:
					case K_TABLES:
					case K_TEXT:
					case K_TIME:
					case K_TIMESTAMP:
					case K_TIMEUUID:
					case K_TINYINT:
					case K_TRIGGER:
					case K_TTL:
					case K_TUPLE:
					case K_TYPE:
					case K_TYPES:
					case K_UNMASK:
					case K_UNSET:
					case K_USER:
					case K_USERS:
					case K_UUID:
					case K_VALUES:
					case K_VARCHAR:
					case K_VARINT:
					case K_VECTOR:
					case K_WRITETIME:
						{
						alt201=3;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return stmt;}
						NoViableAltException nvae =
							new NoViableAltException("", 201, 0, input);
						throw nvae;
					}
					switch (alt201) {
						case 1 :
							// Parser.g:1437:11: tT= IDENT
							{
							tT=(Token)match(input,IDENT,FOLLOW_IDENT_in_describeStatement10313); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { gen.setName((tT!=null?tT.getText():null), false);}
							}
							break;
						case 2 :
							// Parser.g:1438:11: tT= QUOTED_NAME
							{
							tT=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_describeStatement10354); if (state.failed) return stmt;
							if ( state.backtracking==0 ) { gen.setName((tT!=null?tT.getText():null), true);}
							}
							break;
						case 3 :
							// Parser.g:1439:11: tK= unreserved_keyword
							{
							pushFollow(FOLLOW_unreserved_keyword_in_describeStatement10389);
							tK=unreserved_keyword();
							state._fsp--;
							if (state.failed) return stmt;
							if ( state.backtracking==0 ) { gen.setName(tK, false);}
							}
							break;

					}

					if ( state.backtracking==0 ) { stmt = DescribeStatement.generic(gen.getKeyspace(), gen.getName()); }
					}
					break;

			}

			// Parser.g:1442:5: ( K_WITH K_INTERNALS )?
			int alt203=2;
			int LA203_0 = input.LA(1);
			if ( (LA203_0==K_WITH) ) {
				alt203=1;
			}
			switch (alt203) {
				case 1 :
					// Parser.g:1442:7: K_WITH K_INTERNALS
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_describeStatement10473); if (state.failed) return stmt;
					match(input,K_INTERNALS,FOLLOW_K_INTERNALS_in_describeStatement10475); if (state.failed) return stmt;
					if ( state.backtracking==0 ) { stmt.withInternalDetails(); }
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "describeStatement"



	// $ANTLR start "cident"
	// Parser.g:1449:1: cident returns [ColumnIdentifier id] : ( EMPTY_QUOTED_NAME |t= ident );
	public final ColumnIdentifier cident() throws RecognitionException {
		ColumnIdentifier id = null;


		ColumnIdentifier t =null;

		try {
			// Parser.g:1450:5: ( EMPTY_QUOTED_NAME |t= ident )
			int alt204=2;
			int LA204_0 = input.LA(1);
			if ( (LA204_0==EMPTY_QUOTED_NAME) ) {
				alt204=1;
			}
			else if ( (LA204_0==IDENT||LA204_0==K_ACCESS||(LA204_0 >= K_AGGREGATE && LA204_0 <= K_ALL)||LA204_0==K_ANN||LA204_0==K_AS||LA204_0==K_ASCII||(LA204_0 >= K_BIGINT && LA204_0 <= K_BOOLEAN)||(LA204_0 >= K_CALLED && LA204_0 <= K_CLUSTERING)||(LA204_0 >= K_COMPACT && LA204_0 <= K_COUNTER)||(LA204_0 >= K_CUSTOM && LA204_0 <= K_DEFAULT)||(LA204_0 >= K_DISTINCT && LA204_0 <= K_DOUBLE)||LA204_0==K_DURATION||(LA204_0 >= K_EXISTS && LA204_0 <= K_FLOAT)||LA204_0==K_FROZEN||(LA204_0 >= K_FUNCTION && LA204_0 <= K_FUNCTIONS)||(LA204_0 >= K_GROUP && LA204_0 <= K_IDENTITY)||(LA204_0 >= K_INET && LA204_0 <= K_INPUT)||(LA204_0 >= K_INT && LA204_0 <= K_INTERNALS)||(LA204_0 >= K_JSON && LA204_0 <= K_KEYS)||(LA204_0 >= K_KEYSPACES && LA204_0 <= K_LIKE)||(LA204_0 >= K_LIST && LA204_0 <= K_MASKED)||(LA204_0 >= K_MAXWRITETIME && LA204_0 <= K_MBEANS)||LA204_0==K_NOLOGIN||LA204_0==K_NOSUPERUSER||(LA204_0 >= K_ONLY && LA204_0 <= K_OPTIONS)||(LA204_0 >= K_PARTITION && LA204_0 <= K_PERMISSIONS)||(LA204_0 >= K_REPLACE && LA204_0 <= K_RETURNS)||(LA204_0 >= K_ROLE && LA204_0 <= K_ROLES)||LA204_0==K_SELECT_MASKED||(LA204_0 >= K_SFUNC && LA204_0 <= K_TINYINT)||LA204_0==K_TRIGGER||(LA204_0 >= K_TTL && LA204_0 <= K_TYPES)||(LA204_0 >= K_UNMASK && LA204_0 <= K_UNSET)||(LA204_0 >= K_USER && LA204_0 <= K_USERS)||(LA204_0 >= K_UUID && LA204_0 <= K_VECTOR)||LA204_0==K_WRITETIME||LA204_0==QUOTED_NAME) ) {
				alt204=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return id;}
				NoViableAltException nvae =
					new NoViableAltException("", 204, 0, input);
				throw nvae;
			}

			switch (alt204) {
				case 1 :
					// Parser.g:1450:7: EMPTY_QUOTED_NAME
					{
					match(input,EMPTY_QUOTED_NAME,FOLLOW_EMPTY_QUOTED_NAME_in_cident10506); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = ColumnIdentifier.getInterned("", true); }
					}
					break;
				case 2 :
					// Parser.g:1451:7: t= ident
					{
					pushFollow(FOLLOW_ident_in_cident10521);
					t=ident();
					state._fsp--;
					if (state.failed) return id;
					if ( state.backtracking==0 ) { id = t; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "cident"



	// $ANTLR start "ident"
	// Parser.g:1454:1: ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// Parser.g:1455:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt205=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt205=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt205=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt205=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return id;}
				NoViableAltException nvae =
					new NoViableAltException("", 205, 0, input);
				throw nvae;
			}
			switch (alt205) {
				case 1 :
					// Parser.g:1455:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ident10559); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = ColumnIdentifier.getInterned((t!=null?t.getText():null), false); }
					}
					break;
				case 2 :
					// Parser.g:1456:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ident10584); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = ColumnIdentifier.getInterned((t!=null?t.getText():null), true); }
					}
					break;
				case 3 :
					// Parser.g:1457:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ident10603);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return id;
					if ( state.backtracking==0 ) { id = ColumnIdentifier.getInterned(k, false); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "ident"



	// $ANTLR start "fident"
	// Parser.g:1460:1: fident returns [FieldIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final FieldIdentifier fident() throws RecognitionException {
		FieldIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// Parser.g:1461:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt206=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt206=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt206=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt206=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return id;}
				NoViableAltException nvae =
					new NoViableAltException("", 206, 0, input);
				throw nvae;
			}
			switch (alt206) {
				case 1 :
					// Parser.g:1461:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_fident10628); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = FieldIdentifier.forUnquoted((t!=null?t.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:1462:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_fident10653); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = FieldIdentifier.forQuoted((t!=null?t.getText():null)); }
					}
					break;
				case 3 :
					// Parser.g:1463:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_fident10672);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return id;
					if ( state.backtracking==0 ) { id = FieldIdentifier.forUnquoted(k); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "fident"



	// $ANTLR start "noncol_ident"
	// Parser.g:1467:1: noncol_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier noncol_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// Parser.g:1468:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt207=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt207=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt207=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt207=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return id;}
				NoViableAltException nvae =
					new NoViableAltException("", 207, 0, input);
				throw nvae;
			}
			switch (alt207) {
				case 1 :
					// Parser.g:1468:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_noncol_ident10698); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = new ColumnIdentifier((t!=null?t.getText():null), false); }
					}
					break;
				case 2 :
					// Parser.g:1469:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_noncol_ident10723); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = new ColumnIdentifier((t!=null?t.getText():null), true); }
					}
					break;
				case 3 :
					// Parser.g:1470:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_noncol_ident10742);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return id;
					if ( state.backtracking==0 ) { id = new ColumnIdentifier(k, false); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "noncol_ident"



	// $ANTLR start "keyspaceName"
	// Parser.g:1474:1: keyspaceName returns [String id] : ksName[name] ;
	public final String keyspaceName() throws RecognitionException {
		String id = null;


		 QualifiedName name = new QualifiedName(); 
		try {
			// Parser.g:1476:5: ( ksName[name] )
			// Parser.g:1476:7: ksName[name]
			{
			pushFollow(FOLLOW_ksName_in_keyspaceName10775);
			ksName(name);
			state._fsp--;
			if (state.failed) return id;
			if ( state.backtracking==0 ) { id = name.getKeyspace(); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "keyspaceName"



	// $ANTLR start "indexName"
	// Parser.g:1479:1: indexName returns [QualifiedName name] : ( ksName[name] '.' )? idxName[name] ;
	public final QualifiedName indexName() throws RecognitionException {
		QualifiedName name = null;


		 name = new QualifiedName(); 
		try {
			// Parser.g:1481:5: ( ( ksName[name] '.' )? idxName[name] )
			// Parser.g:1481:7: ( ksName[name] '.' )? idxName[name]
			{
			// Parser.g:1481:7: ( ksName[name] '.' )?
			int alt208=2;
			alt208 = dfa208.predict(input);
			switch (alt208) {
				case 1 :
					// Parser.g:1481:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_indexName10809);
					ksName(name);
					state._fsp--;
					if (state.failed) return name;
					match(input,216,FOLLOW_216_in_indexName10812); if (state.failed) return name;
					}
					break;

			}

			pushFollow(FOLLOW_idxName_in_indexName10816);
			idxName(name);
			state._fsp--;
			if (state.failed) return name;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "indexName"



	// $ANTLR start "columnFamilyName"
	// Parser.g:1484:1: columnFamilyName returns [QualifiedName name] : ( ksName[name] '.' )? cfName[name] ;
	public final QualifiedName columnFamilyName() throws RecognitionException {
		QualifiedName name = null;


		 name = new QualifiedName(); 
		try {
			// Parser.g:1486:5: ( ( ksName[name] '.' )? cfName[name] )
			// Parser.g:1486:7: ( ksName[name] '.' )? cfName[name]
			{
			// Parser.g:1486:7: ( ksName[name] '.' )?
			int alt209=2;
			alt209 = dfa209.predict(input);
			switch (alt209) {
				case 1 :
					// Parser.g:1486:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_columnFamilyName10848);
					ksName(name);
					state._fsp--;
					if (state.failed) return name;
					match(input,216,FOLLOW_216_in_columnFamilyName10851); if (state.failed) return name;
					}
					break;

			}

			pushFollow(FOLLOW_cfName_in_columnFamilyName10855);
			cfName(name);
			state._fsp--;
			if (state.failed) return name;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "columnFamilyName"



	// $ANTLR start "userTypeName"
	// Parser.g:1489:1: userTypeName returns [UTName name] : (ks= noncol_ident '.' )? ut= non_type_ident ;
	public final UTName userTypeName() throws RecognitionException {
		UTName name = null;


		ColumnIdentifier ks =null;
		ColumnIdentifier ut =null;

		try {
			// Parser.g:1490:5: ( (ks= noncol_ident '.' )? ut= non_type_ident )
			// Parser.g:1490:7: (ks= noncol_ident '.' )? ut= non_type_ident
			{
			// Parser.g:1490:7: (ks= noncol_ident '.' )?
			int alt210=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA210_1 = input.LA(2);
					if ( (LA210_1==216) ) {
						alt210=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA210_2 = input.LA(2);
					if ( (LA210_2==216) ) {
						alt210=1;
					}
					}
					break;
				case K_ACCESS:
				case K_AGGREGATE:
				case K_AGGREGATES:
				case K_ALL:
				case K_ANN:
				case K_AS:
				case K_CALLED:
				case K_CIDRS:
				case K_CLUSTER:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DATACENTERS:
				case K_DEFAULT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FINALFUNC:
				case K_FROZEN:
				case K_FUNCTION:
				case K_FUNCTIONS:
				case K_GROUP:
				case K_HASHED:
				case K_IDENTITY:
				case K_INITCOND:
				case K_INPUT:
				case K_INTERNALS:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LANGUAGE:
				case K_LIKE:
				case K_LIST:
				case K_LOGIN:
				case K_MAP:
				case K_MASKED:
				case K_MBEAN:
				case K_MBEANS:
				case K_NOLOGIN:
				case K_NOSUPERUSER:
				case K_ONLY:
				case K_OPTIONS:
				case K_PARTITION:
				case K_PASSWORD:
				case K_PER:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_REPLACE:
				case K_RETURNS:
				case K_ROLE:
				case K_ROLES:
				case K_SELECT_MASKED:
				case K_SFUNC:
				case K_STATIC:
				case K_STORAGE:
				case K_STYPE:
				case K_SUPERUSER:
				case K_TABLES:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_TYPES:
				case K_UNMASK:
				case K_UNSET:
				case K_USER:
				case K_USERS:
				case K_VALUES:
				case K_VECTOR:
					{
					int LA210_3 = input.LA(2);
					if ( (LA210_3==216) ) {
						alt210=1;
					}
					}
					break;
				case K_ASCII:
				case K_BIGINT:
				case K_BLOB:
				case K_BOOLEAN:
				case K_CAST:
				case K_COUNT:
				case K_COUNTER:
				case K_DATE:
				case K_DECIMAL:
				case K_DISTINCT:
				case K_DOUBLE:
				case K_DURATION:
				case K_FLOAT:
				case K_INET:
				case K_INT:
				case K_JSON:
				case K_MAXWRITETIME:
				case K_SMALLINT:
				case K_TEXT:
				case K_TIME:
				case K_TIMESTAMP:
				case K_TIMEUUID:
				case K_TINYINT:
				case K_TTL:
				case K_UUID:
				case K_VARCHAR:
				case K_VARINT:
				case K_WRITETIME:
					{
					alt210=1;
					}
					break;
				case K_KEY:
					{
					int LA210_5 = input.LA(2);
					if ( (LA210_5==216) ) {
						alt210=1;
					}
					}
					break;
			}
			switch (alt210) {
				case 1 :
					// Parser.g:1490:8: ks= noncol_ident '.'
					{
					pushFollow(FOLLOW_noncol_ident_in_userTypeName10880);
					ks=noncol_ident();
					state._fsp--;
					if (state.failed) return name;
					match(input,216,FOLLOW_216_in_userTypeName10882); if (state.failed) return name;
					}
					break;

			}

			pushFollow(FOLLOW_non_type_ident_in_userTypeName10888);
			ut=non_type_ident();
			state._fsp--;
			if (state.failed) return name;
			if ( state.backtracking==0 ) { name = new UTName(ks, ut); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userTypeName"



	// $ANTLR start "userOrRoleName"
	// Parser.g:1493:1: userOrRoleName returns [RoleName name] : roleName[role] ;
	public final RoleName userOrRoleName() throws RecognitionException {
		RoleName name = null;


		 RoleName role = new RoleName(); 
		try {
			// Parser.g:1495:5: ( roleName[role] )
			// Parser.g:1495:7: roleName[role]
			{
			pushFollow(FOLLOW_roleName_in_userOrRoleName10920);
			roleName(role);
			state._fsp--;
			if (state.failed) return name;
			if ( state.backtracking==0 ) {name = role;}
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userOrRoleName"



	// $ANTLR start "ksName"
	// Parser.g:1498:1: ksName[QualifiedName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void ksName(QualifiedName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// Parser.g:1499:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt211=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt211=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt211=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt211=3;
				}
				break;
			case QMARK:
				{
				alt211=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 211, 0, input);
				throw nvae;
			}
			switch (alt211) {
				case 1 :
					// Parser.g:1499:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ksName10943); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setKeyspace((t!=null?t.getText():null), false);}
					}
					break;
				case 2 :
					// Parser.g:1500:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ksName10968); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setKeyspace((t!=null?t.getText():null), true);}
					}
					break;
				case 3 :
					// Parser.g:1501:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ksName10987);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { name.setKeyspace(k, false);}
					}
					break;
				case 4 :
					// Parser.g:1502:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_ksName10997); if (state.failed) return;
					if ( state.backtracking==0 ) {addRecognitionError("Bind variables cannot be used for keyspace names");}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ksName"



	// $ANTLR start "cfName"
	// Parser.g:1505:1: cfName[QualifiedName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void cfName(QualifiedName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// Parser.g:1506:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt212=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt212=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt212=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt212=3;
				}
				break;
			case QMARK:
				{
				alt212=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 212, 0, input);
				throw nvae;
			}
			switch (alt212) {
				case 1 :
					// Parser.g:1506:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfName11019); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((t!=null?t.getText():null), false); }
					}
					break;
				case 2 :
					// Parser.g:1507:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfName11044); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((t!=null?t.getText():null), true); }
					}
					break;
				case 3 :
					// Parser.g:1508:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cfName11063);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName(k, false); }
					}
					break;
				case 4 :
					// Parser.g:1509:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_cfName11073); if (state.failed) return;
					if ( state.backtracking==0 ) {addRecognitionError("Bind variables cannot be used for table names");}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfName"



	// $ANTLR start "idxName"
	// Parser.g:1512:1: idxName[QualifiedName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void idxName(QualifiedName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// Parser.g:1513:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt213=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt213=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt213=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt213=3;
				}
				break;
			case QMARK:
				{
				alt213=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 213, 0, input);
				throw nvae;
			}
			switch (alt213) {
				case 1 :
					// Parser.g:1513:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_idxName11095); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((t!=null?t.getText():null), false); }
					}
					break;
				case 2 :
					// Parser.g:1514:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_idxName11120); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((t!=null?t.getText():null), true);}
					}
					break;
				case 3 :
					// Parser.g:1515:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_idxName11139);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName(k, false); }
					}
					break;
				case 4 :
					// Parser.g:1516:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_idxName11149); if (state.failed) return;
					if ( state.backtracking==0 ) {addRecognitionError("Bind variables cannot be used for index names");}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "idxName"



	// $ANTLR start "roleName"
	// Parser.g:1519:1: roleName[RoleName name] : (t= IDENT |s= STRING_LITERAL |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void roleName(RoleName name) throws RecognitionException {
		Token t=null;
		Token s=null;
		String k =null;

		try {
			// Parser.g:1520:5: (t= IDENT |s= STRING_LITERAL |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt214=5;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt214=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt214=2;
				}
				break;
			case QUOTED_NAME:
				{
				alt214=3;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CAST:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MAXWRITETIME:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
			case K_WRITETIME:
				{
				alt214=4;
				}
				break;
			case QMARK:
				{
				alt214=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 214, 0, input);
				throw nvae;
			}
			switch (alt214) {
				case 1 :
					// Parser.g:1520:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_roleName11171); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((t!=null?t.getText():null), false); }
					}
					break;
				case 2 :
					// Parser.g:1521:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_roleName11196); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((s!=null?s.getText():null), true); }
					}
					break;
				case 3 :
					// Parser.g:1522:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_roleName11212); if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName((t!=null?t.getText():null), true); }
					}
					break;
				case 4 :
					// Parser.g:1523:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_roleName11231);
					k=unreserved_keyword();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { name.setName(k, false); }
					}
					break;
				case 5 :
					// Parser.g:1524:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_roleName11241); if (state.failed) return;
					if ( state.backtracking==0 ) {addRecognitionError("Bind variables cannot be used for role names");}
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleName"



	// $ANTLR start "constant"
	// Parser.g:1527:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= DURATION |t= UUID |t= HEXNUMBER | ( ( K_POSITIVE_NAN | K_NEGATIVE_NAN ) | K_POSITIVE_INFINITY | K_NEGATIVE_INFINITY ) );
	public final Constants.Literal constant() throws RecognitionException {
		Constants.Literal constant = null;


		Token t=null;

		try {
			// Parser.g:1528:5: (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= DURATION |t= UUID |t= HEXNUMBER | ( ( K_POSITIVE_NAN | K_NEGATIVE_NAN ) | K_POSITIVE_INFINITY | K_NEGATIVE_INFINITY ) )
			int alt216=8;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt216=1;
				}
				break;
			case INTEGER:
				{
				alt216=2;
				}
				break;
			case FLOAT:
				{
				alt216=3;
				}
				break;
			case BOOLEAN:
				{
				alt216=4;
				}
				break;
			case DURATION:
				{
				alt216=5;
				}
				break;
			case UUID:
				{
				alt216=6;
				}
				break;
			case HEXNUMBER:
				{
				alt216=7;
				}
				break;
			case K_NEGATIVE_INFINITY:
			case K_NEGATIVE_NAN:
			case K_POSITIVE_INFINITY:
			case K_POSITIVE_NAN:
				{
				alt216=8;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return constant;}
				NoViableAltException nvae =
					new NoViableAltException("", 216, 0, input);
				throw nvae;
			}
			switch (alt216) {
				case 1 :
					// Parser.g:1528:7: t= STRING_LITERAL
					{
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant11266); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.string((t!=null?t.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:1529:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant11278); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.integer((t!=null?t.getText():null)); }
					}
					break;
				case 3 :
					// Parser.g:1530:7: t= FLOAT
					{
					t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant11297); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); }
					}
					break;
				case 4 :
					// Parser.g:1531:7: t= BOOLEAN
					{
					t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant11318); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.bool((t!=null?t.getText():null)); }
					}
					break;
				case 5 :
					// Parser.g:1532:7: t= DURATION
					{
					t=(Token)match(input,DURATION,FOLLOW_DURATION_in_constant11337); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.duration((t!=null?t.getText():null));}
					}
					break;
				case 6 :
					// Parser.g:1533:7: t= UUID
					{
					t=(Token)match(input,UUID,FOLLOW_UUID_in_constant11355); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.uuid((t!=null?t.getText():null)); }
					}
					break;
				case 7 :
					// Parser.g:1534:7: t= HEXNUMBER
					{
					t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant11377); if (state.failed) return constant;
					if ( state.backtracking==0 ) { constant = Constants.Literal.hex((t!=null?t.getText():null)); }
					}
					break;
				case 8 :
					// Parser.g:1535:7: ( ( K_POSITIVE_NAN | K_NEGATIVE_NAN ) | K_POSITIVE_INFINITY | K_NEGATIVE_INFINITY )
					{
					// Parser.g:1535:7: ( ( K_POSITIVE_NAN | K_NEGATIVE_NAN ) | K_POSITIVE_INFINITY | K_NEGATIVE_INFINITY )
					int alt215=3;
					switch ( input.LA(1) ) {
					case K_NEGATIVE_NAN:
					case K_POSITIVE_NAN:
						{
						alt215=1;
						}
						break;
					case K_POSITIVE_INFINITY:
						{
						alt215=2;
						}
						break;
					case K_NEGATIVE_INFINITY:
						{
						alt215=3;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return constant;}
						NoViableAltException nvae =
							new NoViableAltException("", 215, 0, input);
						throw nvae;
					}
					switch (alt215) {
						case 1 :
							// Parser.g:1535:8: ( K_POSITIVE_NAN | K_NEGATIVE_NAN )
							{
							if ( input.LA(1)==K_NEGATIVE_NAN||input.LA(1)==K_POSITIVE_NAN ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return constant;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							if ( state.backtracking==0 ) { constant = Constants.Literal.floatingPoint("NaN"); }
							}
							break;
						case 2 :
							// Parser.g:1536:11: K_POSITIVE_INFINITY
							{
							match(input,K_POSITIVE_INFINITY,FOLLOW_K_POSITIVE_INFINITY_in_constant11413); if (state.failed) return constant;
							if ( state.backtracking==0 ) { constant = Constants.Literal.floatingPoint("Infinity"); }
							}
							break;
						case 3 :
							// Parser.g:1537:11: K_NEGATIVE_INFINITY
							{
							match(input,K_NEGATIVE_INFINITY,FOLLOW_K_NEGATIVE_INFINITY_in_constant11428); if (state.failed) return constant;
							if ( state.backtracking==0 ) { constant = Constants.Literal.floatingPoint("-Infinity"); }
							}
							break;

					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return constant;
	}
	// $ANTLR end "constant"



	// $ANTLR start "fullMapLiteral"
	// Parser.g:1540:1: fullMapLiteral returns [Maps.Literal map] : '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' ;
	public final Maps.Literal fullMapLiteral() throws RecognitionException {
		Maps.Literal map = null;


		Term.Raw k1 =null;
		Term.Raw v1 =null;
		Term.Raw kn =null;
		Term.Raw vn =null;

		 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>();
		try {
			// Parser.g:1543:5: ( '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' )
			// Parser.g:1543:7: '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}'
			{
			match(input,229,FOLLOW_229_in_fullMapLiteral11469); if (state.failed) return map;
			// Parser.g:1543:11: (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )?
			int alt218=2;
			int LA218_0 = input.LA(1);
			if ( (LA218_0==BOOLEAN||LA218_0==DURATION||LA218_0==FLOAT||LA218_0==HEXNUMBER||(LA218_0 >= IDENT && LA218_0 <= INTEGER)||LA218_0==K_ACCESS||(LA218_0 >= K_AGGREGATE && LA218_0 <= K_ALL)||LA218_0==K_ANN||LA218_0==K_AS||LA218_0==K_ASCII||(LA218_0 >= K_BIGINT && LA218_0 <= K_BOOLEAN)||(LA218_0 >= K_CALLED && LA218_0 <= K_CLUSTERING)||(LA218_0 >= K_COMPACT && LA218_0 <= K_COUNTER)||(LA218_0 >= K_CUSTOM && LA218_0 <= K_DEFAULT)||(LA218_0 >= K_DISTINCT && LA218_0 <= K_DOUBLE)||LA218_0==K_DURATION||(LA218_0 >= K_EXISTS && LA218_0 <= K_FLOAT)||LA218_0==K_FROZEN||(LA218_0 >= K_FUNCTION && LA218_0 <= K_FUNCTIONS)||(LA218_0 >= K_GROUP && LA218_0 <= K_IDENTITY)||(LA218_0 >= K_INET && LA218_0 <= K_INPUT)||(LA218_0 >= K_INT && LA218_0 <= K_INTERNALS)||(LA218_0 >= K_JSON && LA218_0 <= K_KEYS)||(LA218_0 >= K_KEYSPACES && LA218_0 <= K_LIKE)||(LA218_0 >= K_LIST && LA218_0 <= K_MASKED)||(LA218_0 >= K_MAXWRITETIME && LA218_0 <= K_MBEANS)||(LA218_0 >= K_NEGATIVE_INFINITY && LA218_0 <= K_NOLOGIN)||LA218_0==K_NOSUPERUSER||LA218_0==K_NULL||(LA218_0 >= K_ONLY && LA218_0 <= K_OPTIONS)||(LA218_0 >= K_PARTITION && LA218_0 <= K_POSITIVE_NAN)||(LA218_0 >= K_REPLACE && LA218_0 <= K_RETURNS)||(LA218_0 >= K_ROLE && LA218_0 <= K_ROLES)||LA218_0==K_SELECT_MASKED||(LA218_0 >= K_SFUNC && LA218_0 <= K_TINYINT)||(LA218_0 >= K_TOKEN && LA218_0 <= K_TRIGGER)||(LA218_0 >= K_TTL && LA218_0 <= K_TYPES)||(LA218_0 >= K_UNMASK && LA218_0 <= K_UNSET)||(LA218_0 >= K_USER && LA218_0 <= K_USERS)||(LA218_0 >= K_UUID && LA218_0 <= K_VECTOR)||LA218_0==K_WRITETIME||(LA218_0 >= QMARK && LA218_0 <= QUOTED_NAME)||LA218_0==STRING_LITERAL||LA218_0==UUID||LA218_0==209||LA218_0==214||LA218_0==218||LA218_0==225||LA218_0==229) ) {
				alt218=1;
			}
			switch (alt218) {
				case 1 :
					// Parser.g:1543:13: k1= term ':' v1= term ( ',' kn= term ':' vn= term )*
					{
					pushFollow(FOLLOW_term_in_fullMapLiteral11475);
					k1=term();
					state._fsp--;
					if (state.failed) return map;
					match(input,218,FOLLOW_218_in_fullMapLiteral11477); if (state.failed) return map;
					pushFollow(FOLLOW_term_in_fullMapLiteral11481);
					v1=term();
					state._fsp--;
					if (state.failed) return map;
					if ( state.backtracking==0 ) { m.add(Pair.create(k1, v1)); }
					// Parser.g:1543:65: ( ',' kn= term ':' vn= term )*
					loop217:
					while (true) {
						int alt217=2;
						int LA217_0 = input.LA(1);
						if ( (LA217_0==213) ) {
							alt217=1;
						}

						switch (alt217) {
						case 1 :
							// Parser.g:1543:67: ',' kn= term ':' vn= term
							{
							match(input,213,FOLLOW_213_in_fullMapLiteral11487); if (state.failed) return map;
							pushFollow(FOLLOW_term_in_fullMapLiteral11491);
							kn=term();
							state._fsp--;
							if (state.failed) return map;
							match(input,218,FOLLOW_218_in_fullMapLiteral11493); if (state.failed) return map;
							pushFollow(FOLLOW_term_in_fullMapLiteral11497);
							vn=term();
							state._fsp--;
							if (state.failed) return map;
							if ( state.backtracking==0 ) { m.add(Pair.create(kn, vn)); }
							}
							break;

						default :
							break loop217;
						}
					}

					}
					break;

			}

			match(input,230,FOLLOW_230_in_fullMapLiteral11513); if (state.failed) return map;
			}

			if ( state.backtracking==0 ) { map = new Maps.Literal(m); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return map;
	}
	// $ANTLR end "fullMapLiteral"



	// $ANTLR start "setOrMapLiteral"
	// Parser.g:1547:1: setOrMapLiteral[Term.Raw t] returns [Term.Raw value] : (m= mapLiteral[t] |s= setLiteral[t] );
	public final Term.Raw setOrMapLiteral(Term.Raw t) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw m =null;
		Term.Raw s =null;

		try {
			// Parser.g:1548:5: (m= mapLiteral[t] |s= setLiteral[t] )
			int alt219=2;
			int LA219_0 = input.LA(1);
			if ( (LA219_0==218) ) {
				alt219=1;
			}
			else if ( (LA219_0==213||LA219_0==230) ) {
				alt219=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return value;}
				NoViableAltException nvae =
					new NoViableAltException("", 219, 0, input);
				throw nvae;
			}

			switch (alt219) {
				case 1 :
					// Parser.g:1548:7: m= mapLiteral[t]
					{
					pushFollow(FOLLOW_mapLiteral_in_setOrMapLiteral11537);
					m=mapLiteral(t);
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value =m; }
					}
					break;
				case 2 :
					// Parser.g:1549:7: s= setLiteral[t]
					{
					pushFollow(FOLLOW_setLiteral_in_setOrMapLiteral11550);
					s=setLiteral(t);
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value =s; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setOrMapLiteral"



	// $ANTLR start "setLiteral"
	// Parser.g:1552:1: setLiteral[Term.Raw t] returns [Term.Raw value] : ( ',' tn= term )* ;
	public final Term.Raw setLiteral(Term.Raw t) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw tn =null;

		 List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
		try {
			// Parser.g:1555:5: ( ( ',' tn= term )* )
			// Parser.g:1555:7: ( ',' tn= term )*
			{
			// Parser.g:1555:7: ( ',' tn= term )*
			loop220:
			while (true) {
				int alt220=2;
				int LA220_0 = input.LA(1);
				if ( (LA220_0==213) ) {
					alt220=1;
				}

				switch (alt220) {
				case 1 :
					// Parser.g:1555:9: ',' tn= term
					{
					match(input,213,FOLLOW_213_in_setLiteral11595); if (state.failed) return value;
					pushFollow(FOLLOW_term_in_setLiteral11599);
					tn=term();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { s.add(tn); }
					}
					break;

				default :
					break loop220;
				}
			}

			}

			if ( state.backtracking==0 ) { value = new Sets.Literal(s); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setLiteral"



	// $ANTLR start "mapLiteral"
	// Parser.g:1558:1: mapLiteral[Term.Raw k] returns [Term.Raw value] : ':' v= term ( ',' kn= term ':' vn= term )* ;
	public final Term.Raw mapLiteral(Term.Raw k) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw v =null;
		Term.Raw kn =null;
		Term.Raw vn =null;

		 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
		try {
			// Parser.g:1561:5: ( ':' v= term ( ',' kn= term ':' vn= term )* )
			// Parser.g:1561:7: ':' v= term ( ',' kn= term ':' vn= term )*
			{
			match(input,218,FOLLOW_218_in_mapLiteral11644); if (state.failed) return value;
			pushFollow(FOLLOW_term_in_mapLiteral11648);
			v=term();
			state._fsp--;
			if (state.failed) return value;
			if ( state.backtracking==0 ) {  m.add(Pair.create(k, v)); }
			// Parser.g:1561:49: ( ',' kn= term ':' vn= term )*
			loop221:
			while (true) {
				int alt221=2;
				int LA221_0 = input.LA(1);
				if ( (LA221_0==213) ) {
					alt221=1;
				}

				switch (alt221) {
				case 1 :
					// Parser.g:1561:51: ',' kn= term ':' vn= term
					{
					match(input,213,FOLLOW_213_in_mapLiteral11654); if (state.failed) return value;
					pushFollow(FOLLOW_term_in_mapLiteral11658);
					kn=term();
					state._fsp--;
					if (state.failed) return value;
					match(input,218,FOLLOW_218_in_mapLiteral11660); if (state.failed) return value;
					pushFollow(FOLLOW_term_in_mapLiteral11664);
					vn=term();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { m.add(Pair.create(kn, vn)); }
					}
					break;

				default :
					break loop221;
				}
			}

			}

			if ( state.backtracking==0 ) { value = new Maps.Literal(m); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "mapLiteral"



	// $ANTLR start "collectionLiteral"
	// Parser.g:1564:1: collectionLiteral returns [Term.Raw value] : (l= listLiteral | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' );
	public final Term.Raw collectionLiteral() throws RecognitionException {
		Term.Raw value = null;


		Term.Raw l =null;
		Term.Raw t =null;
		Term.Raw v =null;

		try {
			// Parser.g:1565:5: (l= listLiteral | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' )
			int alt222=3;
			int LA222_0 = input.LA(1);
			if ( (LA222_0==225) ) {
				alt222=1;
			}
			else if ( (LA222_0==229) ) {
				int LA222_2 = input.LA(2);
				if ( (LA222_2==230) ) {
					alt222=3;
				}
				else if ( (LA222_2==BOOLEAN||LA222_2==DURATION||LA222_2==FLOAT||LA222_2==HEXNUMBER||(LA222_2 >= IDENT && LA222_2 <= INTEGER)||LA222_2==K_ACCESS||(LA222_2 >= K_AGGREGATE && LA222_2 <= K_ALL)||LA222_2==K_ANN||LA222_2==K_AS||LA222_2==K_ASCII||(LA222_2 >= K_BIGINT && LA222_2 <= K_BOOLEAN)||(LA222_2 >= K_CALLED && LA222_2 <= K_CLUSTERING)||(LA222_2 >= K_COMPACT && LA222_2 <= K_COUNTER)||(LA222_2 >= K_CUSTOM && LA222_2 <= K_DEFAULT)||(LA222_2 >= K_DISTINCT && LA222_2 <= K_DOUBLE)||LA222_2==K_DURATION||(LA222_2 >= K_EXISTS && LA222_2 <= K_FLOAT)||LA222_2==K_FROZEN||(LA222_2 >= K_FUNCTION && LA222_2 <= K_FUNCTIONS)||(LA222_2 >= K_GROUP && LA222_2 <= K_IDENTITY)||(LA222_2 >= K_INET && LA222_2 <= K_INPUT)||(LA222_2 >= K_INT && LA222_2 <= K_INTERNALS)||(LA222_2 >= K_JSON && LA222_2 <= K_KEYS)||(LA222_2 >= K_KEYSPACES && LA222_2 <= K_LIKE)||(LA222_2 >= K_LIST && LA222_2 <= K_MASKED)||(LA222_2 >= K_MAXWRITETIME && LA222_2 <= K_MBEANS)||(LA222_2 >= K_NEGATIVE_INFINITY && LA222_2 <= K_NOLOGIN)||LA222_2==K_NOSUPERUSER||LA222_2==K_NULL||(LA222_2 >= K_ONLY && LA222_2 <= K_OPTIONS)||(LA222_2 >= K_PARTITION && LA222_2 <= K_POSITIVE_NAN)||(LA222_2 >= K_REPLACE && LA222_2 <= K_RETURNS)||(LA222_2 >= K_ROLE && LA222_2 <= K_ROLES)||LA222_2==K_SELECT_MASKED||(LA222_2 >= K_SFUNC && LA222_2 <= K_TINYINT)||(LA222_2 >= K_TOKEN && LA222_2 <= K_TRIGGER)||(LA222_2 >= K_TTL && LA222_2 <= K_TYPES)||(LA222_2 >= K_UNMASK && LA222_2 <= K_UNSET)||(LA222_2 >= K_USER && LA222_2 <= K_USERS)||(LA222_2 >= K_UUID && LA222_2 <= K_VECTOR)||LA222_2==K_WRITETIME||(LA222_2 >= QMARK && LA222_2 <= QUOTED_NAME)||LA222_2==STRING_LITERAL||LA222_2==UUID||LA222_2==209||LA222_2==214||LA222_2==218||LA222_2==225||LA222_2==229) ) {
					alt222=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return value;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 222, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return value;}
				NoViableAltException nvae =
					new NoViableAltException("", 222, 0, input);
				throw nvae;
			}

			switch (alt222) {
				case 1 :
					// Parser.g:1565:7: l= listLiteral
					{
					pushFollow(FOLLOW_listLiteral_in_collectionLiteral11692);
					l=listLiteral();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = l; }
					}
					break;
				case 2 :
					// Parser.g:1566:7: '{' t= term v= setOrMapLiteral[t] '}'
					{
					match(input,229,FOLLOW_229_in_collectionLiteral11702); if (state.failed) return value;
					pushFollow(FOLLOW_term_in_collectionLiteral11706);
					t=term();
					state._fsp--;
					if (state.failed) return value;
					pushFollow(FOLLOW_setOrMapLiteral_in_collectionLiteral11710);
					v=setOrMapLiteral(t);
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = v; }
					match(input,230,FOLLOW_230_in_collectionLiteral11715); if (state.failed) return value;
					}
					break;
				case 3 :
					// Parser.g:1569:7: '{' '}'
					{
					match(input,229,FOLLOW_229_in_collectionLiteral11733); if (state.failed) return value;
					match(input,230,FOLLOW_230_in_collectionLiteral11735); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = new Sets.Literal(Collections.<Term.Raw>emptyList()); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "collectionLiteral"



	// $ANTLR start "listLiteral"
	// Parser.g:1572:1: listLiteral returns [Term.Raw value] : '[' (t1= term ( ',' tn= term )* )? ']' ;
	public final Term.Raw listLiteral() throws RecognitionException {
		Term.Raw value = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		List<Term.Raw> l = new ArrayList<Term.Raw>();
		try {
			// Parser.g:1575:5: ( '[' (t1= term ( ',' tn= term )* )? ']' )
			// Parser.g:1575:7: '[' (t1= term ( ',' tn= term )* )? ']'
			{
			match(input,225,FOLLOW_225_in_listLiteral11776); if (state.failed) return value;
			// Parser.g:1575:11: (t1= term ( ',' tn= term )* )?
			int alt224=2;
			int LA224_0 = input.LA(1);
			if ( (LA224_0==BOOLEAN||LA224_0==DURATION||LA224_0==FLOAT||LA224_0==HEXNUMBER||(LA224_0 >= IDENT && LA224_0 <= INTEGER)||LA224_0==K_ACCESS||(LA224_0 >= K_AGGREGATE && LA224_0 <= K_ALL)||LA224_0==K_ANN||LA224_0==K_AS||LA224_0==K_ASCII||(LA224_0 >= K_BIGINT && LA224_0 <= K_BOOLEAN)||(LA224_0 >= K_CALLED && LA224_0 <= K_CLUSTERING)||(LA224_0 >= K_COMPACT && LA224_0 <= K_COUNTER)||(LA224_0 >= K_CUSTOM && LA224_0 <= K_DEFAULT)||(LA224_0 >= K_DISTINCT && LA224_0 <= K_DOUBLE)||LA224_0==K_DURATION||(LA224_0 >= K_EXISTS && LA224_0 <= K_FLOAT)||LA224_0==K_FROZEN||(LA224_0 >= K_FUNCTION && LA224_0 <= K_FUNCTIONS)||(LA224_0 >= K_GROUP && LA224_0 <= K_IDENTITY)||(LA224_0 >= K_INET && LA224_0 <= K_INPUT)||(LA224_0 >= K_INT && LA224_0 <= K_INTERNALS)||(LA224_0 >= K_JSON && LA224_0 <= K_KEYS)||(LA224_0 >= K_KEYSPACES && LA224_0 <= K_LIKE)||(LA224_0 >= K_LIST && LA224_0 <= K_MASKED)||(LA224_0 >= K_MAXWRITETIME && LA224_0 <= K_MBEANS)||(LA224_0 >= K_NEGATIVE_INFINITY && LA224_0 <= K_NOLOGIN)||LA224_0==K_NOSUPERUSER||LA224_0==K_NULL||(LA224_0 >= K_ONLY && LA224_0 <= K_OPTIONS)||(LA224_0 >= K_PARTITION && LA224_0 <= K_POSITIVE_NAN)||(LA224_0 >= K_REPLACE && LA224_0 <= K_RETURNS)||(LA224_0 >= K_ROLE && LA224_0 <= K_ROLES)||LA224_0==K_SELECT_MASKED||(LA224_0 >= K_SFUNC && LA224_0 <= K_TINYINT)||(LA224_0 >= K_TOKEN && LA224_0 <= K_TRIGGER)||(LA224_0 >= K_TTL && LA224_0 <= K_TYPES)||(LA224_0 >= K_UNMASK && LA224_0 <= K_UNSET)||(LA224_0 >= K_USER && LA224_0 <= K_USERS)||(LA224_0 >= K_UUID && LA224_0 <= K_VECTOR)||LA224_0==K_WRITETIME||(LA224_0 >= QMARK && LA224_0 <= QUOTED_NAME)||LA224_0==STRING_LITERAL||LA224_0==UUID||LA224_0==209||LA224_0==214||LA224_0==218||LA224_0==225||LA224_0==229) ) {
				alt224=1;
			}
			switch (alt224) {
				case 1 :
					// Parser.g:1575:13: t1= term ( ',' tn= term )*
					{
					pushFollow(FOLLOW_term_in_listLiteral11782);
					t1=term();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { l.add(t1); }
					// Parser.g:1575:36: ( ',' tn= term )*
					loop223:
					while (true) {
						int alt223=2;
						int LA223_0 = input.LA(1);
						if ( (LA223_0==213) ) {
							alt223=1;
						}

						switch (alt223) {
						case 1 :
							// Parser.g:1575:38: ',' tn= term
							{
							match(input,213,FOLLOW_213_in_listLiteral11788); if (state.failed) return value;
							pushFollow(FOLLOW_term_in_listLiteral11792);
							tn=term();
							state._fsp--;
							if (state.failed) return value;
							if ( state.backtracking==0 ) { l.add(tn); }
							}
							break;

						default :
							break loop223;
						}
					}

					}
					break;

			}

			match(input,227,FOLLOW_227_in_listLiteral11802); if (state.failed) return value;
			if ( state.backtracking==0 ) { value = new ArrayLiteral(l); }
			}

			if ( state.backtracking==0 ) {value = new ArrayLiteral(l);}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "listLiteral"



	// $ANTLR start "usertypeLiteral"
	// Parser.g:1578:1: usertypeLiteral returns [UserTypes.Literal ut] : '{' k1= fident ':' v1= term ( ',' kn= fident ':' vn= term )* '}' ;
	public final UserTypes.Literal usertypeLiteral() throws RecognitionException {
		UserTypes.Literal ut = null;


		FieldIdentifier k1 =null;
		Term.Raw v1 =null;
		FieldIdentifier kn =null;
		Term.Raw vn =null;

		 Map<FieldIdentifier, Term.Raw> m = new HashMap<>(); 
		try {
			// Parser.g:1582:5: ( '{' k1= fident ':' v1= term ( ',' kn= fident ':' vn= term )* '}' )
			// Parser.g:1582:7: '{' k1= fident ':' v1= term ( ',' kn= fident ':' vn= term )* '}'
			{
			match(input,229,FOLLOW_229_in_usertypeLiteral11846); if (state.failed) return ut;
			pushFollow(FOLLOW_fident_in_usertypeLiteral11850);
			k1=fident();
			state._fsp--;
			if (state.failed) return ut;
			match(input,218,FOLLOW_218_in_usertypeLiteral11852); if (state.failed) return ut;
			pushFollow(FOLLOW_term_in_usertypeLiteral11856);
			v1=term();
			state._fsp--;
			if (state.failed) return ut;
			if ( state.backtracking==0 ) { m.put(k1, v1); }
			// Parser.g:1582:52: ( ',' kn= fident ':' vn= term )*
			loop225:
			while (true) {
				int alt225=2;
				int LA225_0 = input.LA(1);
				if ( (LA225_0==213) ) {
					alt225=1;
				}

				switch (alt225) {
				case 1 :
					// Parser.g:1582:54: ',' kn= fident ':' vn= term
					{
					match(input,213,FOLLOW_213_in_usertypeLiteral11862); if (state.failed) return ut;
					pushFollow(FOLLOW_fident_in_usertypeLiteral11866);
					kn=fident();
					state._fsp--;
					if (state.failed) return ut;
					match(input,218,FOLLOW_218_in_usertypeLiteral11868); if (state.failed) return ut;
					pushFollow(FOLLOW_term_in_usertypeLiteral11872);
					vn=term();
					state._fsp--;
					if (state.failed) return ut;
					if ( state.backtracking==0 ) { m.put(kn, vn); }
					}
					break;

				default :
					break loop225;
				}
			}

			match(input,230,FOLLOW_230_in_usertypeLiteral11879); if (state.failed) return ut;
			}

			if ( state.backtracking==0 ) { ut = new UserTypes.Literal(m); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ut;
	}
	// $ANTLR end "usertypeLiteral"



	// $ANTLR start "tupleLiteral"
	// Parser.g:1585:1: tupleLiteral returns [Tuples.Literal tt] : '(' t1= term ( ',' tn= term )* ')' ;
	public final Tuples.Literal tupleLiteral() throws RecognitionException {
		Tuples.Literal tt = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
		try {
			// Parser.g:1588:5: ( '(' t1= term ( ',' tn= term )* ')' )
			// Parser.g:1588:7: '(' t1= term ( ',' tn= term )* ')'
			{
			match(input,209,FOLLOW_209_in_tupleLiteral11916); if (state.failed) return tt;
			pushFollow(FOLLOW_term_in_tupleLiteral11920);
			t1=term();
			state._fsp--;
			if (state.failed) return tt;
			if ( state.backtracking==0 ) { l.add(t1); }
			// Parser.g:1588:34: ( ',' tn= term )*
			loop226:
			while (true) {
				int alt226=2;
				int LA226_0 = input.LA(1);
				if ( (LA226_0==213) ) {
					alt226=1;
				}

				switch (alt226) {
				case 1 :
					// Parser.g:1588:36: ',' tn= term
					{
					match(input,213,FOLLOW_213_in_tupleLiteral11926); if (state.failed) return tt;
					pushFollow(FOLLOW_term_in_tupleLiteral11930);
					tn=term();
					state._fsp--;
					if (state.failed) return tt;
					if ( state.backtracking==0 ) { l.add(tn); }
					}
					break;

				default :
					break loop226;
				}
			}

			match(input,210,FOLLOW_210_in_tupleLiteral11937); if (state.failed) return tt;
			}

			if ( state.backtracking==0 ) { tt = new Tuples.Literal(l); }
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return tt;
	}
	// $ANTLR end "tupleLiteral"



	// $ANTLR start "value"
	// Parser.g:1591:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK );
	public final Term.Raw value() throws RecognitionException {
		Term.Raw value = null;


		Constants.Literal c =null;
		Term.Raw l =null;
		UserTypes.Literal u =null;
		Tuples.Literal t =null;
		ColumnIdentifier id =null;

		try {
			// Parser.g:1592:5: (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK )
			int alt227=7;
			alt227 = dfa227.predict(input);
			switch (alt227) {
				case 1 :
					// Parser.g:1592:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_value11960);
					c=constant();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = c; }
					}
					break;
				case 2 :
					// Parser.g:1593:7: l= collectionLiteral
					{
					pushFollow(FOLLOW_collectionLiteral_in_value11982);
					l=collectionLiteral();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = l; }
					}
					break;
				case 3 :
					// Parser.g:1594:7: u= usertypeLiteral
					{
					pushFollow(FOLLOW_usertypeLiteral_in_value11995);
					u=usertypeLiteral();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = u; }
					}
					break;
				case 4 :
					// Parser.g:1595:7: t= tupleLiteral
					{
					pushFollow(FOLLOW_tupleLiteral_in_value12010);
					t=tupleLiteral();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = t; }
					}
					break;
				case 5 :
					// Parser.g:1596:7: K_NULL
					{
					match(input,K_NULL,FOLLOW_K_NULL_in_value12026); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = Constants.NULL_LITERAL; }
					}
					break;
				case 6 :
					// Parser.g:1597:7: ':' id= noncol_ident
					{
					match(input,218,FOLLOW_218_in_value12050); if (state.failed) return value;
					pushFollow(FOLLOW_noncol_ident_in_value12054);
					id=noncol_ident();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newBindVariables(id); }
					}
					break;
				case 7 :
					// Parser.g:1598:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_value12065); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newBindVariables(null); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "value"



	// $ANTLR start "intValue"
	// Parser.g:1601:1: intValue returns [Term.Raw value] : (t= INTEGER | ':' id= noncol_ident | QMARK );
	public final Term.Raw intValue() throws RecognitionException {
		Term.Raw value = null;


		Token t=null;
		ColumnIdentifier id =null;

		try {
			// Parser.g:1602:5: (t= INTEGER | ':' id= noncol_ident | QMARK )
			int alt228=3;
			switch ( input.LA(1) ) {
			case INTEGER:
				{
				alt228=1;
				}
				break;
			case 218:
				{
				alt228=2;
				}
				break;
			case QMARK:
				{
				alt228=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return value;}
				NoViableAltException nvae =
					new NoViableAltException("", 228, 0, input);
				throw nvae;
			}
			switch (alt228) {
				case 1 :
					// Parser.g:1602:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue12105); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = Constants.Literal.integer((t!=null?t.getText():null)); }
					}
					break;
				case 2 :
					// Parser.g:1603:7: ':' id= noncol_ident
					{
					match(input,218,FOLLOW_218_in_intValue12119); if (state.failed) return value;
					pushFollow(FOLLOW_noncol_ident_in_intValue12123);
					id=noncol_ident();
					state._fsp--;
					if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newBindVariables(id); }
					}
					break;
				case 3 :
					// Parser.g:1604:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_intValue12134); if (state.failed) return value;
					if ( state.backtracking==0 ) { value = newBindVariables(null); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "intValue"



	// $ANTLR start "functionName"
	// Parser.g:1607:1: functionName returns [FunctionName s] : (ks= keyspaceName '.' )? f= allowedFunctionName ;
	public final FunctionName functionName() throws RecognitionException {
		FunctionName s = null;


		String ks =null;
		String f =null;

		try {
			// Parser.g:1610:5: ( (ks= keyspaceName '.' )? f= allowedFunctionName )
			// Parser.g:1610:7: (ks= keyspaceName '.' )? f= allowedFunctionName
			{
			// Parser.g:1610:7: (ks= keyspaceName '.' )?
			int alt229=2;
			alt229 = dfa229.predict(input);
			switch (alt229) {
				case 1 :
					// Parser.g:1610:8: ks= keyspaceName '.'
					{
					pushFollow(FOLLOW_keyspaceName_in_functionName12180);
					ks=keyspaceName();
					state._fsp--;
					if (state.failed) return s;
					match(input,216,FOLLOW_216_in_functionName12182); if (state.failed) return s;
					}
					break;

			}

			pushFollow(FOLLOW_allowedFunctionName_in_functionName12188);
			f=allowedFunctionName();
			state._fsp--;
			if (state.failed) return s;
			if ( state.backtracking==0 ) { s = f == null ? null : new FunctionName(ks, f); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "functionName"



	// $ANTLR start "allowedFunctionName"
	// Parser.g:1613:1: allowedFunctionName returns [String s] : (f= IDENT |f= QUOTED_NAME |u= unreserved_function_keyword | K_TOKEN | K_COUNT );
	public final String allowedFunctionName() throws RecognitionException {
		String s = null;


		Token f=null;
		String u =null;

		try {
			// Parser.g:1614:5: (f= IDENT |f= QUOTED_NAME |u= unreserved_function_keyword | K_TOKEN | K_COUNT )
			int alt230=5;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt230=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt230=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DATE:
			case K_DECIMAL:
			case K_DEFAULT:
			case K_DOUBLE:
			case K_DURATION:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_INTERNALS:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_VECTOR:
				{
				alt230=3;
				}
				break;
			case K_TOKEN:
				{
				alt230=4;
				}
				break;
			case K_COUNT:
				{
				alt230=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return s;}
				NoViableAltException nvae =
					new NoViableAltException("", 230, 0, input);
				throw nvae;
			}
			switch (alt230) {
				case 1 :
					// Parser.g:1614:7: f= IDENT
					{
					f=(Token)match(input,IDENT,FOLLOW_IDENT_in_allowedFunctionName12215); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = (f!=null?f.getText():null).toLowerCase(); }
					}
					break;
				case 2 :
					// Parser.g:1615:7: f= QUOTED_NAME
					{
					f=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_allowedFunctionName12249); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = (f!=null?f.getText():null); }
					}
					break;
				case 3 :
					// Parser.g:1616:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_allowedFunctionName12277);
					u=unreserved_function_keyword();
					state._fsp--;
					if (state.failed) return s;
					if ( state.backtracking==0 ) { s = u; }
					}
					break;
				case 4 :
					// Parser.g:1617:7: K_TOKEN
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_allowedFunctionName12287); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = "token"; }
					}
					break;
				case 5 :
					// Parser.g:1618:7: K_COUNT
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_allowedFunctionName12319); if (state.failed) return s;
					if ( state.backtracking==0 ) { s = "count"; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "allowedFunctionName"



	// $ANTLR start "function"
	// Parser.g:1621:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );
	public final Term.Raw function() throws RecognitionException {
		Term.Raw t = null;


		FunctionName f =null;
		List<Term.Raw> args =null;

		try {
			// Parser.g:1622:5: (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' )
			int alt231=2;
			alt231 = dfa231.predict(input);
			switch (alt231) {
				case 1 :
					// Parser.g:1622:7: f= functionName '(' ')'
					{
					pushFollow(FOLLOW_functionName_in_function12366);
					f=functionName();
					state._fsp--;
					if (state.failed) return t;
					match(input,209,FOLLOW_209_in_function12368); if (state.failed) return t;
					match(input,210,FOLLOW_210_in_function12370); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = new FunctionCall.Raw(f, Collections.<Term.Raw>emptyList()); }
					}
					break;
				case 2 :
					// Parser.g:1623:7: f= functionName '(' args= functionArgs ')'
					{
					pushFollow(FOLLOW_functionName_in_function12400);
					f=functionName();
					state._fsp--;
					if (state.failed) return t;
					match(input,209,FOLLOW_209_in_function12402); if (state.failed) return t;
					pushFollow(FOLLOW_functionArgs_in_function12406);
					args=functionArgs();
					state._fsp--;
					if (state.failed) return t;
					match(input,210,FOLLOW_210_in_function12408); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = new FunctionCall.Raw(f, args); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "function"



	// $ANTLR start "functionArgs"
	// Parser.g:1626:1: functionArgs returns [List<Term.Raw> args] : t1= term ( ',' tn= term )* ;
	public final List<Term.Raw> functionArgs() throws RecognitionException {
		List<Term.Raw> args = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 args = new ArrayList<Term.Raw>(); 
		try {
			// Parser.g:1628:5: (t1= term ( ',' tn= term )* )
			// Parser.g:1628:7: t1= term ( ',' tn= term )*
			{
			pushFollow(FOLLOW_term_in_functionArgs12441);
			t1=term();
			state._fsp--;
			if (state.failed) return args;
			if ( state.backtracking==0 ) {args.add(t1); }
			// Parser.g:1628:32: ( ',' tn= term )*
			loop232:
			while (true) {
				int alt232=2;
				int LA232_0 = input.LA(1);
				if ( (LA232_0==213) ) {
					alt232=1;
				}

				switch (alt232) {
				case 1 :
					// Parser.g:1628:34: ',' tn= term
					{
					match(input,213,FOLLOW_213_in_functionArgs12447); if (state.failed) return args;
					pushFollow(FOLLOW_term_in_functionArgs12451);
					tn=term();
					state._fsp--;
					if (state.failed) return args;
					if ( state.backtracking==0 ) { args.add(tn); }
					}
					break;

				default :
					break loop232;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return args;
	}
	// $ANTLR end "functionArgs"



	// $ANTLR start "term"
	// Parser.g:1631:1: term returns [Term.Raw term] : t= termAddition ;
	public final Term.Raw term() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw t =null;

		try {
			// Parser.g:1632:5: (t= termAddition )
			// Parser.g:1632:7: t= termAddition
			{
			pushFollow(FOLLOW_termAddition_in_term12479);
			t=termAddition();
			state._fsp--;
			if (state.failed) return term;
			if ( state.backtracking==0 ) { term = t; }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "term"



	// $ANTLR start "termAddition"
	// Parser.g:1635:1: termAddition returns [Term.Raw term] : l= termMultiplication ( '+' r= termMultiplication | '-' r= termMultiplication )* ;
	public final Term.Raw termAddition() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw l =null;
		Term.Raw r =null;

		try {
			// Parser.g:1636:5: (l= termMultiplication ( '+' r= termMultiplication | '-' r= termMultiplication )* )
			// Parser.g:1636:9: l= termMultiplication ( '+' r= termMultiplication | '-' r= termMultiplication )*
			{
			pushFollow(FOLLOW_termMultiplication_in_termAddition12531);
			l=termMultiplication();
			state._fsp--;
			if (state.failed) return term;
			if ( state.backtracking==0 ) {term = l;}
			// Parser.g:1637:9: ( '+' r= termMultiplication | '-' r= termMultiplication )*
			loop233:
			while (true) {
				int alt233=3;
				alt233 = dfa233.predict(input);
				switch (alt233) {
				case 1 :
					// Parser.g:1637:11: '+' r= termMultiplication
					{
					match(input,211,FOLLOW_211_in_termAddition12547); if (state.failed) return term;
					pushFollow(FOLLOW_termMultiplication_in_termAddition12551);
					r=termMultiplication();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) {term = FunctionCall.Raw.newOperation('+', term, r);}
					}
					break;
				case 2 :
					// Parser.g:1638:11: '-' r= termMultiplication
					{
					match(input,214,FOLLOW_214_in_termAddition12565); if (state.failed) return term;
					pushFollow(FOLLOW_termMultiplication_in_termAddition12569);
					r=termMultiplication();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) {term = FunctionCall.Raw.newOperation('-', term, r);}
					}
					break;

				default :
					break loop233;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "termAddition"



	// $ANTLR start "termMultiplication"
	// Parser.g:1642:1: termMultiplication returns [Term.Raw term] : l= termGroup ( '\\*' r= termGroup | '/' r= termGroup | '%' r= termGroup )* ;
	public final Term.Raw termMultiplication() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw l =null;
		Term.Raw r =null;

		try {
			// Parser.g:1643:5: (l= termGroup ( '\\*' r= termGroup | '/' r= termGroup | '%' r= termGroup )* )
			// Parser.g:1643:9: l= termGroup ( '\\*' r= termGroup | '/' r= termGroup | '%' r= termGroup )*
			{
			pushFollow(FOLLOW_termGroup_in_termMultiplication12607);
			l=termGroup();
			state._fsp--;
			if (state.failed) return term;
			if ( state.backtracking==0 ) {term = l;}
			// Parser.g:1644:9: ( '\\*' r= termGroup | '/' r= termGroup | '%' r= termGroup )*
			loop234:
			while (true) {
				int alt234=4;
				switch ( input.LA(1) ) {
				case 226:
					{
					alt234=1;
					}
					break;
				case 217:
					{
					alt234=2;
					}
					break;
				case 208:
					{
					alt234=3;
					}
					break;
				}
				switch (alt234) {
				case 1 :
					// Parser.g:1644:11: '\\*' r= termGroup
					{
					match(input,226,FOLLOW_226_in_termMultiplication12623); if (state.failed) return term;
					pushFollow(FOLLOW_termGroup_in_termMultiplication12627);
					r=termGroup();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) {term = FunctionCall.Raw.newOperation('*', term, r);}
					}
					break;
				case 2 :
					// Parser.g:1645:11: '/' r= termGroup
					{
					match(input,217,FOLLOW_217_in_termMultiplication12641); if (state.failed) return term;
					pushFollow(FOLLOW_termGroup_in_termMultiplication12645);
					r=termGroup();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) {term = FunctionCall.Raw.newOperation('/', term, r);}
					}
					break;
				case 3 :
					// Parser.g:1646:11: '%' r= termGroup
					{
					match(input,208,FOLLOW_208_in_termMultiplication12659); if (state.failed) return term;
					pushFollow(FOLLOW_termGroup_in_termMultiplication12663);
					r=termGroup();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) {term = FunctionCall.Raw.newOperation('%', term, r);}
					}
					break;

				default :
					break loop234;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "termMultiplication"



	// $ANTLR start "termGroup"
	// Parser.g:1650:1: termGroup returns [Term.Raw term] : (t= simpleTerm | '-' t= simpleTerm );
	public final Term.Raw termGroup() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw t =null;

		try {
			// Parser.g:1651:5: (t= simpleTerm | '-' t= simpleTerm )
			int alt235=2;
			int LA235_0 = input.LA(1);
			if ( (LA235_0==BOOLEAN||LA235_0==DURATION||LA235_0==FLOAT||LA235_0==HEXNUMBER||(LA235_0 >= IDENT && LA235_0 <= INTEGER)||LA235_0==K_ACCESS||(LA235_0 >= K_AGGREGATE && LA235_0 <= K_ALL)||LA235_0==K_ANN||LA235_0==K_AS||LA235_0==K_ASCII||(LA235_0 >= K_BIGINT && LA235_0 <= K_BOOLEAN)||(LA235_0 >= K_CALLED && LA235_0 <= K_CLUSTERING)||(LA235_0 >= K_COMPACT && LA235_0 <= K_COUNTER)||(LA235_0 >= K_CUSTOM && LA235_0 <= K_DEFAULT)||(LA235_0 >= K_DISTINCT && LA235_0 <= K_DOUBLE)||LA235_0==K_DURATION||(LA235_0 >= K_EXISTS && LA235_0 <= K_FLOAT)||LA235_0==K_FROZEN||(LA235_0 >= K_FUNCTION && LA235_0 <= K_FUNCTIONS)||(LA235_0 >= K_GROUP && LA235_0 <= K_IDENTITY)||(LA235_0 >= K_INET && LA235_0 <= K_INPUT)||(LA235_0 >= K_INT && LA235_0 <= K_INTERNALS)||(LA235_0 >= K_JSON && LA235_0 <= K_KEYS)||(LA235_0 >= K_KEYSPACES && LA235_0 <= K_LIKE)||(LA235_0 >= K_LIST && LA235_0 <= K_MASKED)||(LA235_0 >= K_MAXWRITETIME && LA235_0 <= K_MBEANS)||(LA235_0 >= K_NEGATIVE_INFINITY && LA235_0 <= K_NOLOGIN)||LA235_0==K_NOSUPERUSER||LA235_0==K_NULL||(LA235_0 >= K_ONLY && LA235_0 <= K_OPTIONS)||(LA235_0 >= K_PARTITION && LA235_0 <= K_POSITIVE_NAN)||(LA235_0 >= K_REPLACE && LA235_0 <= K_RETURNS)||(LA235_0 >= K_ROLE && LA235_0 <= K_ROLES)||LA235_0==K_SELECT_MASKED||(LA235_0 >= K_SFUNC && LA235_0 <= K_TINYINT)||(LA235_0 >= K_TOKEN && LA235_0 <= K_TRIGGER)||(LA235_0 >= K_TTL && LA235_0 <= K_TYPES)||(LA235_0 >= K_UNMASK && LA235_0 <= K_UNSET)||(LA235_0 >= K_USER && LA235_0 <= K_USERS)||(LA235_0 >= K_UUID && LA235_0 <= K_VECTOR)||LA235_0==K_WRITETIME||(LA235_0 >= QMARK && LA235_0 <= QUOTED_NAME)||LA235_0==STRING_LITERAL||LA235_0==UUID||LA235_0==209||LA235_0==218||LA235_0==225||LA235_0==229) ) {
				alt235=1;
			}
			else if ( (LA235_0==214) ) {
				alt235=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return term;}
				NoViableAltException nvae =
					new NoViableAltException("", 235, 0, input);
				throw nvae;
			}

			switch (alt235) {
				case 1 :
					// Parser.g:1651:7: t= simpleTerm
					{
					pushFollow(FOLLOW_simpleTerm_in_termGroup12699);
					t=simpleTerm();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) { term = t; }
					}
					break;
				case 2 :
					// Parser.g:1652:7: '-' t= simpleTerm
					{
					match(input,214,FOLLOW_214_in_termGroup12722); if (state.failed) return term;
					pushFollow(FOLLOW_simpleTerm_in_termGroup12727);
					t=simpleTerm();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) { term = FunctionCall.Raw.newNegation(t); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "termGroup"



	// $ANTLR start "simpleTerm"
	// Parser.g:1655:1: simpleTerm returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= simpleTerm | K_CAST '(' t= simpleTerm K_AS n= native_type ')' );
	public final Term.Raw simpleTerm() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw v =null;
		Term.Raw f =null;
		CQL3Type.Raw c =null;
		Term.Raw t =null;
		CQL3Type n =null;

		try {
			// Parser.g:1656:5: (v= value |f= function | '(' c= comparatorType ')' t= simpleTerm | K_CAST '(' t= simpleTerm K_AS n= native_type ')' )
			int alt236=4;
			alt236 = dfa236.predict(input);
			switch (alt236) {
				case 1 :
					// Parser.g:1656:7: v= value
					{
					pushFollow(FOLLOW_value_in_simpleTerm12760);
					v=value();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) { term = v; }
					}
					break;
				case 2 :
					// Parser.g:1657:7: f= function
					{
					pushFollow(FOLLOW_function_in_simpleTerm12811);
					f=function();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) { term = f; }
					}
					break;
				case 3 :
					// Parser.g:1658:7: '(' c= comparatorType ')' t= simpleTerm
					{
					match(input,209,FOLLOW_209_in_simpleTerm12857); if (state.failed) return term;
					pushFollow(FOLLOW_comparatorType_in_simpleTerm12861);
					c=comparatorType();
					state._fsp--;
					if (state.failed) return term;
					match(input,210,FOLLOW_210_in_simpleTerm12863); if (state.failed) return term;
					pushFollow(FOLLOW_simpleTerm_in_simpleTerm12867);
					t=simpleTerm();
					state._fsp--;
					if (state.failed) return term;
					if ( state.backtracking==0 ) { term = new TypeCast(c, t); }
					}
					break;
				case 4 :
					// Parser.g:1659:7: K_CAST '(' t= simpleTerm K_AS n= native_type ')'
					{
					match(input,K_CAST,FOLLOW_K_CAST_in_simpleTerm12886); if (state.failed) return term;
					match(input,209,FOLLOW_209_in_simpleTerm12888); if (state.failed) return term;
					pushFollow(FOLLOW_simpleTerm_in_simpleTerm12892);
					t=simpleTerm();
					state._fsp--;
					if (state.failed) return term;
					match(input,K_AS,FOLLOW_K_AS_in_simpleTerm12894); if (state.failed) return term;
					pushFollow(FOLLOW_native_type_in_simpleTerm12898);
					n=native_type();
					state._fsp--;
					if (state.failed) return term;
					match(input,210,FOLLOW_210_in_simpleTerm12900); if (state.failed) return term;
					if ( state.backtracking==0 ) { term = FunctionCall.Raw.newCast(t, n); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "simpleTerm"



	// $ANTLR start "columnOperation"
	// Parser.g:1662:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : key= cident columnOperationDifferentiator[operations, key] ;
	public final void columnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations) throws RecognitionException {
		ColumnIdentifier key =null;

		try {
			// Parser.g:1663:5: (key= cident columnOperationDifferentiator[operations, key] )
			// Parser.g:1663:7: key= cident columnOperationDifferentiator[operations, key]
			{
			pushFollow(FOLLOW_cident_in_columnOperation12922);
			key=cident();
			state._fsp--;
			if (state.failed) return;
			pushFollow(FOLLOW_columnOperationDifferentiator_in_columnOperation12924);
			columnOperationDifferentiator(operations, key);
			state._fsp--;
			if (state.failed) return;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperation"



	// $ANTLR start "columnOperationDifferentiator"
	// Parser.g:1666:1: columnOperationDifferentiator[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key] : ( '=' normalColumnOperation[operations, key] | shorthandColumnOperation[operations, key] | '[' k= term ']' collectionColumnOperation[operations, key, k] | '.' field= fident udtColumnOperation[operations, key, field] );
	public final void columnOperationDifferentiator(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key) throws RecognitionException {
		Term.Raw k =null;
		FieldIdentifier field =null;

		try {
			// Parser.g:1667:5: ( '=' normalColumnOperation[operations, key] | shorthandColumnOperation[operations, key] | '[' k= term ']' collectionColumnOperation[operations, key, k] | '.' field= fident udtColumnOperation[operations, key, field] )
			int alt237=4;
			switch ( input.LA(1) ) {
			case 222:
				{
				alt237=1;
				}
				break;
			case 212:
			case 215:
				{
				alt237=2;
				}
				break;
			case 225:
				{
				alt237=3;
				}
				break;
			case 216:
				{
				alt237=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 237, 0, input);
				throw nvae;
			}
			switch (alt237) {
				case 1 :
					// Parser.g:1667:7: '=' normalColumnOperation[operations, key]
					{
					match(input,222,FOLLOW_222_in_columnOperationDifferentiator12943); if (state.failed) return;
					pushFollow(FOLLOW_normalColumnOperation_in_columnOperationDifferentiator12945);
					normalColumnOperation(operations, key);
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 2 :
					// Parser.g:1668:7: shorthandColumnOperation[operations, key]
					{
					pushFollow(FOLLOW_shorthandColumnOperation_in_columnOperationDifferentiator12954);
					shorthandColumnOperation(operations, key);
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 3 :
					// Parser.g:1669:7: '[' k= term ']' collectionColumnOperation[operations, key, k]
					{
					match(input,225,FOLLOW_225_in_columnOperationDifferentiator12963); if (state.failed) return;
					pushFollow(FOLLOW_term_in_columnOperationDifferentiator12967);
					k=term();
					state._fsp--;
					if (state.failed) return;
					match(input,227,FOLLOW_227_in_columnOperationDifferentiator12969); if (state.failed) return;
					pushFollow(FOLLOW_collectionColumnOperation_in_columnOperationDifferentiator12971);
					collectionColumnOperation(operations, key, k);
					state._fsp--;
					if (state.failed) return;
					}
					break;
				case 4 :
					// Parser.g:1670:7: '.' field= fident udtColumnOperation[operations, key, field]
					{
					match(input,216,FOLLOW_216_in_columnOperationDifferentiator12980); if (state.failed) return;
					pushFollow(FOLLOW_fident_in_columnOperationDifferentiator12984);
					field=fident();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_udtColumnOperation_in_columnOperationDifferentiator12986);
					udtColumnOperation(operations, key, field);
					state._fsp--;
					if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperationDifferentiator"



	// $ANTLR start "normalColumnOperation"
	// Parser.g:1673:1: normalColumnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );
	public final void normalColumnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key) throws RecognitionException {
		Token sig=null;
		Token i=null;
		Term.Raw t =null;
		ColumnIdentifier c =null;

		try {
			// Parser.g:1674:5: (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER )
			int alt239=3;
			alt239 = dfa239.predict(input);
			switch (alt239) {
				case 1 :
					// Parser.g:1674:7: t= term ( '+' c= cident )?
					{
					pushFollow(FOLLOW_term_in_normalColumnOperation13007);
					t=term();
					state._fsp--;
					if (state.failed) return;
					// Parser.g:1674:14: ( '+' c= cident )?
					int alt238=2;
					int LA238_0 = input.LA(1);
					if ( (LA238_0==211) ) {
						alt238=1;
					}
					switch (alt238) {
						case 1 :
							// Parser.g:1674:15: '+' c= cident
							{
							match(input,211,FOLLOW_211_in_normalColumnOperation13010); if (state.failed) return;
							pushFollow(FOLLOW_cident_in_normalColumnOperation13014);
							c=cident();
							state._fsp--;
							if (state.failed) return;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					          if (c == null)
					          {
					              addRawUpdate(operations, key, new Operation.SetValue(t));
					          }
					          else
					          {
					              if (!key.equals(c))
					                  addRecognitionError("Only expressions of the form X = <value> + X are supported.");
					              addRawUpdate(operations, key, new Operation.Prepend(t));
					          }
					      }
					}
					break;
				case 2 :
					// Parser.g:1687:7: c= cident sig= ( '+' | '-' ) t= term
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation13035);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					sig=input.LT(1);
					if ( input.LA(1)==211||input.LA(1)==214 ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_term_in_normalColumnOperation13049);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) {
					          if (!key.equals(c))
					              addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
					          addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
					      }
					}
					break;
				case 3 :
					// Parser.g:1693:7: c= cident i= INTEGER
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation13067);
					c=cident();
					state._fsp--;
					if (state.failed) return;
					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_normalColumnOperation13071); if (state.failed) return;
					if ( state.backtracking==0 ) {
					          // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
					          if (!key.equals(c))
					              // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
					              addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
					          addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
					      }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "normalColumnOperation"



	// $ANTLR start "shorthandColumnOperation"
	// Parser.g:1703:1: shorthandColumnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key] : sig= ( '+=' | '-=' ) t= term ;
	public final void shorthandColumnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key) throws RecognitionException {
		Token sig=null;
		Term.Raw t =null;

		try {
			// Parser.g:1704:5: (sig= ( '+=' | '-=' ) t= term )
			// Parser.g:1704:7: sig= ( '+=' | '-=' ) t= term
			{
			sig=input.LT(1);
			if ( input.LA(1)==212||input.LA(1)==215 ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			pushFollow(FOLLOW_term_in_shorthandColumnOperation13109);
			t=term();
			state._fsp--;
			if (state.failed) return;
			if ( state.backtracking==0 ) {
			          addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+=") ? new Operation.Addition(t) : new Operation.Substraction(t));
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "shorthandColumnOperation"



	// $ANTLR start "collectionColumnOperation"
	// Parser.g:1710:1: collectionColumnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, Term.Raw k] : '=' t= term ;
	public final void collectionColumnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, Term.Raw k) throws RecognitionException {
		Term.Raw t =null;

		try {
			// Parser.g:1711:5: ( '=' t= term )
			// Parser.g:1711:7: '=' t= term
			{
			match(input,222,FOLLOW_222_in_collectionColumnOperation13135); if (state.failed) return;
			pushFollow(FOLLOW_term_in_collectionColumnOperation13139);
			t=term();
			state._fsp--;
			if (state.failed) return;
			if ( state.backtracking==0 ) {
			          addRawUpdate(operations, key, new Operation.SetElement(k, t));
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "collectionColumnOperation"



	// $ANTLR start "udtColumnOperation"
	// Parser.g:1717:1: udtColumnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, FieldIdentifier field] : '=' t= term ;
	public final void udtColumnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, FieldIdentifier field) throws RecognitionException {
		Term.Raw t =null;

		try {
			// Parser.g:1718:5: ( '=' t= term )
			// Parser.g:1718:7: '=' t= term
			{
			match(input,222,FOLLOW_222_in_udtColumnOperation13165); if (state.failed) return;
			pushFollow(FOLLOW_term_in_udtColumnOperation13169);
			t=term();
			state._fsp--;
			if (state.failed) return;
			if ( state.backtracking==0 ) {
			          addRawUpdate(operations, key, new Operation.SetField(field, t));
			      }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "udtColumnOperation"



	// $ANTLR start "columnCondition"
	// Parser.g:1724:1: columnCondition[List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions] : key= cident (op= relationType t= term |op= containsOperator t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) | '.' field= fident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) ;
	public final void columnCondition(List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions) throws RecognitionException {
		ColumnIdentifier key =null;
		Operator op =null;
		Term.Raw t =null;
		List<Term.Raw> values =null;
		AbstractMarker.INRaw marker =null;
		Term.Raw element =null;
		FieldIdentifier field =null;

		try {
			// Parser.g:1726:5: (key= cident (op= relationType t= term |op= containsOperator t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) | '.' field= fident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) )
			// Parser.g:1726:7: key= cident (op= relationType t= term |op= containsOperator t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) | '.' field= fident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			{
			pushFollow(FOLLOW_cident_in_columnCondition13202);
			key=cident();
			state._fsp--;
			if (state.failed) return;
			// Parser.g:1727:9: (op= relationType t= term |op= containsOperator t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) | '.' field= fident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			int alt245=5;
			switch ( input.LA(1) ) {
			case 207:
			case 220:
			case 221:
			case 222:
			case 223:
			case 224:
				{
				alt245=1;
				}
				break;
			case K_CONTAINS:
				{
				alt245=2;
				}
				break;
			case K_IN:
				{
				alt245=3;
				}
				break;
			case 225:
				{
				alt245=4;
				}
				break;
			case 216:
				{
				alt245=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return;}
				NoViableAltException nvae =
					new NoViableAltException("", 245, 0, input);
				throw nvae;
			}
			switch (alt245) {
				case 1 :
					// Parser.g:1727:11: op= relationType t= term
					{
					pushFollow(FOLLOW_relationType_in_columnCondition13216);
					op=relationType();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_term_in_columnCondition13220);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.simpleCondition(t, op))); }
					}
					break;
				case 2 :
					// Parser.g:1728:11: op= containsOperator t= term
					{
					pushFollow(FOLLOW_containsOperator_in_columnCondition13236);
					op=containsOperator();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_term_in_columnCondition13240);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.simpleCondition(t, op))); }
					}
					break;
				case 3 :
					// Parser.g:1729:11: K_IN (values= singleColumnInValues |marker= inMarker )
					{
					match(input,K_IN,FOLLOW_K_IN_in_columnCondition13254); if (state.failed) return;
					// Parser.g:1730:13: (values= singleColumnInValues |marker= inMarker )
					int alt240=2;
					int LA240_0 = input.LA(1);
					if ( (LA240_0==209) ) {
						alt240=1;
					}
					else if ( (LA240_0==QMARK||LA240_0==218) ) {
						alt240=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 240, 0, input);
						throw nvae;
					}

					switch (alt240) {
						case 1 :
							// Parser.g:1730:15: values= singleColumnInValues
							{
							pushFollow(FOLLOW_singleColumnInValues_in_columnCondition13272);
							values=singleColumnInValues();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(values))); }
							}
							break;
						case 2 :
							// Parser.g:1731:15: marker= inMarker
							{
							pushFollow(FOLLOW_inMarker_in_columnCondition13292);
							marker=inMarker();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(marker))); }
							}
							break;

					}

					}
					break;
				case 4 :
					// Parser.g:1733:11: '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					{
					match(input,225,FOLLOW_225_in_columnCondition13320); if (state.failed) return;
					pushFollow(FOLLOW_term_in_columnCondition13324);
					element=term();
					state._fsp--;
					if (state.failed) return;
					match(input,227,FOLLOW_227_in_columnCondition13326); if (state.failed) return;
					// Parser.g:1734:13: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					int alt242=2;
					int LA242_0 = input.LA(1);
					if ( (LA242_0==207||(LA242_0 >= 220 && LA242_0 <= 224)) ) {
						alt242=1;
					}
					else if ( (LA242_0==K_IN) ) {
						alt242=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 242, 0, input);
						throw nvae;
					}

					switch (alt242) {
						case 1 :
							// Parser.g:1734:15: op= relationType t= term
							{
							pushFollow(FOLLOW_relationType_in_columnCondition13344);
							op=relationType();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_term_in_columnCondition13348);
							t=term();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.collectionCondition(t, element, op))); }
							}
							break;
						case 2 :
							// Parser.g:1735:15: K_IN (values= singleColumnInValues |marker= inMarker )
							{
							match(input,K_IN,FOLLOW_K_IN_in_columnCondition13366); if (state.failed) return;
							// Parser.g:1736:17: (values= singleColumnInValues |marker= inMarker )
							int alt241=2;
							int LA241_0 = input.LA(1);
							if ( (LA241_0==209) ) {
								alt241=1;
							}
							else if ( (LA241_0==QMARK||LA241_0==218) ) {
								alt241=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return;}
								NoViableAltException nvae =
									new NoViableAltException("", 241, 0, input);
								throw nvae;
							}

							switch (alt241) {
								case 1 :
									// Parser.g:1736:19: values= singleColumnInValues
									{
									pushFollow(FOLLOW_singleColumnInValues_in_columnCondition13388);
									values=singleColumnInValues();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, values))); }
									}
									break;
								case 2 :
									// Parser.g:1737:19: marker= inMarker
									{
									pushFollow(FOLLOW_inMarker_in_columnCondition13412);
									marker=inMarker();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, marker))); }
									}
									break;

							}

							}
							break;

					}

					}
					break;
				case 5 :
					// Parser.g:1740:11: '.' field= fident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					{
					match(input,216,FOLLOW_216_in_columnCondition13458); if (state.failed) return;
					pushFollow(FOLLOW_fident_in_columnCondition13462);
					field=fident();
					state._fsp--;
					if (state.failed) return;
					// Parser.g:1741:13: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					int alt244=2;
					int LA244_0 = input.LA(1);
					if ( (LA244_0==207||(LA244_0 >= 220 && LA244_0 <= 224)) ) {
						alt244=1;
					}
					else if ( (LA244_0==K_IN) ) {
						alt244=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 244, 0, input);
						throw nvae;
					}

					switch (alt244) {
						case 1 :
							// Parser.g:1741:15: op= relationType t= term
							{
							pushFollow(FOLLOW_relationType_in_columnCondition13480);
							op=relationType();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_term_in_columnCondition13484);
							t=term();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.udtFieldCondition(t, field, op))); }
							}
							break;
						case 2 :
							// Parser.g:1742:15: K_IN (values= singleColumnInValues |marker= inMarker )
							{
							match(input,K_IN,FOLLOW_K_IN_in_columnCondition13502); if (state.failed) return;
							// Parser.g:1743:17: (values= singleColumnInValues |marker= inMarker )
							int alt243=2;
							int LA243_0 = input.LA(1);
							if ( (LA243_0==209) ) {
								alt243=1;
							}
							else if ( (LA243_0==QMARK||LA243_0==218) ) {
								alt243=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return;}
								NoViableAltException nvae =
									new NoViableAltException("", 243, 0, input);
								throw nvae;
							}

							switch (alt243) {
								case 1 :
									// Parser.g:1743:19: values= singleColumnInValues
									{
									pushFollow(FOLLOW_singleColumnInValues_in_columnCondition13524);
									values=singleColumnInValues();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.udtFieldInCondition(field, values))); }
									}
									break;
								case 2 :
									// Parser.g:1744:19: marker= inMarker
									{
									pushFollow(FOLLOW_inMarker_in_columnCondition13548);
									marker=inMarker();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) { conditions.add(Pair.create(key, ColumnCondition.Raw.udtFieldInCondition(field, marker))); }
									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnCondition"



	// $ANTLR start "properties"
	// Parser.g:1750:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
	public final void properties(PropertyDefinitions props) throws RecognitionException {
		try {
			// Parser.g:1751:5: ( property[props] ( K_AND property[props] )* )
			// Parser.g:1751:7: property[props] ( K_AND property[props] )*
			{
			pushFollow(FOLLOW_property_in_properties13610);
			property(props);
			state._fsp--;
			if (state.failed) return;
			// Parser.g:1751:23: ( K_AND property[props] )*
			loop246:
			while (true) {
				int alt246=2;
				int LA246_0 = input.LA(1);
				if ( (LA246_0==K_AND) ) {
					alt246=1;
				}

				switch (alt246) {
				case 1 :
					// Parser.g:1751:24: K_AND property[props]
					{
					match(input,K_AND,FOLLOW_K_AND_in_properties13614); if (state.failed) return;
					pushFollow(FOLLOW_property_in_properties13616);
					property(props);
					state._fsp--;
					if (state.failed) return;
					}
					break;

				default :
					break loop246;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "properties"



	// $ANTLR start "property"
	// Parser.g:1754:1: property[PropertyDefinitions props] : (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= fullMapLiteral );
	public final void property(PropertyDefinitions props) throws RecognitionException {
		ColumnIdentifier k =null;
		String simple =null;
		Maps.Literal map =null;

		try {
			// Parser.g:1755:5: (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= fullMapLiteral )
			int alt247=2;
			alt247 = dfa247.predict(input);
			switch (alt247) {
				case 1 :
					// Parser.g:1755:7: k= noncol_ident '=' simple= propertyValue
					{
					pushFollow(FOLLOW_noncol_ident_in_property13639);
					k=noncol_ident();
					state._fsp--;
					if (state.failed) return;
					match(input,222,FOLLOW_222_in_property13641); if (state.failed) return;
					pushFollow(FOLLOW_propertyValue_in_property13645);
					simple=propertyValue();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } }
					}
					break;
				case 2 :
					// Parser.g:1756:7: k= noncol_ident '=' map= fullMapLiteral
					{
					pushFollow(FOLLOW_noncol_ident_in_property13657);
					k=noncol_ident();
					state._fsp--;
					if (state.failed) return;
					match(input,222,FOLLOW_222_in_property13659); if (state.failed) return;
					pushFollow(FOLLOW_fullMapLiteral_in_property13663);
					map=fullMapLiteral();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"



	// $ANTLR start "propertyValue"
	// Parser.g:1759:1: propertyValue returns [String str] : (c= constant |u= unreserved_keyword );
	public final String propertyValue() throws RecognitionException {
		String str = null;


		Constants.Literal c =null;
		String u =null;

		try {
			// Parser.g:1760:5: (c= constant |u= unreserved_keyword )
			int alt248=2;
			int LA248_0 = input.LA(1);
			if ( (LA248_0==BOOLEAN||LA248_0==DURATION||LA248_0==FLOAT||LA248_0==HEXNUMBER||LA248_0==INTEGER||(LA248_0 >= K_NEGATIVE_INFINITY && LA248_0 <= K_NEGATIVE_NAN)||(LA248_0 >= K_POSITIVE_INFINITY && LA248_0 <= K_POSITIVE_NAN)||LA248_0==STRING_LITERAL||LA248_0==UUID) ) {
				alt248=1;
			}
			else if ( (LA248_0==K_ACCESS||(LA248_0 >= K_AGGREGATE && LA248_0 <= K_ALL)||LA248_0==K_ANN||LA248_0==K_AS||LA248_0==K_ASCII||(LA248_0 >= K_BIGINT && LA248_0 <= K_BOOLEAN)||(LA248_0 >= K_CALLED && LA248_0 <= K_CLUSTERING)||(LA248_0 >= K_COMPACT && LA248_0 <= K_COUNTER)||(LA248_0 >= K_CUSTOM && LA248_0 <= K_DEFAULT)||(LA248_0 >= K_DISTINCT && LA248_0 <= K_DOUBLE)||LA248_0==K_DURATION||(LA248_0 >= K_EXISTS && LA248_0 <= K_FLOAT)||LA248_0==K_FROZEN||(LA248_0 >= K_FUNCTION && LA248_0 <= K_FUNCTIONS)||(LA248_0 >= K_GROUP && LA248_0 <= K_IDENTITY)||(LA248_0 >= K_INET && LA248_0 <= K_INPUT)||(LA248_0 >= K_INT && LA248_0 <= K_INTERNALS)||(LA248_0 >= K_JSON && LA248_0 <= K_KEYS)||(LA248_0 >= K_KEYSPACES && LA248_0 <= K_LIKE)||(LA248_0 >= K_LIST && LA248_0 <= K_MASKED)||(LA248_0 >= K_MAXWRITETIME && LA248_0 <= K_MBEANS)||LA248_0==K_NOLOGIN||LA248_0==K_NOSUPERUSER||(LA248_0 >= K_ONLY && LA248_0 <= K_OPTIONS)||(LA248_0 >= K_PARTITION && LA248_0 <= K_PERMISSIONS)||(LA248_0 >= K_REPLACE && LA248_0 <= K_RETURNS)||(LA248_0 >= K_ROLE && LA248_0 <= K_ROLES)||LA248_0==K_SELECT_MASKED||(LA248_0 >= K_SFUNC && LA248_0 <= K_TINYINT)||LA248_0==K_TRIGGER||(LA248_0 >= K_TTL && LA248_0 <= K_TYPES)||(LA248_0 >= K_UNMASK && LA248_0 <= K_UNSET)||(LA248_0 >= K_USER && LA248_0 <= K_USERS)||(LA248_0 >= K_UUID && LA248_0 <= K_VECTOR)||LA248_0==K_WRITETIME) ) {
				alt248=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return str;}
				NoViableAltException nvae =
					new NoViableAltException("", 248, 0, input);
				throw nvae;
			}

			switch (alt248) {
				case 1 :
					// Parser.g:1760:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_propertyValue13688);
					c=constant();
					state._fsp--;
					if (state.failed) return str;
					if ( state.backtracking==0 ) { str = c.getRawText(); }
					}
					break;
				case 2 :
					// Parser.g:1761:7: u= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_propertyValue13710);
					u=unreserved_keyword();
					state._fsp--;
					if (state.failed) return str;
					if ( state.backtracking==0 ) { str = u; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "propertyValue"



	// $ANTLR start "relationType"
	// Parser.g:1764:1: relationType returns [Operator op] : ( '=' | '<' | '<=' | '>' | '>=' | '!=' );
	public final Operator relationType() throws RecognitionException {
		Operator op = null;


		try {
			// Parser.g:1765:5: ( '=' | '<' | '<=' | '>' | '>=' | '!=' )
			int alt249=6;
			switch ( input.LA(1) ) {
			case 222:
				{
				alt249=1;
				}
				break;
			case 220:
				{
				alt249=2;
				}
				break;
			case 221:
				{
				alt249=3;
				}
				break;
			case 223:
				{
				alt249=4;
				}
				break;
			case 224:
				{
				alt249=5;
				}
				break;
			case 207:
				{
				alt249=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return op;}
				NoViableAltException nvae =
					new NoViableAltException("", 249, 0, input);
				throw nvae;
			}
			switch (alt249) {
				case 1 :
					// Parser.g:1765:7: '='
					{
					match(input,222,FOLLOW_222_in_relationType13733); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = Operator.EQ; }
					}
					break;
				case 2 :
					// Parser.g:1766:7: '<'
					{
					match(input,220,FOLLOW_220_in_relationType13744); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = Operator.LT; }
					}
					break;
				case 3 :
					// Parser.g:1767:7: '<='
					{
					match(input,221,FOLLOW_221_in_relationType13755); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = Operator.LTE; }
					}
					break;
				case 4 :
					// Parser.g:1768:7: '>'
					{
					match(input,223,FOLLOW_223_in_relationType13765); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = Operator.GT; }
					}
					break;
				case 5 :
					// Parser.g:1769:7: '>='
					{
					match(input,224,FOLLOW_224_in_relationType13776); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = Operator.GTE; }
					}
					break;
				case 6 :
					// Parser.g:1770:7: '!='
					{
					match(input,207,FOLLOW_207_in_relationType13786); if (state.failed) return op;
					if ( state.backtracking==0 ) { op = Operator.NEQ; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "relationType"



	// $ANTLR start "relation"
	// Parser.g:1773:1: relation[WhereClause.Builder clauses] : (name= cident type= relationType t= term |name= cident K_LIKE t= term |name= cident K_IS K_NOT K_NULL | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident rt= containsOperator t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );
	public final void relation(WhereClause.Builder clauses) throws RecognitionException {
		ColumnIdentifier name =null;
		Operator type =null;
		Term.Raw t =null;
		List<ColumnIdentifier> l =null;
		AbstractMarker.INRaw marker =null;
		List<Term.Raw> inValues =null;
		Operator rt =null;
		Term.Raw key =null;
		List<ColumnIdentifier> ids =null;
		Tuples.INRaw tupleInMarker =null;
		List<Tuples.Literal> literals =null;
		List<Tuples.Raw> markers =null;
		Tuples.Literal literal =null;
		Tuples.Raw tupleMarker =null;

		try {
			// Parser.g:1774:5: (name= cident type= relationType t= term |name= cident K_LIKE t= term |name= cident K_IS K_NOT K_NULL | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident rt= containsOperator t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' )
			int alt252=10;
			alt252 = dfa252.predict(input);
			switch (alt252) {
				case 1 :
					// Parser.g:1774:7: name= cident type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation13808);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_relationType_in_relation13812);
					type=relationType();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_term_in_relation13816);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new SingleColumnRelation(name, type, t)); }
					}
					break;
				case 2 :
					// Parser.g:1775:7: name= cident K_LIKE t= term
					{
					pushFollow(FOLLOW_cident_in_relation13828);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,K_LIKE,FOLLOW_K_LIKE_in_relation13830); if (state.failed) return;
					pushFollow(FOLLOW_term_in_relation13834);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new SingleColumnRelation(name, Operator.LIKE, t)); }
					}
					break;
				case 3 :
					// Parser.g:1776:7: name= cident K_IS K_NOT K_NULL
					{
					pushFollow(FOLLOW_cident_in_relation13846);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,K_IS,FOLLOW_K_IS_in_relation13848); if (state.failed) return;
					match(input,K_NOT,FOLLOW_K_NOT_in_relation13850); if (state.failed) return;
					match(input,K_NULL,FOLLOW_K_NULL_in_relation13852); if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new SingleColumnRelation(name, Operator.IS_NOT, Constants.NULL_LITERAL)); }
					}
					break;
				case 4 :
					// Parser.g:1777:7: K_TOKEN l= tupleOfIdentifiers type= relationType t= term
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation13862); if (state.failed) return;
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation13866);
					l=tupleOfIdentifiers();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_relationType_in_relation13870);
					type=relationType();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_term_in_relation13874);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new TokenRelation(l, type, t)); }
					}
					break;
				case 5 :
					// Parser.g:1779:7: name= cident K_IN marker= inMarker
					{
					pushFollow(FOLLOW_cident_in_relation13894);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,K_IN,FOLLOW_K_IN_in_relation13896); if (state.failed) return;
					pushFollow(FOLLOW_inMarker_in_relation13900);
					marker=inMarker();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new SingleColumnRelation(name, Operator.IN, marker)); }
					}
					break;
				case 6 :
					// Parser.g:1781:7: name= cident K_IN inValues= singleColumnInValues
					{
					pushFollow(FOLLOW_cident_in_relation13920);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,K_IN,FOLLOW_K_IN_in_relation13922); if (state.failed) return;
					pushFollow(FOLLOW_singleColumnInValues_in_relation13926);
					inValues=singleColumnInValues();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(SingleColumnRelation.createInRelation(name, inValues)); }
					}
					break;
				case 7 :
					// Parser.g:1783:7: name= cident rt= containsOperator t= term
					{
					pushFollow(FOLLOW_cident_in_relation13946);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_containsOperator_in_relation13950);
					rt=containsOperator();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_term_in_relation13954);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new SingleColumnRelation(name, rt, t)); }
					}
					break;
				case 8 :
					// Parser.g:1784:7: name= cident '[' key= term ']' type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation13966);
					name=cident();
					state._fsp--;
					if (state.failed) return;
					match(input,225,FOLLOW_225_in_relation13968); if (state.failed) return;
					pushFollow(FOLLOW_term_in_relation13972);
					key=term();
					state._fsp--;
					if (state.failed) return;
					match(input,227,FOLLOW_227_in_relation13974); if (state.failed) return;
					pushFollow(FOLLOW_relationType_in_relation13978);
					type=relationType();
					state._fsp--;
					if (state.failed) return;
					pushFollow(FOLLOW_term_in_relation13982);
					t=term();
					state._fsp--;
					if (state.failed) return;
					if ( state.backtracking==0 ) { clauses.add(new SingleColumnRelation(name, key, type, t)); }
					}
					break;
				case 9 :
					// Parser.g:1785:7: ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					{
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation13994);
					ids=tupleOfIdentifiers();
					state._fsp--;
					if (state.failed) return;
					// Parser.g:1786:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					int alt251=3;
					alt251 = dfa251.predict(input);
					switch (alt251) {
						case 1 :
							// Parser.g:1786:9: K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							{
							match(input,K_IN,FOLLOW_K_IN_in_relation14004); if (state.failed) return;
							// Parser.g:1787:11: ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							int alt250=4;
							int LA250_0 = input.LA(1);
							if ( (LA250_0==209) ) {
								switch ( input.LA(2) ) {
								case 210:
									{
									alt250=1;
									}
									break;
								case 209:
									{
									alt250=3;
									}
									break;
								case QMARK:
								case 218:
									{
									alt250=4;
									}
									break;
								default:
									if (state.backtracking>0) {state.failed=true; return;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 250, 1, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}
							else if ( (LA250_0==QMARK||LA250_0==218) ) {
								alt250=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return;}
								NoViableAltException nvae =
									new NoViableAltException("", 250, 0, input);
								throw nvae;
							}

							switch (alt250) {
								case 1 :
									// Parser.g:1787:13: '(' ')'
									{
									match(input,209,FOLLOW_209_in_relation14018); if (state.failed) return;
									match(input,210,FOLLOW_210_in_relation14020); if (state.failed) return;
									if ( state.backtracking==0 ) { clauses.add(MultiColumnRelation.createInRelation(ids, new ArrayList<Tuples.Literal>())); }
									}
									break;
								case 2 :
									// Parser.g:1789:13: tupleInMarker= inMarkerForTuple
									{
									pushFollow(FOLLOW_inMarkerForTuple_in_relation14052);
									tupleInMarker=inMarkerForTuple();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) { clauses.add(MultiColumnRelation.createSingleMarkerInRelation(ids, tupleInMarker)); }
									}
									break;
								case 3 :
									// Parser.g:1791:13: literals= tupleOfTupleLiterals
									{
									pushFollow(FOLLOW_tupleOfTupleLiterals_in_relation14086);
									literals=tupleOfTupleLiterals();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) {
									                  clauses.add(MultiColumnRelation.createInRelation(ids, literals));
									              }
									}
									break;
								case 4 :
									// Parser.g:1795:13: markers= tupleOfMarkersForTuples
									{
									pushFollow(FOLLOW_tupleOfMarkersForTuples_in_relation14120);
									markers=tupleOfMarkersForTuples();
									state._fsp--;
									if (state.failed) return;
									if ( state.backtracking==0 ) { clauses.add(MultiColumnRelation.createInRelation(ids, markers)); }
									}
									break;

							}

							}
							break;
						case 2 :
							// Parser.g:1798:9: type= relationType literal= tupleLiteral
							{
							pushFollow(FOLLOW_relationType_in_relation14162);
							type=relationType();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_tupleLiteral_in_relation14166);
							literal=tupleLiteral();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) {
							              clauses.add(MultiColumnRelation.createNonInRelation(ids, type, literal));
							          }
							}
							break;
						case 3 :
							// Parser.g:1802:9: type= relationType tupleMarker= markerForTuple
							{
							pushFollow(FOLLOW_relationType_in_relation14192);
							type=relationType();
							state._fsp--;
							if (state.failed) return;
							pushFollow(FOLLOW_markerForTuple_in_relation14196);
							tupleMarker=markerForTuple();
							state._fsp--;
							if (state.failed) return;
							if ( state.backtracking==0 ) { clauses.add(MultiColumnRelation.createNonInRelation(ids, type, tupleMarker)); }
							}
							break;

					}

					}
					break;
				case 10 :
					// Parser.g:1805:7: '(' relation[$clauses] ')'
					{
					match(input,209,FOLLOW_209_in_relation14226); if (state.failed) return;
					pushFollow(FOLLOW_relation_in_relation14228);
					relation(clauses);
					state._fsp--;
					if (state.failed) return;
					match(input,210,FOLLOW_210_in_relation14231); if (state.failed) return;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "relation"



	// $ANTLR start "containsOperator"
	// Parser.g:1808:1: containsOperator returns [Operator o] : K_CONTAINS ( K_KEY )? ;
	public final Operator containsOperator() throws RecognitionException {
		Operator o = null;


		try {
			// Parser.g:1809:5: ( K_CONTAINS ( K_KEY )? )
			// Parser.g:1809:7: K_CONTAINS ( K_KEY )?
			{
			match(input,K_CONTAINS,FOLLOW_K_CONTAINS_in_containsOperator14252); if (state.failed) return o;
			if ( state.backtracking==0 ) { o = Operator.CONTAINS; }
			// Parser.g:1809:45: ( K_KEY )?
			int alt253=2;
			int LA253_0 = input.LA(1);
			if ( (LA253_0==K_KEY) ) {
				int LA253_1 = input.LA(2);
				if ( (LA253_1==BOOLEAN||LA253_1==DURATION||LA253_1==FLOAT||LA253_1==HEXNUMBER||(LA253_1 >= IDENT && LA253_1 <= INTEGER)||LA253_1==K_ACCESS||(LA253_1 >= K_AGGREGATE && LA253_1 <= K_ALL)||LA253_1==K_ANN||LA253_1==K_AS||LA253_1==K_ASCII||(LA253_1 >= K_BIGINT && LA253_1 <= K_BOOLEAN)||(LA253_1 >= K_CALLED && LA253_1 <= K_CLUSTERING)||(LA253_1 >= K_COMPACT && LA253_1 <= K_COUNTER)||(LA253_1 >= K_CUSTOM && LA253_1 <= K_DEFAULT)||(LA253_1 >= K_DISTINCT && LA253_1 <= K_DOUBLE)||LA253_1==K_DURATION||(LA253_1 >= K_EXISTS && LA253_1 <= K_FLOAT)||LA253_1==K_FROZEN||(LA253_1 >= K_FUNCTION && LA253_1 <= K_FUNCTIONS)||(LA253_1 >= K_GROUP && LA253_1 <= K_IDENTITY)||(LA253_1 >= K_INET && LA253_1 <= K_INPUT)||(LA253_1 >= K_INT && LA253_1 <= K_INTERNALS)||(LA253_1 >= K_JSON && LA253_1 <= K_KEYS)||(LA253_1 >= K_KEYSPACES && LA253_1 <= K_LIKE)||(LA253_1 >= K_LIST && LA253_1 <= K_MASKED)||(LA253_1 >= K_MAXWRITETIME && LA253_1 <= K_MBEANS)||(LA253_1 >= K_NEGATIVE_INFINITY && LA253_1 <= K_NOLOGIN)||LA253_1==K_NOSUPERUSER||LA253_1==K_NULL||(LA253_1 >= K_ONLY && LA253_1 <= K_OPTIONS)||(LA253_1 >= K_PARTITION && LA253_1 <= K_POSITIVE_NAN)||(LA253_1 >= K_REPLACE && LA253_1 <= K_RETURNS)||(LA253_1 >= K_ROLE && LA253_1 <= K_ROLES)||LA253_1==K_SELECT_MASKED||(LA253_1 >= K_SFUNC && LA253_1 <= K_TINYINT)||(LA253_1 >= K_TOKEN && LA253_1 <= K_TRIGGER)||(LA253_1 >= K_TTL && LA253_1 <= K_TYPES)||(LA253_1 >= K_UNMASK && LA253_1 <= K_UNSET)||(LA253_1 >= K_USER && LA253_1 <= K_USERS)||(LA253_1 >= K_UUID && LA253_1 <= K_VECTOR)||LA253_1==K_WRITETIME||(LA253_1 >= QMARK && LA253_1 <= QUOTED_NAME)||LA253_1==STRING_LITERAL||LA253_1==UUID||LA253_1==209||LA253_1==214||LA253_1==218||LA253_1==225||LA253_1==229) ) {
					alt253=1;
				}
			}
			switch (alt253) {
				case 1 :
					// Parser.g:1809:46: K_KEY
					{
					match(input,K_KEY,FOLLOW_K_KEY_in_containsOperator14257); if (state.failed) return o;
					if ( state.backtracking==0 ) { o = Operator.CONTAINS_KEY; }
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return o;
	}
	// $ANTLR end "containsOperator"



	// $ANTLR start "inMarker"
	// Parser.g:1812:1: inMarker returns [AbstractMarker.INRaw marker] : ( QMARK | ':' name= noncol_ident );
	public final AbstractMarker.INRaw inMarker() throws RecognitionException {
		AbstractMarker.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// Parser.g:1813:5: ( QMARK | ':' name= noncol_ident )
			int alt254=2;
			int LA254_0 = input.LA(1);
			if ( (LA254_0==QMARK) ) {
				alt254=1;
			}
			else if ( (LA254_0==218) ) {
				alt254=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return marker;}
				NoViableAltException nvae =
					new NoViableAltException("", 254, 0, input);
				throw nvae;
			}

			switch (alt254) {
				case 1 :
					// Parser.g:1813:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarker14282); if (state.failed) return marker;
					if ( state.backtracking==0 ) { marker = newINBindVariables(null); }
					}
					break;
				case 2 :
					// Parser.g:1814:7: ':' name= noncol_ident
					{
					match(input,218,FOLLOW_218_in_inMarker14292); if (state.failed) return marker;
					pushFollow(FOLLOW_noncol_ident_in_inMarker14296);
					name=noncol_ident();
					state._fsp--;
					if (state.failed) return marker;
					if ( state.backtracking==0 ) { marker = newINBindVariables(name); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarker"



	// $ANTLR start "tupleOfIdentifiers"
	// Parser.g:1817:1: tupleOfIdentifiers returns [List<ColumnIdentifier> ids] : '(' n1= cident ( ',' ni= cident )* ')' ;
	public final List<ColumnIdentifier> tupleOfIdentifiers() throws RecognitionException {
		List<ColumnIdentifier> ids = null;


		ColumnIdentifier n1 =null;
		ColumnIdentifier ni =null;

		 ids = new ArrayList<ColumnIdentifier>(); 
		try {
			// Parser.g:1819:5: ( '(' n1= cident ( ',' ni= cident )* ')' )
			// Parser.g:1819:7: '(' n1= cident ( ',' ni= cident )* ')'
			{
			match(input,209,FOLLOW_209_in_tupleOfIdentifiers14328); if (state.failed) return ids;
			pushFollow(FOLLOW_cident_in_tupleOfIdentifiers14332);
			n1=cident();
			state._fsp--;
			if (state.failed) return ids;
			if ( state.backtracking==0 ) { ids.add(n1); }
			// Parser.g:1819:39: ( ',' ni= cident )*
			loop255:
			while (true) {
				int alt255=2;
				int LA255_0 = input.LA(1);
				if ( (LA255_0==213) ) {
					alt255=1;
				}

				switch (alt255) {
				case 1 :
					// Parser.g:1819:40: ',' ni= cident
					{
					match(input,213,FOLLOW_213_in_tupleOfIdentifiers14337); if (state.failed) return ids;
					pushFollow(FOLLOW_cident_in_tupleOfIdentifiers14341);
					ni=cident();
					state._fsp--;
					if (state.failed) return ids;
					if ( state.backtracking==0 ) { ids.add(ni); }
					}
					break;

				default :
					break loop255;
				}
			}

			match(input,210,FOLLOW_210_in_tupleOfIdentifiers14347); if (state.failed) return ids;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ids;
	}
	// $ANTLR end "tupleOfIdentifiers"



	// $ANTLR start "singleColumnInValues"
	// Parser.g:1822:1: singleColumnInValues returns [List<Term.Raw> terms] : '(' (t1= term ( ',' ti= term )* )? ')' ;
	public final List<Term.Raw> singleColumnInValues() throws RecognitionException {
		List<Term.Raw> terms = null;


		Term.Raw t1 =null;
		Term.Raw ti =null;

		 terms = new ArrayList<Term.Raw>(); 
		try {
			// Parser.g:1824:5: ( '(' (t1= term ( ',' ti= term )* )? ')' )
			// Parser.g:1824:7: '(' (t1= term ( ',' ti= term )* )? ')'
			{
			match(input,209,FOLLOW_209_in_singleColumnInValues14377); if (state.failed) return terms;
			// Parser.g:1824:11: (t1= term ( ',' ti= term )* )?
			int alt257=2;
			int LA257_0 = input.LA(1);
			if ( (LA257_0==BOOLEAN||LA257_0==DURATION||LA257_0==FLOAT||LA257_0==HEXNUMBER||(LA257_0 >= IDENT && LA257_0 <= INTEGER)||LA257_0==K_ACCESS||(LA257_0 >= K_AGGREGATE && LA257_0 <= K_ALL)||LA257_0==K_ANN||LA257_0==K_AS||LA257_0==K_ASCII||(LA257_0 >= K_BIGINT && LA257_0 <= K_BOOLEAN)||(LA257_0 >= K_CALLED && LA257_0 <= K_CLUSTERING)||(LA257_0 >= K_COMPACT && LA257_0 <= K_COUNTER)||(LA257_0 >= K_CUSTOM && LA257_0 <= K_DEFAULT)||(LA257_0 >= K_DISTINCT && LA257_0 <= K_DOUBLE)||LA257_0==K_DURATION||(LA257_0 >= K_EXISTS && LA257_0 <= K_FLOAT)||LA257_0==K_FROZEN||(LA257_0 >= K_FUNCTION && LA257_0 <= K_FUNCTIONS)||(LA257_0 >= K_GROUP && LA257_0 <= K_IDENTITY)||(LA257_0 >= K_INET && LA257_0 <= K_INPUT)||(LA257_0 >= K_INT && LA257_0 <= K_INTERNALS)||(LA257_0 >= K_JSON && LA257_0 <= K_KEYS)||(LA257_0 >= K_KEYSPACES && LA257_0 <= K_LIKE)||(LA257_0 >= K_LIST && LA257_0 <= K_MASKED)||(LA257_0 >= K_MAXWRITETIME && LA257_0 <= K_MBEANS)||(LA257_0 >= K_NEGATIVE_INFINITY && LA257_0 <= K_NOLOGIN)||LA257_0==K_NOSUPERUSER||LA257_0==K_NULL||(LA257_0 >= K_ONLY && LA257_0 <= K_OPTIONS)||(LA257_0 >= K_PARTITION && LA257_0 <= K_POSITIVE_NAN)||(LA257_0 >= K_REPLACE && LA257_0 <= K_RETURNS)||(LA257_0 >= K_ROLE && LA257_0 <= K_ROLES)||LA257_0==K_SELECT_MASKED||(LA257_0 >= K_SFUNC && LA257_0 <= K_TINYINT)||(LA257_0 >= K_TOKEN && LA257_0 <= K_TRIGGER)||(LA257_0 >= K_TTL && LA257_0 <= K_TYPES)||(LA257_0 >= K_UNMASK && LA257_0 <= K_UNSET)||(LA257_0 >= K_USER && LA257_0 <= K_USERS)||(LA257_0 >= K_UUID && LA257_0 <= K_VECTOR)||LA257_0==K_WRITETIME||(LA257_0 >= QMARK && LA257_0 <= QUOTED_NAME)||LA257_0==STRING_LITERAL||LA257_0==UUID||LA257_0==209||LA257_0==214||LA257_0==218||LA257_0==225||LA257_0==229) ) {
				alt257=1;
			}
			switch (alt257) {
				case 1 :
					// Parser.g:1824:13: t1= term ( ',' ti= term )*
					{
					pushFollow(FOLLOW_term_in_singleColumnInValues14385);
					t1=term();
					state._fsp--;
					if (state.failed) return terms;
					if ( state.backtracking==0 ) { terms.add(t1); }
					// Parser.g:1824:43: ( ',' ti= term )*
					loop256:
					while (true) {
						int alt256=2;
						int LA256_0 = input.LA(1);
						if ( (LA256_0==213) ) {
							alt256=1;
						}

						switch (alt256) {
						case 1 :
							// Parser.g:1824:44: ',' ti= term
							{
							match(input,213,FOLLOW_213_in_singleColumnInValues14390); if (state.failed) return terms;
							pushFollow(FOLLOW_term_in_singleColumnInValues14394);
							ti=term();
							state._fsp--;
							if (state.failed) return terms;
							if ( state.backtracking==0 ) { terms.add(ti); }
							}
							break;

						default :
							break loop256;
						}
					}

					}
					break;

			}

			match(input,210,FOLLOW_210_in_singleColumnInValues14403); if (state.failed) return terms;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return terms;
	}
	// $ANTLR end "singleColumnInValues"



	// $ANTLR start "tupleOfTupleLiterals"
	// Parser.g:1827:1: tupleOfTupleLiterals returns [List<Tuples.Literal> literals] : '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' ;
	public final List<Tuples.Literal> tupleOfTupleLiterals() throws RecognitionException {
		List<Tuples.Literal> literals = null;


		Tuples.Literal t1 =null;
		Tuples.Literal ti =null;

		 literals = new ArrayList<>(); 
		try {
			// Parser.g:1829:5: ( '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' )
			// Parser.g:1829:7: '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')'
			{
			match(input,209,FOLLOW_209_in_tupleOfTupleLiterals14433); if (state.failed) return literals;
			pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals14437);
			t1=tupleLiteral();
			state._fsp--;
			if (state.failed) return literals;
			if ( state.backtracking==0 ) { literals.add(t1); }
			// Parser.g:1829:50: ( ',' ti= tupleLiteral )*
			loop258:
			while (true) {
				int alt258=2;
				int LA258_0 = input.LA(1);
				if ( (LA258_0==213) ) {
					alt258=1;
				}

				switch (alt258) {
				case 1 :
					// Parser.g:1829:51: ',' ti= tupleLiteral
					{
					match(input,213,FOLLOW_213_in_tupleOfTupleLiterals14442); if (state.failed) return literals;
					pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals14446);
					ti=tupleLiteral();
					state._fsp--;
					if (state.failed) return literals;
					if ( state.backtracking==0 ) { literals.add(ti); }
					}
					break;

				default :
					break loop258;
				}
			}

			match(input,210,FOLLOW_210_in_tupleOfTupleLiterals14452); if (state.failed) return literals;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return literals;
	}
	// $ANTLR end "tupleOfTupleLiterals"



	// $ANTLR start "markerForTuple"
	// Parser.g:1832:1: markerForTuple returns [Tuples.Raw marker] : ( QMARK | ':' name= noncol_ident );
	public final Tuples.Raw markerForTuple() throws RecognitionException {
		Tuples.Raw marker = null;


		ColumnIdentifier name =null;

		try {
			// Parser.g:1833:5: ( QMARK | ':' name= noncol_ident )
			int alt259=2;
			int LA259_0 = input.LA(1);
			if ( (LA259_0==QMARK) ) {
				alt259=1;
			}
			else if ( (LA259_0==218) ) {
				alt259=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return marker;}
				NoViableAltException nvae =
					new NoViableAltException("", 259, 0, input);
				throw nvae;
			}

			switch (alt259) {
				case 1 :
					// Parser.g:1833:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_markerForTuple14473); if (state.failed) return marker;
					if ( state.backtracking==0 ) { marker = newTupleBindVariables(null); }
					}
					break;
				case 2 :
					// Parser.g:1834:7: ':' name= noncol_ident
					{
					match(input,218,FOLLOW_218_in_markerForTuple14483); if (state.failed) return marker;
					pushFollow(FOLLOW_noncol_ident_in_markerForTuple14487);
					name=noncol_ident();
					state._fsp--;
					if (state.failed) return marker;
					if ( state.backtracking==0 ) { marker = newTupleBindVariables(name); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "markerForTuple"



	// $ANTLR start "tupleOfMarkersForTuples"
	// Parser.g:1837:1: tupleOfMarkersForTuples returns [List<Tuples.Raw> markers] : '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' ;
	public final List<Tuples.Raw> tupleOfMarkersForTuples() throws RecognitionException {
		List<Tuples.Raw> markers = null;


		Tuples.Raw m1 =null;
		Tuples.Raw mi =null;

		 markers = new ArrayList<Tuples.Raw>(); 
		try {
			// Parser.g:1839:5: ( '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' )
			// Parser.g:1839:7: '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')'
			{
			match(input,209,FOLLOW_209_in_tupleOfMarkersForTuples14519); if (state.failed) return markers;
			pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples14523);
			m1=markerForTuple();
			state._fsp--;
			if (state.failed) return markers;
			if ( state.backtracking==0 ) { markers.add(m1); }
			// Parser.g:1839:51: ( ',' mi= markerForTuple )*
			loop260:
			while (true) {
				int alt260=2;
				int LA260_0 = input.LA(1);
				if ( (LA260_0==213) ) {
					alt260=1;
				}

				switch (alt260) {
				case 1 :
					// Parser.g:1839:52: ',' mi= markerForTuple
					{
					match(input,213,FOLLOW_213_in_tupleOfMarkersForTuples14528); if (state.failed) return markers;
					pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples14532);
					mi=markerForTuple();
					state._fsp--;
					if (state.failed) return markers;
					if ( state.backtracking==0 ) { markers.add(mi); }
					}
					break;

				default :
					break loop260;
				}
			}

			match(input,210,FOLLOW_210_in_tupleOfMarkersForTuples14538); if (state.failed) return markers;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return markers;
	}
	// $ANTLR end "tupleOfMarkersForTuples"



	// $ANTLR start "inMarkerForTuple"
	// Parser.g:1842:1: inMarkerForTuple returns [Tuples.INRaw marker] : ( QMARK | ':' name= noncol_ident );
	public final Tuples.INRaw inMarkerForTuple() throws RecognitionException {
		Tuples.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// Parser.g:1843:5: ( QMARK | ':' name= noncol_ident )
			int alt261=2;
			int LA261_0 = input.LA(1);
			if ( (LA261_0==QMARK) ) {
				alt261=1;
			}
			else if ( (LA261_0==218) ) {
				alt261=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return marker;}
				NoViableAltException nvae =
					new NoViableAltException("", 261, 0, input);
				throw nvae;
			}

			switch (alt261) {
				case 1 :
					// Parser.g:1843:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarkerForTuple14559); if (state.failed) return marker;
					if ( state.backtracking==0 ) { marker = newTupleINBindVariables(null); }
					}
					break;
				case 2 :
					// Parser.g:1844:7: ':' name= noncol_ident
					{
					match(input,218,FOLLOW_218_in_inMarkerForTuple14569); if (state.failed) return marker;
					pushFollow(FOLLOW_noncol_ident_in_inMarkerForTuple14573);
					name=noncol_ident();
					state._fsp--;
					if (state.failed) return marker;
					if ( state.backtracking==0 ) { marker = newTupleINBindVariables(name); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarkerForTuple"



	// $ANTLR start "comparatorType"
	// Parser.g:1847:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |vc= vector_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );
	public final CQL3Type.Raw comparatorType() throws RecognitionException {
		CQL3Type.Raw t = null;


		Token s=null;
		CQL3Type n =null;
		CQL3Type.Raw c =null;
		CQL3Type.Raw tt =null;
		CQL3Type.Raw vc =null;
		UTName id =null;
		CQL3Type.Raw f =null;

		try {
			// Parser.g:1848:5: (n= native_type |c= collection_type |tt= tuple_type |vc= vector_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL )
			int alt262=7;
			alt262 = dfa262.predict(input);
			switch (alt262) {
				case 1 :
					// Parser.g:1848:7: n= native_type
					{
					pushFollow(FOLLOW_native_type_in_comparatorType14598);
					n=native_type();
					state._fsp--;
					if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Raw.from(n); }
					}
					break;
				case 2 :
					// Parser.g:1849:7: c= collection_type
					{
					pushFollow(FOLLOW_collection_type_in_comparatorType14614);
					c=collection_type();
					state._fsp--;
					if (state.failed) return t;
					if ( state.backtracking==0 ) { t = c; }
					}
					break;
				case 3 :
					// Parser.g:1850:7: tt= tuple_type
					{
					pushFollow(FOLLOW_tuple_type_in_comparatorType14626);
					tt=tuple_type();
					state._fsp--;
					if (state.failed) return t;
					if ( state.backtracking==0 ) { t = tt; }
					}
					break;
				case 4 :
					// Parser.g:1851:7: vc= vector_type
					{
					pushFollow(FOLLOW_vector_type_in_comparatorType14642);
					vc=vector_type();
					state._fsp--;
					if (state.failed) return t;
					if ( state.backtracking==0 ) { t = vc; }
					}
					break;
				case 5 :
					// Parser.g:1852:7: id= userTypeName
					{
					pushFollow(FOLLOW_userTypeName_in_comparatorType14657);
					id=userTypeName();
					state._fsp--;
					if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Raw.userType(id); }
					}
					break;
				case 6 :
					// Parser.g:1853:7: K_FROZEN '<' f= comparatorType '>'
					{
					match(input,K_FROZEN,FOLLOW_K_FROZEN_in_comparatorType14669); if (state.failed) return t;
					match(input,220,FOLLOW_220_in_comparatorType14671); if (state.failed) return t;
					pushFollow(FOLLOW_comparatorType_in_comparatorType14675);
					f=comparatorType();
					state._fsp--;
					if (state.failed) return t;
					match(input,223,FOLLOW_223_in_comparatorType14677); if (state.failed) return t;
					if ( state.backtracking==0 ) {
					        try {
					            t = f.freeze();
					        } catch (InvalidRequestException e) {
					            addRecognitionError(e.getMessage());
					        }
					      }
					}
					break;
				case 7 :
					// Parser.g:1861:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType14695); if (state.failed) return t;
					if ( state.backtracking==0 ) {
					        try {
					            t = CQL3Type.Raw.from(new CQL3Type.Custom((s!=null?s.getText():null)));
					        } catch (SyntaxException e) {
					            addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        } catch (ConfigurationException e) {
					            addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        }
					      }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "comparatorType"



	// $ANTLR start "native_type"
	// Parser.g:1873:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_DURATION | K_FLOAT | K_INET | K_INT | K_SMALLINT | K_TEXT | K_TIMESTAMP | K_TINYINT | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID | K_DATE | K_TIME );
	public final CQL3Type native_type() throws RecognitionException {
		CQL3Type t = null;


		try {
			// Parser.g:1874:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_DURATION | K_FLOAT | K_INET | K_INT | K_SMALLINT | K_TEXT | K_TIMESTAMP | K_TINYINT | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID | K_DATE | K_TIME )
			int alt263=21;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				alt263=1;
				}
				break;
			case K_BIGINT:
				{
				alt263=2;
				}
				break;
			case K_BLOB:
				{
				alt263=3;
				}
				break;
			case K_BOOLEAN:
				{
				alt263=4;
				}
				break;
			case K_COUNTER:
				{
				alt263=5;
				}
				break;
			case K_DECIMAL:
				{
				alt263=6;
				}
				break;
			case K_DOUBLE:
				{
				alt263=7;
				}
				break;
			case K_DURATION:
				{
				alt263=8;
				}
				break;
			case K_FLOAT:
				{
				alt263=9;
				}
				break;
			case K_INET:
				{
				alt263=10;
				}
				break;
			case K_INT:
				{
				alt263=11;
				}
				break;
			case K_SMALLINT:
				{
				alt263=12;
				}
				break;
			case K_TEXT:
				{
				alt263=13;
				}
				break;
			case K_TIMESTAMP:
				{
				alt263=14;
				}
				break;
			case K_TINYINT:
				{
				alt263=15;
				}
				break;
			case K_UUID:
				{
				alt263=16;
				}
				break;
			case K_VARCHAR:
				{
				alt263=17;
				}
				break;
			case K_VARINT:
				{
				alt263=18;
				}
				break;
			case K_TIMEUUID:
				{
				alt263=19;
				}
				break;
			case K_DATE:
				{
				alt263=20;
				}
				break;
			case K_TIME:
				{
				alt263=21;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return t;}
				NoViableAltException nvae =
					new NoViableAltException("", 263, 0, input);
				throw nvae;
			}
			switch (alt263) {
				case 1 :
					// Parser.g:1874:7: K_ASCII
					{
					match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type14724); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.ASCII; }
					}
					break;
				case 2 :
					// Parser.g:1875:7: K_BIGINT
					{
					match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type14738); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.BIGINT; }
					}
					break;
				case 3 :
					// Parser.g:1876:7: K_BLOB
					{
					match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type14751); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.BLOB; }
					}
					break;
				case 4 :
					// Parser.g:1877:7: K_BOOLEAN
					{
					match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type14766); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.BOOLEAN; }
					}
					break;
				case 5 :
					// Parser.g:1878:7: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type14778); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.COUNTER; }
					}
					break;
				case 6 :
					// Parser.g:1879:7: K_DECIMAL
					{
					match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type14790); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.DECIMAL; }
					}
					break;
				case 7 :
					// Parser.g:1880:7: K_DOUBLE
					{
					match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type14802); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.DOUBLE; }
					}
					break;
				case 8 :
					// Parser.g:1881:7: K_DURATION
					{
					match(input,K_DURATION,FOLLOW_K_DURATION_in_native_type14815); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.DURATION; }
					}
					break;
				case 9 :
					// Parser.g:1882:7: K_FLOAT
					{
					match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type14826); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.FLOAT; }
					}
					break;
				case 10 :
					// Parser.g:1883:7: K_INET
					{
					match(input,K_INET,FOLLOW_K_INET_in_native_type14840); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.INET;}
					}
					break;
				case 11 :
					// Parser.g:1884:7: K_INT
					{
					match(input,K_INT,FOLLOW_K_INT_in_native_type14855); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.INT; }
					}
					break;
				case 12 :
					// Parser.g:1885:7: K_SMALLINT
					{
					match(input,K_SMALLINT,FOLLOW_K_SMALLINT_in_native_type14871); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.SMALLINT; }
					}
					break;
				case 13 :
					// Parser.g:1886:7: K_TEXT
					{
					match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type14882); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.TEXT; }
					}
					break;
				case 14 :
					// Parser.g:1887:7: K_TIMESTAMP
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type14897); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.TIMESTAMP; }
					}
					break;
				case 15 :
					// Parser.g:1888:7: K_TINYINT
					{
					match(input,K_TINYINT,FOLLOW_K_TINYINT_in_native_type14907); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.TINYINT; }
					}
					break;
				case 16 :
					// Parser.g:1889:7: K_UUID
					{
					match(input,K_UUID,FOLLOW_K_UUID_in_native_type14919); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.UUID; }
					}
					break;
				case 17 :
					// Parser.g:1890:7: K_VARCHAR
					{
					match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type14934); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.VARCHAR; }
					}
					break;
				case 18 :
					// Parser.g:1891:7: K_VARINT
					{
					match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type14946); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.VARINT; }
					}
					break;
				case 19 :
					// Parser.g:1892:7: K_TIMEUUID
					{
					match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type14959); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.TIMEUUID; }
					}
					break;
				case 20 :
					// Parser.g:1893:7: K_DATE
					{
					match(input,K_DATE,FOLLOW_K_DATE_in_native_type14970); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.DATE; }
					}
					break;
				case 21 :
					// Parser.g:1894:7: K_TIME
					{
					match(input,K_TIME,FOLLOW_K_TIME_in_native_type14985); if (state.failed) return t;
					if ( state.backtracking==0 ) { t = CQL3Type.Native.TIME; }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "native_type"



	// $ANTLR start "collection_type"
	// Parser.g:1897:1: collection_type returns [CQL3Type.Raw pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
	public final CQL3Type.Raw collection_type() throws RecognitionException {
		CQL3Type.Raw pt = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw t2 =null;
		CQL3Type.Raw t =null;

		try {
			// Parser.g:1898:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
			int alt264=3;
			switch ( input.LA(1) ) {
			case K_MAP:
				{
				alt264=1;
				}
				break;
			case K_LIST:
				{
				alt264=2;
				}
				break;
			case K_SET:
				{
				alt264=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return pt;}
				NoViableAltException nvae =
					new NoViableAltException("", 264, 0, input);
				throw nvae;
			}
			switch (alt264) {
				case 1 :
					// Parser.g:1898:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
					{
					match(input,K_MAP,FOLLOW_K_MAP_in_collection_type15013); if (state.failed) return pt;
					match(input,220,FOLLOW_220_in_collection_type15016); if (state.failed) return pt;
					pushFollow(FOLLOW_comparatorType_in_collection_type15020);
					t1=comparatorType();
					state._fsp--;
					if (state.failed) return pt;
					match(input,213,FOLLOW_213_in_collection_type15022); if (state.failed) return pt;
					pushFollow(FOLLOW_comparatorType_in_collection_type15026);
					t2=comparatorType();
					state._fsp--;
					if (state.failed) return pt;
					match(input,223,FOLLOW_223_in_collection_type15028); if (state.failed) return pt;
					if ( state.backtracking==0 ) {
					            // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
					            if (t1 != null && t2 != null)
					                pt = CQL3Type.Raw.map(t1, t2);
					        }
					}
					break;
				case 2 :
					// Parser.g:1904:7: K_LIST '<' t= comparatorType '>'
					{
					match(input,K_LIST,FOLLOW_K_LIST_in_collection_type15046); if (state.failed) return pt;
					match(input,220,FOLLOW_220_in_collection_type15048); if (state.failed) return pt;
					pushFollow(FOLLOW_comparatorType_in_collection_type15052);
					t=comparatorType();
					state._fsp--;
					if (state.failed) return pt;
					match(input,223,FOLLOW_223_in_collection_type15054); if (state.failed) return pt;
					if ( state.backtracking==0 ) { if (t != null) pt = CQL3Type.Raw.list(t); }
					}
					break;
				case 3 :
					// Parser.g:1906:7: K_SET '<' t= comparatorType '>'
					{
					match(input,K_SET,FOLLOW_K_SET_in_collection_type15072); if (state.failed) return pt;
					match(input,220,FOLLOW_220_in_collection_type15075); if (state.failed) return pt;
					pushFollow(FOLLOW_comparatorType_in_collection_type15079);
					t=comparatorType();
					state._fsp--;
					if (state.failed) return pt;
					match(input,223,FOLLOW_223_in_collection_type15081); if (state.failed) return pt;
					if ( state.backtracking==0 ) { if (t != null) pt = CQL3Type.Raw.set(t); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pt;
	}
	// $ANTLR end "collection_type"



	// $ANTLR start "tuple_type"
	// Parser.g:1910:1: tuple_type returns [CQL3Type.Raw t] : K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' ;
	public final CQL3Type.Raw tuple_type() throws RecognitionException {
		CQL3Type.Raw t = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw tn =null;

		List<CQL3Type.Raw> types = new ArrayList<>();
		try {
			// Parser.g:1913:5: ( K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' )
			// Parser.g:1913:7: K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>'
			{
			match(input,K_TUPLE,FOLLOW_K_TUPLE_in_tuple_type15130); if (state.failed) return t;
			match(input,220,FOLLOW_220_in_tuple_type15132); if (state.failed) return t;
			pushFollow(FOLLOW_comparatorType_in_tuple_type15136);
			t1=comparatorType();
			state._fsp--;
			if (state.failed) return t;
			if ( state.backtracking==0 ) { types.add(t1); }
			// Parser.g:1913:56: ( ',' tn= comparatorType )*
			loop265:
			while (true) {
				int alt265=2;
				int LA265_0 = input.LA(1);
				if ( (LA265_0==213) ) {
					alt265=1;
				}

				switch (alt265) {
				case 1 :
					// Parser.g:1913:57: ',' tn= comparatorType
					{
					match(input,213,FOLLOW_213_in_tuple_type15141); if (state.failed) return t;
					pushFollow(FOLLOW_comparatorType_in_tuple_type15145);
					tn=comparatorType();
					state._fsp--;
					if (state.failed) return t;
					if ( state.backtracking==0 ) { types.add(tn); }
					}
					break;

				default :
					break loop265;
				}
			}

			match(input,223,FOLLOW_223_in_tuple_type15151); if (state.failed) return t;
			}

			if ( state.backtracking==0 ) {t = CQL3Type.Raw.tuple(types);}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "tuple_type"



	// $ANTLR start "vector_type"
	// Parser.g:1916:1: vector_type returns [CQL3Type.Raw vt] : K_VECTOR '<' t1= comparatorType ',' d= INTEGER '>' ;
	public final CQL3Type.Raw vector_type() throws RecognitionException {
		CQL3Type.Raw vt = null;


		Token d=null;
		CQL3Type.Raw t1 =null;

		try {
			// Parser.g:1917:5: ( K_VECTOR '<' t1= comparatorType ',' d= INTEGER '>' )
			// Parser.g:1917:7: K_VECTOR '<' t1= comparatorType ',' d= INTEGER '>'
			{
			match(input,K_VECTOR,FOLLOW_K_VECTOR_in_vector_type15172); if (state.failed) return vt;
			match(input,220,FOLLOW_220_in_vector_type15174); if (state.failed) return vt;
			pushFollow(FOLLOW_comparatorType_in_vector_type15178);
			t1=comparatorType();
			state._fsp--;
			if (state.failed) return vt;
			match(input,213,FOLLOW_213_in_vector_type15180); if (state.failed) return vt;
			d=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_vector_type15185); if (state.failed) return vt;
			match(input,223,FOLLOW_223_in_vector_type15187); if (state.failed) return vt;
			if ( state.backtracking==0 ) { vt = CQL3Type.Raw.vector(t1, Integer.parseInt((d!=null?d.getText():null))); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return vt;
	}
	// $ANTLR end "vector_type"


	public static class username_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "username"
	// Parser.g:1921:1: username : ( IDENT | STRING_LITERAL | QUOTED_NAME );
	public final Cql_Parser.username_return username() throws RecognitionException {
		Cql_Parser.username_return retval = new Cql_Parser.username_return();
		retval.start = input.LT(1);

		try {
			// Parser.g:1922:5: ( IDENT | STRING_LITERAL | QUOTED_NAME )
			int alt266=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt266=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt266=2;
				}
				break;
			case QUOTED_NAME:
				{
				alt266=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 266, 0, input);
				throw nvae;
			}
			switch (alt266) {
				case 1 :
					// Parser.g:1922:7: IDENT
					{
					match(input,IDENT,FOLLOW_IDENT_in_username15214); if (state.failed) return retval;
					}
					break;
				case 2 :
					// Parser.g:1923:7: STRING_LITERAL
					{
					match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_username15222); if (state.failed) return retval;
					}
					break;
				case 3 :
					// Parser.g:1924:7: QUOTED_NAME
					{
					match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_username15230); if (state.failed) return retval;
					if ( state.backtracking==0 ) { addRecognitionError("Quoted strings are are not supported for user names and USER is deprecated, please use ROLE");}
					}
					break;

			}
			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "username"


	public static class identity_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "identity"
	// Parser.g:1927:1: identity : ( IDENT | STRING_LITERAL | QUOTED_NAME );
	public final Cql_Parser.identity_return identity() throws RecognitionException {
		Cql_Parser.identity_return retval = new Cql_Parser.identity_return();
		retval.start = input.LT(1);

		try {
			// Parser.g:1928:5: ( IDENT | STRING_LITERAL | QUOTED_NAME )
			int alt267=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt267=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt267=2;
				}
				break;
			case QUOTED_NAME:
				{
				alt267=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 267, 0, input);
				throw nvae;
			}
			switch (alt267) {
				case 1 :
					// Parser.g:1928:7: IDENT
					{
					match(input,IDENT,FOLLOW_IDENT_in_identity15249); if (state.failed) return retval;
					}
					break;
				case 2 :
					// Parser.g:1929:7: STRING_LITERAL
					{
					match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_identity15257); if (state.failed) return retval;
					}
					break;
				case 3 :
					// Parser.g:1930:7: QUOTED_NAME
					{
					match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_identity15265); if (state.failed) return retval;
					if ( state.backtracking==0 ) { addRecognitionError("Quoted strings are are not supported for identity");}
					}
					break;

			}
			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "identity"


	public static class mbean_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "mbean"
	// Parser.g:1933:1: mbean : STRING_LITERAL ;
	public final Cql_Parser.mbean_return mbean() throws RecognitionException {
		Cql_Parser.mbean_return retval = new Cql_Parser.mbean_return();
		retval.start = input.LT(1);

		try {
			// Parser.g:1934:5: ( STRING_LITERAL )
			// Parser.g:1934:7: STRING_LITERAL
			{
			match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_mbean15284); if (state.failed) return retval;
			}

			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mbean"



	// $ANTLR start "non_type_ident"
	// Parser.g:1939:1: non_type_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY );
	public final ColumnIdentifier non_type_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		Token kk=null;
		String k =null;

		try {
			// Parser.g:1940:5: (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY )
			int alt268=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt268=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt268=2;
				}
				break;
			case K_ACCESS:
			case K_AGGREGATE:
			case K_AGGREGATES:
			case K_ALL:
			case K_ANN:
			case K_AS:
			case K_CALLED:
			case K_CIDRS:
			case K_CLUSTER:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DATACENTERS:
			case K_DEFAULT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_GROUP:
			case K_HASHED:
			case K_IDENTITY:
			case K_INITCOND:
			case K_INPUT:
			case K_INTERNALS:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIKE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_MASKED:
			case K_MBEAN:
			case K_MBEANS:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_ONLY:
			case K_OPTIONS:
			case K_PARTITION:
			case K_PASSWORD:
			case K_PER:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_REPLACE:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SELECT_MASKED:
			case K_SFUNC:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TABLES:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_TYPES:
			case K_UNMASK:
			case K_UNSET:
			case K_USER:
			case K_USERS:
			case K_VALUES:
			case K_VECTOR:
				{
				alt268=3;
				}
				break;
			case K_KEY:
				{
				alt268=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return id;}
				NoViableAltException nvae =
					new NoViableAltException("", 268, 0, input);
				throw nvae;
			}
			switch (alt268) {
				case 1 :
					// Parser.g:1940:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_non_type_ident15309); if (state.failed) return id;
					if ( state.backtracking==0 ) { if (reservedTypeNames.contains((t!=null?t.getText():null))) addRecognitionError("Invalid (reserved) user type name " + (t!=null?t.getText():null)); id = new ColumnIdentifier((t!=null?t.getText():null), false); }
					}
					break;
				case 2 :
					// Parser.g:1941:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_non_type_ident15340); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = new ColumnIdentifier((t!=null?t.getText():null), true); }
					}
					break;
				case 3 :
					// Parser.g:1942:7: k= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_non_type_ident15365);
					k=basic_unreserved_keyword();
					state._fsp--;
					if (state.failed) return id;
					if ( state.backtracking==0 ) { id = new ColumnIdentifier(k, false); }
					}
					break;
				case 4 :
					// Parser.g:1943:7: kk= K_KEY
					{
					kk=(Token)match(input,K_KEY,FOLLOW_K_KEY_in_non_type_ident15377); if (state.failed) return id;
					if ( state.backtracking==0 ) { id = new ColumnIdentifier((kk!=null?kk.getText():null), false); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "non_type_ident"



	// $ANTLR start "unreserved_keyword"
	// Parser.g:1946:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_MAXWRITETIME | K_KEY | K_CAST | K_JSON | K_DISTINCT ) );
	public final String unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;
		String u =null;

		try {
			// Parser.g:1947:5: (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_MAXWRITETIME | K_KEY | K_CAST | K_JSON | K_DISTINCT ) )
			int alt269=2;
			int LA269_0 = input.LA(1);
			if ( (LA269_0==K_ACCESS||(LA269_0 >= K_AGGREGATE && LA269_0 <= K_ALL)||LA269_0==K_ANN||LA269_0==K_AS||LA269_0==K_ASCII||(LA269_0 >= K_BIGINT && LA269_0 <= K_BOOLEAN)||LA269_0==K_CALLED||(LA269_0 >= K_CIDRS && LA269_0 <= K_CLUSTERING)||(LA269_0 >= K_COMPACT && LA269_0 <= K_CONTAINS)||LA269_0==K_COUNTER||(LA269_0 >= K_CUSTOM && LA269_0 <= K_DEFAULT)||LA269_0==K_DOUBLE||LA269_0==K_DURATION||(LA269_0 >= K_EXISTS && LA269_0 <= K_FLOAT)||LA269_0==K_FROZEN||(LA269_0 >= K_FUNCTION && LA269_0 <= K_FUNCTIONS)||(LA269_0 >= K_GROUP && LA269_0 <= K_IDENTITY)||(LA269_0 >= K_INET && LA269_0 <= K_INPUT)||(LA269_0 >= K_INT && LA269_0 <= K_INTERNALS)||LA269_0==K_KEYS||(LA269_0 >= K_KEYSPACES && LA269_0 <= K_LIKE)||(LA269_0 >= K_LIST && LA269_0 <= K_MASKED)||(LA269_0 >= K_MBEAN && LA269_0 <= K_MBEANS)||LA269_0==K_NOLOGIN||LA269_0==K_NOSUPERUSER||(LA269_0 >= K_ONLY && LA269_0 <= K_OPTIONS)||(LA269_0 >= K_PARTITION && LA269_0 <= K_PERMISSIONS)||(LA269_0 >= K_REPLACE && LA269_0 <= K_RETURNS)||(LA269_0 >= K_ROLE && LA269_0 <= K_ROLES)||LA269_0==K_SELECT_MASKED||(LA269_0 >= K_SFUNC && LA269_0 <= K_TINYINT)||LA269_0==K_TRIGGER||(LA269_0 >= K_TUPLE && LA269_0 <= K_TYPES)||(LA269_0 >= K_UNMASK && LA269_0 <= K_UNSET)||(LA269_0 >= K_USER && LA269_0 <= K_USERS)||(LA269_0 >= K_UUID && LA269_0 <= K_VECTOR)) ) {
				alt269=1;
			}
			else if ( (LA269_0==K_CAST||LA269_0==K_COUNT||LA269_0==K_DISTINCT||(LA269_0 >= K_JSON && LA269_0 <= K_KEY)||LA269_0==K_MAXWRITETIME||LA269_0==K_TTL||LA269_0==K_WRITETIME) ) {
				alt269=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return str;}
				NoViableAltException nvae =
					new NoViableAltException("", 269, 0, input);
				throw nvae;
			}

			switch (alt269) {
				case 1 :
					// Parser.g:1947:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword15420);
					u=unreserved_function_keyword();
					state._fsp--;
					if (state.failed) return str;
					if ( state.backtracking==0 ) { str = u; }
					}
					break;
				case 2 :
					// Parser.g:1948:7: k= ( K_TTL | K_COUNT | K_WRITETIME | K_MAXWRITETIME | K_KEY | K_CAST | K_JSON | K_DISTINCT )
					{
					k=input.LT(1);
					if ( input.LA(1)==K_CAST||input.LA(1)==K_COUNT||input.LA(1)==K_DISTINCT||(input.LA(1) >= K_JSON && input.LA(1) <= K_KEY)||input.LA(1)==K_MAXWRITETIME||input.LA(1)==K_TTL||input.LA(1)==K_WRITETIME ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return str;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { str = (k!=null?k.getText():null); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_keyword"



	// $ANTLR start "unreserved_function_keyword"
	// Parser.g:1951:1: unreserved_function_keyword returns [String str] : (u= basic_unreserved_keyword |t= native_type );
	public final String unreserved_function_keyword() throws RecognitionException {
		String str = null;


		String u =null;
		CQL3Type t =null;

		try {
			// Parser.g:1952:5: (u= basic_unreserved_keyword |t= native_type )
			int alt270=2;
			int LA270_0 = input.LA(1);
			if ( (LA270_0==K_ACCESS||(LA270_0 >= K_AGGREGATE && LA270_0 <= K_ALL)||LA270_0==K_ANN||LA270_0==K_AS||LA270_0==K_CALLED||(LA270_0 >= K_CIDRS && LA270_0 <= K_CLUSTERING)||(LA270_0 >= K_COMPACT && LA270_0 <= K_CONTAINS)||(LA270_0 >= K_CUSTOM && LA270_0 <= K_DATACENTERS)||LA270_0==K_DEFAULT||(LA270_0 >= K_EXISTS && LA270_0 <= K_FINALFUNC)||LA270_0==K_FROZEN||(LA270_0 >= K_FUNCTION && LA270_0 <= K_FUNCTIONS)||(LA270_0 >= K_GROUP && LA270_0 <= K_IDENTITY)||(LA270_0 >= K_INITCOND && LA270_0 <= K_INPUT)||LA270_0==K_INTERNALS||LA270_0==K_KEYS||(LA270_0 >= K_KEYSPACES && LA270_0 <= K_LIKE)||(LA270_0 >= K_LIST && LA270_0 <= K_MASKED)||(LA270_0 >= K_MBEAN && LA270_0 <= K_MBEANS)||LA270_0==K_NOLOGIN||LA270_0==K_NOSUPERUSER||(LA270_0 >= K_ONLY && LA270_0 <= K_OPTIONS)||(LA270_0 >= K_PARTITION && LA270_0 <= K_PERMISSIONS)||(LA270_0 >= K_REPLACE && LA270_0 <= K_RETURNS)||(LA270_0 >= K_ROLE && LA270_0 <= K_ROLES)||LA270_0==K_SELECT_MASKED||LA270_0==K_SFUNC||(LA270_0 >= K_STATIC && LA270_0 <= K_TABLES)||LA270_0==K_TRIGGER||(LA270_0 >= K_TUPLE && LA270_0 <= K_TYPES)||(LA270_0 >= K_UNMASK && LA270_0 <= K_UNSET)||(LA270_0 >= K_USER && LA270_0 <= K_USERS)||LA270_0==K_VALUES||LA270_0==K_VECTOR) ) {
				alt270=1;
			}
			else if ( (LA270_0==K_ASCII||(LA270_0 >= K_BIGINT && LA270_0 <= K_BOOLEAN)||LA270_0==K_COUNTER||(LA270_0 >= K_DATE && LA270_0 <= K_DECIMAL)||LA270_0==K_DOUBLE||LA270_0==K_DURATION||LA270_0==K_FLOAT||LA270_0==K_INET||LA270_0==K_INT||LA270_0==K_SMALLINT||(LA270_0 >= K_TEXT && LA270_0 <= K_TINYINT)||LA270_0==K_UUID||(LA270_0 >= K_VARCHAR && LA270_0 <= K_VARINT)) ) {
				alt270=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return str;}
				NoViableAltException nvae =
					new NoViableAltException("", 270, 0, input);
				throw nvae;
			}

			switch (alt270) {
				case 1 :
					// Parser.g:1952:7: u= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword15491);
					u=basic_unreserved_keyword();
					state._fsp--;
					if (state.failed) return str;
					if ( state.backtracking==0 ) { str = u; }
					}
					break;
				case 2 :
					// Parser.g:1953:7: t= native_type
					{
					pushFollow(FOLLOW_native_type_in_unreserved_function_keyword15503);
					t=native_type();
					state._fsp--;
					if (state.failed) return str;
					if ( state.backtracking==0 ) { str = t.toString(); }
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_function_keyword"



	// $ANTLR start "basic_unreserved_keyword"
	// Parser.g:1956:1: basic_unreserved_keyword returns [String str] : k= ( K_KEYS | K_AS | K_CLUSTER | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TABLES | K_TYPE | K_TYPES | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_IDENTITY | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_HASHED | K_EXISTS | K_CUSTOM | K_TRIGGER | K_CONTAINS | K_INTERNALS | K_ONLY | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_AGGREGATES | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_CALLED | K_INPUT | K_LIKE | K_PER | K_PARTITION | K_GROUP | K_DATACENTERS | K_CIDRS | K_ACCESS | K_DEFAULT | K_MBEAN | K_MBEANS | K_REPLACE | K_UNSET | K_MASKED | K_UNMASK | K_SELECT_MASKED | K_VECTOR | K_ANN ) ;
	public final String basic_unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;

		try {
			// Parser.g:1957:5: (k= ( K_KEYS | K_AS | K_CLUSTER | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TABLES | K_TYPE | K_TYPES | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_IDENTITY | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_HASHED | K_EXISTS | K_CUSTOM | K_TRIGGER | K_CONTAINS | K_INTERNALS | K_ONLY | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_AGGREGATES | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_CALLED | K_INPUT | K_LIKE | K_PER | K_PARTITION | K_GROUP | K_DATACENTERS | K_CIDRS | K_ACCESS | K_DEFAULT | K_MBEAN | K_MBEANS | K_REPLACE | K_UNSET | K_MASKED | K_UNMASK | K_SELECT_MASKED | K_VECTOR | K_ANN ) )
			// Parser.g:1957:7: k= ( K_KEYS | K_AS | K_CLUSTER | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TABLES | K_TYPE | K_TYPES | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_IDENTITY | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_HASHED | K_EXISTS | K_CUSTOM | K_TRIGGER | K_CONTAINS | K_INTERNALS | K_ONLY | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_AGGREGATES | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_CALLED | K_INPUT | K_LIKE | K_PER | K_PARTITION | K_GROUP | K_DATACENTERS | K_CIDRS | K_ACCESS | K_DEFAULT | K_MBEAN | K_MBEANS | K_REPLACE | K_UNSET | K_MASKED | K_UNMASK | K_SELECT_MASKED | K_VECTOR | K_ANN )
			{
			k=input.LT(1);
			if ( input.LA(1)==K_ACCESS||(input.LA(1) >= K_AGGREGATE && input.LA(1) <= K_ALL)||input.LA(1)==K_ANN||input.LA(1)==K_AS||input.LA(1)==K_CALLED||(input.LA(1) >= K_CIDRS && input.LA(1) <= K_CLUSTERING)||(input.LA(1) >= K_COMPACT && input.LA(1) <= K_CONTAINS)||(input.LA(1) >= K_CUSTOM && input.LA(1) <= K_DATACENTERS)||input.LA(1)==K_DEFAULT||(input.LA(1) >= K_EXISTS && input.LA(1) <= K_FINALFUNC)||input.LA(1)==K_FROZEN||(input.LA(1) >= K_FUNCTION && input.LA(1) <= K_FUNCTIONS)||(input.LA(1) >= K_GROUP && input.LA(1) <= K_IDENTITY)||(input.LA(1) >= K_INITCOND && input.LA(1) <= K_INPUT)||input.LA(1)==K_INTERNALS||input.LA(1)==K_KEYS||(input.LA(1) >= K_KEYSPACES && input.LA(1) <= K_LIKE)||(input.LA(1) >= K_LIST && input.LA(1) <= K_MASKED)||(input.LA(1) >= K_MBEAN && input.LA(1) <= K_MBEANS)||input.LA(1)==K_NOLOGIN||input.LA(1)==K_NOSUPERUSER||(input.LA(1) >= K_ONLY && input.LA(1) <= K_OPTIONS)||(input.LA(1) >= K_PARTITION && input.LA(1) <= K_PERMISSIONS)||(input.LA(1) >= K_REPLACE && input.LA(1) <= K_RETURNS)||(input.LA(1) >= K_ROLE && input.LA(1) <= K_ROLES)||input.LA(1)==K_SELECT_MASKED||input.LA(1)==K_SFUNC||(input.LA(1) >= K_STATIC && input.LA(1) <= K_TABLES)||input.LA(1)==K_TRIGGER||(input.LA(1) >= K_TUPLE && input.LA(1) <= K_TYPES)||(input.LA(1) >= K_UNMASK && input.LA(1) <= K_UNSET)||(input.LA(1) >= K_USER && input.LA(1) <= K_USERS)||input.LA(1)==K_VALUES||input.LA(1)==K_VECTOR ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return str;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			if ( state.backtracking==0 ) { str = (k!=null?k.getText():null); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "basic_unreserved_keyword"

	// $ANTLR start synpred1_Parser
	public final void synpred1_Parser_fragment() throws RecognitionException {
		// Parser.g:278:9: ( K_JSON selectClause )
		// Parser.g:278:10: K_JSON selectClause
		{
		match(input,K_JSON,FOLLOW_K_JSON_in_synpred1_Parser1133); if (state.failed) return;
		pushFollow(FOLLOW_selectClause_in_synpred1_Parser1135);
		selectClause();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_Parser

	// $ANTLR start synpred2_Parser
	public final void synpred2_Parser_fragment() throws RecognitionException {
		// Parser.g:300:7: ( K_DISTINCT selectors )
		// Parser.g:300:8: K_DISTINCT selectors
		{
		match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_synpred2_Parser1336); if (state.failed) return;
		pushFollow(FOLLOW_selectors_in_synpred2_Parser1338);
		selectors();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred2_Parser

	// $ANTLR start synpred3_Parser
	public final void synpred3_Parser_fragment() throws RecognitionException {
		// Parser.g:334:7: ( selectionGroupWithField )
		// Parser.g:334:8: selectionGroupWithField
		{
		pushFollow(FOLLOW_selectionGroupWithField_in_synpred3_Parser1667);
		selectionGroupWithField();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred3_Parser

	// $ANTLR start synpred4_Parser
	public final void synpred4_Parser_fragment() throws RecognitionException {
		// Parser.g:368:7: ( selectionTypeHint )
		// Parser.g:368:8: selectionTypeHint
		{
		pushFollow(FOLLOW_selectionTypeHint_in_synpred4_Parser1954);
		selectionTypeHint();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred4_Parser

	// $ANTLR start synpred5_Parser
	public final void synpred5_Parser_fragment() throws RecognitionException {
		// Parser.g:1419:7: ( K_CLUSTER )
		// Parser.g:1419:8: K_CLUSTER
		{
		match(input,K_CLUSTER,FOLLOW_K_CLUSTER_in_synpred5_Parser9739); if (state.failed) return;
		}

	}
	// $ANTLR end synpred5_Parser

	// $ANTLR start synpred6_Parser
	public final void synpred6_Parser_fragment() throws RecognitionException {
		// Parser.g:1421:7: ( K_KEYSPACES )
		// Parser.g:1421:8: K_KEYSPACES
		{
		match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_synpred6_Parser9795); if (state.failed) return;
		}

	}
	// $ANTLR end synpred6_Parser

	// $ANTLR start synpred7_Parser
	public final void synpred7_Parser_fragment() throws RecognitionException {
		// Parser.g:1424:7: ( K_TABLES )
		// Parser.g:1424:8: K_TABLES
		{
		match(input,K_TABLES,FOLLOW_K_TABLES_in_synpred7_Parser9902); if (state.failed) return;
		}

	}
	// $ANTLR end synpred7_Parser

	// $ANTLR start synpred8_Parser
	public final void synpred8_Parser_fragment() throws RecognitionException {
		// Parser.g:1428:7: ( K_TYPES )
		// Parser.g:1428:8: K_TYPES
		{
		match(input,K_TYPES,FOLLOW_K_TYPES_in_synpred8_Parser10007); if (state.failed) return;
		}

	}
	// $ANTLR end synpred8_Parser

	// $ANTLR start synpred9_Parser
	public final void synpred9_Parser_fragment() throws RecognitionException {
		// Parser.g:1430:7: ( K_FUNCTIONS )
		// Parser.g:1430:8: K_FUNCTIONS
		{
		match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_synpred9_Parser10081); if (state.failed) return;
		}

	}
	// $ANTLR end synpred9_Parser

	// $ANTLR start synpred10_Parser
	public final void synpred10_Parser_fragment() throws RecognitionException {
		// Parser.g:1432:7: ( K_AGGREGATES )
		// Parser.g:1432:8: K_AGGREGATES
		{
		match(input,K_AGGREGATES,FOLLOW_K_AGGREGATES_in_synpred10_Parser10143); if (state.failed) return;
		}

	}
	// $ANTLR end synpred10_Parser

	// Delegated rules

	public final boolean synpred2_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred2_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred10_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred10_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred1_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred3_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred3_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred4_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred4_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred5_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred5_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred6_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred6_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred7_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred7_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred8_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred8_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred9_Parser() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred9_Parser_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}


	protected DFA1 dfa1 = new DFA1(this);
	protected DFA2 dfa2 = new DFA2(this);
	protected DFA11 dfa11 = new DFA11(this);
	protected DFA17 dfa17 = new DFA17(this);
	protected DFA22 dfa22 = new DFA22(this);
	protected DFA30 dfa30 = new DFA30(this);
	protected DFA31 dfa31 = new DFA31(this);
	protected DFA62 dfa62 = new DFA62(this);
	protected DFA145 dfa145 = new DFA145(this);
	protected DFA167 dfa167 = new DFA167(this);
	protected DFA194 dfa194 = new DFA194(this);
	protected DFA202 dfa202 = new DFA202(this);
	protected DFA200 dfa200 = new DFA200(this);
	protected DFA208 dfa208 = new DFA208(this);
	protected DFA209 dfa209 = new DFA209(this);
	protected DFA227 dfa227 = new DFA227(this);
	protected DFA229 dfa229 = new DFA229(this);
	protected DFA231 dfa231 = new DFA231(this);
	protected DFA233 dfa233 = new DFA233(this);
	protected DFA236 dfa236 = new DFA236(this);
	protected DFA239 dfa239 = new DFA239(this);
	protected DFA247 dfa247 = new DFA247(this);
	protected DFA252 dfa252 = new DFA252(this);
	protected DFA251 dfa251 = new DFA251(this);
	protected DFA262 dfa262 = new DFA262(this);
	static final String DFA1_eotS =
		"\70\uffff";
	static final String DFA1_eofS =
		"\70\uffff";
	static final String DFA1_minS =
		"\1\37\7\uffff\2\40\1\67\2\32\1\42\12\uffff\1\u008a\23\uffff\2\174\2\uffff"+
		"\2\117\5\uffff\1\40";
	static final String DFA1_maxS =
		"\1\u00ab\7\uffff\3\u00ac\2\u00c5\1\u00ad\12\uffff\1\u008a\23\uffff\1\u009f"+
		"\1\u00d5\2\uffff\1\u0085\1\u00d5\5\uffff\1\122";
	static final String DFA1_acceptS =
		"\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\6\uffff\1\51\1\52\1\10\1\11\1\23"+
		"\1\27\1\31\1\40\1\46\1\12\1\uffff\1\34\1\36\1\13\1\14\1\15\1\25\1\30\1"+
		"\33\1\35\1\37\1\42\1\47\1\53\1\16\1\17\1\24\1\32\1\41\1\50\2\uffff\1\44"+
		"\1\20\2\uffff\1\45\1\21\1\26\1\43\1\22\1\uffff";
	static final String DFA1_specialS =
		"\70\uffff}>";
	static final String[] DFA1_transitionS = {
			"\1\17\4\uffff\1\12\10\uffff\1\4\16\uffff\1\10\5\uffff\1\5\2\16\2\uffff"+
			"\1\11\14\uffff\1\13\11\uffff\1\2\14\uffff\1\15\40\uffff\1\14\3\uffff"+
			"\1\1\21\uffff\1\7\7\uffff\1\3\1\6",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\32\26\uffff\1\21\5\uffff\1\27\24\uffff\1\31\7\uffff\1\27\13\uffff"+
			"\1\20\10\uffff\1\26\17\uffff\1\30\15\uffff\1\25\23\uffff\1\23\3\uffff"+
			"\1\24\6\uffff\1\22",
			"\1\42\26\uffff\1\34\32\uffff\1\41\4\uffff\1\45\2\uffff\1\35\13\uffff"+
			"\1\33\10\uffff\1\44\35\uffff\1\43\23\uffff\1\37\3\uffff\1\40\6\uffff"+
			"\1\36",
			"\1\46\56\uffff\1\47\10\uffff\1\53\35\uffff\1\52\27\uffff\1\51\6\uffff"+
			"\1\50",
			"\1\56\3\uffff\1\56\1\uffff\2\56\1\54\1\uffff\1\57\1\uffff\1\56\1\uffff"+
			"\1\56\1\uffff\1\56\1\57\2\uffff\3\56\1\uffff\5\56\1\uffff\4\56\1\57\5"+
			"\56\2\uffff\1\57\2\56\1\57\1\56\1\uffff\1\57\4\56\1\uffff\1\56\1\uffff"+
			"\2\56\1\uffff\3\56\3\uffff\3\56\1\uffff\2\56\2\uffff\3\56\1\uffff\3\56"+
			"\1\uffff\4\56\1\uffff\3\56\1\57\2\uffff\1\56\1\uffff\1\56\4\uffff\2\56"+
			"\2\uffff\5\56\4\uffff\2\56\1\uffff\2\56\1\uffff\1\57\1\55\1\uffff\14"+
			"\56\2\uffff\1\56\1\uffff\4\56\1\uffff\1\55\1\56\2\uffff\2\56\1\uffff"+
			"\5\56\3\uffff\1\56\10\uffff\2\56\3\uffff\1\56",
			"\1\62\3\uffff\1\62\1\uffff\2\62\1\60\1\uffff\1\63\1\uffff\1\62\1\uffff"+
			"\1\62\1\uffff\1\62\1\63\2\uffff\3\62\1\uffff\5\62\1\uffff\4\62\1\63\5"+
			"\62\2\uffff\1\63\2\62\1\63\1\62\1\uffff\1\63\4\62\1\uffff\1\62\1\uffff"+
			"\2\62\1\uffff\3\62\3\uffff\3\62\1\uffff\2\62\2\uffff\3\62\1\uffff\3\62"+
			"\1\uffff\4\62\1\uffff\3\62\1\63\2\uffff\1\62\1\uffff\1\62\4\uffff\2\62"+
			"\2\uffff\5\62\4\uffff\2\62\1\uffff\2\62\1\uffff\1\63\1\61\1\uffff\14"+
			"\62\2\uffff\1\62\1\uffff\4\62\1\uffff\1\61\1\62\2\uffff\2\62\1\uffff"+
			"\5\62\3\uffff\1\62\10\uffff\2\62\3\uffff\1\62",
			"\1\66\1\uffff\1\66\6\uffff\1\66\20\uffff\1\66\7\uffff\1\66\2\uffff\1"+
			"\66\2\uffff\1\66\50\uffff\1\66\32\uffff\1\65\1\uffff\2\66\26\uffff\1"+
			"\66\4\uffff\1\64",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\67",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\57\10\uffff\1\57\31\uffff\1\56",
			"\1\57\7\uffff\1\57\32\uffff\1\56\65\uffff\1\57",
			"",
			"",
			"\1\62\54\uffff\1\63\10\uffff\1\63",
			"\1\62\54\uffff\1\63\7\uffff\1\63\120\uffff\1\63",
			"",
			"",
			"",
			"",
			"",
			"\1\32\61\uffff\1\31"
	};

	static final short[] DFA1_eot = DFA.unpackEncodedString(DFA1_eotS);
	static final short[] DFA1_eof = DFA.unpackEncodedString(DFA1_eofS);
	static final char[] DFA1_min = DFA.unpackEncodedStringToUnsignedChars(DFA1_minS);
	static final char[] DFA1_max = DFA.unpackEncodedStringToUnsignedChars(DFA1_maxS);
	static final short[] DFA1_accept = DFA.unpackEncodedString(DFA1_acceptS);
	static final short[] DFA1_special = DFA.unpackEncodedString(DFA1_specialS);
	static final short[][] DFA1_transition;

	static {
		int numStates = DFA1_transitionS.length;
		DFA1_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA1_transition[i] = DFA.unpackEncodedString(DFA1_transitionS[i]);
		}
	}

	protected class DFA1 extends DFA {

		public DFA1(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 1;
			this.eot = DFA1_eot;
			this.eof = DFA1_eof;
			this.min = DFA1_min;
			this.max = DFA1_max;
			this.accept = DFA1_accept;
			this.special = DFA1_special;
			this.transition = DFA1_transition;
		}
		@Override
		public String getDescription() {
			return "207:1: cqlStatement returns [CQLStatement.Raw stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement |st41= describeStatement |st42= addIdentityStatement |st43= dropIdentityStatement );";
		}
	}

	static final String DFA2_eotS =
		"\65\uffff";
	static final String DFA2_eofS =
		"\65\uffff";
	static final String DFA2_minS =
		"\1\6\1\0\63\uffff";
	static final String DFA2_maxS =
		"\1\u00e5\1\0\63\uffff";
	static final String DFA2_acceptS =
		"\2\uffff\1\2\61\uffff\1\1";
	static final String DFA2_specialS =
		"\1\uffff\1\0\63\uffff}>";
	static final String[] DFA2_transitionS = {
			"\1\2\4\uffff\1\2\10\uffff\1\2\3\uffff\1\2\1\uffff\2\2\2\uffff\1\2\1\uffff"+
			"\3\2\3\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3\uffff\3\2\1\uffff\5\2\1\uffff"+
			"\4\2\1\uffff\5\2\3\uffff\2\2\1\uffff\1\2\2\uffff\4\2\1\uffff\1\2\1\uffff"+
			"\2\2\1\uffff\3\2\3\uffff\3\2\1\uffff\2\2\2\uffff\1\1\2\2\1\uffff\3\2"+
			"\1\uffff\4\2\1\uffff\3\2\1\uffff\3\2\1\uffff\1\2\1\uffff\1\2\2\uffff"+
			"\2\2\2\uffff\7\2\2\uffff\2\2\1\uffff\2\2\2\uffff\1\2\1\uffff\14\2\1\uffff"+
			"\2\2\1\uffff\4\2\1\uffff\2\2\2\uffff\2\2\1\uffff\5\2\3\uffff\1\2\10\uffff"+
			"\2\2\3\uffff\1\2\2\uffff\1\2\10\uffff\1\2\4\uffff\1\2\3\uffff\1\2\6\uffff"+
			"\2\2\2\uffff\1\2",
			"\1\uffff",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			""
	};

	static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
	static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
	static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
	static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
	static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
	static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
	static final short[][] DFA2_transition;

	static {
		int numStates = DFA2_transitionS.length;
		DFA2_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
		}
	}

	protected class DFA2 extends DFA {

		public DFA2(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 2;
			this.eot = DFA2_eot;
			this.eof = DFA2_eof;
			this.min = DFA2_min;
			this.max = DFA2_max;
			this.accept = DFA2_accept;
			this.special = DFA2_special;
			this.transition = DFA2_transition;
		}
		@Override
		public String getDescription() {
			return "278:7: ( ( K_JSON selectClause )=> K_JSON )?";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			TokenStream input = (TokenStream)_input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA2_1 = input.LA(1);
						 
						int index2_1 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred1_Parser()) ) {s = 52;}
						else if ( (true) ) {s = 2;}
						 
						input.seek(index2_1);
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 2, _s, input);
			error(nvae);
			throw nvae;
		}
	}

	static final String DFA11_eotS =
		"\64\uffff";
	static final String DFA11_eofS =
		"\64\uffff";
	static final String DFA11_minS =
		"\1\6\1\0\62\uffff";
	static final String DFA11_maxS =
		"\1\u00e5\1\0\62\uffff";
	static final String DFA11_acceptS =
		"\2\uffff\1\2\60\uffff\1\1";
	static final String DFA11_specialS =
		"\1\uffff\1\0\62\uffff}>";
	static final String[] DFA11_transitionS = {
			"\1\2\4\uffff\1\2\10\uffff\1\2\3\uffff\1\2\1\uffff\2\2\2\uffff\1\2\1\uffff"+
			"\3\2\3\uffff\1\2\1\uffff\1\2\1\uffff\1\2\3\uffff\3\2\1\uffff\5\2\1\uffff"+
			"\4\2\1\uffff\5\2\3\uffff\1\1\1\2\1\uffff\1\2\2\uffff\4\2\1\uffff\1\2"+
			"\1\uffff\2\2\1\uffff\3\2\3\uffff\3\2\1\uffff\2\2\2\uffff\3\2\1\uffff"+
			"\3\2\1\uffff\4\2\1\uffff\3\2\1\uffff\3\2\1\uffff\1\2\1\uffff\1\2\2\uffff"+
			"\2\2\2\uffff\7\2\2\uffff\2\2\1\uffff\2\2\2\uffff\1\2\1\uffff\14\2\1\uffff"+
			"\2\2\1\uffff\4\2\1\uffff\2\2\2\uffff\2\2\1\uffff\5\2\3\uffff\1\2\10\uffff"+
			"\2\2\3\uffff\1\2\2\uffff\1\2\10\uffff\1\2\4\uffff\1\2\3\uffff\1\2\6\uffff"+
			"\2\2\2\uffff\1\2",
			"\1\uffff",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			""
	};

	static final short[] DFA11_eot = DFA.unpackEncodedString(DFA11_eotS);
	static final short[] DFA11_eof = DFA.unpackEncodedString(DFA11_eofS);
	static final char[] DFA11_min = DFA.unpackEncodedStringToUnsignedChars(DFA11_minS);
	static final char[] DFA11_max = DFA.unpackEncodedStringToUnsignedChars(DFA11_maxS);
	static final short[] DFA11_accept = DFA.unpackEncodedString(DFA11_acceptS);
	static final short[] DFA11_special = DFA.unpackEncodedString(DFA11_specialS);
	static final short[][] DFA11_transition;

	static {
		int numStates = DFA11_transitionS.length;
		DFA11_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA11_transition[i] = DFA.unpackEncodedString(DFA11_transitionS[i]);
		}
	}

	protected class DFA11 extends DFA {

		public DFA11(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 11;
			this.eot = DFA11_eot;
			this.eof = DFA11_eof;
			this.min = DFA11_min;
			this.max = DFA11_max;
			this.accept = DFA11_accept;
			this.special = DFA11_special;
			this.transition = DFA11_transition;
		}
		@Override
		public String getDescription() {
			return "297:1: selectClause returns [boolean isDistinct, List<RawSelector> selectors] : ( ( K_DISTINCT selectors )=> K_DISTINCT s= selectors |s= selectors );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			TokenStream input = (TokenStream)_input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA11_1 = input.LA(1);
						 
						int index11_1 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred2_Parser()) ) {s = 51;}
						else if ( (true) ) {s = 2;}
						 
						input.seek(index11_1);
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 11, _s, input);
			error(nvae);
			throw nvae;
		}
	}

	static final String DFA17_eotS =
		"\63\uffff";
	static final String DFA17_eofS =
		"\63\uffff";
	static final String DFA17_minS =
		"\1\6\57\0\3\uffff";
	static final String DFA17_maxS =
		"\1\u00e5\57\0\3\uffff";
	static final String DFA17_acceptS =
		"\60\uffff\1\3\1\1\1\2";
	static final String DFA17_specialS =
		"\1\uffff\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14\1\15"+
		"\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
		"\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50\1\51"+
		"\1\52\1\53\1\54\1\55\1\56\3\uffff}>";
	static final String[] DFA17_transitionS = {
			"\1\35\4\uffff\1\36\10\uffff\1\34\3\uffff\1\40\1\uffff\1\1\1\33\2\uffff"+
			"\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6"+
			"\1\7\1\uffff\1\3\1\52\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1\27\1\11"+
			"\1\3\3\uffff\1\53\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff\1\3\1\uffff"+
			"\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff\2\53\1\3\1"+
			"\uffff\3\3\1\uffff\4\3\1\uffff\1\47\2\3\1\uffff\1\43\1\41\1\3\1\uffff"+
			"\1\3\1\uffff\1\44\2\uffff\2\3\2\uffff\5\3\1\42\1\41\2\uffff\2\3\1\uffff"+
			"\2\3\2\uffff\1\3\1\uffff\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\1\uffff"+
			"\1\54\1\3\1\uffff\1\51\3\3\1\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1"+
			"\24\1\25\1\3\3\uffff\1\50\10\uffff\1\46\1\2\3\uffff\1\32\2\uffff\1\37"+
			"\10\uffff\1\55\4\uffff\1\60\3\uffff\1\45\6\uffff\1\56\3\uffff\1\57",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"\1\uffff",
			"",
			"",
			""
	};

	static final short[] DFA17_eot = DFA.unpackEncodedString(DFA17_eotS);
	static final short[] DFA17_eof = DFA.unpackEncodedString(DFA17_eofS);
	static final char[] DFA17_min = DFA.unpackEncodedStringToUnsignedChars(DFA17_minS);
	static final char[] DFA17_max = DFA.unpackEncodedStringToUnsignedChars(DFA17_maxS);
	static final short[] DFA17_accept = DFA.unpackEncodedString(DFA17_acceptS);
	static final short[] DFA17_special = DFA.unpackEncodedString(DFA17_specialS);
	static final short[][] DFA17_transition;

	static {
		int numStates = DFA17_transitionS.length;
		DFA17_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA17_transition[i] = DFA.unpackEncodedString(DFA17_transitionS[i]);
		}
	}

	protected class DFA17 extends DFA {

		public DFA17(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 17;
			this.eot = DFA17_eot;
			this.eof = DFA17_eof;
			this.min = DFA17_min;
			this.max = DFA17_max;
			this.accept = DFA17_accept;
			this.special = DFA17_special;
			this.transition = DFA17_transition;
		}
		@Override
		public String getDescription() {
			return "333:1: selectionGroup returns [Selectable.Raw s] : ( ( selectionGroupWithField )=>f= selectionGroupWithField |g= selectionGroupWithoutField | '-' g= selectionGroup );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			TokenStream input = (TokenStream)_input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA17_1 = input.LA(1);
						 
						int index17_1 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_1);
						if ( s>=0 ) return s;
						break;

					case 1 : 
						int LA17_2 = input.LA(1);
						 
						int index17_2 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_2);
						if ( s>=0 ) return s;
						break;

					case 2 : 
						int LA17_3 = input.LA(1);
						 
						int index17_3 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_3);
						if ( s>=0 ) return s;
						break;

					case 3 : 
						int LA17_4 = input.LA(1);
						 
						int index17_4 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_4);
						if ( s>=0 ) return s;
						break;

					case 4 : 
						int LA17_5 = input.LA(1);
						 
						int index17_5 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_5);
						if ( s>=0 ) return s;
						break;

					case 5 : 
						int LA17_6 = input.LA(1);
						 
						int index17_6 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_6);
						if ( s>=0 ) return s;
						break;

					case 6 : 
						int LA17_7 = input.LA(1);
						 
						int index17_7 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_7);
						if ( s>=0 ) return s;
						break;

					case 7 : 
						int LA17_8 = input.LA(1);
						 
						int index17_8 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_8);
						if ( s>=0 ) return s;
						break;

					case 8 : 
						int LA17_9 = input.LA(1);
						 
						int index17_9 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_9);
						if ( s>=0 ) return s;
						break;

					case 9 : 
						int LA17_10 = input.LA(1);
						 
						int index17_10 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_10);
						if ( s>=0 ) return s;
						break;

					case 10 : 
						int LA17_11 = input.LA(1);
						 
						int index17_11 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_11);
						if ( s>=0 ) return s;
						break;

					case 11 : 
						int LA17_12 = input.LA(1);
						 
						int index17_12 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_12);
						if ( s>=0 ) return s;
						break;

					case 12 : 
						int LA17_13 = input.LA(1);
						 
						int index17_13 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_13);
						if ( s>=0 ) return s;
						break;

					case 13 : 
						int LA17_14 = input.LA(1);
						 
						int index17_14 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_14);
						if ( s>=0 ) return s;
						break;

					case 14 : 
						int LA17_15 = input.LA(1);
						 
						int index17_15 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_15);
						if ( s>=0 ) return s;
						break;

					case 15 : 
						int LA17_16 = input.LA(1);
						 
						int index17_16 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_16);
						if ( s>=0 ) return s;
						break;

					case 16 : 
						int LA17_17 = input.LA(1);
						 
						int index17_17 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_17);
						if ( s>=0 ) return s;
						break;

					case 17 : 
						int LA17_18 = input.LA(1);
						 
						int index17_18 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_18);
						if ( s>=0 ) return s;
						break;

					case 18 : 
						int LA17_19 = input.LA(1);
						 
						int index17_19 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_19);
						if ( s>=0 ) return s;
						break;

					case 19 : 
						int LA17_20 = input.LA(1);
						 
						int index17_20 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_20);
						if ( s>=0 ) return s;
						break;

					case 20 : 
						int LA17_21 = input.LA(1);
						 
						int index17_21 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_21);
						if ( s>=0 ) return s;
						break;

					case 21 : 
						int LA17_22 = input.LA(1);
						 
						int index17_22 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_22);
						if ( s>=0 ) return s;
						break;

					case 22 : 
						int LA17_23 = input.LA(1);
						 
						int index17_23 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_23);
						if ( s>=0 ) return s;
						break;

					case 23 : 
						int LA17_24 = input.LA(1);
						 
						int index17_24 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_24);
						if ( s>=0 ) return s;
						break;

					case 24 : 
						int LA17_25 = input.LA(1);
						 
						int index17_25 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_25);
						if ( s>=0 ) return s;
						break;

					case 25 : 
						int LA17_26 = input.LA(1);
						 
						int index17_26 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_26);
						if ( s>=0 ) return s;
						break;

					case 26 : 
						int LA17_27 = input.LA(1);
						 
						int index17_27 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_27);
						if ( s>=0 ) return s;
						break;

					case 27 : 
						int LA17_28 = input.LA(1);
						 
						int index17_28 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_28);
						if ( s>=0 ) return s;
						break;

					case 28 : 
						int LA17_29 = input.LA(1);
						 
						int index17_29 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_29);
						if ( s>=0 ) return s;
						break;

					case 29 : 
						int LA17_30 = input.LA(1);
						 
						int index17_30 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_30);
						if ( s>=0 ) return s;
						break;

					case 30 : 
						int LA17_31 = input.LA(1);
						 
						int index17_31 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_31);
						if ( s>=0 ) return s;
						break;

					case 31 : 
						int LA17_32 = input.LA(1);
						 
						int index17_32 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_32);
						if ( s>=0 ) return s;
						break;

					case 32 : 
						int LA17_33 = input.LA(1);
						 
						int index17_33 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_33);
						if ( s>=0 ) return s;
						break;

					case 33 : 
						int LA17_34 = input.LA(1);
						 
						int index17_34 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_34);
						if ( s>=0 ) return s;
						break;

					case 34 : 
						int LA17_35 = input.LA(1);
						 
						int index17_35 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_35);
						if ( s>=0 ) return s;
						break;

					case 35 : 
						int LA17_36 = input.LA(1);
						 
						int index17_36 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_36);
						if ( s>=0 ) return s;
						break;

					case 36 : 
						int LA17_37 = input.LA(1);
						 
						int index17_37 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_37);
						if ( s>=0 ) return s;
						break;

					case 37 : 
						int LA17_38 = input.LA(1);
						 
						int index17_38 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_38);
						if ( s>=0 ) return s;
						break;

					case 38 : 
						int LA17_39 = input.LA(1);
						 
						int index17_39 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_39);
						if ( s>=0 ) return s;
						break;

					case 39 : 
						int LA17_40 = input.LA(1);
						 
						int index17_40 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_40);
						if ( s>=0 ) return s;
						break;

					case 40 : 
						int LA17_41 = input.LA(1);
						 
						int index17_41 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_41);
						if ( s>=0 ) return s;
						break;

					case 41 : 
						int LA17_42 = input.LA(1);
						 
						int index17_42 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_42);
						if ( s>=0 ) return s;
						break;

					case 42 : 
						int LA17_43 = input.LA(1);
						 
						int index17_43 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_43);
						if ( s>=0 ) return s;
						break;

					case 43 : 
						int LA17_44 = input.LA(1);
						 
						int index17_44 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_44);
						if ( s>=0 ) return s;
						break;

					case 44 : 
						int LA17_45 = input.LA(1);
						 
						int index17_45 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_45);
						if ( s>=0 ) return s;
						break;

					case 45 : 
						int LA17_46 = input.LA(1);
						 
						int index17_46 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_46);
						if ( s>=0 ) return s;
						break;

					case 46 : 
						int LA17_47 = input.LA(1);
						 
						int index17_47 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred3_Parser()) ) {s = 49;}
						else if ( (true) ) {s = 50;}
						 
						input.seek(index17_47);
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 17, _s, input);
			error(nvae);
			throw nvae;
		}
	}

	static final String DFA22_eotS =
		"\62\uffff";
	static final String DFA22_eofS =
		"\62\uffff";
	static final String DFA22_minS =
		"\1\6\54\uffff\1\0\4\uffff";
	static final String DFA22_maxS =
		"\1\u00e5\54\uffff\1\0\4\uffff";
	static final String DFA22_acceptS =
		"\1\uffff\1\1\54\uffff\1\4\1\5\1\2\1\3";
	static final String DFA22_specialS =
		"\55\uffff\1\0\4\uffff}>";
	static final String[] DFA22_transitionS = {
			"\1\1\4\uffff\1\1\10\uffff\1\1\3\uffff\1\1\1\uffff\2\1\2\uffff\1\1\1\uffff"+
			"\3\1\3\uffff\1\1\1\uffff\1\1\1\uffff\1\1\3\uffff\3\1\1\uffff\5\1\1\uffff"+
			"\4\1\1\uffff\5\1\3\uffff\2\1\1\uffff\1\1\2\uffff\4\1\1\uffff\1\1\1\uffff"+
			"\2\1\1\uffff\3\1\3\uffff\3\1\1\uffff\2\1\2\uffff\3\1\1\uffff\3\1\1\uffff"+
			"\4\1\1\uffff\3\1\1\uffff\3\1\1\uffff\1\1\1\uffff\1\1\2\uffff\2\1\2\uffff"+
			"\7\1\2\uffff\2\1\1\uffff\2\1\2\uffff\1\1\1\uffff\14\1\1\uffff\2\1\1\uffff"+
			"\4\1\1\uffff\2\1\2\uffff\2\1\1\uffff\5\1\3\uffff\1\1\10\uffff\2\1\3\uffff"+
			"\1\1\2\uffff\1\1\10\uffff\1\55\10\uffff\1\1\6\uffff\1\56\3\uffff\1\57",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\uffff",
			"",
			"",
			"",
			""
	};

	static final short[] DFA22_eot = DFA.unpackEncodedString(DFA22_eotS);
	static final short[] DFA22_eof = DFA.unpackEncodedString(DFA22_eofS);
	static final char[] DFA22_min = DFA.unpackEncodedStringToUnsignedChars(DFA22_minS);
	static final char[] DFA22_max = DFA.unpackEncodedStringToUnsignedChars(DFA22_maxS);
	static final short[] DFA22_accept = DFA.unpackEncodedString(DFA22_acceptS);
	static final short[] DFA22_special = DFA.unpackEncodedString(DFA22_specialS);
	static final short[][] DFA22_transition;

	static {
		int numStates = DFA22_transitionS.length;
		DFA22_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA22_transition[i] = DFA.unpackEncodedString(DFA22_transitionS[i]);
		}
	}

	protected class DFA22 extends DFA {

		public DFA22(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 22;
			this.eot = DFA22_eot;
			this.eof = DFA22_eof;
			this.min = DFA22_min;
			this.max = DFA22_max;
			this.accept = DFA22_accept;
			this.special = DFA22_special;
			this.transition = DFA22_transition;
		}
		@Override
		public String getDescription() {
			return "364:1: selectionGroupWithoutField returns [Selectable.Raw s] : (sn= simpleUnaliasedSelector | ( selectionTypeHint )=>h= selectionTypeHint |t= selectionTupleOrNestedSelector |l= selectionList |m= selectionMapOrSet );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			TokenStream input = (TokenStream)_input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA22_45 = input.LA(1);
						 
						int index22_45 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred4_Parser()) ) {s = 48;}
						else if ( (true) ) {s = 49;}
						 
						input.seek(index22_45);
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 22, _s, input);
			error(nvae);
			throw nvae;
		}
	}

	static final String DFA30_eotS =
		"\127\uffff";
	static final String DFA30_eofS =
		"\1\uffff\31\42\1\uffff\1\32\5\42\4\uffff\31\42\31\32";
	static final String DFA30_minS =
		"\1\6\31\43\1\uffff\6\43\2\uffff\2\32\62\43";
	static final String DFA30_maxS =
		"\1\u00da\31\u00e6\1\uffff\6\u00e6\2\uffff\2\u00c1\62\u00e6";
	static final String DFA30_acceptS =
		"\32\uffff\1\2\6\uffff\1\3\1\1\64\uffff";
	static final String DFA30_specialS =
		"\127\uffff}>";
	static final String[] DFA30_transitionS = {
			"\1\32\4\uffff\1\32\10\uffff\1\32\3\uffff\1\32\1\uffff\1\1\1\32\2\uffff"+
			"\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6"+
			"\1\7\1\uffff\1\3\1\37\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1\27\1\11"+
			"\1\3\3\uffff\1\40\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff\1\3\1\uffff"+
			"\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff\2\40\1\3\1"+
			"\uffff\3\3\1\uffff\4\3\1\uffff\1\34\2\3\1\uffff\2\32\1\3\1\uffff\1\3"+
			"\1\uffff\1\32\2\uffff\2\3\2\uffff\5\3\2\32\2\uffff\2\3\1\uffff\2\3\2"+
			"\uffff\1\3\1\uffff\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\1\uffff\1\41"+
			"\1\3\1\uffff\1\36\3\3\1\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1"+
			"\25\1\3\3\uffff\1\35\10\uffff\1\33\1\2\3\uffff\1\32\2\uffff\1\32\21\uffff"+
			"\1\32",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\uffff\2\32\1\uffff\2\32\1\uffff\1\44\3\32\5\uffff"+
			"\3\32\2\uffff\1\32",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\uffff\2\42\1\uffff\2\42\1\uffff\1\43\3\42\5\uffff"+
			"\3\42\2\uffff\1\42",
			"",
			"",
			"\1\45\3\uffff\1\47\1\uffff\3\47\3\uffff\1\47\1\uffff\1\47\1\uffff\1"+
			"\50\3\uffff\1\51\1\52\1\53\1\uffff\1\47\1\42\3\47\1\uffff\2\47\1\75\1"+
			"\54\1\uffff\2\47\1\73\1\55\1\47\3\uffff\1\42\1\56\1\uffff\1\57\2\uffff"+
			"\3\47\1\60\1\uffff\1\47\1\uffff\2\47\1\uffff\3\47\3\uffff\1\61\2\47\1"+
			"\uffff\1\62\1\47\2\uffff\2\42\1\47\1\uffff\3\47\1\uffff\4\47\1\uffff"+
			"\1\42\2\47\3\uffff\1\47\1\uffff\1\47\4\uffff\2\47\2\uffff\5\47\4\uffff"+
			"\2\47\1\uffff\2\47\2\uffff\1\47\1\uffff\1\47\1\63\5\47\1\64\1\74\1\65"+
			"\1\72\1\66\1\uffff\1\41\1\47\1\uffff\1\42\3\47\1\uffff\2\47\2\uffff\2"+
			"\47\1\uffff\1\67\1\47\1\70\1\71\1\47\3\uffff\1\42\11\uffff\1\46",
			"\1\76\3\uffff\1\100\1\uffff\3\100\3\uffff\1\100\1\uffff\1\100\1\uffff"+
			"\1\101\3\uffff\1\102\1\103\1\104\1\uffff\1\100\1\32\3\100\1\uffff\2\100"+
			"\1\126\1\105\1\uffff\2\100\1\124\1\106\1\100\3\uffff\1\32\1\107\1\uffff"+
			"\1\110\2\uffff\3\100\1\111\1\uffff\1\100\1\uffff\2\100\1\uffff\3\100"+
			"\3\uffff\1\112\2\100\1\uffff\1\113\1\100\2\uffff\2\32\1\100\1\uffff\3"+
			"\100\1\uffff\4\100\1\uffff\1\32\2\100\3\uffff\1\100\1\uffff\1\100\4\uffff"+
			"\2\100\2\uffff\5\100\4\uffff\2\100\1\uffff\2\100\2\uffff\1\100\1\uffff"+
			"\1\100\1\114\5\100\1\115\1\125\1\116\1\123\1\117\1\uffff\1\41\1\100\1"+
			"\uffff\1\32\3\100\1\uffff\2\100\2\uffff\2\100\1\uffff\1\120\1\100\1\121"+
			"\1\122\1\100\3\uffff\1\32\11\uffff\1\77",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\42\4\uffff\1\42\46\uffff\1\42\32\uffff\1\42\25\uffff\1\42\2\uffff"+
			"\1\42\114\uffff\1\42\1\41\2\42\1\uffff\2\42\1\uffff\4\42\5\uffff\3\42"+
			"\2\uffff\1\42",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32",
			"\1\32\4\uffff\1\32\46\uffff\1\32\32\uffff\1\32\25\uffff\1\32\2\uffff"+
			"\1\32\114\uffff\1\32\1\41\2\32\1\uffff\2\32\1\uffff\4\32\5\uffff\3\32"+
			"\2\uffff\1\32"
	};

	static final short[] DFA30_eot = DFA.unpackEncodedString(DFA30_eotS);
	static final short[] DFA30_eof = DFA.unpackEncodedString(DFA30_eofS);
	static final char[] DFA30_min = DFA.unpackEncodedStringToUnsignedChars(DFA30_minS);
	static final char[] DFA30_max = DFA.unpackEncodedStringToUnsignedChars(DFA30_maxS);
	static final short[] DFA30_accept = DFA.unpackEncodedString(DFA30_acceptS);
	static final short[] DFA30_special = DFA.unpackEncodedString(DFA30_specialS);
	static final short[][] DFA30_transition;

	static {
		int numStates = DFA30_transitionS.length;
		DFA30_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA30_transition[i] = DFA.unpackEncodedString(DFA30_transitionS[i]);
		}
	}

	protected class DFA30 extends DFA {

		public DFA30(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 30;
			this.eot = DFA30_eot;
			this.eof = DFA30_eof;
			this.min = DFA30_min;
			this.max = DFA30_max;
			this.accept = DFA30_accept;
			this.special = DFA30_special;
			this.transition = DFA30_transition;
		}
		@Override
		public String getDescription() {
			return "412:1: simpleUnaliasedSelector returns [Selectable.Raw s] : (c= sident |l= selectionLiteral |f= selectionFunction );";
		}
	}

	static final String DFA31_eotS =
		"\15\uffff";
	static final String DFA31_eofS =
		"\15\uffff";
	static final String DFA31_minS =
		"\1\32\5\u00d1\1\uffff\1\6\5\uffff";
	static final String DFA31_maxS =
		"\1\u00c1\5\u00d8\1\uffff\1\u00e5\5\uffff";
	static final String DFA31_acceptS =
		"\6\uffff\1\6\1\uffff\1\2\1\3\1\4\1\5\1\1";
	static final String DFA31_specialS =
		"\15\uffff}>";
	static final String[] DFA31_transitionS = {
			"\1\6\3\uffff\1\6\1\uffff\3\6\3\uffff\1\6\1\uffff\1\6\1\uffff\1\6\3\uffff"+
			"\3\6\1\uffff\1\6\1\5\3\6\1\uffff\2\6\1\1\1\6\1\uffff\5\6\3\uffff\2\6"+
			"\1\uffff\1\6\2\uffff\4\6\1\uffff\1\6\1\uffff\2\6\1\uffff\3\6\3\uffff"+
			"\3\6\1\uffff\2\6\2\uffff\3\6\1\uffff\3\6\1\uffff\4\6\1\uffff\1\2\2\6"+
			"\3\uffff\1\6\1\uffff\1\6\4\uffff\2\6\2\uffff\5\6\4\uffff\2\6\1\uffff"+
			"\2\6\2\uffff\1\6\1\uffff\14\6\1\uffff\2\6\1\uffff\1\4\3\6\1\uffff\2\6"+
			"\2\uffff\2\6\1\uffff\5\6\3\uffff\1\3\10\uffff\2\6",
			"\1\7\6\uffff\1\6",
			"\1\10\6\uffff\1\6",
			"\1\11\6\uffff\1\6",
			"\1\12\6\uffff\1\6",
			"\1\13\6\uffff\1\6",
			"",
			"\1\6\4\uffff\1\6\10\uffff\1\6\3\uffff\1\6\1\uffff\2\6\2\uffff\1\6\1"+
			"\uffff\3\6\3\uffff\1\6\1\uffff\1\6\1\uffff\1\6\3\uffff\3\6\1\uffff\5"+
			"\6\1\uffff\4\6\1\uffff\5\6\3\uffff\2\6\1\uffff\1\6\2\uffff\4\6\1\uffff"+
			"\1\6\1\uffff\2\6\1\uffff\3\6\3\uffff\3\6\1\uffff\2\6\2\uffff\3\6\1\uffff"+
			"\3\6\1\uffff\4\6\1\uffff\3\6\1\uffff\3\6\1\uffff\1\6\1\uffff\1\6\2\uffff"+
			"\2\6\2\uffff\7\6\2\uffff\2\6\1\uffff\2\6\2\uffff\1\6\1\uffff\14\6\1\uffff"+
			"\2\6\1\uffff\4\6\1\uffff\2\6\2\uffff\2\6\1\uffff\5\6\3\uffff\1\6\10\uffff"+
			"\2\6\3\uffff\1\6\2\uffff\1\6\10\uffff\2\6\3\uffff\1\6\3\uffff\1\6\6\uffff"+
			"\1\6\1\14\2\uffff\1\6",
			"",
			"",
			"",
			"",
			""
	};

	static final short[] DFA31_eot = DFA.unpackEncodedString(DFA31_eotS);
	static final short[] DFA31_eof = DFA.unpackEncodedString(DFA31_eofS);
	static final char[] DFA31_min = DFA.unpackEncodedStringToUnsignedChars(DFA31_minS);
	static final char[] DFA31_max = DFA.unpackEncodedStringToUnsignedChars(DFA31_maxS);
	static final short[] DFA31_accept = DFA.unpackEncodedString(DFA31_acceptS);
	static final short[] DFA31_special = DFA.unpackEncodedString(DFA31_specialS);
	static final short[][] DFA31_transition;

	static {
		int numStates = DFA31_transitionS.length;
		DFA31_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA31_transition[i] = DFA.unpackEncodedString(DFA31_transitionS[i]);
		}
	}

	protected class DFA31 extends DFA {

		public DFA31(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 31;
			this.eot = DFA31_eot;
			this.eof = DFA31_eof;
			this.min = DFA31_min;
			this.max = DFA31_max;
			this.accept = DFA31_accept;
			this.special = DFA31_special;
			this.transition = DFA31_transition;
		}
		@Override
		public String getDescription() {
			return "418:1: selectionFunction returns [Selectable.Raw s] : ( K_COUNT '(' '\\*' ')' | K_MAXWRITETIME '(' c= sident m= selectorModifier[c] ')' | K_WRITETIME '(' c= sident m= selectorModifier[c] ')' | K_TTL '(' c= sident m= selectorModifier[c] ')' | K_CAST '(' sn= unaliasedSelector K_AS t= native_type ')' |f= functionName args= selectionFunctionArgs );";
		}
	}

	static final String DFA62_eotS =
		"\36\uffff";
	static final String DFA62_eofS =
		"\36\uffff";
	static final String DFA62_minS =
		"\1\21\32\117\3\uffff";
	static final String DFA62_maxS =
		"\1\u00c1\32\u00e1\3\uffff";
	static final String DFA62_acceptS =
		"\33\uffff\1\1\1\2\1\3";
	static final String DFA62_specialS =
		"\36\uffff}>";
	static final String[] DFA62_transitionS = {
			"\1\1\10\uffff\1\2\3\uffff\1\4\1\uffff\3\4\3\uffff\1\4\1\uffff\1\4\1\uffff"+
			"\1\5\3\uffff\1\6\1\7\1\10\1\uffff\1\4\1\32\3\4\1\uffff\2\4\1\32\1\11"+
			"\1\uffff\2\4\1\30\1\12\1\4\3\uffff\1\32\1\13\1\uffff\1\14\2\uffff\3\4"+
			"\1\15\1\uffff\1\4\1\uffff\2\4\1\uffff\3\4\3\uffff\1\16\2\4\1\uffff\1"+
			"\17\1\4\2\uffff\2\32\1\4\1\uffff\3\4\1\uffff\4\4\1\uffff\1\32\2\4\3\uffff"+
			"\1\4\1\uffff\1\4\4\uffff\2\4\2\uffff\5\4\4\uffff\2\4\1\uffff\2\4\2\uffff"+
			"\1\4\1\uffff\1\4\1\20\5\4\1\21\1\31\1\22\1\27\1\23\2\uffff\1\4\1\uffff"+
			"\1\32\3\4\1\uffff\2\4\2\uffff\2\4\1\uffff\1\24\1\4\1\25\1\26\1\4\3\uffff"+
			"\1\32\11\uffff\1\3",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"\1\33\u0085\uffff\1\33\2\uffff\1\35\10\uffff\1\34",
			"",
			"",
			""
	};

	static final short[] DFA62_eot = DFA.unpackEncodedString(DFA62_eotS);
	static final short[] DFA62_eof = DFA.unpackEncodedString(DFA62_eofS);
	static final char[] DFA62_min = DFA.unpackEncodedStringToUnsignedChars(DFA62_minS);
	static final char[] DFA62_max = DFA.unpackEncodedStringToUnsignedChars(DFA62_maxS);
	static final short[] DFA62_accept = DFA.unpackEncodedString(DFA62_acceptS);
	static final short[] DFA62_special = DFA.unpackEncodedString(DFA62_specialS);
	static final short[][] DFA62_transition;

	static {
		int numStates = DFA62_transitionS.length;
		DFA62_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA62_transition[i] = DFA.unpackEncodedString(DFA62_transitionS[i]);
		}
	}

	protected class DFA62 extends DFA {

		public DFA62(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 62;
			this.eot = DFA62_eot;
			this.eof = DFA62_eof;
			this.min = DFA62_min;
			this.max = DFA62_max;
			this.accept = DFA62_accept;
			this.special = DFA62_special;
			this.transition = DFA62_transition;
		}
		@Override
		public String getDescription() {
			return "606:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' |c= cident '.' field= fident );";
		}
	}

	static final String DFA145_eotS =
		"\45\uffff";
	static final String DFA145_eofS =
		"\41\uffff\1\42\3\uffff";
	static final String DFA145_minS =
		"\1\37\1\21\1\uffff\1\32\2\uffff\32\107\1\uffff\1\u0096\3\uffff";
	static final String DFA145_maxS =
		"\1\u00b6\1\u00c1\1\uffff\1\u00d1\2\uffff\32\u00a5\1\uffff\1\u00db\3\uffff";
	static final String DFA145_acceptS =
		"\2\uffff\1\3\1\uffff\1\5\1\7\32\uffff\1\2\1\uffff\1\4\1\1\1\6";
	static final String DFA145_specialS =
		"\45\uffff}>";
	static final String[] DFA145_transitionS = {
			"\1\2\4\uffff\1\1\42\uffff\1\3\101\uffff\1\4\54\uffff\1\5",
			"\1\6\10\uffff\1\7\3\uffff\1\11\1\uffff\3\11\3\uffff\1\11\1\uffff\1\11"+
			"\1\uffff\1\12\3\uffff\1\13\1\14\1\15\1\uffff\1\11\1\37\3\11\1\uffff\2"+
			"\11\1\37\1\16\1\uffff\2\11\1\35\1\17\1\11\3\uffff\1\37\1\20\1\uffff\1"+
			"\21\2\uffff\3\11\1\22\1\uffff\1\11\1\uffff\2\11\1\uffff\3\11\1\40\2\uffff"+
			"\1\23\2\11\1\uffff\1\24\1\11\2\uffff\2\37\1\11\1\uffff\3\11\1\uffff\4"+
			"\11\1\uffff\1\37\2\11\3\uffff\1\11\1\uffff\1\11\4\uffff\2\11\2\uffff"+
			"\5\11\4\uffff\2\11\1\uffff\2\11\2\uffff\1\11\1\uffff\1\11\1\25\5\11\1"+
			"\26\1\36\1\27\1\34\1\30\2\uffff\1\11\1\uffff\1\37\3\11\1\uffff\2\11\2"+
			"\uffff\2\11\1\uffff\1\31\1\11\1\32\1\33\1\11\3\uffff\1\37\11\uffff\1"+
			"\10",
			"",
			"\1\42\3\uffff\1\42\1\uffff\3\42\3\uffff\1\42\1\uffff\1\42\1\uffff\1"+
			"\42\3\uffff\3\42\1\uffff\5\42\1\uffff\1\41\3\42\1\uffff\5\42\3\uffff"+
			"\2\42\1\uffff\1\42\2\uffff\4\42\1\uffff\1\42\1\uffff\2\42\1\uffff\4\42"+
			"\2\uffff\3\42\1\uffff\2\42\2\uffff\3\42\1\uffff\3\42\1\uffff\4\42\1\uffff"+
			"\3\42\3\uffff\1\42\1\uffff\1\42\4\uffff\2\42\2\uffff\5\42\4\uffff\2\42"+
			"\1\uffff\2\42\2\uffff\1\42\1\uffff\14\42\2\uffff\1\42\1\uffff\4\42\1"+
			"\uffff\2\42\2\uffff\2\42\1\uffff\5\42\3\uffff\1\42\11\uffff\1\42\17\uffff"+
			"\1\42",
			"",
			"",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"\1\40\46\uffff\1\40\66\uffff\1\43",
			"",
			"\1\44\27\uffff\1\42\54\uffff\1\42",
			"",
			"",
			""
	};

	static final short[] DFA145_eot = DFA.unpackEncodedString(DFA145_eotS);
	static final short[] DFA145_eof = DFA.unpackEncodedString(DFA145_eofS);
	static final char[] DFA145_min = DFA.unpackEncodedStringToUnsignedChars(DFA145_minS);
	static final char[] DFA145_max = DFA.unpackEncodedStringToUnsignedChars(DFA145_maxS);
	static final short[] DFA145_accept = DFA.unpackEncodedString(DFA145_acceptS);
	static final short[] DFA145_special = DFA.unpackEncodedString(DFA145_specialS);
	static final short[][] DFA145_transition;

	static {
		int numStates = DFA145_transitionS.length;
		DFA145_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA145_transition[i] = DFA.unpackEncodedString(DFA145_transitionS[i]);
		}
	}

	protected class DFA145 extends DFA {

		public DFA145(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 145;
			this.eot = DFA145_eot;
			this.eof = DFA145_eof;
			this.min = DFA145_min;
			this.max = DFA145_max;
			this.accept = DFA145_accept;
			this.special = DFA145_special;
			this.transition = DFA145_transition;
		}
		@Override
		public String getDescription() {
			return "961:7: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ALTER ( K_IF K_EXISTS )? id= cident (mask= columnMask | K_DROP K_MASKED ) | K_ADD ( K_IF K_NOT K_EXISTS )? (id= ident v= comparatorType b= isStaticColumn (m= columnMask )? | ( '(' id1= ident v1= comparatorType b1= isStaticColumn (m1= columnMask )? ( ',' idn= ident vn= comparatorType bn= isStaticColumn (mn= columnMask )? )* ')' ) ) | K_DROP ( K_IF K_EXISTS )? (id= ident | ( '(' id1= ident ( ',' idn= ident )* ')' ) ) ( K_USING K_TIMESTAMP t= INTEGER )? | K_RENAME ( K_IF K_EXISTS )? (id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) | K_DROP K_COMPACT K_STORAGE | K_WITH properties[$stmt.attrs] )";
		}
	}

	static final String DFA167_eotS =
		"\12\uffff";
	static final String DFA167_eofS =
		"\1\uffff\1\2\1\uffff\4\2\3\uffff";
	static final String DFA167_minS =
		"\1\32\1\117\1\uffff\2\32\2\117\3\uffff";
	static final String DFA167_maxS =
		"\1\u00c1\1\u00db\1\uffff\4\u00db\3\uffff";
	static final String DFA167_acceptS =
		"\2\uffff\1\1\4\uffff\1\2\1\3\1\4";
	static final String DFA167_specialS =
		"\12\uffff}>";
	static final String[] DFA167_transitionS = {
			"\1\2\3\uffff\1\2\1\uffff\2\2\1\1\3\uffff\1\2\1\uffff\1\2\1\uffff\1\2"+
			"\3\uffff\3\2\1\uffff\12\2\1\uffff\5\2\3\uffff\2\2\1\uffff\1\2\2\uffff"+
			"\4\2\1\uffff\1\2\1\uffff\1\4\1\2\1\uffff\3\2\3\uffff\3\2\1\uffff\2\2"+
			"\2\uffff\7\2\1\uffff\4\2\1\uffff\1\2\1\5\1\6\3\uffff\1\2\1\uffff\1\2"+
			"\4\uffff\2\2\2\uffff\5\2\4\uffff\2\2\1\uffff\1\3\1\2\2\uffff\1\2\1\uffff"+
			"\14\2\2\uffff\1\2\1\uffff\4\2\1\uffff\2\2\2\uffff\2\2\1\uffff\5\2\3\uffff"+
			"\1\2\10\uffff\2\2",
			"\1\2\3\uffff\1\10\23\uffff\1\2\12\uffff\1\11\4\uffff\1\2\3\uffff\1\2"+
			"\22\uffff\1\7\12\uffff\1\2\5\uffff\1\2\70\uffff\1\2\2\uffff\1\2",
			"",
			"\1\7\3\uffff\1\7\1\uffff\3\7\3\uffff\1\7\1\uffff\1\7\1\uffff\1\7\3\uffff"+
			"\3\7\1\uffff\5\7\1\uffff\4\7\1\uffff\5\7\3\uffff\2\7\1\uffff\1\7\2\uffff"+
			"\4\7\1\2\1\7\1\uffff\2\7\1\uffff\3\7\3\uffff\3\7\1\uffff\2\7\2\uffff"+
			"\3\7\1\uffff\3\7\1\uffff\4\7\1\uffff\3\7\3\uffff\1\7\1\2\1\7\2\uffff"+
			"\1\2\1\uffff\2\7\2\uffff\5\7\4\uffff\2\7\1\uffff\2\7\2\uffff\1\7\1\uffff"+
			"\14\7\1\2\1\uffff\1\7\1\uffff\4\7\1\uffff\2\7\2\uffff\2\7\1\uffff\5\7"+
			"\3\uffff\1\7\10\uffff\2\7\3\uffff\1\7\22\uffff\1\2\2\uffff\1\2",
			"\1\10\3\uffff\1\10\1\uffff\3\10\3\uffff\1\10\1\uffff\1\10\1\uffff\1"+
			"\10\3\uffff\3\10\1\uffff\5\10\1\uffff\4\10\1\uffff\5\10\3\uffff\2\10"+
			"\1\uffff\1\10\2\uffff\4\10\1\2\1\10\1\uffff\2\10\1\uffff\3\10\3\uffff"+
			"\3\10\1\uffff\2\10\2\uffff\3\10\1\uffff\3\10\1\uffff\4\10\1\uffff\3\10"+
			"\3\uffff\1\10\1\2\1\10\2\uffff\1\2\1\uffff\2\10\2\uffff\5\10\4\uffff"+
			"\2\10\1\uffff\2\10\2\uffff\1\10\1\uffff\14\10\1\2\2\10\1\uffff\4\10\1"+
			"\uffff\2\10\2\uffff\2\10\1\uffff\5\10\3\uffff\1\10\10\uffff\2\10\26\uffff"+
			"\1\2\2\uffff\1\2",
			"\1\2\47\uffff\1\2\3\uffff\1\2\43\uffff\1\2\45\uffff\1\11\22\uffff\1"+
			"\2\2\uffff\1\2",
			"\1\2\47\uffff\1\2\3\uffff\1\2\43\uffff\1\2\45\uffff\1\11\22\uffff\1"+
			"\2\2\uffff\1\2",
			"",
			"",
			""
	};

	static final short[] DFA167_eot = DFA.unpackEncodedString(DFA167_eotS);
	static final short[] DFA167_eof = DFA.unpackEncodedString(DFA167_eofS);
	static final char[] DFA167_min = DFA.unpackEncodedStringToUnsignedChars(DFA167_minS);
	static final char[] DFA167_max = DFA.unpackEncodedStringToUnsignedChars(DFA167_maxS);
	static final short[] DFA167_accept = DFA.unpackEncodedString(DFA167_acceptS);
	static final short[] DFA167_special = DFA.unpackEncodedString(DFA167_specialS);
	static final short[][] DFA167_transition;

	static {
		int numStates = DFA167_transitionS.length;
		DFA167_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA167_transition[i] = DFA.unpackEncodedString(DFA167_transitionS[i]);
		}
	}

	protected class DFA167 extends DFA {

		public DFA167(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 167;
			this.eot = DFA167_eot;
			this.eof = DFA167_eof;
			this.min = DFA167_min;
			this.max = DFA167_max;
			this.accept = DFA167_accept;
			this.special = DFA167_special;
			this.transition = DFA167_transition;
		}
		@Override
		public String getDescription() {
			return "1148:1: resource returns [IResource res] : (d= dataResource |r= roleResource |f= functionResource |j= jmxResource );";
		}
	}

	static final String DFA194_eotS =
		"\15\uffff";
	static final String DFA194_eofS =
		"\15\uffff";
	static final String DFA194_minS =
		"\1\36\5\uffff\1\117\2\42\4\uffff";
	static final String DFA194_maxS =
		"\1\u0098\5\uffff\1\u009f\1\76\1\64\4\uffff";
	static final String DFA194_acceptS =
		"\1\uffff\1\1\1\2\1\3\1\4\1\5\3\uffff\1\6\1\7\1\10\1\11";
	static final String DFA194_specialS =
		"\15\uffff}>";
	static final String[] DFA194_transitionS = {
			"\1\6\67\uffff\1\2\25\uffff\1\5\21\uffff\1\3\3\uffff\1\1\25\uffff\1\4",
			"",
			"",
			"",
			"",
			"",
			"\1\10\117\uffff\1\7",
			"\1\11\33\uffff\1\12",
			"\1\13\21\uffff\1\14",
			"",
			"",
			"",
			""
	};

	static final short[] DFA194_eot = DFA.unpackEncodedString(DFA194_eotS);
	static final short[] DFA194_eof = DFA.unpackEncodedString(DFA194_eofS);
	static final char[] DFA194_min = DFA.unpackEncodedStringToUnsignedChars(DFA194_minS);
	static final char[] DFA194_max = DFA.unpackEncodedStringToUnsignedChars(DFA194_maxS);
	static final short[] DFA194_accept = DFA.unpackEncodedString(DFA194_acceptS);
	static final short[] DFA194_special = DFA.unpackEncodedString(DFA194_specialS);
	static final short[][] DFA194_transition;

	static {
		int numStates = DFA194_transitionS.length;
		DFA194_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA194_transition[i] = DFA.unpackEncodedString(DFA194_transitionS[i]);
		}
	}

	protected class DFA194 extends DFA {

		public DFA194(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 194;
			this.eot = DFA194_eot;
			this.eof = DFA194_eof;
			this.min = DFA194_min;
			this.max = DFA194_max;
			this.accept = DFA194_accept;
			this.special = DFA194_special;
			this.transition = DFA194_transition;
		}
		@Override
		public String getDescription() {
			return "1378:1: roleOption[RoleOptions opts, DCPermissions.Builder dcperms, CIDRPermissions.Builder cidrperms] : ( K_PASSWORD '=' v= STRING_LITERAL | K_HASHED K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= fullMapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN | K_ACCESS K_TO K_ALL K_DATACENTERS | K_ACCESS K_TO K_DATACENTERS '{' dcPermission[dcperms] ( ',' dcPermission[dcperms] )* '}' | K_ACCESS K_FROM K_ALL K_CIDRS | K_ACCESS K_FROM K_CIDRS '{' cidrPermission[cidrperms] ( ',' cidrPermission[cidrperms] )* '}' );";
		}
	}

	static final String DFA202_eotS =
		"\32\uffff";
	static final String DFA202_eofS =
		"\4\uffff\1\20\6\uffff\1\20\1\uffff\1\20\1\uffff\1\20\12\uffff";
	static final String DFA202_minS =
		"\1\32\1\0\1\uffff\1\0\1\146\1\uffff\1\0\3\uffff\1\0\1\32\1\0\1\32\1\0"+
		"\1\32\12\uffff";
	static final String DFA202_maxS =
		"\1\u00c1\1\0\1\uffff\1\0\1\u00db\1\uffff\1\0\3\uffff\1\0\1\u00db\1\0\1"+
		"\u00db\1\0\1\u00db\12\uffff";
	static final String DFA202_acceptS =
		"\2\uffff\1\2\2\uffff\1\4\1\uffff\1\6\1\7\1\10\6\uffff\1\17\1\1\1\3\1\5"+
		"\1\11\1\12\1\13\1\14\1\15\1\16";
	static final String DFA202_specialS =
		"\1\uffff\1\0\1\uffff\1\1\2\uffff\1\2\3\uffff\1\3\1\uffff\1\4\1\uffff\1"+
		"\5\13\uffff}>";
	static final String[] DFA202_transitionS = {
			"\1\20\3\uffff\1\20\1\uffff\1\17\1\16\1\20\3\uffff\1\20\1\uffff\1\20\1"+
			"\uffff\1\20\3\uffff\3\20\1\uffff\3\20\1\1\1\20\1\7\4\20\1\uffff\5\20"+
			"\3\uffff\2\20\1\uffff\1\20\2\uffff\4\20\1\uffff\1\20\1\2\1\15\1\14\1"+
			"\uffff\3\20\2\uffff\1\10\3\20\1\uffff\2\20\2\uffff\3\20\1\5\1\3\2\20"+
			"\1\uffff\4\20\1\11\3\20\3\uffff\1\20\1\uffff\1\20\4\uffff\1\4\1\20\2"+
			"\uffff\5\20\4\uffff\2\20\1\uffff\2\20\1\2\1\uffff\1\20\1\uffff\6\20\1"+
			"\6\5\20\2\uffff\1\20\1\uffff\2\20\1\13\1\12\1\uffff\2\20\2\uffff\2\20"+
			"\1\uffff\5\20\3\uffff\1\20\11\uffff\1\20",
			"\1\uffff",
			"",
			"\1\uffff",
			"\1\5\117\uffff\1\20\41\uffff\1\20\2\uffff\1\20",
			"",
			"\1\uffff",
			"",
			"",
			"",
			"\1\uffff",
			"\1\25\3\uffff\1\25\1\uffff\3\25\3\uffff\1\25\1\uffff\1\25\1\uffff\1"+
			"\25\3\uffff\3\25\1\uffff\5\25\1\uffff\4\25\1\uffff\5\25\3\uffff\2\25"+
			"\1\uffff\1\25\2\uffff\4\25\1\uffff\1\25\1\uffff\2\25\1\uffff\3\25\3\uffff"+
			"\3\25\1\uffff\2\25\2\uffff\3\25\1\uffff\3\25\1\uffff\4\25\1\uffff\3\25"+
			"\3\uffff\1\25\1\uffff\1\25\4\uffff\2\25\2\uffff\5\25\4\uffff\2\25\1\uffff"+
			"\2\25\2\uffff\1\25\1\uffff\14\25\2\uffff\1\25\1\uffff\4\25\1\uffff\2"+
			"\25\2\uffff\2\25\1\uffff\5\25\2\uffff\1\20\1\25\11\uffff\1\25\26\uffff"+
			"\1\20\2\uffff\1\20",
			"\1\uffff",
			"\1\27\3\uffff\1\27\1\uffff\3\27\3\uffff\1\27\1\uffff\1\27\1\uffff\1"+
			"\27\3\uffff\3\27\1\uffff\5\27\1\uffff\4\27\1\uffff\5\27\3\uffff\2\27"+
			"\1\uffff\1\27\2\uffff\4\27\1\uffff\1\27\1\uffff\2\27\1\uffff\3\27\3\uffff"+
			"\3\27\1\uffff\2\27\2\uffff\3\27\1\uffff\3\27\1\uffff\4\27\1\uffff\3\27"+
			"\3\uffff\1\27\1\uffff\1\27\4\uffff\2\27\2\uffff\5\27\4\uffff\2\27\1\uffff"+
			"\2\27\2\uffff\1\27\1\uffff\14\27\1\uffff\2\27\1\uffff\4\27\1\uffff\2"+
			"\27\2\uffff\2\27\1\uffff\5\27\2\uffff\1\20\1\27\10\uffff\2\27\26\uffff"+
			"\1\20\2\uffff\1\20",
			"\1\uffff",
			"\1\31\3\uffff\1\31\1\uffff\3\31\3\uffff\1\31\1\uffff\1\31\1\uffff\1"+
			"\31\3\uffff\3\31\1\uffff\5\31\1\uffff\4\31\1\uffff\5\31\3\uffff\2\31"+
			"\1\uffff\1\31\2\uffff\4\31\1\uffff\1\31\1\uffff\2\31\1\uffff\3\31\3\uffff"+
			"\3\31\1\uffff\2\31\2\uffff\3\31\1\uffff\3\31\1\uffff\4\31\1\uffff\3\31"+
			"\3\uffff\1\31\1\uffff\1\31\4\uffff\2\31\2\uffff\5\31\4\uffff\2\31\1\uffff"+
			"\2\31\2\uffff\1\31\1\uffff\14\31\1\uffff\2\31\1\uffff\4\31\1\uffff\2"+
			"\31\2\uffff\2\31\1\uffff\5\31\2\uffff\1\20\1\31\10\uffff\2\31\26\uffff"+
			"\1\20\2\uffff\1\20",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			""
	};

	static final short[] DFA202_eot = DFA.unpackEncodedString(DFA202_eotS);
	static final short[] DFA202_eof = DFA.unpackEncodedString(DFA202_eofS);
	static final char[] DFA202_min = DFA.unpackEncodedStringToUnsignedChars(DFA202_minS);
	static final char[] DFA202_max = DFA.unpackEncodedStringToUnsignedChars(DFA202_maxS);
	static final short[] DFA202_accept = DFA.unpackEncodedString(DFA202_acceptS);
	static final short[] DFA202_special = DFA.unpackEncodedString(DFA202_specialS);
	static final short[][] DFA202_transition;

	static {
		int numStates = DFA202_transitionS.length;
		DFA202_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA202_transition[i] = DFA.unpackEncodedString(DFA202_transitionS[i]);
		}
	}

	protected class DFA202 extends DFA {

		public DFA202(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 202;
			this.eot = DFA202_eot;
			this.eof = DFA202_eof;
			this.min = DFA202_min;
			this.max = DFA202_max;
			this.accept = DFA202_accept;
			this.special = DFA202_special;
			this.transition = DFA202_transition;
		}
		@Override
		public String getDescription() {
			return "1419:5: ( ( K_CLUSTER )=> K_CLUSTER | ( K_FULL )? K_SCHEMA | ( K_KEYSPACES )=> K_KEYSPACES | ( K_ONLY )? K_KEYSPACE (ks= keyspaceName )? | ( K_TABLES )=> K_TABLES | K_COLUMNFAMILY cf= columnFamilyName | K_INDEX idx= columnFamilyName | K_MATERIALIZED K_VIEW view= columnFamilyName | ( K_TYPES )=> K_TYPES | K_TYPE tn= userTypeName | ( K_FUNCTIONS )=> K_FUNCTIONS | K_FUNCTION fn= functionName | ( K_AGGREGATES )=> K_AGGREGATES | K_AGGREGATE ag= functionName | ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )? (tT= IDENT |tT= QUOTED_NAME |tK= unreserved_keyword ) )";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			TokenStream input = (TokenStream)_input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA202_1 = input.LA(1);
						 
						int index202_1 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred5_Parser()) ) {s = 17;}
						else if ( (true) ) {s = 16;}
						 
						input.seek(index202_1);
						if ( s>=0 ) return s;
						break;

					case 1 : 
						int LA202_3 = input.LA(1);
						 
						int index202_3 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred6_Parser()) ) {s = 18;}
						else if ( (true) ) {s = 16;}
						 
						input.seek(index202_3);
						if ( s>=0 ) return s;
						break;

					case 2 : 
						int LA202_6 = input.LA(1);
						 
						int index202_6 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred7_Parser()) ) {s = 19;}
						else if ( (true) ) {s = 16;}
						 
						input.seek(index202_6);
						if ( s>=0 ) return s;
						break;

					case 3 : 
						int LA202_10 = input.LA(1);
						 
						int index202_10 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred8_Parser()) ) {s = 20;}
						else if ( (true) ) {s = 16;}
						 
						input.seek(index202_10);
						if ( s>=0 ) return s;
						break;

					case 4 : 
						int LA202_12 = input.LA(1);
						 
						int index202_12 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred9_Parser()) ) {s = 22;}
						else if ( (true) ) {s = 16;}
						 
						input.seek(index202_12);
						if ( s>=0 ) return s;
						break;

					case 5 : 
						int LA202_14 = input.LA(1);
						 
						int index202_14 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred10_Parser()) ) {s = 24;}
						else if ( (true) ) {s = 16;}
						 
						input.seek(index202_14);
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 202, _s, input);
			error(nvae);
			throw nvae;
		}
	}

	static final String DFA200_eotS =
		"\34\uffff";
	static final String DFA200_eofS =
		"\1\uffff\31\33\2\uffff";
	static final String DFA200_minS =
		"\1\32\31\u00b6\2\uffff";
	static final String DFA200_maxS =
		"\1\u00c1\31\u00db\2\uffff";
	static final String DFA200_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA200_specialS =
		"\34\uffff}>";
	static final String[] DFA200_transitionS = {
			"\1\1\3\uffff\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff"+
			"\1\5\1\6\1\7\1\uffff\1\3\1\31\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1"+
			"\27\1\11\1\3\3\uffff\1\31\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff"+
			"\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff"+
			"\2\31\1\3\1\uffff\3\3\1\uffff\4\3\1\uffff\1\31\2\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\2\3\2\uffff\5\3\4\uffff\2\3\1\uffff\2\3\2\uffff\1\3\1\uffff"+
			"\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\2\uffff\1\3\1\uffff\1\31\3\3\1"+
			"\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1\25\1\3\3\uffff\1\31\11"+
			"\uffff\1\2",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"\1\33\41\uffff\1\32\2\uffff\1\33",
			"",
			""
	};

	static final short[] DFA200_eot = DFA.unpackEncodedString(DFA200_eotS);
	static final short[] DFA200_eof = DFA.unpackEncodedString(DFA200_eofS);
	static final char[] DFA200_min = DFA.unpackEncodedStringToUnsignedChars(DFA200_minS);
	static final char[] DFA200_max = DFA.unpackEncodedStringToUnsignedChars(DFA200_maxS);
	static final short[] DFA200_accept = DFA.unpackEncodedString(DFA200_acceptS);
	static final short[] DFA200_special = DFA.unpackEncodedString(DFA200_specialS);
	static final short[][] DFA200_transition;

	static {
		int numStates = DFA200_transitionS.length;
		DFA200_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA200_transition[i] = DFA.unpackEncodedString(DFA200_transitionS[i]);
		}
	}

	protected class DFA200 extends DFA {

		public DFA200(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 200;
			this.eot = DFA200_eot;
			this.eof = DFA200_eof;
			this.min = DFA200_min;
			this.max = DFA200_max;
			this.accept = DFA200_accept;
			this.special = DFA200_special;
			this.transition = DFA200_transition;
		}
		@Override
		public String getDescription() {
			return "1434:7: ( (ksT= IDENT |ksT= QUOTED_NAME |ksK= unreserved_keyword ) '.' )?";
		}
	}

	static final String DFA208_eotS =
		"\35\uffff";
	static final String DFA208_eofS =
		"\1\uffff\32\34\2\uffff";
	static final String DFA208_minS =
		"\1\32\32\u00d8\2\uffff";
	static final String DFA208_maxS =
		"\1\u00c1\32\u00db\2\uffff";
	static final String DFA208_acceptS =
		"\33\uffff\1\1\1\2";
	static final String DFA208_specialS =
		"\35\uffff}>";
	static final String[] DFA208_transitionS = {
			"\1\1\3\uffff\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff"+
			"\1\5\1\6\1\7\1\uffff\1\3\1\31\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1"+
			"\27\1\11\1\3\3\uffff\1\31\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff"+
			"\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff"+
			"\2\31\1\3\1\uffff\3\3\1\uffff\4\3\1\uffff\1\31\2\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\2\3\2\uffff\5\3\4\uffff\2\3\1\uffff\2\3\2\uffff\1\3\1\uffff"+
			"\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\2\uffff\1\3\1\uffff\1\31\3\3\1"+
			"\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1\25\1\3\3\uffff\1\31\10"+
			"\uffff\1\32\1\2",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"\1\33\2\uffff\1\34",
			"",
			""
	};

	static final short[] DFA208_eot = DFA.unpackEncodedString(DFA208_eotS);
	static final short[] DFA208_eof = DFA.unpackEncodedString(DFA208_eofS);
	static final char[] DFA208_min = DFA.unpackEncodedStringToUnsignedChars(DFA208_minS);
	static final char[] DFA208_max = DFA.unpackEncodedStringToUnsignedChars(DFA208_maxS);
	static final short[] DFA208_accept = DFA.unpackEncodedString(DFA208_acceptS);
	static final short[] DFA208_special = DFA.unpackEncodedString(DFA208_specialS);
	static final short[][] DFA208_transition;

	static {
		int numStates = DFA208_transitionS.length;
		DFA208_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA208_transition[i] = DFA.unpackEncodedString(DFA208_transitionS[i]);
		}
	}

	protected class DFA208 extends DFA {

		public DFA208(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 208;
			this.eot = DFA208_eot;
			this.eof = DFA208_eof;
			this.min = DFA208_min;
			this.max = DFA208_max;
			this.accept = DFA208_accept;
			this.special = DFA208_special;
			this.transition = DFA208_transition;
		}
		@Override
		public String getDescription() {
			return "1481:7: ( ksName[name] '.' )?";
		}
	}

	static final String DFA209_eotS =
		"\35\uffff";
	static final String DFA209_eofS =
		"\1\uffff\32\34\2\uffff";
	static final String DFA209_minS =
		"\1\32\32\37\2\uffff";
	static final String DFA209_maxS =
		"\1\u00c1\32\u00db\2\uffff";
	static final String DFA209_acceptS =
		"\33\uffff\1\1\1\2";
	static final String DFA209_specialS =
		"\35\uffff}>";
	static final String[] DFA209_transitionS = {
			"\1\1\3\uffff\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff"+
			"\1\5\1\6\1\7\1\uffff\1\3\1\31\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1"+
			"\27\1\11\1\3\3\uffff\1\31\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff"+
			"\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff"+
			"\2\31\1\3\1\uffff\3\3\1\uffff\4\3\1\uffff\1\31\2\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\2\3\2\uffff\5\3\4\uffff\2\3\1\uffff\2\3\2\uffff\1\3\1\uffff"+
			"\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\2\uffff\1\3\1\uffff\1\31\3\3\1"+
			"\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1\25\1\3\3\uffff\1\31\10"+
			"\uffff\1\32\1\2",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"\1\34\3\uffff\2\34\3\uffff\1\34\36\uffff\1\34\7\uffff\1\34\5\uffff\1"+
			"\34\15\uffff\1\34\6\uffff\1\34\14\uffff\1\34\3\uffff\1\34\4\uffff\1\34"+
			"\2\uffff\1\34\4\uffff\2\34\10\uffff\1\34\14\uffff\1\34\16\uffff\1\34"+
			"\6\uffff\2\34\32\uffff\1\34\6\uffff\1\33\2\uffff\1\34",
			"",
			""
	};

	static final short[] DFA209_eot = DFA.unpackEncodedString(DFA209_eotS);
	static final short[] DFA209_eof = DFA.unpackEncodedString(DFA209_eofS);
	static final char[] DFA209_min = DFA.unpackEncodedStringToUnsignedChars(DFA209_minS);
	static final char[] DFA209_max = DFA.unpackEncodedStringToUnsignedChars(DFA209_maxS);
	static final short[] DFA209_accept = DFA.unpackEncodedString(DFA209_acceptS);
	static final short[] DFA209_special = DFA.unpackEncodedString(DFA209_specialS);
	static final short[][] DFA209_transition;

	static {
		int numStates = DFA209_transitionS.length;
		DFA209_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA209_transition[i] = DFA.unpackEncodedString(DFA209_transitionS[i]);
		}
	}

	protected class DFA209 extends DFA {

		public DFA209(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 209;
			this.eot = DFA209_eot;
			this.eof = DFA209_eof;
			this.min = DFA209_min;
			this.max = DFA209_max;
			this.accept = DFA209_accept;
			this.special = DFA209_special;
			this.transition = DFA209_transition;
		}
		@Override
		public String getDescription() {
			return "1486:7: ( ksName[name] '.' )?";
		}
	}

	static final String DFA227_eotS =
		"\44\uffff";
	static final String DFA227_eofS =
		"\44\uffff";
	static final String DFA227_minS =
		"\1\6\2\uffff\1\6\4\uffff\32\u00d1\1\u00d8\1\uffff";
	static final String DFA227_maxS =
		"\1\u00e5\2\uffff\1\u00e6\4\uffff\33\u00da\1\uffff";
	static final String DFA227_acceptS =
		"\1\uffff\1\1\1\2\1\uffff\1\4\1\5\1\6\1\7\33\uffff\1\3";
	static final String DFA227_specialS =
		"\44\uffff}>";
	static final String[] DFA227_transitionS = {
			"\1\1\4\uffff\1\1\10\uffff\1\1\3\uffff\1\1\2\uffff\1\1\130\uffff\2\1\4"+
			"\uffff\1\5\13\uffff\2\1\70\uffff\1\7\4\uffff\1\1\2\uffff\1\1\10\uffff"+
			"\1\4\10\uffff\1\6\6\uffff\1\2\3\uffff\1\3",
			"",
			"",
			"\1\2\4\uffff\1\2\10\uffff\1\2\3\uffff\1\2\1\uffff\1\10\1\2\2\uffff\1"+
			"\12\1\uffff\3\12\3\uffff\1\12\1\uffff\1\12\1\uffff\1\13\3\uffff\1\14"+
			"\1\15\1\16\1\uffff\1\12\1\41\3\12\1\uffff\2\12\1\40\1\17\1\uffff\2\12"+
			"\1\36\1\20\1\12\3\uffff\1\42\1\21\1\uffff\1\22\2\uffff\3\12\1\23\1\uffff"+
			"\1\12\1\uffff\2\12\1\uffff\3\12\3\uffff\1\24\2\12\1\uffff\1\25\1\12\2"+
			"\uffff\2\42\1\12\1\uffff\3\12\1\uffff\4\12\1\uffff\1\42\2\12\1\uffff"+
			"\2\2\1\12\1\uffff\1\12\1\uffff\1\2\2\uffff\2\12\2\uffff\5\12\2\2\2\uffff"+
			"\2\12\1\uffff\2\12\2\uffff\1\12\1\uffff\1\12\1\26\5\12\1\27\1\37\1\30"+
			"\1\35\1\31\1\uffff\1\2\1\12\1\uffff\1\42\3\12\1\uffff\2\12\2\uffff\2"+
			"\12\1\uffff\1\32\1\12\1\33\1\34\1\12\3\uffff\1\42\10\uffff\1\2\1\11\3"+
			"\uffff\1\2\2\uffff\1\2\10\uffff\1\2\4\uffff\1\2\3\uffff\1\2\6\uffff\1"+
			"\2\3\uffff\2\2",
			"",
			"",
			"",
			"",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\6\uffff\1\2\1\uffff\1\43",
			"\1\2\1\uffff\1\43",
			""
	};

	static final short[] DFA227_eot = DFA.unpackEncodedString(DFA227_eotS);
	static final short[] DFA227_eof = DFA.unpackEncodedString(DFA227_eofS);
	static final char[] DFA227_min = DFA.unpackEncodedStringToUnsignedChars(DFA227_minS);
	static final char[] DFA227_max = DFA.unpackEncodedStringToUnsignedChars(DFA227_maxS);
	static final short[] DFA227_accept = DFA.unpackEncodedString(DFA227_acceptS);
	static final short[] DFA227_special = DFA.unpackEncodedString(DFA227_specialS);
	static final short[][] DFA227_transition;

	static {
		int numStates = DFA227_transitionS.length;
		DFA227_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA227_transition[i] = DFA.unpackEncodedString(DFA227_transitionS[i]);
		}
	}

	protected class DFA227 extends DFA {

		public DFA227(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 227;
			this.eot = DFA227_eot;
			this.eof = DFA227_eof;
			this.min = DFA227_min;
			this.max = DFA227_max;
			this.accept = DFA227_accept;
			this.special = DFA227_special;
			this.transition = DFA227_transition;
		}
		@Override
		public String getDescription() {
			return "1591:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK );";
		}
	}

	static final String DFA229_eotS =
		"\34\uffff";
	static final String DFA229_eofS =
		"\1\uffff\31\33\2\uffff";
	static final String DFA229_minS =
		"\1\32\31\u00b6\2\uffff";
	static final String DFA229_maxS =
		"\1\u00c1\31\u00db\2\uffff";
	static final String DFA229_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA229_specialS =
		"\34\uffff}>";
	static final String[] DFA229_transitionS = {
			"\1\1\3\uffff\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff"+
			"\1\5\1\6\1\7\1\uffff\1\3\1\32\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1"+
			"\27\1\11\1\3\3\uffff\1\32\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff"+
			"\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff"+
			"\2\32\1\3\1\uffff\3\3\1\uffff\4\3\1\uffff\1\32\2\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\2\3\2\uffff\5\3\4\uffff\2\3\1\uffff\2\3\2\uffff\1\3\1\uffff"+
			"\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\1\uffff\1\33\1\3\1\uffff\1\32"+
			"\3\3\1\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1\25\1\3\3\uffff\1"+
			"\32\10\uffff\1\32\1\2",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"\1\33\32\uffff\1\33\6\uffff\1\32\2\uffff\1\33",
			"",
			""
	};

	static final short[] DFA229_eot = DFA.unpackEncodedString(DFA229_eotS);
	static final short[] DFA229_eof = DFA.unpackEncodedString(DFA229_eofS);
	static final char[] DFA229_min = DFA.unpackEncodedStringToUnsignedChars(DFA229_minS);
	static final char[] DFA229_max = DFA.unpackEncodedStringToUnsignedChars(DFA229_maxS);
	static final short[] DFA229_accept = DFA.unpackEncodedString(DFA229_acceptS);
	static final short[] DFA229_special = DFA.unpackEncodedString(DFA229_specialS);
	static final short[][] DFA229_transition;

	static {
		int numStates = DFA229_transitionS.length;
		DFA229_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA229_transition[i] = DFA.unpackEncodedString(DFA229_transitionS[i]);
		}
	}

	protected class DFA229 extends DFA {

		public DFA229(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 229;
			this.eot = DFA229_eot;
			this.eof = DFA229_eof;
			this.min = DFA229_min;
			this.max = DFA229_max;
			this.accept = DFA229_accept;
			this.special = DFA229_special;
			this.transition = DFA229_transition;
		}
		@Override
		public String getDescription() {
			return "1610:7: (ks= keyspaceName '.' )?";
		}
	}

	static final String DFA231_eotS =
		"\72\uffff";
	static final String DFA231_eofS =
		"\72\uffff";
	static final String DFA231_minS =
		"\1\32\31\u00d1\1\u00d8\1\u00d1\1\u00d8\1\32\1\6\31\u00d1\2\uffff";
	static final String DFA231_maxS =
		"\1\u00c1\32\u00d8\1\u00d1\1\u00d8\1\u00c1\1\u00e5\31\u00d1\2\uffff";
	static final String DFA231_acceptS =
		"\70\uffff\1\1\1\2";
	static final String DFA231_specialS =
		"\72\uffff}>";
	static final String[] DFA231_transitionS = {
			"\1\1\3\uffff\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff"+
			"\1\5\1\6\1\7\1\uffff\1\3\1\34\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1"+
			"\27\1\11\1\3\3\uffff\1\34\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff"+
			"\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff"+
			"\2\34\1\3\1\uffff\3\3\1\uffff\4\3\1\uffff\1\34\2\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\2\3\2\uffff\5\3\4\uffff\2\3\1\uffff\2\3\2\uffff\1\3\1\uffff"+
			"\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\1\uffff\1\33\1\3\1\uffff\1\34"+
			"\3\3\1\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1\25\1\3\3\uffff\1"+
			"\34\10\uffff\1\32\1\2",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\36\6\uffff\1\35",
			"\1\35",
			"\1\36",
			"\1\35",
			"\1\37\3\uffff\1\41\1\uffff\3\41\3\uffff\1\41\1\uffff\1\41\1\uffff\1"+
			"\42\3\uffff\1\43\1\44\1\45\1\uffff\1\41\1\uffff\3\41\1\uffff\2\41\1\67"+
			"\1\46\1\uffff\2\41\1\65\1\47\1\41\4\uffff\1\50\1\uffff\1\51\2\uffff\3"+
			"\41\1\52\1\uffff\1\41\1\uffff\2\41\1\uffff\3\41\3\uffff\1\53\2\41\1\uffff"+
			"\1\54\1\41\4\uffff\1\41\1\uffff\3\41\1\uffff\4\41\2\uffff\2\41\3\uffff"+
			"\1\41\1\uffff\1\41\4\uffff\2\41\2\uffff\5\41\4\uffff\2\41\1\uffff\2\41"+
			"\2\uffff\1\41\1\uffff\1\41\1\55\5\41\1\56\1\66\1\57\1\64\1\60\1\uffff"+
			"\1\33\1\41\2\uffff\3\41\1\uffff\2\41\2\uffff\2\41\1\uffff\1\61\1\41\1"+
			"\62\1\63\1\41\15\uffff\1\40",
			"\1\71\4\uffff\1\71\10\uffff\1\71\3\uffff\1\71\1\uffff\2\71\2\uffff\1"+
			"\71\1\uffff\3\71\3\uffff\1\71\1\uffff\1\71\1\uffff\1\71\3\uffff\3\71"+
			"\1\uffff\5\71\1\uffff\4\71\1\uffff\5\71\3\uffff\2\71\1\uffff\1\71\2\uffff"+
			"\4\71\1\uffff\1\71\1\uffff\2\71\1\uffff\3\71\3\uffff\3\71\1\uffff\2\71"+
			"\2\uffff\3\71\1\uffff\3\71\1\uffff\4\71\1\uffff\3\71\1\uffff\3\71\1\uffff"+
			"\1\71\1\uffff\1\71\2\uffff\2\71\2\uffff\7\71\2\uffff\2\71\1\uffff\2\71"+
			"\2\uffff\1\71\1\uffff\14\71\1\uffff\2\71\1\uffff\4\71\1\uffff\2\71\2"+
			"\uffff\2\71\1\uffff\5\71\3\uffff\1\71\10\uffff\2\71\3\uffff\1\71\2\uffff"+
			"\1\71\10\uffff\1\71\1\70\3\uffff\1\71\3\uffff\1\71\6\uffff\1\71\3\uffff"+
			"\1\71",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"\1\36",
			"",
			""
	};

	static final short[] DFA231_eot = DFA.unpackEncodedString(DFA231_eotS);
	static final short[] DFA231_eof = DFA.unpackEncodedString(DFA231_eofS);
	static final char[] DFA231_min = DFA.unpackEncodedStringToUnsignedChars(DFA231_minS);
	static final char[] DFA231_max = DFA.unpackEncodedStringToUnsignedChars(DFA231_maxS);
	static final short[] DFA231_accept = DFA.unpackEncodedString(DFA231_acceptS);
	static final short[] DFA231_special = DFA.unpackEncodedString(DFA231_specialS);
	static final short[][] DFA231_transition;

	static {
		int numStates = DFA231_transitionS.length;
		DFA231_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA231_transition[i] = DFA.unpackEncodedString(DFA231_transitionS[i]);
		}
	}

	protected class DFA231 extends DFA {

		public DFA231(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 231;
			this.eot = DFA231_eot;
			this.eof = DFA231_eof;
			this.min = DFA231_min;
			this.max = DFA231_max;
			this.accept = DFA231_accept;
			this.special = DFA231_special;
			this.transition = DFA231_transition;
		}
		@Override
		public String getDescription() {
			return "1621:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );";
		}
	}

	static final String DFA233_eotS =
		"\40\uffff";
	static final String DFA233_eofS =
		"\1\1\37\uffff";
	static final String DFA233_minS =
		"\1\43\1\uffff\1\6\1\uffff\31\u00b5\1\uffff\2\u00b5";
	static final String DFA233_maxS =
		"\1\u00e6\1\uffff\1\u00e5\1\uffff\31\u00d8\1\uffff\2\u00d8";
	static final String DFA233_acceptS =
		"\1\uffff\1\3\1\uffff\1\2\31\uffff\1\1\2\uffff";
	static final String DFA233_specialS =
		"\40\uffff}>";
	static final String[] DFA233_transitionS = {
			"\1\1\1\uffff\1\1\1\uffff\1\1\1\uffff\1\1\30\uffff\2\1\21\uffff\1\1\2"+
			"\uffff\1\1\5\uffff\1\1\13\uffff\1\1\25\uffff\1\1\2\uffff\1\1\4\uffff"+
			"\1\1\41\uffff\1\1\12\uffff\1\1\15\uffff\1\1\16\uffff\1\1\1\2\1\uffff"+
			"\1\1\1\3\3\uffff\2\1\7\uffff\1\1\2\uffff\1\1",
			"",
			"\1\35\4\uffff\1\35\5\uffff\1\1\2\uffff\1\35\3\uffff\1\35\1\uffff\1\4"+
			"\1\35\2\uffff\1\6\1\uffff\3\6\3\uffff\1\6\1\uffff\1\6\1\uffff\1\7\3\uffff"+
			"\1\10\1\11\1\12\1\uffff\1\6\1\36\3\6\1\uffff\2\6\1\34\1\13\1\uffff\2"+
			"\6\1\32\1\14\1\6\3\uffff\1\37\1\15\1\uffff\1\16\2\uffff\3\6\1\17\1\uffff"+
			"\1\6\1\uffff\2\6\1\uffff\3\6\3\uffff\1\20\2\6\1\uffff\1\21\1\6\2\uffff"+
			"\2\37\1\6\1\uffff\3\6\1\uffff\4\6\1\uffff\1\37\2\6\1\uffff\2\35\1\6\1"+
			"\uffff\1\6\1\uffff\1\35\2\uffff\2\6\2\uffff\5\6\2\35\2\uffff\2\6\1\uffff"+
			"\2\6\2\uffff\1\6\1\uffff\1\6\1\22\5\6\1\23\1\33\1\24\1\31\1\25\1\uffff"+
			"\1\35\1\6\1\uffff\1\37\3\6\1\uffff\2\6\2\uffff\2\6\1\uffff\1\26\1\6\1"+
			"\27\1\30\1\6\3\uffff\1\37\10\uffff\1\35\1\5\3\uffff\1\35\2\uffff\1\35"+
			"\10\uffff\1\35\4\uffff\1\35\3\uffff\1\35\6\uffff\1\35\3\uffff\1\35",
			"",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"",
			"\1\1\33\uffff\1\35\3\uffff\1\1\2\uffff\1\35",
			"\1\1\37\uffff\1\1\2\uffff\1\35"
	};

	static final short[] DFA233_eot = DFA.unpackEncodedString(DFA233_eotS);
	static final short[] DFA233_eof = DFA.unpackEncodedString(DFA233_eofS);
	static final char[] DFA233_min = DFA.unpackEncodedStringToUnsignedChars(DFA233_minS);
	static final char[] DFA233_max = DFA.unpackEncodedStringToUnsignedChars(DFA233_maxS);
	static final short[] DFA233_accept = DFA.unpackEncodedString(DFA233_acceptS);
	static final short[] DFA233_special = DFA.unpackEncodedString(DFA233_specialS);
	static final short[][] DFA233_transition;

	static {
		int numStates = DFA233_transitionS.length;
		DFA233_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA233_transition[i] = DFA.unpackEncodedString(DFA233_transitionS[i]);
		}
	}

	protected class DFA233 extends DFA {

		public DFA233(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 233;
			this.eot = DFA233_eot;
			this.eof = DFA233_eof;
			this.min = DFA233_min;
			this.max = DFA233_max;
			this.accept = DFA233_accept;
			this.special = DFA233_special;
			this.transition = DFA233_transition;
		}
		@Override
		public String getDescription() {
			return "()* loopback of 1637:9: ( '+' r= termMultiplication | '-' r= termMultiplication )*";
		}
	}

	static final String DFA236_eotS =
		"\116\uffff";
	static final String DFA236_eofS =
		"\3\uffff\1\1\46\uffff\1\1\10\uffff\33\44";
	static final String DFA236_minS =
		"\1\6\1\uffff\1\6\1\43\1\uffff\1\u00d1\1\u00d0\32\u00d1\1\u00d2\2\u00d1"+
		"\1\uffff\2\u00d1\1\u00d8\1\u00d1\1\uffff\1\6\1\32\1\u0081\1\6\1\61\1\52"+
		"\3\u00d1\33\43";
	static final String DFA236_maxS =
		"\1\u00e5\1\uffff\1\u00e5\1\u00e6\1\uffff\1\u00d8\1\u00e2\2\u00d8\1\u00dc"+
		"\30\u00d8\2\u00dc\1\uffff\2\u00dc\2\u00d8\1\uffff\1\u00e6\1\u00c1\1\u00d8"+
		"\1\u00e5\2\u00d8\3\u00d2\33\u00e6";
	static final String DFA236_acceptS =
		"\1\uffff\1\1\2\uffff\1\2\37\uffff\1\3\4\uffff\1\4\44\uffff";
	static final String DFA236_specialS =
		"\116\uffff}>";
	static final String[] DFA236_transitionS = {
			"\1\1\4\uffff\1\1\10\uffff\1\1\3\uffff\1\1\1\uffff\1\4\1\1\2\uffff\1\4"+
			"\1\uffff\3\4\3\uffff\1\4\1\uffff\1\4\1\uffff\1\4\3\uffff\3\4\1\uffff"+
			"\1\4\1\5\3\4\1\uffff\4\4\1\uffff\5\4\3\uffff\2\4\1\uffff\1\4\2\uffff"+
			"\4\4\1\uffff\1\4\1\uffff\2\4\1\uffff\3\4\3\uffff\3\4\1\uffff\2\4\2\uffff"+
			"\3\4\1\uffff\3\4\1\uffff\4\4\1\uffff\3\4\1\uffff\2\1\1\4\1\uffff\1\4"+
			"\1\uffff\1\1\2\uffff\2\4\2\uffff\5\4\2\1\2\uffff\2\4\1\uffff\2\4\2\uffff"+
			"\1\4\1\uffff\14\4\1\uffff\2\4\1\uffff\4\4\1\uffff\2\4\2\uffff\2\4\1\uffff"+
			"\5\4\3\uffff\1\4\10\uffff\1\3\1\4\3\uffff\1\1\2\uffff\1\1\10\uffff\1"+
			"\2\10\uffff\1\1\6\uffff\1\1\3\uffff\1\1",
			"",
			"\1\1\4\uffff\1\1\10\uffff\1\1\3\uffff\1\1\1\uffff\1\7\1\1\2\uffff\1"+
			"\50\1\uffff\3\50\3\uffff\1\50\1\uffff\1\50\1\uffff\1\12\3\uffff\1\13"+
			"\1\14\1\15\1\uffff\1\50\1\40\3\50\1\uffff\2\50\1\37\1\16\1\uffff\2\50"+
			"\1\35\1\17\1\50\3\uffff\1\47\1\20\1\uffff\1\21\2\uffff\3\50\1\22\1\uffff"+
			"\1\46\1\uffff\2\50\1\uffff\3\50\3\uffff\1\23\2\50\1\uffff\1\24\1\50\2"+
			"\uffff\1\47\1\41\1\50\1\uffff\3\50\1\uffff\1\42\1\50\1\11\1\50\1\uffff"+
			"\1\47\2\50\1\uffff\2\1\1\50\1\uffff\1\50\1\uffff\1\1\2\uffff\2\50\2\uffff"+
			"\5\50\2\1\2\uffff\2\50\1\uffff\2\50\2\uffff\1\50\1\44\1\50\1\25\5\50"+
			"\1\26\1\36\1\27\1\34\1\30\1\uffff\1\1\1\50\1\uffff\1\47\1\43\2\50\1\uffff"+
			"\2\50\2\uffff\2\50\1\uffff\1\31\1\50\1\32\1\33\1\45\3\uffff\1\47\10\uffff"+
			"\1\1\1\10\3\uffff\1\6\2\uffff\1\1\10\uffff\1\1\4\uffff\1\1\3\uffff\1"+
			"\1\6\uffff\1\1\3\uffff\1\1",
			"\1\1\1\uffff\1\1\1\uffff\3\1\30\uffff\2\1\21\uffff\1\1\2\uffff\1\1\5"+
			"\uffff\1\1\13\uffff\1\1\25\uffff\1\1\2\uffff\1\1\4\uffff\1\1\41\uffff"+
			"\1\1\12\uffff\1\1\15\uffff\1\1\14\uffff\1\1\1\uffff\2\1\1\uffff\2\1\1"+
			"\uffff\1\4\3\1\6\uffff\2\1\2\uffff\1\1",
			"",
			"\1\51\6\uffff\1\4",
			"\1\1\1\uffff\1\52\1\1\1\uffff\2\1\2\uffff\1\1\10\uffff\1\1",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53\3\uffff\1\44",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"\1\1\6\uffff\1\53",
			"\1\1\6\uffff\1\53",
			"\1\44\5\uffff\1\53",
			"\1\1\1\44\5\uffff\1\53\3\uffff\1\44",
			"\1\1\1\44\5\uffff\1\53\3\uffff\1\44",
			"",
			"\1\1\1\44\5\uffff\1\53\3\uffff\1\44",
			"\1\1\1\44\5\uffff\1\53\3\uffff\1\44",
			"\1\53",
			"\1\1\1\44\5\uffff\1\53",
			"",
			"\1\44\4\uffff\1\44\10\uffff\1\44\3\uffff\1\44\1\uffff\2\44\2\uffff\1"+
			"\44\1\uffff\3\44\1\1\1\uffff\1\1\1\44\1\1\1\57\1\1\1\44\3\uffff\3\44"+
			"\1\uffff\5\44\1\uffff\4\44\1\uffff\5\44\2\1\1\uffff\2\44\1\uffff\1\44"+
			"\2\uffff\4\44\1\uffff\1\44\1\uffff\2\44\1\uffff\1\56\2\44\1\1\2\uffff"+
			"\3\44\1\1\2\44\2\uffff\3\44\1\uffff\3\44\1\1\4\44\1\uffff\3\44\1\uffff"+
			"\3\44\1\uffff\1\44\1\uffff\1\44\2\uffff\2\44\1\uffff\1\1\2\44\1\54\4"+
			"\44\1\1\1\uffff\2\44\1\uffff\2\44\2\uffff\1\44\1\uffff\14\44\1\uffff"+
			"\2\44\1\uffff\4\44\1\uffff\2\44\1\1\1\uffff\2\44\1\uffff\5\44\1\uffff"+
			"\1\1\1\uffff\1\44\10\uffff\2\44\1\uffff\1\1\1\uffff\1\44\2\uffff\1\44"+
			"\7\uffff\1\1\1\44\2\1\1\uffff\2\1\2\uffff\1\1\1\55\1\1\5\uffff\1\44\2"+
			"\1\1\uffff\1\44\1\1",
			"\1\60\3\uffff\1\62\1\uffff\3\62\3\uffff\1\62\1\uffff\1\62\1\uffff\1"+
			"\1\3\uffff\3\1\1\uffff\1\62\1\uffff\3\62\1\uffff\2\62\2\1\1\uffff\2\62"+
			"\2\1\1\62\4\uffff\1\1\1\uffff\1\1\2\uffff\3\62\1\1\1\uffff\1\62\1\uffff"+
			"\2\62\1\uffff\3\62\3\uffff\1\1\2\62\1\uffff\1\1\1\62\3\uffff\1\44\1\62"+
			"\1\uffff\3\62\1\uffff\4\62\2\uffff\2\62\3\uffff\1\62\1\uffff\1\62\4\uffff"+
			"\2\62\2\uffff\5\62\4\uffff\2\62\1\uffff\2\62\2\uffff\1\62\1\uffff\1\62"+
			"\1\1\5\62\5\1\1\uffff\1\1\1\62\2\uffff\3\62\1\uffff\2\62\2\uffff\2\62"+
			"\1\uffff\1\1\1\62\2\1\1\62\15\uffff\1\61",
			"\1\1\117\uffff\1\44\6\uffff\1\44",
			"\1\1\4\uffff\1\1\10\uffff\1\1\3\uffff\1\1\1\uffff\1\63\1\1\2\uffff\1"+
			"\65\1\uffff\3\65\3\uffff\1\65\1\uffff\1\65\1\uffff\1\66\3\uffff\1\67"+
			"\1\70\1\71\1\uffff\1\65\1\114\3\65\1\uffff\2\65\1\113\1\72\1\uffff\2"+
			"\65\1\111\1\73\1\65\3\uffff\1\115\1\74\1\uffff\1\75\2\uffff\3\65\1\76"+
			"\1\uffff\1\65\1\uffff\2\65\1\uffff\3\65\3\uffff\1\77\2\65\1\uffff\1\100"+
			"\1\65\2\uffff\2\115\1\65\1\uffff\3\65\1\uffff\4\65\1\uffff\1\115\2\65"+
			"\1\uffff\2\1\1\65\1\uffff\1\65\1\uffff\1\1\2\uffff\2\65\2\uffff\5\65"+
			"\2\1\2\uffff\2\65\1\uffff\2\65\2\uffff\1\65\1\uffff\1\65\1\101\5\65\1"+
			"\102\1\112\1\103\1\110\1\104\1\uffff\1\1\1\65\1\uffff\1\115\3\65\1\uffff"+
			"\2\65\2\uffff\2\65\1\uffff\1\105\1\65\1\106\1\107\1\65\3\uffff\1\115"+
			"\10\uffff\1\1\1\64\3\uffff\1\1\2\uffff\1\1\10\uffff\1\1\4\uffff\1\1\3"+
			"\uffff\1\1\6\uffff\1\1\3\uffff\1\1",
			"\1\1\u009f\uffff\1\44\6\uffff\1\44",
			"\1\1\3\uffff\3\1\12\uffff\1\1\3\uffff\2\1\5\uffff\1\1\1\uffff\1\1\5"+
			"\uffff\1\1\14\uffff\1\1\3\uffff\1\1\64\uffff\1\1\5\uffff\5\1\20\uffff"+
			"\1\1\1\uffff\2\1\36\uffff\1\44\6\uffff\1\44",
			"\1\1\1\44",
			"\1\1\1\44",
			"\1\1\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\1\2\44"+
			"\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44",
			"\1\44\1\uffff\1\44\1\uffff\3\44\30\uffff\2\44\21\uffff\1\44\2\uffff"+
			"\1\44\5\uffff\1\44\13\uffff\1\44\25\uffff\1\44\2\uffff\1\44\4\uffff\1"+
			"\44\41\uffff\1\44\12\uffff\1\44\15\uffff\1\44\14\uffff\1\44\1\uffff\2"+
			"\44\1\uffff\2\44\1\uffff\1\1\3\44\6\uffff\2\44\2\uffff\1\44"
	};

	static final short[] DFA236_eot = DFA.unpackEncodedString(DFA236_eotS);
	static final short[] DFA236_eof = DFA.unpackEncodedString(DFA236_eofS);
	static final char[] DFA236_min = DFA.unpackEncodedStringToUnsignedChars(DFA236_minS);
	static final char[] DFA236_max = DFA.unpackEncodedStringToUnsignedChars(DFA236_maxS);
	static final short[] DFA236_accept = DFA.unpackEncodedString(DFA236_acceptS);
	static final short[] DFA236_special = DFA.unpackEncodedString(DFA236_specialS);
	static final short[][] DFA236_transition;

	static {
		int numStates = DFA236_transitionS.length;
		DFA236_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA236_transition[i] = DFA.unpackEncodedString(DFA236_transitionS[i]);
		}
	}

	protected class DFA236 extends DFA {

		public DFA236(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 236;
			this.eot = DFA236_eot;
			this.eof = DFA236_eof;
			this.min = DFA236_min;
			this.max = DFA236_max;
			this.accept = DFA236_accept;
			this.special = DFA236_special;
			this.transition = DFA236_transition;
		}
		@Override
		public String getDescription() {
			return "1655:1: simpleTerm returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= simpleTerm | K_CAST '(' t= simpleTerm K_AS n= native_type ')' );";
		}
	}

	static final String DFA239_eotS =
		"\40\uffff";
	static final String DFA239_eofS =
		"\40\uffff";
	static final String DFA239_minS =
		"\1\6\1\uffff\34\33\2\uffff";
	static final String DFA239_maxS =
		"\1\u00e5\1\uffff\33\u00d8\1\u00d6\2\uffff";
	static final String DFA239_acceptS =
		"\1\uffff\1\1\34\uffff\1\2\1\3";
	static final String DFA239_specialS =
		"\40\uffff}>";
	static final String[] DFA239_transitionS = {
			"\1\1\4\uffff\1\1\5\uffff\1\35\2\uffff\1\1\3\uffff\1\1\1\uffff\1\2\1\1"+
			"\2\uffff\1\4\1\uffff\3\4\3\uffff\1\4\1\uffff\1\4\1\uffff\1\5\3\uffff"+
			"\1\6\1\7\1\10\1\uffff\1\4\1\33\3\4\1\uffff\2\4\1\32\1\11\1\uffff\2\4"+
			"\1\30\1\12\1\4\3\uffff\1\34\1\13\1\uffff\1\14\2\uffff\3\4\1\15\1\uffff"+
			"\1\4\1\uffff\2\4\1\uffff\3\4\3\uffff\1\16\2\4\1\uffff\1\17\1\4\2\uffff"+
			"\2\34\1\4\1\uffff\3\4\1\uffff\4\4\1\uffff\1\34\2\4\1\uffff\2\1\1\4\1"+
			"\uffff\1\4\1\uffff\1\1\2\uffff\2\4\2\uffff\5\4\2\1\2\uffff\2\4\1\uffff"+
			"\2\4\2\uffff\1\4\1\uffff\1\4\1\20\5\4\1\21\1\31\1\22\1\27\1\23\1\uffff"+
			"\1\1\1\4\1\uffff\1\34\3\4\1\uffff\2\4\2\uffff\2\4\1\uffff\1\24\1\4\1"+
			"\25\1\26\1\4\3\uffff\1\34\10\uffff\1\1\1\3\3\uffff\1\1\2\uffff\1\1\10"+
			"\uffff\1\1\4\uffff\1\1\3\uffff\1\1\6\uffff\1\1\3\uffff\1\1",
			"",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b5\uffff\1\1\1\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b7\uffff\1\36\2\uffff\1\36\1\uffff\1\1",
			"\1\37\u00b7\uffff\1\36\2\uffff\1\36",
			"",
			""
	};

	static final short[] DFA239_eot = DFA.unpackEncodedString(DFA239_eotS);
	static final short[] DFA239_eof = DFA.unpackEncodedString(DFA239_eofS);
	static final char[] DFA239_min = DFA.unpackEncodedStringToUnsignedChars(DFA239_minS);
	static final char[] DFA239_max = DFA.unpackEncodedStringToUnsignedChars(DFA239_maxS);
	static final short[] DFA239_accept = DFA.unpackEncodedString(DFA239_acceptS);
	static final short[] DFA239_special = DFA.unpackEncodedString(DFA239_specialS);
	static final short[][] DFA239_transition;

	static {
		int numStates = DFA239_transitionS.length;
		DFA239_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA239_transition[i] = DFA.unpackEncodedString(DFA239_transitionS[i]);
		}
	}

	protected class DFA239 extends DFA {

		public DFA239(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 239;
			this.eot = DFA239_eot;
			this.eof = DFA239_eof;
			this.min = DFA239_min;
			this.max = DFA239_max;
			this.accept = DFA239_accept;
			this.special = DFA239_special;
			this.transition = DFA239_transition;
		}
		@Override
		public String getDescription() {
			return "1673:1: normalColumnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );";
		}
	}

	static final String DFA247_eotS =
		"\35\uffff";
	static final String DFA247_eofS =
		"\35\uffff";
	static final String DFA247_minS =
		"\1\32\31\u00de\1\6\2\uffff";
	static final String DFA247_maxS =
		"\1\u00c1\31\u00de\1\u00e5\2\uffff";
	static final String DFA247_acceptS =
		"\33\uffff\1\1\1\2";
	static final String DFA247_specialS =
		"\35\uffff}>";
	static final String[] DFA247_transitionS = {
			"\1\1\3\uffff\1\3\1\uffff\3\3\3\uffff\1\3\1\uffff\1\3\1\uffff\1\4\3\uffff"+
			"\1\5\1\6\1\7\1\uffff\1\3\1\31\3\3\1\uffff\2\3\1\31\1\10\1\uffff\2\3\1"+
			"\27\1\11\1\3\3\uffff\1\31\1\12\1\uffff\1\13\2\uffff\3\3\1\14\1\uffff"+
			"\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\15\2\3\1\uffff\1\16\1\3\2\uffff"+
			"\2\31\1\3\1\uffff\3\3\1\uffff\4\3\1\uffff\1\31\2\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\2\3\2\uffff\5\3\4\uffff\2\3\1\uffff\2\3\2\uffff\1\3\1\uffff"+
			"\1\3\1\17\5\3\1\20\1\30\1\21\1\26\1\22\2\uffff\1\3\1\uffff\1\31\3\3\1"+
			"\uffff\2\3\2\uffff\2\3\1\uffff\1\23\1\3\1\24\1\25\1\3\3\uffff\1\31\11"+
			"\uffff\1\2",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\32",
			"\1\33\4\uffff\1\33\10\uffff\1\33\3\uffff\1\33\2\uffff\1\33\2\uffff\1"+
			"\33\1\uffff\3\33\3\uffff\1\33\1\uffff\1\33\1\uffff\1\33\3\uffff\3\33"+
			"\1\uffff\5\33\1\uffff\4\33\1\uffff\5\33\3\uffff\2\33\1\uffff\1\33\2\uffff"+
			"\4\33\1\uffff\1\33\1\uffff\2\33\1\uffff\3\33\3\uffff\3\33\1\uffff\2\33"+
			"\2\uffff\3\33\1\uffff\3\33\1\uffff\4\33\1\uffff\3\33\1\uffff\3\33\1\uffff"+
			"\1\33\4\uffff\2\33\2\uffff\7\33\2\uffff\2\33\1\uffff\2\33\2\uffff\1\33"+
			"\1\uffff\14\33\2\uffff\1\33\1\uffff\4\33\1\uffff\2\33\2\uffff\2\33\1"+
			"\uffff\5\33\3\uffff\1\33\15\uffff\1\33\2\uffff\1\33\34\uffff\1\34",
			"",
			""
	};

	static final short[] DFA247_eot = DFA.unpackEncodedString(DFA247_eotS);
	static final short[] DFA247_eof = DFA.unpackEncodedString(DFA247_eofS);
	static final char[] DFA247_min = DFA.unpackEncodedStringToUnsignedChars(DFA247_minS);
	static final char[] DFA247_max = DFA.unpackEncodedStringToUnsignedChars(DFA247_maxS);
	static final short[] DFA247_accept = DFA.unpackEncodedString(DFA247_acceptS);
	static final short[] DFA247_special = DFA.unpackEncodedString(DFA247_specialS);
	static final short[][] DFA247_transition;

	static {
		int numStates = DFA247_transitionS.length;
		DFA247_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA247_transition[i] = DFA.unpackEncodedString(DFA247_transitionS[i]);
		}
	}

	protected class DFA247 extends DFA {

		public DFA247(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 247;
			this.eot = DFA247_eot;
			this.eof = DFA247_eof;
			this.min = DFA247_min;
			this.max = DFA247_max;
			this.accept = DFA247_accept;
			this.special = DFA247_special;
			this.transition = DFA247_transition;
		}
		@Override
		public String getDescription() {
			return "1754:1: property[PropertyDefinitions props] : (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= fullMapLiteral );";
		}
	}

	static final String DFA252_eotS =
		"\101\uffff";
	static final String DFA252_eofS =
		"\101\uffff";
	static final String DFA252_minS =
		"\1\21\32\71\1\uffff\1\21\3\uffff\1\u00c0\2\uffff\32\71\4\uffff";
	static final String DFA252_maxS =
		"\1\u00d1\32\u00e1\1\uffff\1\u00d1\3\uffff\1\u00da\2\uffff\32\u00e1\4\uffff";
	static final String DFA252_acceptS =
		"\33\uffff\1\4\1\uffff\1\1\1\2\1\3\1\uffff\1\7\1\10\32\uffff\1\12\1\5\1"+
		"\6\1\11";
	static final String DFA252_specialS =
		"\101\uffff}>";
	static final String[] DFA252_transitionS = {
			"\1\1\10\uffff\1\2\3\uffff\1\4\1\uffff\3\4\3\uffff\1\4\1\uffff\1\4\1\uffff"+
			"\1\5\3\uffff\1\6\1\7\1\10\1\uffff\1\4\1\32\3\4\1\uffff\2\4\1\32\1\11"+
			"\1\uffff\2\4\1\30\1\12\1\4\3\uffff\1\32\1\13\1\uffff\1\14\2\uffff\3\4"+
			"\1\15\1\uffff\1\4\1\uffff\2\4\1\uffff\3\4\3\uffff\1\16\2\4\1\uffff\1"+
			"\17\1\4\2\uffff\2\32\1\4\1\uffff\3\4\1\uffff\4\4\1\uffff\1\32\2\4\3\uffff"+
			"\1\4\1\uffff\1\4\4\uffff\2\4\2\uffff\5\4\4\uffff\2\4\1\uffff\2\4\2\uffff"+
			"\1\4\1\uffff\1\4\1\20\5\4\1\21\1\31\1\22\1\27\1\23\1\uffff\1\33\1\4\1"+
			"\uffff\1\32\3\4\1\uffff\2\4\2\uffff\2\4\1\uffff\1\24\1\4\1\25\1\26\1"+
			"\4\3\uffff\1\32\11\uffff\1\3\17\uffff\1\34",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"\1\41\37\uffff\1\40\10\uffff\1\37\6\uffff\1\36\145\uffff\1\35\14\uffff"+
			"\5\35\1\42",
			"",
			"\1\43\10\uffff\1\44\3\uffff\1\46\1\uffff\3\46\3\uffff\1\46\1\uffff\1"+
			"\46\1\uffff\1\47\3\uffff\1\50\1\51\1\52\1\uffff\1\46\1\74\3\46\1\uffff"+
			"\2\46\1\74\1\53\1\uffff\2\46\1\72\1\54\1\46\3\uffff\1\74\1\55\1\uffff"+
			"\1\56\2\uffff\3\46\1\57\1\uffff\1\46\1\uffff\2\46\1\uffff\3\46\3\uffff"+
			"\1\60\2\46\1\uffff\1\61\1\46\2\uffff\2\74\1\46\1\uffff\3\46\1\uffff\4"+
			"\46\1\uffff\1\74\2\46\3\uffff\1\46\1\uffff\1\46\4\uffff\2\46\2\uffff"+
			"\5\46\4\uffff\2\46\1\uffff\2\46\2\uffff\1\46\1\uffff\1\46\1\62\5\46\1"+
			"\63\1\73\1\64\1\71\1\65\1\uffff\1\75\1\46\1\uffff\1\74\3\46\1\uffff\2"+
			"\46\2\uffff\2\46\1\uffff\1\66\1\46\1\67\1\70\1\46\3\uffff\1\74\11\uffff"+
			"\1\45\17\uffff\1\75",
			"",
			"",
			"",
			"\1\76\20\uffff\1\77\10\uffff\1\76",
			"",
			"",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"\1\75\37\uffff\1\75\10\uffff\1\75\6\uffff\1\75\145\uffff\1\75\2\uffff"+
			"\1\100\2\uffff\1\100\6\uffff\6\75",
			"",
			"",
			"",
			""
	};

	static final short[] DFA252_eot = DFA.unpackEncodedString(DFA252_eotS);
	static final short[] DFA252_eof = DFA.unpackEncodedString(DFA252_eofS);
	static final char[] DFA252_min = DFA.unpackEncodedStringToUnsignedChars(DFA252_minS);
	static final char[] DFA252_max = DFA.unpackEncodedStringToUnsignedChars(DFA252_maxS);
	static final short[] DFA252_accept = DFA.unpackEncodedString(DFA252_acceptS);
	static final short[] DFA252_special = DFA.unpackEncodedString(DFA252_specialS);
	static final short[][] DFA252_transition;

	static {
		int numStates = DFA252_transitionS.length;
		DFA252_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA252_transition[i] = DFA.unpackEncodedString(DFA252_transitionS[i]);
		}
	}

	protected class DFA252 extends DFA {

		public DFA252(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 252;
			this.eot = DFA252_eot;
			this.eof = DFA252_eof;
			this.min = DFA252_min;
			this.max = DFA252_max;
			this.accept = DFA252_accept;
			this.special = DFA252_special;
			this.transition = DFA252_transition;
		}
		@Override
		public String getDescription() {
			return "1773:1: relation[WhereClause.Builder clauses] : (name= cident type= relationType t= term |name= cident K_LIKE t= term |name= cident K_IS K_NOT K_NULL | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident rt= containsOperator t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );";
		}
	}

	static final String DFA251_eotS =
		"\12\uffff";
	static final String DFA251_eofS =
		"\12\uffff";
	static final String DFA251_minS =
		"\1\131\1\uffff\6\u00c0\2\uffff";
	static final String DFA251_maxS =
		"\1\u00e0\1\uffff\6\u00da\2\uffff";
	static final String DFA251_acceptS =
		"\1\uffff\1\1\6\uffff\1\2\1\3";
	static final String DFA251_specialS =
		"\12\uffff}>";
	static final String[] DFA251_transitionS = {
			"\1\1\165\uffff\1\7\14\uffff\1\3\1\4\1\2\1\5\1\6",
			"",
			"\1\11\20\uffff\1\10\10\uffff\1\11",
			"\1\11\20\uffff\1\10\10\uffff\1\11",
			"\1\11\20\uffff\1\10\10\uffff\1\11",
			"\1\11\20\uffff\1\10\10\uffff\1\11",
			"\1\11\20\uffff\1\10\10\uffff\1\11",
			"\1\11\20\uffff\1\10\10\uffff\1\11",
			"",
			""
	};

	static final short[] DFA251_eot = DFA.unpackEncodedString(DFA251_eotS);
	static final short[] DFA251_eof = DFA.unpackEncodedString(DFA251_eofS);
	static final char[] DFA251_min = DFA.unpackEncodedStringToUnsignedChars(DFA251_minS);
	static final char[] DFA251_max = DFA.unpackEncodedStringToUnsignedChars(DFA251_maxS);
	static final short[] DFA251_accept = DFA.unpackEncodedString(DFA251_acceptS);
	static final short[] DFA251_special = DFA.unpackEncodedString(DFA251_specialS);
	static final short[][] DFA251_transition;

	static {
		int numStates = DFA251_transitionS.length;
		DFA251_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA251_transition[i] = DFA.unpackEncodedString(DFA251_transitionS[i]);
		}
	}

	protected class DFA251 extends DFA {

		public DFA251(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 251;
			this.eot = DFA251_eot;
			this.eof = DFA251_eof;
			this.min = DFA251_min;
			this.max = DFA251_max;
			this.accept = DFA251_accept;
			this.special = DFA251_special;
			this.transition = DFA251_transition;
		}
		@Override
		public String getDescription() {
			return "1786:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )";
		}
	}

	static final String DFA262_eotS =
		"\42\uffff";
	static final String DFA262_eofS =
		"\1\uffff\25\36\2\33\1\uffff\2\33\1\uffff\1\33\5\uffff";
	static final String DFA262_minS =
		"\1\32\27\115\1\uffff\2\115\1\uffff\1\115\5\uffff";
	static final String DFA262_maxS =
		"\1\u00c5\27\u00df\1\uffff\2\u00df\1\uffff\1\u00df\5\uffff";
	static final String DFA262_acceptS =
		"\30\uffff\1\2\2\uffff\1\5\1\uffff\1\7\1\1\1\3\1\4\1\6";
	static final String DFA262_specialS =
		"\42\uffff}>";
	static final String[] DFA262_transitionS = {
			"\1\33\3\uffff\1\33\1\uffff\3\33\3\uffff\1\33\1\uffff\1\33\1\uffff\1\1"+
			"\3\uffff\1\2\1\3\1\4\1\uffff\5\33\1\uffff\3\33\1\5\1\uffff\2\33\1\24"+
			"\1\6\1\33\3\uffff\1\33\1\7\1\uffff\1\10\2\uffff\3\33\1\11\1\uffff\1\34"+
			"\1\uffff\2\33\1\uffff\3\33\3\uffff\1\12\2\33\1\uffff\1\13\1\33\2\uffff"+
			"\3\33\1\uffff\3\33\1\uffff\1\27\1\33\1\26\1\33\1\uffff\3\33\3\uffff\1"+
			"\33\1\uffff\1\33\4\uffff\2\33\2\uffff\5\33\4\uffff\2\33\1\uffff\2\33"+
			"\2\uffff\1\33\1\30\1\33\1\14\5\33\1\15\1\25\1\16\1\23\1\17\2\uffff\1"+
			"\33\1\uffff\1\33\1\31\2\33\1\uffff\2\33\2\uffff\2\33\1\uffff\1\20\1\33"+
			"\1\21\1\22\1\32\3\uffff\1\33\11\uffff\1\33\3\uffff\1\35",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\36\16\uffff\1\36\13\uffff\1\36\5\uffff\1\36\31\uffff\1\36\14\uffff"+
			"\1\36\74\uffff\1\36\2\uffff\1\36\2\uffff\1\33\2\uffff\1\36\3\uffff\1"+
			"\36",
			"\1\33\16\uffff\1\33\13\uffff\1\33\5\uffff\1\33\31\uffff\1\33\14\uffff"+
			"\1\33\74\uffff\1\33\2\uffff\1\33\2\uffff\1\33\2\uffff\1\33\1\30\2\uffff"+
			"\1\33",
			"\1\33\16\uffff\1\33\13\uffff\1\33\5\uffff\1\33\31\uffff\1\33\14\uffff"+
			"\1\33\74\uffff\1\33\2\uffff\1\33\2\uffff\1\33\2\uffff\1\33\1\30\2\uffff"+
			"\1\33",
			"",
			"\1\33\16\uffff\1\33\13\uffff\1\33\5\uffff\1\33\31\uffff\1\33\14\uffff"+
			"\1\33\74\uffff\1\33\2\uffff\1\33\2\uffff\1\33\2\uffff\1\33\1\37\2\uffff"+
			"\1\33",
			"\1\33\16\uffff\1\33\13\uffff\1\33\5\uffff\1\33\31\uffff\1\33\14\uffff"+
			"\1\33\74\uffff\1\33\2\uffff\1\33\2\uffff\1\33\2\uffff\1\33\1\40\2\uffff"+
			"\1\33",
			"",
			"\1\33\16\uffff\1\33\13\uffff\1\33\5\uffff\1\33\31\uffff\1\33\14\uffff"+
			"\1\33\74\uffff\1\33\2\uffff\1\33\2\uffff\1\33\2\uffff\1\33\1\41\2\uffff"+
			"\1\33",
			"",
			"",
			"",
			"",
			""
	};

	static final short[] DFA262_eot = DFA.unpackEncodedString(DFA262_eotS);
	static final short[] DFA262_eof = DFA.unpackEncodedString(DFA262_eofS);
	static final char[] DFA262_min = DFA.unpackEncodedStringToUnsignedChars(DFA262_minS);
	static final char[] DFA262_max = DFA.unpackEncodedStringToUnsignedChars(DFA262_maxS);
	static final short[] DFA262_accept = DFA.unpackEncodedString(DFA262_acceptS);
	static final short[] DFA262_special = DFA.unpackEncodedString(DFA262_specialS);
	static final short[][] DFA262_transition;

	static {
		int numStates = DFA262_transitionS.length;
		DFA262_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA262_transition[i] = DFA.unpackEncodedString(DFA262_transitionS[i]);
		}
	}

	protected class DFA262 extends DFA {

		public DFA262(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 262;
			this.eot = DFA262_eot;
			this.eof = DFA262_eof;
			this.min = DFA262_min;
			this.max = DFA262_max;
			this.accept = DFA262_accept;
			this.special = DFA262_special;
			this.transition = DFA262_transition;
		}
		@Override
		public String getDescription() {
			return "1847:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |vc= vector_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );";
		}
	}

	public static final BitSet FOLLOW_selectStatement_in_cqlStatement59 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_cqlStatement88 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_cqlStatement117 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_batchStatement_in_cqlStatement146 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_cqlStatement176 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_useStatement_in_cqlStatement205 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_truncateStatement_in_cqlStatement237 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement264 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTableStatement_in_cqlStatement285 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement353 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement403 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement427 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantPermissionsStatement_in_cqlStatement448 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokePermissionsStatement_in_cqlStatement466 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement483 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createUserStatement_in_cqlStatement502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement577 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement602 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTypeStatement_in_cqlStatement646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTypeStatement_in_cqlStatement670 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTypeStatement_in_cqlStatement695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createFunctionStatement_in_cqlStatement721 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropFunctionStatement_in_cqlStatement741 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createAggregateStatement_in_cqlStatement763 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropAggregateStatement_in_cqlStatement782 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createRoleStatement_in_cqlStatement803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterRoleStatement_in_cqlStatement827 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropRoleStatement_in_cqlStatement852 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listRolesStatement_in_cqlStatement878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantRoleStatement_in_cqlStatement903 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokeRoleStatement_in_cqlStatement928 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createMaterializedViewStatement_in_cqlStatement952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropMaterializedViewStatement_in_cqlStatement964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterMaterializedViewStatement_in_cqlStatement978 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_describeStatement_in_cqlStatement991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_addIdentityStatement_in_cqlStatement1017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropIdentityStatement_in_cqlStatement1040 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USE_in_useStatement1075 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_useStatement1079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SELECT_in_selectStatement1113 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002604420123L});
	public static final BitSet FOLLOW_K_JSON_in_selectStatement1139 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002604420123L});
	public static final BitSet FOLLOW_selectClause_in_selectStatement1148 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_selectStatement1156 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_selectStatement1160 = new BitSet(new long[]{0x0000000800000002L,0x0000040000200000L,0x0020000000000009L});
	public static final BitSet FOLLOW_K_WHERE_in_selectStatement1170 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000001000020002L});
	public static final BitSet FOLLOW_whereClause_in_selectStatement1174 = new BitSet(new long[]{0x0000000800000002L,0x0000040000200000L,0x0000000000000009L});
	public static final BitSet FOLLOW_K_GROUP_in_selectStatement1187 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_K_BY_in_selectStatement1189 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_groupByClause_in_selectStatement1191 = new BitSet(new long[]{0x0000000800000002L,0x0000040000000000L,0x0000000000000009L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_selectStatement1196 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_groupByClause_in_selectStatement1198 = new BitSet(new long[]{0x0000000800000002L,0x0000040000000000L,0x0000000000000009L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_ORDER_in_selectStatement1215 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_K_BY_in_selectStatement1217 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement1219 = new BitSet(new long[]{0x0000000800000002L,0x0000040000000000L,0x0000000000000008L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_selectStatement1224 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement1226 = new BitSet(new long[]{0x0000000800000002L,0x0000040000000000L,0x0000000000000008L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_PER_in_selectStatement1243 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_K_PARTITION_in_selectStatement1245 = new BitSet(new long[]{0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_K_LIMIT_in_selectStatement1247 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_intValue_in_selectStatement1251 = new BitSet(new long[]{0x0000000800000002L,0x0000040000000000L});
	public static final BitSet FOLLOW_K_LIMIT_in_selectStatement1266 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_intValue_in_selectStatement1270 = new BitSet(new long[]{0x0000000800000002L});
	public static final BitSet FOLLOW_K_ALLOW_in_selectStatement1285 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_K_FILTERING_in_selectStatement1287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DISTINCT_in_selectClause1342 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002604420123L});
	public static final BitSet FOLLOW_selectors_in_selectClause1346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectors_in_selectClause1358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selector_in_selectors1383 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_selectors1388 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selector_in_selectors1392 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_226_in_selectors1404 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selector1437 = new BitSet(new long[]{0x0000010000000002L});
	public static final BitSet FOLLOW_K_AS_in_selector1440 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_selector1444 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionAddition_in_unaliasedSelector1473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionMultiplication_in_selectionAddition1500 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_211_in_selectionAddition1516 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selectionMultiplication_in_selectionAddition1520 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_214_in_selectionAddition1534 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selectionMultiplication_in_selectionAddition1538 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_selectionGroup_in_selectionMultiplication1576 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_226_in_selectionMultiplication1592 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selectionGroup_in_selectionMultiplication1596 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_217_in_selectionMultiplication1610 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selectionGroup_in_selectionMultiplication1614 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_208_in_selectionMultiplication1628 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selectionGroup_in_selectionMultiplication1632 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_selectionGroupWithField_in_selectionGroup1674 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionGroupWithoutField_in_selectionGroup1686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_214_in_selectionGroup1696 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_selectionGroup_in_selectionGroup1700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionGroupWithoutField_in_selectionGroupWithField1725 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000201000000L});
	public static final BitSet FOLLOW_selectorModifier_in_selectionGroupWithField1729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fieldSelectorModifier_in_selectorModifier1756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000201000000L});
	public static final BitSet FOLLOW_selectorModifier_in_selectorModifier1761 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_225_in_selectorModifier1772 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x000000220442012BL});
	public static final BitSet FOLLOW_collectionSubSelection_in_selectorModifier1776 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_227_in_selectorModifier1779 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000201000000L});
	public static final BitSet FOLLOW_selectorModifier_in_selectorModifier1783 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_216_in_fieldSelectorModifier1816 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_fieldSelectorModifier1820 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_collectionSubSelection1858 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_RANGE_in_collectionSubSelection1864 = new BitSet(new long[]{0xEF7DC5474D100842L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_collectionSubSelection1869 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RANGE_in_collectionSubSelection1884 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_collectionSubSelection1890 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simpleUnaliasedSelector_in_selectionGroupWithoutField1942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionTypeHint_in_selectionGroupWithoutField1960 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionTupleOrNestedSelector_in_selectionGroupWithoutField1972 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionList_in_selectionGroupWithoutField1984 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionMapOrSet_in_selectionGroupWithoutField1996 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_selectionTypeHint2024 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_selectionTypeHint2028 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_selectionTypeHint2030 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204020123L});
	public static final BitSet FOLLOW_selectionGroupWithoutField_in_selectionTypeHint2034 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_225_in_selectionList2075 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002A04420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionList2081 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800200000L});
	public static final BitSet FOLLOW_213_in_selectionList2087 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionList2091 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800200000L});
	public static final BitSet FOLLOW_227_in_selectionList2101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_229_in_selectionMapOrSet2122 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionMapOrSet2126 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004004200000L});
	public static final BitSet FOLLOW_selectionMap_in_selectionMapOrSet2132 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_selectionSet_in_selectionMapOrSet2141 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_230_in_selectionMapOrSet2147 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_229_in_selectionMapOrSet2155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_230_in_selectionMapOrSet2157 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_selectionMap2202 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionMap2206 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_selectionMap2214 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionMap2218 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_218_in_selectionMap2220 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionMap2224 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_selectionSet2276 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionSet2280 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_209_in_selectionTupleOrNestedSelector2326 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionTupleOrNestedSelector2330 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_selectionTupleOrNestedSelector2335 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionTupleOrNestedSelector2339 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_selectionTupleOrNestedSelector2346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sident_in_simpleUnaliasedSelector2371 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionLiteral_in_simpleUnaliasedSelector2417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionFunction_in_simpleUnaliasedSelector2453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNT_in_selectionFunction2499 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_selectionFunction2508 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_226_in_selectionFunction2510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_selectionFunction2512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MAXWRITETIME_in_selectionFunction2557 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_selectionFunction2559 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_sident_in_selectionFunction2563 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000201040000L});
	public static final BitSet FOLLOW_selectorModifier_in_selectionFunction2567 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_selectionFunction2570 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_WRITETIME_in_selectionFunction2589 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_selectionFunction2594 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_sident_in_selectionFunction2598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000201040000L});
	public static final BitSet FOLLOW_selectorModifier_in_selectionFunction2602 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_selectionFunction2605 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TTL_in_selectionFunction2624 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_selectionFunction2635 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_sident_in_selectionFunction2639 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000201040000L});
	public static final BitSet FOLLOW_selectorModifier_in_selectionFunction2643 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_selectionFunction2646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CAST_in_selectionFunction2665 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_selectionFunction2675 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunction2679 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_AS_in_selectionFunction2681 = new BitSet(new long[]{0x8801C40000000000L,0x0000000088004141L,0x000680007C100000L});
	public static final BitSet FOLLOW_native_type_in_selectionFunction2685 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_selectionFunction2687 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_selectionFunction2699 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_selectionFunctionArgs_in_selectionFunction2703 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_selectionLiteral2749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NULL_in_selectionLiteral2779 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_selectionLiteral2813 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_selectionLiteral2817 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_selectionLiteral2838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_selectionFunctionArgs2894 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204460123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs2899 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_selectionFunctionArgs2915 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs2919 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_selectionFunctionArgs2934 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_sident2957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_sident2982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_sident3001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationOrExpression_in_whereClause3032 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_whereClause3036 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000001000020002L});
	public static final BitSet FOLLOW_relationOrExpression_in_whereClause3038 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_relation_in_relationOrExpression3060 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_customIndexExpression_in_relationOrExpression3069 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_228_in_customIndexExpression3097 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_idxName_in_customIndexExpression3099 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_customIndexExpression3102 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_customIndexExpression3106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_customIndexExpression3108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_orderByClause3138 = new BitSet(new long[]{0x0000024000000002L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_ANN_in_orderByClause3141 = new BitSet(new long[]{0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_K_OF_in_orderByClause3143 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_orderByClause3147 = new BitSet(new long[]{0x0000020000000002L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_ASC_in_orderByClause3152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_orderByClause3156 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unaliasedSelector_in_groupByClause3186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INSERT_in_insertStatement3211 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_INTO_in_insertStatement3213 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_insertStatement3217 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_normalInsertStatement_in_insertStatement3231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_JSON_in_insertStatement3246 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000021L});
	public static final BitSet FOLLOW_jsonInsertStatement_in_insertStatement3250 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_normalInsertStatement3286 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalInsertStatement3290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_normalInsertStatement3297 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalInsertStatement3301 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_normalInsertStatement3308 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_VALUES_in_normalInsertStatement3316 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_normalInsertStatement3324 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_normalInsertStatement3328 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_normalInsertStatement3334 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_normalInsertStatement3338 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_normalInsertStatement3345 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_IF_in_normalInsertStatement3355 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_normalInsertStatement3357 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_normalInsertStatement3359 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_usingClause_in_normalInsertStatement3374 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_jsonValue_in_jsonInsertStatement3420 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000002L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_DEFAULT_in_jsonInsertStatement3430 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_NULL_in_jsonInsertStatement3434 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_UNSET_in_jsonInsertStatement3442 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_IF_in_jsonInsertStatement3458 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_jsonInsertStatement3460 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_jsonInsertStatement3462 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_usingClause_in_jsonInsertStatement3477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_jsonValue3512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_jsonValue3522 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_jsonValue3526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_jsonValue3540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClause3571 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000810000000L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause3573 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_usingClause3578 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000810000000L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause3580 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseObjective3602 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective3606 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective3616 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective3620 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UPDATE_in_updateStatement3654 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_updateStatement3658 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000040000L});
	public static final BitSet FOLLOW_usingClause_in_updateStatement3668 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_SET_in_updateStatement3680 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement3682 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_updateStatement3686 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement3688 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_WHERE_in_updateStatement3699 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000001000020002L});
	public static final BitSet FOLLOW_whereClause_in_updateStatement3703 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L});
	public static final BitSet FOLLOW_K_IF_in_updateStatement3713 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_EXISTS_in_updateStatement3717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_updateStatement3725 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions3767 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_updateConditions3772 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions3774 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_DELETE_in_deleteStatement3811 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8EDF963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_deleteSelection_in_deleteStatement3817 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_deleteStatement3830 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement3834 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020400000000000L});
	public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement3844 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_K_WHERE_in_deleteStatement3856 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000001000020002L});
	public static final BitSet FOLLOW_whereClause_in_deleteStatement3860 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L});
	public static final BitSet FOLLOW_K_IF_in_deleteStatement3870 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_EXISTS_in_deleteStatement3874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_deleteStatement3882 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection3929 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_deleteSelection3944 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection3948 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_cident_in_deleteOp3975 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_deleteOp4002 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_225_in_deleteOp4004 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_deleteOp4008 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_227_in_deleteOp4010 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_deleteOp4022 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_216_in_deleteOp4024 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_deleteOp4028 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClauseDelete4048 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDelete4050 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_intValue_in_usingClauseDelete4054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BEGIN_in_batchStatement4088 = new BitSet(new long[]{0x0800100000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement4098 = new BitSet(new long[]{0x0000100000000000L});
	public static final BitSet FOLLOW_K_COUNTER_in_batchStatement4104 = new BitSet(new long[]{0x0000100000000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement4117 = new BitSet(new long[]{0x0000008000000000L,0x0000000040000004L,0x0000440000000000L});
	public static final BitSet FOLLOW_usingClause_in_batchStatement4121 = new BitSet(new long[]{0x0000008000000000L,0x0000000040000004L,0x0000040000000000L});
	public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement4141 = new BitSet(new long[]{0x0000008000000000L,0x0000000040000004L,0x0000040000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_219_in_batchStatement4143 = new BitSet(new long[]{0x0000008000000000L,0x0000000040000004L,0x0000040000000000L});
	public static final BitSet FOLLOW_K_APPLY_in_batchStatement4157 = new BitSet(new long[]{0x0000100000000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement4159 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective4190 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective4203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective4216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createAggregateStatement4249 = new BitSet(new long[]{0x0000000100000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_OR_in_createAggregateStatement4252 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_K_REPLACE_in_createAggregateStatement4254 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_createAggregateStatement4266 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_createAggregateStatement4275 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createAggregateStatement4277 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createAggregateStatement4279 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_createAggregateStatement4293 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_createAggregateStatement4301 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000040022L});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement4325 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_createAggregateStatement4341 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement4345 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_createAggregateStatement4369 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_SFUNC_in_createAggregateStatement4377 = new BitSet(new long[]{0xEF75C54744000000L,0x61467BA1B8ED7943L,0x000FB3737FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_allowedFunctionName_in_createAggregateStatement4383 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_K_STYPE_in_createAggregateStatement4391 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement4397 = new BitSet(new long[]{0x0000000000000002L,0x0000000010002000L});
	public static final BitSet FOLLOW_K_FINALFUNC_in_createAggregateStatement4415 = new BitSet(new long[]{0xEF75C54744000000L,0x61467BA1B8ED7943L,0x000FB3737FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_allowedFunctionName_in_createAggregateStatement4421 = new BitSet(new long[]{0x0000000000000002L,0x0000000010000000L});
	public static final BitSet FOLLOW_K_INITCOND_in_createAggregateStatement4448 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_createAggregateStatement4454 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropAggregateStatement4501 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_dropAggregateStatement4503 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_dropAggregateStatement4512 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropAggregateStatement4514 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_dropAggregateStatement4529 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_dropAggregateStatement4547 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000040022L});
	public static final BitSet FOLLOW_comparatorType_in_dropAggregateStatement4575 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_dropAggregateStatement4593 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_dropAggregateStatement4597 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_dropAggregateStatement4625 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createFunctionStatement4682 = new BitSet(new long[]{0x0000000000000000L,0x8000000000040000L});
	public static final BitSet FOLLOW_K_OR_in_createFunctionStatement4685 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_K_REPLACE_in_createFunctionStatement4687 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_FUNCTION_in_createFunctionStatement4699 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_createFunctionStatement4708 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createFunctionStatement4710 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createFunctionStatement4712 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_createFunctionStatement4726 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_createFunctionStatement4734 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000040002L});
	public static final BitSet FOLLOW_noncol_ident_in_createFunctionStatement4758 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement4762 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_createFunctionStatement4778 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_createFunctionStatement4782 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement4786 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_createFunctionStatement4810 = new BitSet(new long[]{0x0004000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_RETURNS_in_createFunctionStatement4821 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_K_NULL_in_createFunctionStatement4823 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_CALLED_in_createFunctionStatement4829 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_ON_in_createFunctionStatement4835 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_K_NULL_in_createFunctionStatement4837 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_K_INPUT_in_createFunctionStatement4839 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_RETURNS_in_createFunctionStatement4847 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement4853 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_K_LANGUAGE_in_createFunctionStatement4861 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_IDENT_in_createFunctionStatement4867 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_AS_in_createFunctionStatement4875 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createFunctionStatement4881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropFunctionStatement4919 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_FUNCTION_in_dropFunctionStatement4921 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_dropFunctionStatement4930 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropFunctionStatement4932 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_dropFunctionStatement4947 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_dropFunctionStatement4965 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000040022L});
	public static final BitSet FOLLOW_comparatorType_in_dropFunctionStatement4993 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_dropFunctionStatement5011 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_dropFunctionStatement5015 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_dropFunctionStatement5043 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement5102 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement5104 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement5107 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement5109 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement5111 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement5120 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement5128 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_properties_in_createKeyspaceStatement5130 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTableStatement5165 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement5167 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_createTableStatement5170 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTableStatement5172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement5174 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement5189 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_tableDefinition_in_createTableStatement5199 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_tableDefinition5218 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6D3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_tableColumns_in_tableDefinition5220 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tableDefinition5225 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6D3EL,0x0000000000240002L});
	public static final BitSet FOLLOW_tableColumns_in_tableDefinition5227 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tableDefinition5234 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_tableDefinition5244 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_tableProperty_in_tableDefinition5246 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_tableDefinition5251 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_tableProperty_in_tableDefinition5253 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_ident_in_tableColumns5288 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_tableColumns5292 = new BitSet(new long[]{0x0000000000000002L,0x0000400000000000L,0x0000000000200100L});
	public static final BitSet FOLLOW_K_STATIC_in_tableColumns5295 = new BitSet(new long[]{0x0000000000000002L,0x0000400000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_columnMask_in_tableColumns5304 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_PRIMARY_in_tableColumns5319 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_KEY_in_tableColumns5321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PRIMARY_in_tableColumns5333 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_KEY_in_tableColumns5335 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_tableColumns5337 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_tablePartitionKey_in_tableColumns5339 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tableColumns5343 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_tableColumns5347 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tableColumns5354 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MASKED_in_columnMask5384 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_columnMask5386 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_columnMask5390 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_columnMaskArguments_in_columnMask5392 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MASKED_in_columnMask5403 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_columnMask5405 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_K_DEFAULT_in_columnMask5407 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_columnMaskArguments5427 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_columnMaskArguments5430 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_columnMaskArguments5434 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnMaskArguments5438 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_columnMaskArguments5443 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnMaskArguments5447 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_columnMaskArguments5453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_tablePartitionKey5490 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_tablePartitionKey5500 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_tablePartitionKey5504 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tablePartitionKey5510 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_tablePartitionKey5514 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tablePartitionKey5521 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_tableProperty5539 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COMPACT_in_tableProperty5548 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_STORAGE_in_tableProperty5550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTERING_in_tableProperty5560 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_ORDER_in_tableProperty5562 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_K_BY_in_tableProperty5564 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_tableProperty5566 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_tableClusteringOrder_in_tableProperty5568 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tableProperty5572 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_tableClusteringOrder_in_tableProperty5574 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tableProperty5579 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_tableClusteringOrder5607 = new BitSet(new long[]{0x0000020000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_ASC_in_tableClusteringOrder5610 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_tableClusteringOrder5614 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTypeStatement5652 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_createTypeStatement5654 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_createTypeStatement5657 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTypeStatement5659 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTypeStatement5661 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_createTypeStatement5679 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_createTypeStatement5692 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement5694 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_createTypeStatement5699 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000240002L});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement5701 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_createTypeStatement5708 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_typeColumns5728 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_typeColumns5732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement5766 = new BitSet(new long[]{0x2000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement5769 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement5775 = new BitSet(new long[]{0xEF7DC54744000000L,0x71477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_createIndexStatement5778 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createIndexStatement5780 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement5782 = new BitSet(new long[]{0xEF7DC54744000000L,0x71477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_idxName_in_createIndexStatement5798 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_ON_in_createIndexStatement5803 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement5807 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_createIndexStatement5809 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8EF7B63L,0x008FB37A7FFA6C3EL,0x0000000000040002L});
	public static final BitSet FOLLOW_indexIdent_in_createIndexStatement5812 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_createIndexStatement5816 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8EF7B63L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_indexIdent_in_createIndexStatement5818 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_createIndexStatement5825 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040400000000000L});
	public static final BitSet FOLLOW_K_USING_in_createIndexStatement5836 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement5840 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createIndexStatement5855 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_properties_in_createIndexStatement5857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent5889 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VALUES_in_indexIdent5917 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_indexIdent5919 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent5923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_indexIdent5925 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYS_in_indexIdent5936 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_indexIdent5938 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent5942 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_indexIdent5944 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ENTRIES_in_indexIdent5957 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_indexIdent5959 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent5963 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_indexIdent5965 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FULL_in_indexIdent5975 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_indexIdent5977 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent5981 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_indexIdent5983 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createMaterializedViewStatement6020 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_createMaterializedViewStatement6022 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_VIEW_in_createMaterializedViewStatement6024 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_createMaterializedViewStatement6027 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createMaterializedViewStatement6029 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createMaterializedViewStatement6031 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_createMaterializedViewStatement6039 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_AS_in_createMaterializedViewStatement6041 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_SELECT_in_createMaterializedViewStatement6051 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002604420123L});
	public static final BitSet FOLLOW_selectors_in_createMaterializedViewStatement6055 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_createMaterializedViewStatement6057 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_createMaterializedViewStatement6061 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000100L});
	public static final BitSet FOLLOW_K_WHERE_in_createMaterializedViewStatement6072 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000001000020002L});
	public static final BitSet FOLLOW_whereClause_in_createMaterializedViewStatement6076 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_viewPrimaryKey_in_createMaterializedViewStatement6098 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createMaterializedViewStatement6111 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_viewProperty_in_createMaterializedViewStatement6113 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_createMaterializedViewStatement6118 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_viewProperty_in_createMaterializedViewStatement6120 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_PRIMARY_in_viewPrimaryKey6144 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_KEY_in_viewPrimaryKey6146 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_viewPrimaryKey6148 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_viewPartitionKey_in_viewPrimaryKey6150 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_viewPrimaryKey6154 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_viewPrimaryKey6158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_viewPrimaryKey6165 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_viewPartitionKey6202 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_viewPartitionKey6212 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_viewPartitionKey6216 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_viewPartitionKey6222 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_viewPartitionKey6226 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_viewPartitionKey6233 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_viewProperty6251 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COMPACT_in_viewProperty6260 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_STORAGE_in_viewProperty6262 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTERING_in_viewProperty6272 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_ORDER_in_viewProperty6274 = new BitSet(new long[]{0x0002000000000000L});
	public static final BitSet FOLLOW_K_BY_in_viewProperty6276 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_viewProperty6278 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_viewClusteringOrder_in_viewProperty6280 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_viewProperty6284 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_viewClusteringOrder_in_viewProperty6286 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_viewProperty6291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_viewClusteringOrder6319 = new BitSet(new long[]{0x0000020000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_ASC_in_viewClusteringOrder6322 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_viewClusteringOrder6326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement6364 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement6366 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_createTriggerStatement6369 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTriggerStatement6371 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTriggerStatement6373 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_createTriggerStatement6383 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_ON_in_createTriggerStatement6394 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement6398 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_USING_in_createTriggerStatement6400 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement6404 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement6445 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement6447 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_dropTriggerStatement6450 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTriggerStatement6452 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_dropTriggerStatement6462 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement6465 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement6469 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement6509 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement6511 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_alterKeyspaceStatement6514 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterKeyspaceStatement6516 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement6525 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement6535 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement6537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement6572 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement6574 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_alterTableStatement6577 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTableStatement6579 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement6594 = new BitSet(new long[]{0x0000001080000000L,0x0000000000000080L,0x0040000000000200L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement6614 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement6618 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement6620 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement6624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement6637 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_alterTableStatement6641 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTableStatement6643 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement6652 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000080L});
	public static final BitSet FOLLOW_columnMask_in_alterTableStatement6672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement6692 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_MASKED_in_alterTableStatement6694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTableStatement6709 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_K_IF_in_alterTableStatement6713 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_alterTableStatement6715 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTableStatement6717 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement6749 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement6754 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_isStaticColumn_in_alterTableStatement6759 = new BitSet(new long[]{0x0000000000000002L,0x0000400000000000L});
	public static final BitSet FOLLOW_columnMask_in_alterTableStatement6764 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_alterTableStatement6788 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement6793 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement6797 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L,0x0000000000200000L,0x0000000000240000L});
	public static final BitSet FOLLOW_isStaticColumn_in_alterTableStatement6801 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_columnMask_in_alterTableStatement6806 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_alterTableStatement6831 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement6835 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement6839 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L,0x0000000000200000L,0x0000000000240000L});
	public static final BitSet FOLLOW_isStaticColumn_in_alterTableStatement6843 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_columnMask_in_alterTableStatement6848 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_alterTableStatement6857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement6871 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_K_IF_in_alterTableStatement6875 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTableStatement6877 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement6909 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_209_in_alterTableStatement6931 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement6936 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_alterTableStatement6959 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement6963 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_alterTableStatement6970 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_USING_in_alterTableStatement6992 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_alterTableStatement6994 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_INTEGER_in_alterTableStatement6998 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement7014 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_alterTableStatement7018 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTableStatement7020 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement7053 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement7055 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement7059 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTableStatement7081 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement7085 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement7087 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_alterTableStatement7091 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement7109 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_K_COMPACT_in_alterTableStatement7111 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_STORAGE_in_alterTableStatement7113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_WITH_in_alterTableStatement7126 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_properties_in_alterTableStatement7128 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_STATIC_in_isStaticColumn7170 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterMaterializedViewStatement7206 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_alterMaterializedViewStatement7208 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_VIEW_in_alterMaterializedViewStatement7210 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_alterMaterializedViewStatement7213 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterMaterializedViewStatement7215 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_alterMaterializedViewStatement7224 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_alterMaterializedViewStatement7236 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_properties_in_alterMaterializedViewStatement7238 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement7278 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement7280 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_alterTypeStatement7283 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTypeStatement7285 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_alterTypeStatement7294 = new BitSet(new long[]{0x0000001080000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement7314 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_alterTypeStatement7320 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement7322 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement7326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTypeStatement7339 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_alterTypeStatement7342 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_alterTypeStatement7344 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTypeStatement7346 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_alterTypeStatement7359 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement7363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTypeStatement7383 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_alterTypeStatement7386 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterTypeStatement7388 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_alterTypeStatement7397 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement7399 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_alterTypeStatement7403 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTypeStatement7425 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_alterTypeStatement7429 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement7431 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_alterTypeStatement7435 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement7487 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement7489 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement7492 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement7494 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement7503 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTableStatement7537 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement7539 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_dropTableStatement7542 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement7544 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement7553 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTypeStatement7587 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_dropTypeStatement7589 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_dropTypeStatement7592 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTypeStatement7594 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_dropTypeStatement7603 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement7637 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement7639 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_dropIndexStatement7642 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement7644 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_indexName_in_dropIndexStatement7653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropMaterializedViewStatement7693 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_dropMaterializedViewStatement7695 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_VIEW_in_dropMaterializedViewStatement7697 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_IF_in_dropMaterializedViewStatement7700 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropMaterializedViewStatement7702 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropMaterializedViewStatement7711 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement7742 = new BitSet(new long[]{0xEFFDC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_truncateStatement7745 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement7751 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantPermissionsStatement7776 = new BitSet(new long[]{0x1000081400000000L,0x0008000000000490L,0x0000010000030000L});
	public static final BitSet FOLLOW_permissionOrAll_in_grantPermissionsStatement7788 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_ON_in_grantPermissionsStatement7796 = new BitSet(new long[]{0xEFFDC54744000000L,0x61477BF9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_resource_in_grantPermissionsStatement7808 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_grantPermissionsStatement7816 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_grantPermissionsStatement7830 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokePermissionsStatement7861 = new BitSet(new long[]{0x1000081400000000L,0x0008000000000490L,0x0000010000030000L});
	public static final BitSet FOLLOW_permissionOrAll_in_revokePermissionsStatement7873 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_ON_in_revokePermissionsStatement7881 = new BitSet(new long[]{0xEFFDC54744000000L,0x61477BF9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_resource_in_revokePermissionsStatement7893 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_revokePermissionsStatement7901 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_revokePermissionsStatement7915 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantRoleStatement7946 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_grantRoleStatement7960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_grantRoleStatement7968 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_grantRoleStatement7982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokeRoleStatement8013 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_revokeRoleStatement8027 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_revokeRoleStatement8035 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_revokeRoleStatement8049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement8087 = new BitSet(new long[]{0x1000081400000000L,0x0008000000000490L,0x0000010000030000L});
	public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement8099 = new BitSet(new long[]{0x0000000000000002L,0x1880000000000000L});
	public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement8109 = new BitSet(new long[]{0xEFFDC54744000000L,0x61477BF9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_resource_in_listPermissionsStatement8111 = new BitSet(new long[]{0x0000000000000002L,0x0880000000000000L});
	public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement8126 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_roleName_in_listPermissionsStatement8128 = new BitSet(new long[]{0x0000000000000002L,0x0080000000000000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement8142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_permission8178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_permissionOrAll8243 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll8247 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_permission_in_permissionOrAll8268 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll8272 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_permissionOrAll8281 = new BitSet(new long[]{0x1000081000000000L,0x0008000000000490L,0x0000010000030000L});
	public static final BitSet FOLLOW_permission_in_permissionOrAll8285 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000010L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll8289 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_dataResource_in_resource8320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleResource_in_resource8332 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionResource_in_resource8344 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_jmxResource_in_resource8356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_dataResource8379 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource8381 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource8391 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_dataResource8397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource8409 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_dataResource8418 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_dataResource8428 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_K_TABLES_in_dataResource8430 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_K_IN_in_dataResource8432 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource8434 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_dataResource8440 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_jmxResource8463 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_K_MBEANS_in_jmxResource8465 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MBEAN_in_jmxResource8485 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_mbean_in_jmxResource8487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MBEANS_in_jmxResource8497 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_mbean_in_jmxResource8499 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_roleResource8522 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_K_ROLES_in_roleResource8524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ROLE_in_roleResource8534 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_roleResource8540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_functionResource8572 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_functionResource8574 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_functionResource8584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_functionResource8586 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_K_IN_in_functionResource8588 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_functionResource8590 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_functionResource8596 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FUNCTION_in_functionResource8611 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_functionResource8615 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_functionResource8633 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000040022L});
	public static final BitSet FOLLOW_comparatorType_in_functionResource8661 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_functionResource8679 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_functionResource8683 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_functionResource8711 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createUserStatement8759 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_USER_in_createUserStatement8761 = new BitSet(new long[]{0x0000000004000000L,0x0000000001000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_K_IF_in_createUserStatement8764 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createUserStatement8766 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createUserStatement8768 = new BitSet(new long[]{0x0000000004000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_username_in_createUserStatement8776 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L,0x0040000001000000L});
	public static final BitSet FOLLOW_K_WITH_in_createUserStatement8788 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000000004L});
	public static final BitSet FOLLOW_userPassword_in_createUserStatement8790 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement8804 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement8810 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement8855 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_USER_in_alterUserStatement8857 = new BitSet(new long[]{0x0000000004000000L,0x0000000001000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_K_IF_in_alterUserStatement8860 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterUserStatement8862 = new BitSet(new long[]{0x0000000004000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_username_in_alterUserStatement8870 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L,0x0040000001000000L});
	public static final BitSet FOLLOW_K_WITH_in_alterUserStatement8882 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L,0x0000000000000004L});
	public static final BitSet FOLLOW_userPassword_in_alterUserStatement8884 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement8898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement8912 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropUserStatement8958 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_USER_in_dropUserStatement8960 = new BitSet(new long[]{0x0000000004000000L,0x0000000001000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_K_IF_in_dropUserStatement8963 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropUserStatement8965 = new BitSet(new long[]{0x0000000004000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_username_in_dropUserStatement8973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_addIdentityStatement9006 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_K_IDENTITY_in_addIdentityStatement9008 = new BitSet(new long[]{0x0000000004000000L,0x0000000001000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_K_IF_in_addIdentityStatement9011 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_addIdentityStatement9013 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_addIdentityStatement9015 = new BitSet(new long[]{0x0000000004000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_identity_in_addIdentityStatement9023 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_addIdentityStatement9027 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_ROLE_in_addIdentityStatement9029 = new BitSet(new long[]{0x0000000004000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_identity_in_addIdentityStatement9033 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropIdentityStatement9072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_K_IDENTITY_in_dropIdentityStatement9074 = new BitSet(new long[]{0x0000000004000000L,0x0000000001000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_K_IF_in_dropIdentityStatement9077 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropIdentityStatement9079 = new BitSet(new long[]{0x0000000004000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000022L});
	public static final BitSet FOLLOW_identity_in_dropIdentityStatement9087 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listUsersStatement9114 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_USERS_in_listUsersStatement9116 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createRoleStatement9150 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_ROLE_in_createRoleStatement9152 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_K_IF_in_createRoleStatement9155 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_createRoleStatement9157 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_createRoleStatement9159 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_createRoleStatement9167 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createRoleStatement9177 = new BitSet(new long[]{0x0000000040000000L,0x4000100000400000L,0x0000000001000004L});
	public static final BitSet FOLLOW_roleOptions_in_createRoleStatement9179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterRoleStatement9223 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_ROLE_in_alterRoleStatement9225 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_K_IF_in_alterRoleStatement9228 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_alterRoleStatement9230 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_alterRoleStatement9238 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_alterRoleStatement9248 = new BitSet(new long[]{0x0000000040000000L,0x4000100000400000L,0x0000000001000004L});
	public static final BitSet FOLLOW_roleOptions_in_alterRoleStatement9250 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropRoleStatement9294 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_ROLE_in_dropRoleStatement9296 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B9ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_K_IF_in_dropRoleStatement9299 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropRoleStatement9301 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_userOrRoleName_in_dropRoleStatement9309 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listRolesStatement9349 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_K_ROLES_in_listRolesStatement9351 = new BitSet(new long[]{0x0000000000000002L,0x0880000000000000L});
	public static final BitSet FOLLOW_K_OF_in_listRolesStatement9361 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000023L});
	public static final BitSet FOLLOW_roleName_in_listRolesStatement9363 = new BitSet(new long[]{0x0000000000000002L,0x0080000000000000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listRolesStatement9376 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleOption_in_roleOptions9407 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_roleOptions9411 = new BitSet(new long[]{0x0000000040000000L,0x4000100000400000L,0x0000000001000004L});
	public static final BitSet FOLLOW_roleOption_in_roleOptions9413 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_roleOption9435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_roleOption9437 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_roleOption9441 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_HASHED_in_roleOption9452 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_K_PASSWORD_in_roleOption9454 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_roleOption9456 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_roleOption9460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_OPTIONS_in_roleOption9471 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_roleOption9473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_fullMapLiteral_in_roleOption9477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_roleOption9488 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_roleOption9490 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_BOOLEAN_in_roleOption9494 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LOGIN_in_roleOption9505 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_roleOption9507 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_BOOLEAN_in_roleOption9511 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ACCESS_in_roleOption9522 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_roleOption9524 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_ALL_in_roleOption9526 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_K_DATACENTERS_in_roleOption9528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ACCESS_in_roleOption9539 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_TO_in_roleOption9541 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_K_DATACENTERS_in_roleOption9543 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_229_in_roleOption9545 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_dcPermission_in_roleOption9547 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_213_in_roleOption9551 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_dcPermission_in_roleOption9553 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_230_in_roleOption9558 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ACCESS_in_roleOption9567 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_roleOption9569 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_ALL_in_roleOption9571 = new BitSet(new long[]{0x0010000000000000L});
	public static final BitSet FOLLOW_K_CIDRS_in_roleOption9573 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ACCESS_in_roleOption9584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_FROM_in_roleOption9586 = new BitSet(new long[]{0x0010000000000000L});
	public static final BitSet FOLLOW_K_CIDRS_in_roleOption9588 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_229_in_roleOption9590 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_cidrPermission_in_roleOption9592 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_213_in_roleOption9596 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_cidrPermission_in_roleOption9598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_230_in_roleOption9603 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_dcPermission9623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_cidrPermission9645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_userPassword9667 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_userPassword9671 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_HASHED_in_userPassword9682 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_K_PASSWORD_in_userPassword9684 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_userPassword9688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_describeStatement9722 = new BitSet(new long[]{0xEFFDC54744000000L,0x6147FBF9BCEF7963L,0x008FB37A7FFAEC3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTER_in_describeStatement9743 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_FULL_in_describeStatement9774 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_SCHEMA_in_describeStatement9780 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_describeStatement9799 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_ONLY_in_describeStatement9826 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_describeStatement9832 = new BitSet(new long[]{0xEF7DC54744000002L,0x61477BB9B8ED7963L,0x00CFB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_keyspaceName_in_describeStatement9838 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_TABLES_in_describeStatement9907 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_describeStatement9938 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_describeStatement9942 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_INDEX_in_describeStatement9961 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_describeStatement9965 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_describeStatement9990 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_VIEW_in_describeStatement9992 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_columnFamilyName_in_describeStatement9996 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_TYPES_in_describeStatement10012 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_describeStatement10045 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_describeStatement10049 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_describeStatement10086 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_FUNCTION_in_describeStatement10111 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_describeStatement10115 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_AGGREGATES_in_describeStatement10148 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_describeStatement10171 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_functionName_in_describeStatement10175 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_IDENT_in_describeStatement10207 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_describeStatement10247 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_unreserved_keyword_in_describeStatement10281 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_216_in_describeStatement10296 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_describeStatement10313 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_describeStatement10354 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_unreserved_keyword_in_describeStatement10389 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_describeStatement10473 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_K_INTERNALS_in_describeStatement10475 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EMPTY_QUOTED_NAME_in_cident10506 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_cident10521 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ident10559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ident10584 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ident10603 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_fident10628 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_fident10653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_fident10672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_noncol_ident10698 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_noncol_ident10723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_noncol_ident10742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_keyspaceName10775 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_indexName10809 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_216_in_indexName10812 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_idxName_in_indexName10816 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_columnFamilyName10848 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_216_in_columnFamilyName10851 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000003L});
	public static final BitSet FOLLOW_cfName_in_columnFamilyName10855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_userTypeName10880 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_216_in_userTypeName10882 = new BitSet(new long[]{0x6374014744000000L,0x61467BB130ED3802L,0x0009337203EA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_non_type_ident_in_userTypeName10888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleName_in_userOrRoleName10920 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ksName10943 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ksName10968 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ksName10987 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_ksName10997 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cfName11019 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cfName11044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cfName11063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_cfName11073 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_idxName11095 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_idxName11120 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_idxName11139 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_idxName11149 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_roleName11171 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_roleName11196 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_roleName11212 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_roleName11231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_roleName11241 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_constant11266 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_constant11278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_constant11297 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOOLEAN_in_constant11318 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DURATION_in_constant11337 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UUID_in_constant11355 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEXNUMBER_in_constant11377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_constant11393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_POSITIVE_INFINITY_in_constant11413 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NEGATIVE_INFINITY_in_constant11428 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_229_in_fullMapLiteral11469 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000006204420123L});
	public static final BitSet FOLLOW_term_in_fullMapLiteral11475 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_218_in_fullMapLiteral11477 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_fullMapLiteral11481 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_213_in_fullMapLiteral11487 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_fullMapLiteral11491 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_218_in_fullMapLiteral11493 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_fullMapLiteral11497 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_230_in_fullMapLiteral11513 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_mapLiteral_in_setOrMapLiteral11537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setLiteral_in_setOrMapLiteral11550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_213_in_setLiteral11595 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_setLiteral11599 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_218_in_mapLiteral11644 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_mapLiteral11648 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_mapLiteral11654 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_mapLiteral11658 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_218_in_mapLiteral11660 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_mapLiteral11664 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_listLiteral_in_collectionLiteral11692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_229_in_collectionLiteral11702 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_collectionLiteral11706 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004200000L});
	public static final BitSet FOLLOW_setOrMapLiteral_in_collectionLiteral11710 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_230_in_collectionLiteral11715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_229_in_collectionLiteral11733 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_230_in_collectionLiteral11735 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_225_in_listLiteral11776 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002A04420123L});
	public static final BitSet FOLLOW_term_in_listLiteral11782 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800200000L});
	public static final BitSet FOLLOW_213_in_listLiteral11788 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_listLiteral11792 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800200000L});
	public static final BitSet FOLLOW_227_in_listLiteral11802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_229_in_usertypeLiteral11846 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_usertypeLiteral11850 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_218_in_usertypeLiteral11852 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_usertypeLiteral11856 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_213_in_usertypeLiteral11862 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_usertypeLiteral11866 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_218_in_usertypeLiteral11868 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_usertypeLiteral11872 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000004000200000L});
	public static final BitSet FOLLOW_230_in_usertypeLiteral11879 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_tupleLiteral11916 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_tupleLiteral11920 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tupleLiteral11926 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_tupleLiteral11930 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tupleLiteral11937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_value11960 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionLiteral_in_value11982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_usertypeLiteral_in_value11995 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleLiteral_in_value12010 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NULL_in_value12026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_value12050 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_value12054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_value12065 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_intValue12105 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_intValue12119 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_intValue12123 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_intValue12134 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_keyspaceName_in_functionName12180 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_216_in_functionName12182 = new BitSet(new long[]{0xEF75C54744000000L,0x61467BA1B8ED7943L,0x000FB3737FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_allowedFunctionName_in_functionName12188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_allowedFunctionName12215 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_allowedFunctionName12249 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_allowedFunctionName12277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_allowedFunctionName12287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNT_in_allowedFunctionName12319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function12366 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_function12368 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_function12370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function12400 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_function12402 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_functionArgs_in_function12406 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_function12408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_functionArgs12441 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_functionArgs12447 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_functionArgs12451 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_termAddition_in_term12479 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_termMultiplication_in_termAddition12531 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_211_in_termAddition12547 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_termMultiplication_in_termAddition12551 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_214_in_termAddition12565 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_termMultiplication_in_termAddition12569 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_termGroup_in_termMultiplication12607 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_226_in_termMultiplication12623 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_termGroup_in_termMultiplication12627 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_217_in_termMultiplication12641 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_termGroup_in_termMultiplication12645 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_208_in_termMultiplication12659 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_termGroup_in_termMultiplication12663 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000402010000L});
	public static final BitSet FOLLOW_simpleTerm_in_termGroup12699 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_214_in_termGroup12722 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204020123L});
	public static final BitSet FOLLOW_simpleTerm_in_termGroup12727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_in_simpleTerm12760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_function_in_simpleTerm12811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_simpleTerm12857 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_simpleTerm12861 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_simpleTerm12863 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204020123L});
	public static final BitSet FOLLOW_simpleTerm_in_simpleTerm12867 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CAST_in_simpleTerm12886 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_209_in_simpleTerm12888 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204020123L});
	public static final BitSet FOLLOW_simpleTerm_in_simpleTerm12892 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_AS_in_simpleTerm12894 = new BitSet(new long[]{0x8801C40000000000L,0x0000000088004141L,0x000680007C100000L});
	public static final BitSet FOLLOW_native_type_in_simpleTerm12898 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_simpleTerm12900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnOperation12922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000241900000L});
	public static final BitSet FOLLOW_columnOperationDifferentiator_in_columnOperation12924 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_222_in_columnOperationDifferentiator12943 = new BitSet(new long[]{0xEF7DC5474D120840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_normalColumnOperation_in_columnOperationDifferentiator12945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_shorthandColumnOperation_in_columnOperationDifferentiator12954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_225_in_columnOperationDifferentiator12963 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnOperationDifferentiator12967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_227_in_columnOperationDifferentiator12969 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_collectionColumnOperation_in_columnOperationDifferentiator12971 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_216_in_columnOperationDifferentiator12980 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_columnOperationDifferentiator12984 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_udtColumnOperation_in_columnOperationDifferentiator12986 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation13007 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_211_in_normalColumnOperation13010 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation13014 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation13035 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000480000L});
	public static final BitSet FOLLOW_set_in_normalColumnOperation13039 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation13049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation13067 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_INTEGER_in_normalColumnOperation13071 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_shorthandColumnOperation13099 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_shorthandColumnOperation13109 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_222_in_collectionColumnOperation13135 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_collectionColumnOperation13139 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_222_in_udtColumnOperation13165 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_udtColumnOperation13169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnCondition13202 = new BitSet(new long[]{0x0200000000000000L,0x0000000002000000L,0x0000000000000000L,0x00000003F1008000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition13216 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnCondition13220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_containsOperator_in_columnCondition13236 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnCondition13240 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition13254 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004020001L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition13272 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition13292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_225_in_columnCondition13320 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnCondition13324 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_227_in_columnCondition13326 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L,0x0000000000000000L,0x00000001F0008000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition13344 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnCondition13348 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition13366 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004020001L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition13388 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition13412 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_216_in_columnCondition13458 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_fident_in_columnCondition13462 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L,0x0000000000000000L,0x00000001F0008000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition13480 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_columnCondition13484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition13502 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004020001L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition13524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition13548 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_properties13610 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_K_AND_in_properties13614 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_properties13616 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_property13639 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_property13641 = new BitSet(new long[]{0xEF7DC54749100840L,0x61777BB9B8ED7963L,0x008FB37A7FFA6CFEL,0x0000000000000120L});
	public static final BitSet FOLLOW_propertyValue_in_property13645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_property13657 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_222_in_property13659 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_fullMapLiteral_in_property13663 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_propertyValue13688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue13710 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_222_in_relationType13733 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_220_in_relationType13744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_221_in_relationType13755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_223_in_relationType13765 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_224_in_relationType13776 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_207_in_relationType13786 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13808 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00000001F0008000L});
	public static final BitSet FOLLOW_relationType_in_relation13812 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_relation13816 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13828 = new BitSet(new long[]{0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_LIKE_in_relation13830 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_relation13834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13846 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_IS_in_relation13848 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_K_NOT_in_relation13850 = new BitSet(new long[]{0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_K_NULL_in_relation13852 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_relation13862 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation13866 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00000001F0008000L});
	public static final BitSet FOLLOW_relationType_in_relation13870 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_relation13874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13894 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_K_IN_in_relation13896 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_inMarker_in_relation13900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13920 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_K_IN_in_relation13922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_relation13926 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13946 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_containsOperator_in_relation13950 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_relation13954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation13966 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_225_in_relation13968 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_relation13972 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_227_in_relation13974 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x00000001F0008000L});
	public static final BitSet FOLLOW_relationType_in_relation13978 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_relation13982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation13994 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L,0x0000000000000000L,0x00000001F0008000L});
	public static final BitSet FOLLOW_K_IN_in_relation14004 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004020001L});
	public static final BitSet FOLLOW_209_in_relation14018 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_relation14020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarkerForTuple_in_relation14052 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfTupleLiterals_in_relation14086 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfMarkersForTuples_in_relation14120 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation14162 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_tupleLiteral_in_relation14166 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation14192 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_markerForTuple_in_relation14196 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_relation14226 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37B7FFA6C3EL,0x0000000000020002L});
	public static final BitSet FOLLOW_relation_in_relation14228 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_210_in_relation14231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CONTAINS_in_containsOperator14252 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_KEY_in_containsOperator14257 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarker14282 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_inMarker14292 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_inMarker14296 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_tupleOfIdentifiers14328 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers14332 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tupleOfIdentifiers14337 = new BitSet(new long[]{0xEF7DC54744020000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers14341 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tupleOfIdentifiers14347 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_singleColumnInValues14377 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204460123L});
	public static final BitSet FOLLOW_term_in_singleColumnInValues14385 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_singleColumnInValues14390 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002204420123L});
	public static final BitSet FOLLOW_term_in_singleColumnInValues14394 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_singleColumnInValues14403 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_tupleOfTupleLiterals14433 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals14437 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tupleOfTupleLiterals14442 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals14446 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tupleOfTupleLiterals14452 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_markerForTuple14473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_markerForTuple14483 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_markerForTuple14487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_209_in_tupleOfMarkersForTuples14519 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples14523 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_213_in_tupleOfMarkersForTuples14528 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000004000001L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples14532 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000240000L});
	public static final BitSet FOLLOW_210_in_tupleOfMarkersForTuples14538 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarkerForTuple14559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_218_in_inMarkerForTuple14569 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFA6C3EL,0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_inMarkerForTuple14573 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_comparatorType14598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collection_type_in_comparatorType14614 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tuple_type_in_comparatorType14626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_vector_type_in_comparatorType14642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_comparatorType14657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FROZEN_in_comparatorType14669 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_220_in_comparatorType14671 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_comparatorType14675 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_223_in_comparatorType14677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType14695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ASCII_in_native_type14724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BIGINT_in_native_type14738 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BLOB_in_native_type14751 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BOOLEAN_in_native_type14766 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNTER_in_native_type14778 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DECIMAL_in_native_type14790 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DOUBLE_in_native_type14802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DURATION_in_native_type14815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FLOAT_in_native_type14826 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INET_in_native_type14840 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INT_in_native_type14855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SMALLINT_in_native_type14871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TEXT_in_native_type14882 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type14897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TINYINT_in_native_type14907 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UUID_in_native_type14919 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARCHAR_in_native_type14934 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARINT_in_native_type14946 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMEUUID_in_native_type14959 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DATE_in_native_type14970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIME_in_native_type14985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MAP_in_collection_type15013 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_220_in_collection_type15016 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type15020 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_collection_type15022 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type15026 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_223_in_collection_type15028 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_collection_type15046 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_220_in_collection_type15048 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type15052 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_223_in_collection_type15054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SET_in_collection_type15072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_220_in_collection_type15075 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type15079 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_223_in_collection_type15081 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TUPLE_in_tuple_type15130 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_220_in_tuple_type15132 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type15136 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080200000L});
	public static final BitSet FOLLOW_213_in_tuple_type15141 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type15145 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080200000L});
	public static final BitSet FOLLOW_223_in_tuple_type15151 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VECTOR_in_vector_type15172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_220_in_vector_type15174 = new BitSet(new long[]{0xEF7DC54744000000L,0x61477BB9B8ED7963L,0x008FB37A7FFE6C3EL,0x0000000000000022L});
	public static final BitSet FOLLOW_comparatorType_in_vector_type15178 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_213_in_vector_type15180 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_INTEGER_in_vector_type15185 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_223_in_vector_type15187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_username15214 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_username15222 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_username15230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_identity15249 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_identity15257 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_identity15265 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_mbean15284 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_non_type_ident15309 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_non_type_ident15340 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_non_type_ident15365 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEY_in_non_type_ident15377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword15420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_unreserved_keyword15436 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword15491 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword15503 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_basic_unreserved_keyword15541 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_JSON_in_synpred1_Parser1133 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002604420123L});
	public static final BitSet FOLLOW_selectClause_in_synpred1_Parser1135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DISTINCT_in_synpred2_Parser1336 = new BitSet(new long[]{0xEF7DC5474D100840L,0x65777BB9B8ED7963L,0x008FB37B7FFA6CFEL,0x0000002604420123L});
	public static final BitSet FOLLOW_selectors_in_synpred2_Parser1338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionGroupWithField_in_synpred3_Parser1667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectionTypeHint_in_synpred4_Parser1954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTER_in_synpred5_Parser9739 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_synpred6_Parser9795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TABLES_in_synpred7_Parser9902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TYPES_in_synpred8_Parser10007 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_synpred9_Parser10081 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_AGGREGATES_in_synpred10_Parser10143 = new BitSet(new long[]{0x0000000000000002L});
}
