/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.statsd;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.emitter.statsd.StatsDMetric;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class DimensionConverter {
    private static final Logger log = new Logger(DimensionConverter.class);
    private Map<String, StatsDMetric> metricMap;

    public DimensionConverter(ObjectMapper mapper, String dimensionMapPath) {
        this.metricMap = this.readMap(mapper, dimensionMapPath);
    }

    @Nullable
    public StatsDMetric addFilteredUserDims(String service, String metric, Map<String, Object> userDims, ImmutableMap.Builder<String, String> builder) {
        StatsDMetric statsDMetric = null;
        if (this.metricMap.containsKey(metric)) {
            statsDMetric = this.metricMap.get(metric);
        } else if (this.metricMap.containsKey(service + "-" + metric)) {
            statsDMetric = this.metricMap.get(service + "-" + metric);
        }
        if (statsDMetric != null) {
            for (String dim : statsDMetric.dimensions) {
                if (!userDims.containsKey(dim)) continue;
                builder.put((Object)dim, (Object)userDims.get(dim).toString());
            }
            return statsDMetric;
        }
        return null;
    }

    private Map<String, StatsDMetric> readMap(ObjectMapper mapper, String dimensionMapPath) {
        try {
            InputStream is;
            if (Strings.isNullOrEmpty((String)dimensionMapPath)) {
                log.info("Using default metric dimension and types", new Object[0]);
                is = this.getClass().getClassLoader().getResourceAsStream("defaultMetricDimensions.json");
            } else {
                log.info("Using metric dimensions at types at [%s]", new Object[]{dimensionMapPath});
                is = new FileInputStream(new File(dimensionMapPath));
            }
            return (Map)mapper.readerFor((TypeReference)new TypeReference<Map<String, StatsDMetric>>(){}).readValue(is);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Failed to parse metric dimensions and types", new Object[0]);
        }
    }
}

