/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.statsd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class StatsDEmitterConfig {
    @JsonProperty
    private final String hostname;
    @JsonProperty
    private final Integer port;
    @JsonProperty
    private final String prefix;
    @JsonProperty
    private final String separator;
    @JsonProperty
    private final Boolean includeHost;
    @JsonProperty
    @Nullable
    private final String dimensionMapPath;
    @JsonProperty
    private final String blankHolder;
    @JsonProperty
    private final Boolean dogstatsd;
    @JsonProperty
    private final List<String> dogstatsdConstantTags;
    @JsonProperty
    private final Boolean dogstatsdServiceAsTag;
    @JsonProperty
    private final Boolean dogstatsdEvents;

    @JsonCreator
    public StatsDEmitterConfig(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="port") Integer port, @JsonProperty(value="prefix") @Nullable String prefix, @JsonProperty(value="separator") @Nullable String separator, @JsonProperty(value="includeHost") @Nullable Boolean includeHost, @JsonProperty(value="dimensionMapPath") @Nullable String dimensionMapPath, @JsonProperty(value="blankHolder") @Nullable String blankHolder, @JsonProperty(value="dogstatsd") @Nullable Boolean dogstatsd, @JsonProperty(value="dogstatsdConstantTags") @Nullable List<String> dogstatsdConstantTags, @JsonProperty(value="dogstatsdServiceAsTag") @Nullable Boolean dogstatsdServiceAsTag, @JsonProperty(value="dogstatsdEvents") @Nullable Boolean dogstatsdEvents) {
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"StatsD hostname cannot be null.");
        this.port = (Integer)Preconditions.checkNotNull((Object)port, (Object)"StatsD port cannot be null.");
        this.prefix = prefix != null ? prefix : "";
        this.separator = separator != null ? separator : ".";
        this.includeHost = includeHost != null ? includeHost : false;
        this.dimensionMapPath = dimensionMapPath;
        this.blankHolder = blankHolder != null ? blankHolder : "-";
        this.dogstatsd = dogstatsd != null ? dogstatsd : false;
        this.dogstatsdConstantTags = dogstatsdConstantTags != null ? dogstatsdConstantTags : Collections.emptyList();
        this.dogstatsdServiceAsTag = dogstatsdServiceAsTag != null ? dogstatsdServiceAsTag : false;
        this.dogstatsdEvents = dogstatsdEvents != null ? dogstatsdEvents : false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsDEmitterConfig that = (StatsDEmitterConfig)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.separator, that.separator)) {
            return false;
        }
        if (!Objects.equals(this.includeHost, that.includeHost)) {
            return false;
        }
        if (!Objects.equals(this.dimensionMapPath, that.dimensionMapPath)) {
            return false;
        }
        if (!Objects.equals(this.dogstatsd, that.dogstatsd)) {
            return false;
        }
        if (!Objects.equals(this.dogstatsdServiceAsTag, that.dogstatsdServiceAsTag)) {
            return false;
        }
        return Objects.equals(this.dogstatsdConstantTags, that.dogstatsdConstantTags);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port, this.prefix, this.separator, this.includeHost, this.dimensionMapPath, this.blankHolder, this.dogstatsd, this.dogstatsdConstantTags, this.dogstatsdServiceAsTag);
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public String getSeparator() {
        return this.separator;
    }

    @JsonProperty
    public Boolean getIncludeHost() {
        return this.includeHost;
    }

    @JsonProperty
    @Nullable
    public String getDimensionMapPath() {
        return this.dimensionMapPath;
    }

    @JsonProperty
    public String getBlankHolder() {
        return this.blankHolder;
    }

    @JsonProperty
    public Boolean isDogstatsd() {
        return this.dogstatsd;
    }

    @JsonProperty
    public List<String> getDogstatsdConstantTags() {
        return this.dogstatsdConstantTags;
    }

    @JsonProperty
    public Boolean isDogstatsdServiceAsTag() {
        return this.dogstatsdServiceAsTag;
    }

    @JsonProperty
    public Boolean isDogstatsdEvents() {
        return this.dogstatsdEvents;
    }
}

