/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.google;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.google.GoogleCloudStorageEntity;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;

public class GoogleCloudStorageInputSource
extends CloudObjectInputSource<GoogleCloudStorageEntity> {
    static final String SCHEME = "gs";
    private final GoogleStorage storage;

    @JsonCreator
    public GoogleCloudStorageInputSource(@JacksonInject GoogleStorage storage, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects) {
        super(SCHEME, uris, prefixes, objects);
        this.storage = storage;
    }

    protected GoogleCloudStorageEntity createEntity(InputSplit<CloudObjectLocation> split) {
        return new GoogleCloudStorageEntity(this.storage, (CloudObjectLocation)split.get());
    }

    protected Stream<InputSplit<CloudObjectLocation>> getPrefixesSplitStream() {
        return StreamSupport.stream(this.storageObjectIterable().spliterator(), false).map(this::byteSourceFromStorageObject).map(InputSplit::new);
    }

    public SplittableInputSource<CloudObjectLocation> withSplit(InputSplit<CloudObjectLocation> split) {
        return new GoogleCloudStorageInputSource(this.storage, null, null, (List<CloudObjectLocation>)ImmutableList.of((Object)split.get()));
    }

    private CloudObjectLocation byteSourceFromStorageObject(StorageObject storageObject) {
        return new CloudObjectLocation(storageObject.getBucket(), storageObject.getName());
    }

    private Iterable<StorageObject> storageObjectIterable() {
        return () -> GoogleUtils.lazyFetchingStorageObjectsIterator(this.storage, this.getPrefixes().iterator(), 10L);
    }

    public String toString() {
        return "GoogleCloudStorageInputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + '}';
    }
}

