/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.firehose.google;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;

public class GoogleBlob {
    private final String bucket;
    private final String path;

    @JsonCreator
    public GoogleBlob(@JsonProperty(value="bucket") String bucket, @JsonProperty(value="path") String path) {
        this.bucket = bucket;
        this.path = path;
    }

    @JsonProperty
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "GoogleBlob {bucket=" + this.bucket + ",path=" + this.path + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleBlob that = (GoogleBlob)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.path);
    }

    public URI toURI() {
        return URI.create(StringUtils.format((String)"gs://%s/%s", (Object[])new Object[]{this.bucket, this.path}));
    }
}

