/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.HttpResponseException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.timeline.DataSegment;

public class GoogleDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger LOG = new Logger(GoogleDataSegmentKiller.class);
    private final GoogleStorage storage;

    @Inject
    public GoogleDataSegmentKiller(GoogleStorage storage) {
        this.storage = storage;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        LOG.info("Killing segment [%s]", new Object[]{segment});
        Map loadSpec = segment.getLoadSpec();
        String bucket = MapUtils.getString((Map)loadSpec, (String)"bucket");
        String indexPath = MapUtils.getString((Map)loadSpec, (String)"path");
        String descriptorPath = DataSegmentKiller.descriptorPath((String)indexPath);
        try {
            this.deleteIfPresent(bucket, indexPath);
            this.deleteIfPresent(bucket, descriptorPath);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getId(), e.getMessage()});
        }
    }

    private void deleteIfPresent(String bucket, String path) throws IOException {
        try {
            RetryUtils.retry(() -> {
                this.storage.delete(bucket, path);
                return null;
            }, GoogleUtils::isRetryable, (int)1, (int)5);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            LOG.debug("Already deleted: [%s] [%s]", new Object[]{bucket, path});
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to delete [%s] [%s]", new Object[]{bucket, path});
        }
    }

    public void killAll() {
        throw new UnsupportedOperationException("not implemented");
    }
}

