/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;

public class GoogleStorage {
    private final Storage storage;

    public GoogleStorage(Storage storage) {
        this.storage = storage;
    }

    public void insert(String bucket, String path, AbstractInputStreamContent mediaContent) throws IOException {
        Storage.Objects.Insert insertObject = this.storage.objects().insert(bucket, null, mediaContent);
        insertObject.setName(path);
        insertObject.getMediaHttpUploader().setDirectUploadEnabled(false);
        insertObject.execute();
    }

    public InputStream get(String bucket, String path) throws IOException {
        return this.get(bucket, path, 0L);
    }

    public InputStream get(String bucket, String path, long start) throws IOException {
        Storage.Objects.Get get = this.storage.objects().get(bucket, path);
        if (start > 0L) {
            get.getMediaHttpDownloader().setBytesDownloaded(start);
        }
        get.getMediaHttpDownloader().setDirectDownloadEnabled(false);
        return get.executeMediaAsInputStream();
    }

    public void delete(String bucket, String path) throws IOException {
        this.storage.objects().delete(bucket, path).execute();
    }

    public boolean exists(String bucket, String path) {
        try {
            return this.storage.objects().get(bucket, path).executeUsingHead().isSuccessStatusCode();
        }
        catch (Exception e) {
            return false;
        }
    }

    public long size(String bucket, String path) throws IOException {
        return ((StorageObject)this.storage.objects().get(bucket, path).execute()).getSize().longValue();
    }

    public String version(String bucket, String path) throws IOException {
        return ((StorageObject)this.storage.objects().get(bucket, path).execute()).getEtag();
    }

    public Storage.Objects.List list(String bucket) throws IOException {
        return this.storage.objects().list(bucket);
    }
}

