/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.storage.Storage;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.List;
import org.apache.druid.data.input.google.GoogleCloudStorageInputSource;
import org.apache.druid.firehose.google.StaticGoogleBlobStoreFirehoseFactory;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleAccountConfig;
import org.apache.druid.storage.google.GoogleDataSegmentKiller;
import org.apache.druid.storage.google.GoogleDataSegmentPusher;
import org.apache.druid.storage.google.GoogleLoadSpec;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleTaskLogs;
import org.apache.druid.storage.google.GoogleTaskLogsConfig;

public class GoogleStorageDruidModule
implements DruidModule {
    static final String SCHEME = "google";
    private static final Logger LOG = new Logger(GoogleStorageDruidModule.class);
    private static final String APPLICATION_NAME = "druid-google-extensions";

    public List<? extends Module> getJacksonModules() {
        LOG.info("Getting jackson modules...", new Object[0]);
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "Google-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{GoogleLoadSpec.class});
            }
        }, (Object)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(StaticGoogleBlobStoreFirehoseFactory.class, "static-google-blobstore"), new NamedType(GoogleCloudStorageInputSource.class, SCHEME)}));
    }

    public void configure(Binder binder) {
        LOG.info("Configuring GoogleStorageDruidModule...", new Object[0]);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.google", GoogleAccountConfig.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(GoogleDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(GoogleDataSegmentKiller.class).in(LazySingleton.class);
        Binders.taskLogsBinder((Binder)binder).addBinding((Object)SCHEME).to(GoogleTaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", GoogleTaskLogsConfig.class);
        binder.bind(GoogleTaskLogs.class).in(LazySingleton.class);
    }

    @Provides
    @LazySingleton
    public GoogleStorage getGoogleStorage(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer requestInitializer) {
        LOG.info("Building Cloud Storage Client...", new Object[0]);
        Storage storage = new Storage.Builder(httpTransport, jsonFactory, requestInitializer).setApplicationName(APPLICATION_NAME).build();
        return new GoogleStorage(storage);
    }
}

