/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleByteSource;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleTaskLogsConfig;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.tasklogs.TaskLogs;

public class GoogleTaskLogs
implements TaskLogs {
    private static final Logger LOG = new Logger(GoogleTaskLogs.class);
    private final GoogleTaskLogsConfig config;
    private final GoogleStorage storage;

    @Inject
    public GoogleTaskLogs(GoogleTaskLogsConfig config, GoogleStorage storage) {
        this.config = config;
        this.storage = storage;
    }

    public void pushTaskLog(String taskid, File logFile) throws IOException {
        String taskKey = this.getTaskLogKey(taskid);
        LOG.info("Pushing task log %s to: %s", new Object[]{logFile, taskKey});
        this.pushTaskFile(logFile, taskKey);
    }

    public void pushTaskReports(String taskid, File reportFile) throws IOException {
        String taskKey = this.getTaskReportKey(taskid);
        LOG.info("Pushing task reports %s to: %s", new Object[]{reportFile, taskKey});
        this.pushTaskFile(reportFile, taskKey);
    }

    private void pushTaskFile(File logFile, String taskKey) throws IOException {
        try (InputStream fileStream = Files.newInputStream(logFile.toPath(), new OpenOption[0]);){
            InputStreamContent mediaContent = new InputStreamContent("text/plain", fileStream);
            mediaContent.setLength(logFile.length());
            try {
                RetryUtils.retry(() -> {
                    this.storage.insert(this.config.getBucket(), taskKey, (AbstractInputStreamContent)mediaContent);
                    return null;
                }, GoogleUtils::isRetryable, (int)1, (int)5);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RE((Throwable)e, "Failed to upload [%s] to [%s]", new Object[]{logFile, taskKey});
            }
        }
    }

    public Optional<ByteSource> streamTaskLog(String taskid, long offset) throws IOException {
        String taskKey = this.getTaskLogKey(taskid);
        return this.streamTaskFile(taskid, offset, taskKey);
    }

    public Optional<ByteSource> streamTaskReports(String taskid) throws IOException {
        String taskKey = this.getTaskReportKey(taskid);
        return this.streamTaskFile(taskid, 0L, taskKey);
    }

    private Optional<ByteSource> streamTaskFile(String taskid, final long offset, final String taskKey) throws IOException {
        try {
            if (!this.storage.exists(this.config.getBucket(), taskKey)) {
                return Optional.absent();
            }
            final long length = this.storage.size(this.config.getBucket(), taskKey);
            return Optional.of((Object)new ByteSource(){

                public InputStream openStream() throws IOException {
                    try {
                        long start = offset > 0L && offset < length ? offset : (offset < 0L && -1L * offset < length ? length + offset : 0L);
                        InputStream stream = new GoogleByteSource(GoogleTaskLogs.this.storage, GoogleTaskLogs.this.config.getBucket(), taskKey).openStream();
                        stream.skip(start);
                        return stream;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new IOE((Throwable)e, "Failed to stream logs from: %s", new Object[]{taskKey});
        }
    }

    private String getTaskLogKey(String taskid) {
        return this.config.getPrefix() + "/" + taskid.replace(':', '_');
    }

    private String getTaskReportKey(String taskid) {
        return this.config.getPrefix() + "/" + taskid.replace(':', '_') + ".report.json";
    }

    public void killAll() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void killOlderThan(long timestamp) {
        throw new UnsupportedOperationException("not implemented");
    }
}

