/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleStorage;

public class GoogleUtils {
    public static final Predicate<Throwable> GOOGLE_RETRY = GoogleUtils::isRetryable;

    public static boolean isRetryable(Throwable t) {
        if (t instanceof HttpResponseException) {
            HttpResponseException e = (HttpResponseException)t;
            return e.getStatusCode() == 429 || e.getStatusCode() / 500 == 1;
        }
        return t instanceof IOException;
    }

    private static <T> T retryGoogleCloudStorageOperation(RetryUtils.Task<T> f) throws Exception {
        return (T)RetryUtils.retry(f, GOOGLE_RETRY, (int)10);
    }

    public static Iterator<StorageObject> lazyFetchingStorageObjectsIterator(final GoogleStorage storage, final Iterator<URI> uris, final long maxListingLength) {
        return new Iterator<StorageObject>(){
            private Storage.Objects.List listRequest;
            private Objects results;
            private URI currentUri;
            private String currentBucket;
            private String currentPrefix;
            private String nextPageToken = null;
            private Iterator<StorageObject> storageObjectsIterator;
            {
                this.prepareNextRequest();
                this.fetchNextBatch();
            }

            private void prepareNextRequest() {
                try {
                    this.currentUri = (URI)uris.next();
                    this.currentBucket = this.currentUri.getAuthority();
                    this.currentPrefix = StringUtils.maybeRemoveLeadingSlash((String)this.currentUri.getPath());
                    this.nextPageToken = null;
                    this.listRequest = storage.list(this.currentBucket).setPrefix(this.currentPrefix).setMaxResults(Long.valueOf(maxListingLength));
                }
                catch (IOException io) {
                    throw new RuntimeException(io);
                }
            }

            private void fetchNextBatch() {
                try {
                    this.listRequest.setPageToken(this.nextPageToken);
                    this.results = (Objects)GoogleUtils.retryGoogleCloudStorageOperation(() -> (Objects)this.listRequest.execute());
                    this.storageObjectsIterator = this.results.getItems().iterator();
                    this.nextPageToken = this.results.getNextPageToken();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public boolean hasNext() {
                return this.storageObjectsIterator.hasNext() || this.nextPageToken != null || uris.hasNext();
            }

            @Override
            public StorageObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (this.storageObjectsIterator.hasNext()) {
                    StorageObject next = this.storageObjectsIterator.next();
                    if (next.getName().endsWith("/")) continue;
                    return next;
                }
                if (this.nextPageToken != null) {
                    this.fetchNextBatch();
                } else if (uris.hasNext()) {
                    this.prepareNextRequest();
                    this.fetchNextBatch();
                }
                if (!this.storageObjectsIterator.hasNext()) {
                    throw new ISE("Failed to further iterate on bucket[%s] and prefix[%s]. The last page token was [%s]", new Object[]{this.currentBucket, this.currentPrefix, this.nextPageToken});
                }
                return this.next();
            }
        };
    }
}

