/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent.debezium;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.AvroRowDataSerializationSchema;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.registry.confluent.ConfluentRegistryAvroSerializationSchema;
import org.apache.flink.formats.avro.registry.confluent.debezium.DebeziumAvroFormatFactory;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class DebeziumAvroSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString((String)"c");
    private static final StringData OP_DELETE = StringData.fromString((String)"d");
    private final AvroRowDataSerializationSchema avroSerializer;
    private transient GenericRowData outputReuse;

    public DebeziumAvroSerializationSchema(RowType rowType, String schemaRegistryUrl, String schemaRegistrySubject, @Nullable Map<String, ?> registryConfigs) {
        this(rowType, schemaRegistryUrl, schemaRegistrySubject, null, registryConfigs);
    }

    public DebeziumAvroSerializationSchema(RowType rowType, String schemaRegistryUrl, String schemaRegistrySubject, @Nullable String schemaString, @Nullable Map<String, ?> registryConfigs) {
        RowType debeziumAvroRowType = DebeziumAvroSerializationSchema.createDebeziumAvroRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType));
        DebeziumAvroFormatFactory.validateSchemaString(schemaString, debeziumAvroRowType);
        Schema schema = schemaString == null ? AvroSchemaConverter.convertToSchema((LogicalType)debeziumAvroRowType) : new Schema.Parser().parse(schemaString);
        this.avroSerializer = new AvroRowDataSerializationSchema(debeziumAvroRowType, ConfluentRegistryAvroSerializationSchema.forGeneric(schemaRegistrySubject, schema, schemaRegistryUrl, registryConfigs), RowDataToAvroConverters.createConverter((LogicalType)debeziumAvroRowType));
    }

    @VisibleForTesting
    DebeziumAvroSerializationSchema(AvroRowDataSerializationSchema avroSerializer) {
        this.avroSerializer = avroSerializer;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.avroSerializer.open(context);
        this.outputReuse = new GenericRowData(3);
    }

    public byte[] serialize(RowData rowData) {
        try {
            switch (rowData.getRowKind()) {
                case INSERT: 
                case UPDATE_AFTER: {
                    this.outputReuse.setField(0, null);
                    this.outputReuse.setField(1, (Object)rowData);
                    this.outputReuse.setField(2, (Object)OP_INSERT);
                    return this.avroSerializer.serialize((RowData)this.outputReuse);
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    this.outputReuse.setField(0, (Object)rowData);
                    this.outputReuse.setField(1, null);
                    this.outputReuse.setField(2, (Object)OP_DELETE);
                    return this.avroSerializer.serialize((RowData)this.outputReuse);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported operation '%s' for row kind.", rowData.getRowKind()));
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Could not serialize row '%s'.", rowData), t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebeziumAvroSerializationSchema that = (DebeziumAvroSerializationSchema)o;
        return Objects.equals(this.avroSerializer, that.avroSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.avroSerializer);
    }

    public static RowType createDebeziumAvroRowType(DataType dataType) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)((DataType)dataType.nullable())), DataTypes.FIELD((String)"after", (DataType)((DataType)dataType.nullable())), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())}).getLogicalType();
    }
}

