/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.split;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.util.Preconditions;

@Internal
public class CompositeJdbcParameterValuesProvider
implements JdbcParameterValuesProvider {
    JdbcParameterValuesProvider a;
    JdbcParameterValuesProvider b;

    public CompositeJdbcParameterValuesProvider(JdbcParameterValuesProvider a, JdbcParameterValuesProvider b) {
        Preconditions.checkArgument((a.getParameterValues().length == b.getParameterValues().length ? 1 : 0) != 0, (Object)"Both JdbcParameterValuesProvider should have the same length.");
        this.a = a;
        this.b = b;
    }

    @Override
    public Serializable[][] getParameterValues() {
        int batchNum = this.a.getParameterValues().length;
        Serializable[][] parameters = new Serializable[batchNum][];
        for (int i = 0; i < batchNum; ++i) {
            Serializable[] aSlice = this.a.getParameterValues()[i];
            Serializable[] bSlice = this.b.getParameterValues()[i];
            int totalLen = aSlice.length + bSlice.length;
            Serializable[] batchParams = new Serializable[totalLen];
            System.arraycopy(aSlice, 0, batchParams, 0, aSlice.length);
            System.arraycopy(bSlice, 0, batchParams, aSlice.length, bSlice.length);
            parameters[i] = batchParams;
        }
        return parameters;
    }
}

