/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcReadOptions;
import org.apache.flink.connector.jdbc.split.CompositeJdbcParameterValuesProvider;
import org.apache.flink.connector.jdbc.split.JdbcGenericParameterValuesProvider;
import org.apache.flink.connector.jdbc.split.JdbcNumericBetweenParametersProvider;
import org.apache.flink.connector.jdbc.table.JdbcFilterPushdownPreparedStatementVisitor;
import org.apache.flink.connector.jdbc.table.JdbcRowDataInputFormat;
import org.apache.flink.connector.jdbc.table.JdbcRowDataLookupFunction;
import org.apache.flink.connector.jdbc.table.ParameterizedPredicate;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcDynamicTableSource
implements ScanTableSource,
LookupTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown,
SupportsFilterPushDown {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDynamicTableSource.class);
    private final InternalJdbcConnectionOptions options;
    private final JdbcReadOptions readOptions;
    private final int lookupMaxRetryTimes;
    @Nullable
    private final LookupCache cache;
    private DataType physicalRowDataType;
    private final String dialectName;
    private long limit = -1L;
    private List<String> resolvedPredicates = new ArrayList<String>();
    private Serializable[] pushdownParams = new Serializable[0];

    public JdbcDynamicTableSource(InternalJdbcConnectionOptions options, JdbcReadOptions readOptions, int lookupMaxRetryTimes, @Nullable LookupCache cache, DataType physicalRowDataType) {
        this.options = options;
        this.readOptions = readOptions;
        this.lookupMaxRetryTimes = lookupMaxRetryTimes;
        this.cache = cache;
        this.physicalRowDataType = physicalRowDataType;
        this.dialectName = options.getDialect().dialectName();
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"JDBC only support non-nested look up keys");
            keyNames[i] = (String)DataType.getFieldNames((DataType)this.physicalRowDataType).get(innerKeyArr[0]);
        }
        RowType rowType = (RowType)this.physicalRowDataType.getLogicalType();
        JdbcRowDataLookupFunction lookupFunction = new JdbcRowDataLookupFunction(this.options, this.lookupMaxRetryTimes, DataType.getFieldNames((DataType)this.physicalRowDataType).toArray(new String[0]), DataType.getFieldDataTypes((DataType)this.physicalRowDataType).toArray(new DataType[0]), keyNames, rowType);
        if (this.cache != null) {
            return PartialCachingLookupProvider.of((LookupFunction)lookupFunction, (LookupCache)this.cache);
        }
        return LookupFunctionProvider.of((LookupFunction)lookupFunction);
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        JdbcRowDataInputFormat.Builder builder = JdbcRowDataInputFormat.builder().setDrivername(this.options.getDriverName()).setDBUrl(this.options.getDbURL()).setUsername(this.options.getUsername().orElse(null)).setPassword(this.options.getPassword().orElse(null)).setAutoCommit(this.readOptions.getAutoCommit());
        if (this.readOptions.getFetchSize() != 0) {
            builder.setFetchSize(this.readOptions.getFetchSize());
        }
        JdbcDialect dialect = this.options.getDialect();
        String query = dialect.getSelectFromStatement(this.options.getTableName(), DataType.getFieldNames((DataType)this.physicalRowDataType).toArray(new String[0]), new String[0]);
        ArrayList<String> predicates = new ArrayList<String>();
        if (this.readOptions.getPartitionColumnName().isPresent()) {
            long lowerBound = this.readOptions.getPartitionLowerBound().get();
            long upperBound = this.readOptions.getPartitionUpperBound().get();
            int numPartitions = this.readOptions.getNumPartitions().get();
            Serializable[][] allPushdownParams = this.replicatePushdownParamsForN(numPartitions);
            CompositeJdbcParameterValuesProvider allParams = new CompositeJdbcParameterValuesProvider(new JdbcNumericBetweenParametersProvider(lowerBound, upperBound).ofBatchNum(numPartitions), new JdbcGenericParameterValuesProvider(allPushdownParams));
            builder.setParametersProvider(allParams);
            predicates.add(dialect.quoteIdentifier(this.readOptions.getPartitionColumnName().get()) + " BETWEEN ? AND ?");
        } else {
            builder.setParametersProvider(new JdbcGenericParameterValuesProvider(this.replicatePushdownParamsForN(1)));
        }
        predicates.addAll(this.resolvedPredicates);
        if (predicates.size() > 0) {
            String joinedConditions = predicates.stream().map(pred -> String.format("(%s)", pred)).collect(Collectors.joining(" AND "));
            query = query + " WHERE " + joinedConditions;
        }
        if (this.limit >= 0L) {
            query = String.format("%s %s", query, dialect.getLimitClause(this.limit));
        }
        LOG.debug("Query generated for JDBC scan: " + query);
        builder.setQuery(query);
        RowType rowType = (RowType)this.physicalRowDataType.getLogicalType();
        builder.setRowConverter(dialect.getRowConverter(rowType));
        builder.setRowDataTypeInfo((TypeInformation<RowData>)runtimeProviderContext.createTypeInformation(this.physicalRowDataType));
        return InputFormatProvider.of((InputFormat)builder.build());
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.physicalRowDataType = Projection.of((int[][])projectedFields).project(this.physicalRowDataType);
    }

    public DynamicTableSource copy() {
        JdbcDynamicTableSource newSource = new JdbcDynamicTableSource(this.options, this.readOptions, this.lookupMaxRetryTimes, this.cache, this.physicalRowDataType);
        newSource.resolvedPredicates = new ArrayList<String>(this.resolvedPredicates);
        newSource.pushdownParams = Arrays.copyOf(this.pushdownParams, this.pushdownParams.length);
        return newSource;
    }

    public String asSummaryString() {
        return "JDBC:" + this.dialectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcDynamicTableSource)) {
            return false;
        }
        JdbcDynamicTableSource that = (JdbcDynamicTableSource)o;
        return Objects.equals(this.options, that.options) && Objects.equals(this.readOptions, that.readOptions) && Objects.equals(this.lookupMaxRetryTimes, that.lookupMaxRetryTimes) && Objects.equals(this.cache, that.cache) && Objects.equals(this.physicalRowDataType, that.physicalRowDataType) && Objects.equals(this.dialectName, that.dialectName) && Objects.equals(this.limit, that.limit) && Objects.equals(this.resolvedPredicates, that.resolvedPredicates) && Arrays.deepEquals(this.pushdownParams, that.pushdownParams);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.readOptions, this.lookupMaxRetryTimes, this.cache, this.physicalRowDataType, this.dialectName, this.limit, this.resolvedPredicates, this.pushdownParams);
    }

    public void applyLimit(long limit) {
        this.limit = limit;
    }

    public SupportsFilterPushDown.Result applyFilters(List<ResolvedExpression> filters) {
        ArrayList<ResolvedExpression> acceptedFilters = new ArrayList<ResolvedExpression>();
        ArrayList<ResolvedExpression> remainingFilters = new ArrayList<ResolvedExpression>();
        for (ResolvedExpression filter : filters) {
            Optional<ParameterizedPredicate> simplePredicate = this.parseFilterToPredicate(filter);
            if (simplePredicate.isPresent()) {
                acceptedFilters.add(filter);
                ParameterizedPredicate pred = simplePredicate.get();
                this.pushdownParams = (Serializable[])ArrayUtils.addAll((Object[])this.pushdownParams, (Object[])pred.getParameters());
                this.resolvedPredicates.add(pred.getPredicate());
                continue;
            }
            remainingFilters.add(filter);
        }
        return SupportsFilterPushDown.Result.of(acceptedFilters, remainingFilters);
    }

    private Optional<ParameterizedPredicate> parseFilterToPredicate(ResolvedExpression filter) {
        if (filter instanceof CallExpression) {
            CallExpression callExp = (CallExpression)filter;
            return (Optional)callExp.accept((ExpressionVisitor)new JdbcFilterPushdownPreparedStatementVisitor(this.options.getDialect()::quoteIdentifier));
        }
        return Optional.empty();
    }

    private Serializable[][] replicatePushdownParamsForN(int n) {
        Serializable[][] allPushdownParams = new Serializable[n][this.pushdownParams.length];
        for (int i = 0; i < n; ++i) {
            allPushdownParams[i] = this.pushdownParams;
        }
        return allPushdownParams;
    }
}

