/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexSpilledRegionManager;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava30.com.google.common.cache.RemovalNotification;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class HsFileDataIndexCache {
    private final List<TreeMap<Integer, HsFileDataIndexImpl.InternalRegion>> subpartitionFirstBufferIndexInternalRegions;
    private final Cache<CachedRegionKey, Object> internalCache;
    private final HsFileDataIndexSpilledRegionManager spilledRegionManager;
    private final Path indexFilePath;
    public static final Object PLACEHOLDER = new Object();

    public HsFileDataIndexCache(int numSubpartitions, Path indexFilePath, long numRetainedInMemoryRegionsMax, HsFileDataIndexSpilledRegionManager.Factory spilledRegionManagerFactory) {
        this.subpartitionFirstBufferIndexInternalRegions = new ArrayList<TreeMap<Integer, HsFileDataIndexImpl.InternalRegion>>(numSubpartitions);
        for (int subpartitionId = 0; subpartitionId < numSubpartitions; ++subpartitionId) {
            this.subpartitionFirstBufferIndexInternalRegions.add(new TreeMap());
        }
        this.internalCache = CacheBuilder.newBuilder().maximumSize(numRetainedInMemoryRegionsMax).removalListener(this::handleRemove).build();
        this.indexFilePath = (Path)Preconditions.checkNotNull((Object)indexFilePath);
        this.spilledRegionManager = spilledRegionManagerFactory.create(numSubpartitions, indexFilePath, (subpartition, region) -> {
            if (!this.getCachedRegionContainsTargetBufferIndex((int)subpartition, region.getFirstBufferIndex()).isPresent()) {
                this.subpartitionFirstBufferIndexInternalRegions.get((int)subpartition).put(region.getFirstBufferIndex(), (HsFileDataIndexImpl.InternalRegion)region);
                this.internalCache.put((Object)new CachedRegionKey((int)subpartition, region.getFirstBufferIndex()), PLACEHOLDER);
            } else {
                this.internalCache.getIfPresent((Object)new CachedRegionKey((int)subpartition, region.getFirstBufferIndex()));
            }
        });
    }

    public Optional<HsFileDataIndexImpl.InternalRegion> get(int subpartitionId, int bufferIndex) {
        Optional<HsFileDataIndexImpl.InternalRegion> regionOpt = this.getCachedRegionContainsTargetBufferIndex(subpartitionId, bufferIndex);
        if (regionOpt.isPresent()) {
            HsFileDataIndexImpl.InternalRegion region = regionOpt.get();
            Preconditions.checkNotNull((Object)this.internalCache.getIfPresent((Object)new CachedRegionKey(subpartitionId, region.getFirstBufferIndex())));
            return Optional.of(region);
        }
        this.spilledRegionManager.findRegion(subpartitionId, bufferIndex, true);
        return this.getCachedRegionContainsTargetBufferIndex(subpartitionId, bufferIndex);
    }

    public void put(int subpartition, List<HsFileDataIndexImpl.InternalRegion> internalRegions) {
        TreeMap<Integer, HsFileDataIndexImpl.InternalRegion> treeMap = this.subpartitionFirstBufferIndexInternalRegions.get(subpartition);
        for (HsFileDataIndexImpl.InternalRegion internalRegion : internalRegions) {
            this.internalCache.put((Object)new CachedRegionKey(subpartition, internalRegion.getFirstBufferIndex()), PLACEHOLDER);
            treeMap.put(internalRegion.getFirstBufferIndex(), internalRegion);
        }
    }

    public void close() throws IOException {
        this.spilledRegionManager.close();
        IOUtils.deleteFileQuietly((Path)this.indexFilePath);
    }

    private void handleRemove(RemovalNotification<CachedRegionKey, Object> removedEntry) {
        CachedRegionKey removedKey = (CachedRegionKey)removedEntry.getKey();
        HsFileDataIndexImpl.InternalRegion removedRegion = this.subpartitionFirstBufferIndexInternalRegions.get(removedKey.getSubpartition()).remove(removedKey.getFirstBufferIndex());
        this.writeRegion(removedKey.getSubpartition(), removedRegion);
    }

    private void writeRegion(int subpartition, HsFileDataIndexImpl.InternalRegion region) {
        try {
            this.spilledRegionManager.appendOrOverwriteRegion(subpartition, region);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private Optional<HsFileDataIndexImpl.InternalRegion> getCachedRegionContainsTargetBufferIndex(int subpartitionId, int bufferIndex) {
        return Optional.ofNullable(this.subpartitionFirstBufferIndexInternalRegions.get(subpartitionId).floorEntry(bufferIndex)).map(Map.Entry::getValue).filter(internalRegion -> internalRegion.containBuffer(bufferIndex));
    }

    private static class CachedRegionKey {
        private final int subpartition;
        private final int firstBufferIndex;

        public CachedRegionKey(int subpartition, int firstBufferIndex) {
            this.subpartition = subpartition;
            this.firstBufferIndex = firstBufferIndex;
        }

        public int getSubpartition() {
            return this.subpartition;
        }

        public int getFirstBufferIndex() {
            return this.firstBufferIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedRegionKey that = (CachedRegionKey)o;
            return this.subpartition == that.subpartition && this.firstBufferIndex == that.firstBufferIndex;
        }

        public int hashCode() {
            return Objects.hash(this.subpartition, this.firstBufferIndex);
        }
    }
}

