/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.config;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.sink.PulsarSinkOptions;
import org.apache.flink.connector.pulsar.sink.writer.router.MessageKeyHash;

@PublicEvolving
public class SinkConfiguration
extends PulsarConfiguration {
    private static final long serialVersionUID = 4941360605051251153L;
    private final DeliveryGuarantee deliveryGuarantee = (DeliveryGuarantee)this.get(PulsarSinkOptions.PULSAR_WRITE_DELIVERY_GUARANTEE);
    private final long transactionTimeoutMillis = this.getLong(PulsarSinkOptions.PULSAR_WRITE_TRANSACTION_TIMEOUT);
    private final long topicMetadataRefreshInterval = this.getLong(PulsarSinkOptions.PULSAR_TOPIC_METADATA_REFRESH_INTERVAL);
    private final int partitionSwitchSize = this.getInteger(PulsarSinkOptions.PULSAR_BATCHING_MAX_MESSAGES);
    private final MessageKeyHash messageKeyHash = (MessageKeyHash)((Object)this.get(PulsarSinkOptions.PULSAR_MESSAGE_KEY_HASH));
    private final boolean enableSchemaEvolution = (Boolean)this.get(PulsarSinkOptions.PULSAR_WRITE_SCHEMA_EVOLUTION);
    private final int maxRecommitTimes = (Integer)this.get(PulsarSinkOptions.PULSAR_MAX_RECOMMIT_TIMES);
    private final boolean enableMetrics = (Boolean)this.get(PulsarSinkOptions.PULSAR_ENABLE_SINK_METRICS) != false && (Long)this.get(PulsarOptions.PULSAR_STATS_INTERVAL_SECONDS) > 0L;
    private final boolean validateSinkMessageBytes = (Boolean)this.get(PulsarSinkOptions.PULSAR_VALIDATE_SINK_MESSAGE_BYTES);

    public SinkConfiguration(Configuration configuration) {
        super(configuration);
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public long getTransactionTimeoutMillis() {
        return this.transactionTimeoutMillis;
    }

    public long getTopicMetadataRefreshInterval() {
        return this.topicMetadataRefreshInterval;
    }

    public int getPartitionSwitchSize() {
        return this.partitionSwitchSize;
    }

    public MessageKeyHash getMessageKeyHash() {
        return this.messageKeyHash;
    }

    public boolean isEnableSchemaEvolution() {
        return this.enableSchemaEvolution;
    }

    public int getMaxRecommitTimes() {
        return this.maxRecommitTimes;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public boolean isValidateSinkMessageBytes() {
        return this.validateSinkMessageBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SinkConfiguration that = (SinkConfiguration)((Object)o);
        return this.transactionTimeoutMillis == that.transactionTimeoutMillis && this.topicMetadataRefreshInterval == that.topicMetadataRefreshInterval && this.partitionSwitchSize == that.partitionSwitchSize && this.enableSchemaEvolution == that.enableSchemaEvolution && this.messageKeyHash == that.messageKeyHash && this.maxRecommitTimes == that.maxRecommitTimes && this.enableMetrics == that.enableMetrics && this.validateSinkMessageBytes == that.validateSinkMessageBytes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.transactionTimeoutMillis, this.topicMetadataRefreshInterval, this.partitionSwitchSize, this.messageKeyHash, this.enableSchemaEvolution, this.maxRecommitTimes, this.enableMetrics, this.validateSinkMessageBytes});
    }
}

