/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.message;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;

@PublicEvolving
public class PulsarMessageBuilder<T> {
    private byte[] orderingKey;
    private String key;
    private boolean isBase64EncodedKey;
    private long eventTime;
    @Nullable
    private final Schema<T> schema;
    @Nullable
    private final T value;
    private final Map<String, String> properties = new HashMap<String, String>();
    private Long sequenceId;
    private List<String> replicationClusters;
    private boolean disableReplication = false;

    PulsarMessageBuilder(@Nullable Schema<T> schema, @Nullable T value) {
        this.schema = schema;
        this.value = value;
    }

    public PulsarMessageBuilder<T> orderingKey(byte[] orderingKey) {
        this.orderingKey = (byte[])Preconditions.checkNotNull((Object)orderingKey);
        return this;
    }

    public PulsarMessageBuilder<T> key(String key) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.isBase64EncodedKey = false;
        return this;
    }

    public PulsarMessageBuilder<T> keyBytes(byte[] keyBytes) {
        this.key = Base64.getEncoder().encodeToString(keyBytes);
        this.isBase64EncodedKey = true;
        return this;
    }

    public PulsarMessageBuilder<T> eventTime(long eventTime) {
        Preconditions.checkArgument((eventTime > 0L ? 1 : 0) != 0, (Object)"The given event time should above 0.");
        this.eventTime = eventTime;
        return this;
    }

    public PulsarMessageBuilder<T> property(String key, String value) {
        this.properties.put((String)Preconditions.checkNotNull((Object)key), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public PulsarMessageBuilder<T> properties(Map<String, String> properties) {
        this.properties.putAll((Map)Preconditions.checkNotNull(properties));
        return this;
    }

    public PulsarMessageBuilder<T> sequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
        return this;
    }

    public PulsarMessageBuilder<T> replicationClusters(List<String> replicationClusters) {
        this.replicationClusters = (List)Preconditions.checkNotNull(replicationClusters);
        return this;
    }

    public PulsarMessageBuilder<T> disableReplication() {
        this.disableReplication = true;
        return this;
    }

    public PulsarMessage<T> build() {
        return new PulsarMessage<T>(this.orderingKey, this.key, this.isBase64EncodedKey, this.eventTime, this.schema, this.value, this.properties, this.sequenceId, this.replicationClusters, this.disableReplication);
    }
}

