/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.router;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.router.MessageKeyHash;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.impl.Hash;
import org.apache.pulsar.client.util.MathUtils;
import org.apache.pulsar.shade.com.google.common.base.Strings;

@Internal
public class KeyHashTopicRouter<IN>
implements TopicRouter<IN> {
    private static final long serialVersionUID = 2475614648095079804L;
    private final MessageKeyHash messageKeyHash;

    public KeyHashTopicRouter(SinkConfiguration sinkConfiguration) {
        this.messageKeyHash = sinkConfiguration.getMessageKeyHash();
    }

    @Override
    public TopicPartition route(IN in, String key, List<TopicPartition> partitions, PulsarSinkContext context) {
        int topicIndex;
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"You should provide topics for routing topic by message key hash.");
        if (Strings.isNullOrEmpty(key)) {
            topicIndex = ThreadLocalRandom.current().nextInt(partitions.size());
        } else {
            Hash hash = this.messageKeyHash.getHash();
            int code = hash.makeHash(key);
            topicIndex = MathUtils.signSafeMod(code, partitions.size());
        }
        return partitions.get(topicIndex);
    }
}

