/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.router;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.connector.pulsar.sink.PulsarSinkOptions;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;

@PublicEvolving
public enum TopicRoutingMode implements DescribedEnum
{
    ROUND_ROBIN("round-robin", (InlineElement)TextElement.text((String)"The producer will publish messages across all partitions in a round-robin fashion to achieve maximum throughput. Please note that round-robin is not done per individual message but rather it's set to the same boundary of %s, to ensure batching is effective.", (InlineElement[])new InlineElement[]{TextElement.code((String)PulsarSinkOptions.PULSAR_BATCHING_MAX_MESSAGES.key())})),
    MESSAGE_KEY_HASH("message-key-hash", (InlineElement)TextElement.text((String)"If no key is provided, The partitioned producer will randomly pick one single topic partition and publish all the messages into that partition. If a key is provided on the message, the partitioned producer will hash the key and assign the message to a particular partition.")),
    CUSTOM("custom", (InlineElement)TextElement.text((String)"Use custom %s implementation that will be called to determine the partition for a particular message.", (InlineElement[])new InlineElement[]{TextElement.code((String)TopicRouter.class.getSimpleName())}));

    private final String name;
    private final transient InlineElement desc;

    private TopicRoutingMode(String name, InlineElement desc) {
        this.name = name;
        this.desc = desc;
    }

    @Internal
    public InlineElement getDescription() {
        return this.desc;
    }

    public String toString() {
        return this.name;
    }
}

