/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.ChunkMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;

@PublicEvolving
public final class CursorPosition
implements Serializable {
    private static final long serialVersionUID = -802405183307684549L;
    private final Type type;
    private final MessageId messageId;
    private final boolean include;
    private final Long timestamp;

    public CursorPosition(MessageId messageId, boolean include) {
        Preconditions.checkNotNull((Object)messageId, (String)"Message id couldn't be null.");
        this.type = Type.MESSAGE_ID;
        this.messageId = messageId;
        this.include = include;
        this.timestamp = null;
    }

    public CursorPosition(Long timestamp) {
        Preconditions.checkNotNull((Object)timestamp, (String)"Timestamp couldn't be null.");
        this.type = Type.TIMESTAMP;
        this.messageId = null;
        this.include = true;
        this.timestamp = timestamp;
    }

    @Internal
    public void setupSubPosition(PulsarClient client, String topicName, String subscriptionName) throws PulsarClientException {
        try (Consumer<GenericRecord> consumer = client.newConsumer(new AutoConsumeSchema()).topic(topicName).subscriptionName(subscriptionName).subscribe();){
            if (this.type == Type.TIMESTAMP) {
                consumer.seek(this.getActualTimestamp(this.timestamp));
            } else if (this.messageId instanceof ChunkMessageIdImpl) {
                MessageIdAdv msgId = ((ChunkMessageIdImpl)this.messageId).getFirstChunkMessageId();
                consumer.seek(this.getActualMessageId(msgId));
            } else {
                consumer.seek(this.getActualMessageId((MessageIdAdv)this.messageId));
            }
        }
    }

    private MessageId getActualMessageId(MessageIdAdv messageIdImpl) {
        if (this.include) {
            return messageIdImpl;
        }
        return new MessageIdImpl(messageIdImpl.getLedgerId(), messageIdImpl.getEntryId() + 1L, messageIdImpl.getPartitionIndex());
    }

    private long getActualTimestamp(long timestamp) {
        if (this.include) {
            return timestamp;
        }
        return timestamp + 1L;
    }

    public String toString() {
        if (this.type == Type.TIMESTAMP) {
            return "timestamp: " + this.timestamp;
        }
        return "message id: " + this.messageId + " include: " + this.include;
    }

    @Internal
    public static enum Type {
        TIMESTAMP,
        MESSAGE_ID;

    }
}

