/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import java.util.Objects;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

public class MessageIdStopCursor
implements StopCursor {
    private static final long serialVersionUID = -3990454110809274542L;
    private final MessageId messageId;
    private final boolean inclusive;

    public MessageIdStopCursor(MessageId messageId, boolean inclusive) {
        Preconditions.checkArgument((!MessageId.earliest.equals(messageId) ? 1 : 0) != 0, (Object)"MessageId.earliest is not supported.");
        Preconditions.checkArgument((!MessageId.latest.equals(messageId) ? 1 : 0) != 0, (Object)"Use LatestMessageStopCursor instead.");
        this.inclusive = inclusive;
        this.messageId = messageId;
    }

    @Override
    public StopCursor.StopCondition shouldStop(Message<?> message) {
        MessageId current = message.getMessageId();
        return StopCursor.StopCondition.compare(this.messageId, current, this.inclusive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageIdStopCursor that = (MessageIdStopCursor)o;
        return this.inclusive == that.inclusive && Objects.equals(this.messageId, that.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.messageId, this.inclusive);
    }
}

