/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import java.util.Objects;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.pulsar.client.api.Message;

public class PublishTimestampStopCursor
implements StopCursor {
    private static final long serialVersionUID = 4386276745339324527L;
    private final long timestamp;
    private final boolean inclusive;

    public PublishTimestampStopCursor(long timestamp, boolean inclusive) {
        this.timestamp = timestamp;
        this.inclusive = inclusive;
    }

    @Override
    public StopCursor.StopCondition shouldStop(Message<?> message) {
        long publishTime = message.getPublishTime();
        return StopCursor.StopCondition.compare(this.timestamp, publishTime, this.inclusive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishTimestampStopCursor that = (PublishTimestampStopCursor)o;
        return this.timestamp == that.timestamp && this.inclusive == that.inclusive;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.inclusive);
    }
}

