/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader;

import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplitState;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;

public class PulsarRecordEmitter<T>
implements RecordEmitter<Message<byte[]>, T, PulsarPartitionSplitState> {
    private final PulsarDeserializationSchema<T> deserializationSchema;
    private final SourceOutputWrapper<T> sourceOutputWrapper;

    public PulsarRecordEmitter(PulsarDeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
        this.sourceOutputWrapper = new SourceOutputWrapper();
    }

    public void emitRecord(Message<byte[]> element, SourceOutput<T> output, PulsarPartitionSplitState splitState) throws Exception {
        ((SourceOutputWrapper)this.sourceOutputWrapper).setSourceOutput(output);
        ((SourceOutputWrapper)this.sourceOutputWrapper).setTimestamp(element);
        this.deserializationSchema.deserialize(element, this.sourceOutputWrapper);
        splitState.setLatestConsumedId(element.getMessageId());
        element.release();
    }

    private static class SourceOutputWrapper<T>
    implements Collector<T> {
        private SourceOutput<T> sourceOutput;
        private long timestamp;

        private SourceOutputWrapper() {
        }

        public void collect(T record) {
            if (this.timestamp > 0L) {
                this.sourceOutput.collect(record, this.timestamp);
            } else {
                this.sourceOutput.collect(record);
            }
        }

        public void close() {
        }

        private void setSourceOutput(SourceOutput<T> sourceOutput) {
            this.sourceOutput = sourceOutput;
        }

        private void setTimestamp(Message<?> message) {
            this.timestamp = message.getEventTime();
        }
    }
}

