/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.split;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.TxnID;

@Internal
public class PulsarPartitionSplit
implements SourceSplit,
Serializable {
    private static final long serialVersionUID = -6857317360756062625L;
    private final TopicPartition partition;
    private final StopCursor stopCursor;
    @Nullable
    private final MessageId latestConsumedId;
    @Nullable
    private final TxnID uncommittedTransactionId;

    public PulsarPartitionSplit(TopicPartition partition, StopCursor stopCursor) {
        this.partition = (TopicPartition)Preconditions.checkNotNull((Object)partition);
        this.stopCursor = (StopCursor)Preconditions.checkNotNull((Object)stopCursor);
        this.latestConsumedId = null;
        this.uncommittedTransactionId = null;
    }

    public PulsarPartitionSplit(TopicPartition partition, StopCursor stopCursor, @Nullable MessageId latestConsumedId, @Nullable TxnID uncommittedTransactionId) {
        this.partition = (TopicPartition)Preconditions.checkNotNull((Object)partition);
        this.stopCursor = (StopCursor)Preconditions.checkNotNull((Object)stopCursor);
        this.latestConsumedId = latestConsumedId;
        this.uncommittedTransactionId = uncommittedTransactionId;
    }

    public String splitId() {
        return this.partition.toString();
    }

    public TopicPartition getPartition() {
        return this.partition;
    }

    public StopCursor getStopCursor() {
        return this.stopCursor;
    }

    @Nullable
    public MessageId getLatestConsumedId() {
        return this.latestConsumedId;
    }

    @Nullable
    public TxnID getUncommittedTransactionId() {
        return this.uncommittedTransactionId;
    }

    public void open(PulsarClient client) throws Exception {
        this.stopCursor.open(client, this.partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarPartitionSplit that = (PulsarPartitionSplit)o;
        return this.partition.equals(that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.partition);
    }

    public String toString() {
        return "PulsarPartitionSplit{partition=" + this.partition + '}';
    }
}

