/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.sink;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.flink.connector.pulsar.table.sink.PulsarTableSerializationSchema;
import org.apache.flink.connector.pulsar.table.sink.PulsarWritableMetadata;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

public class PulsarTableSerializationSchemaFactory {
    private final DataType physicalDataType;
    @Nullable
    private final EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat;
    private final int[] keyProjection;
    private final EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat;
    private final int[] valueProjection;
    private List<String> writableMetadataKeys;
    private final boolean upsertMode;

    public PulsarTableSerializationSchemaFactory(DataType physicalDataType, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, int[] keyProjection, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] valueProjection, boolean upsertMode) {
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType);
        this.keyEncodingFormat = keyEncodingFormat;
        this.keyProjection = (int[])Preconditions.checkNotNull((Object)keyProjection);
        this.valueEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(valueEncodingFormat);
        this.valueProjection = (int[])Preconditions.checkNotNull((Object)valueProjection);
        this.writableMetadataKeys = Collections.emptyList();
        this.upsertMode = upsertMode;
    }

    public PulsarSerializationSchema<RowData> createPulsarSerializationSchema(DynamicTableSink.Context context) {
        SerializationSchema<RowData> keySerialization = this.createSerialization(context, this.keyEncodingFormat, this.keyProjection, null);
        SerializationSchema<RowData> valueSerialization = this.createSerialization(context, this.valueEncodingFormat, this.valueProjection, null);
        List physicalChildren = this.physicalDataType.getLogicalType().getChildren();
        RowData.FieldGetter[] keyFieldGetters = this.getFieldGetters(physicalChildren, this.keyProjection);
        RowData.FieldGetter[] valueFieldGetters = this.getFieldGetters(physicalChildren, this.valueProjection);
        PulsarWritableMetadata writableMetadata = new PulsarWritableMetadata(this.writableMetadataKeys, physicalChildren.size());
        return new PulsarTableSerializationSchema(keySerialization, keyFieldGetters, valueSerialization, valueFieldGetters, writableMetadata, this.upsertMode);
    }

    @Nullable
    private SerializationSchema<RowData> createSerialization(DynamicTableSink.Context context, @Nullable EncodingFormat<SerializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = Projection.of((int[])projection).project(this.physicalDataType);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (SerializationSchema)format.createRuntimeEncoder(context, physicalFormatDataType);
    }

    private RowData.FieldGetter[] getFieldGetters(List<LogicalType> physicalChildren, int[] projection) {
        return (RowData.FieldGetter[])Arrays.stream(projection).mapToObj(targetField -> RowData.createFieldGetter((LogicalType)((LogicalType)physicalChildren.get(targetField)), (int)targetField)).toArray(RowData.FieldGetter[]::new);
    }

    public void setWritableMetadataKeys(List<String> writableMetadataKeys) {
        this.writableMetadataKeys = writableMetadataKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarTableSerializationSchemaFactory that = (PulsarTableSerializationSchemaFactory)o;
        return Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.keyEncodingFormat, that.keyEncodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Objects.equals(this.valueEncodingFormat, that.valueEncodingFormat) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.writableMetadataKeys, that.writableMetadataKeys) && Objects.equals(this.upsertMode, that.upsertMode);
    }

    public int hashCode() {
        int result = Objects.hash(this.physicalDataType, this.keyEncodingFormat, this.valueEncodingFormat, this.writableMetadataKeys, this.upsertMode);
        result = 31 * result + Arrays.hashCode(this.keyProjection);
        result = 31 * result + Arrays.hashCode(this.valueProjection);
        return result;
    }
}

