/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.source;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.connector.pulsar.table.source.PulsarReadableMetadata;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;

public class PulsarRowDataConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int physicalArity;
    private final int[] keyProjection;
    private final int[] valueProjection;
    private final PulsarReadableMetadata readableMetadata;
    private final boolean upsertMode;

    public PulsarRowDataConverter(int physicalArity, int[] keyProjection, int[] valueProjection, PulsarReadableMetadata readableMetadata, boolean upsertMode) {
        this.physicalArity = physicalArity;
        this.keyProjection = keyProjection;
        this.valueProjection = valueProjection;
        this.readableMetadata = readableMetadata;
        this.upsertMode = upsertMode;
    }

    public void projectToProducedRowAndCollect(Message<?> message, List<RowData> keyRowDataList, List<RowData> valueRowDataList, Collector<RowData> collector) {
        if (this.hasNoKeyProjection()) {
            valueRowDataList.forEach(valueRow -> this.emitRow(null, (GenericRowData)valueRow, collector, message));
        } else {
            valueRowDataList.forEach(valueRow -> keyRowDataList.forEach(keyRow -> this.emitRow((GenericRowData)keyRow, (GenericRowData)valueRow, collector, message)));
        }
    }

    public void projectToRowWithNullValueRow(Message<?> message, List<RowData> keyRowDataList, Collector<RowData> collector) {
        for (RowData keyRow : keyRowDataList) {
            this.emitRow((GenericRowData)keyRow, null, collector, message);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void emitRow(@Nullable GenericRowData physicalKeyRow, @Nullable GenericRowData physicalValueRow, Collector<RowData> collector, Message<?> message) {
        RowKind rowKind;
        if (physicalValueRow == null) {
            if (!this.upsertMode) throw new DeserializationException("Invalid null value received in non-upsert mode. Could not to set row kind for output record.upsert mode is not supported yet.");
            rowKind = RowKind.DELETE;
        } else {
            rowKind = physicalValueRow.getRowKind();
        }
        GenericRowData producedRow = new GenericRowData(rowKind, this.physicalArity + this.readableMetadata.getConnectorMetadataArity());
        for (int valuePos = 0; valuePos < this.valueProjection.length; ++valuePos) {
            producedRow.setField(this.valueProjection[valuePos], physicalValueRow.getField(valuePos));
        }
        for (int keyPos = 0; keyPos < this.keyProjection.length; ++keyPos) {
            assert (physicalKeyRow != null);
            producedRow.setField(this.keyProjection[keyPos], physicalKeyRow.getField(keyPos));
        }
        this.readableMetadata.appendProducedRowWithMetadata(producedRow, this.physicalArity, message);
        collector.collect((Object)producedRow);
    }

    private boolean hasNoKeyProjection() {
        return this.keyProjection.length == 0;
    }
}

