/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonReader<T>
implements SchemaReader<T> {
    private final Class<T> pojo;
    private final ObjectReader objectReader;
    private static final Logger log = LoggerFactory.getLogger(JacksonJsonReader.class);

    public JacksonJsonReader(ObjectMapper objectMapper, Class<T> pojo) {
        this.pojo = pojo;
        this.objectReader = pojo != null ? objectMapper.readerFor(pojo) : objectMapper.reader();
    }

    @Override
    public T read(byte[] bytes, int offset, int length) {
        try {
            return this.objectReader.readValue(bytes, offset, length);
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public T read(InputStream inputStream) {
        try {
            T t = this.objectReader.readValue(inputStream, this.pojo);
            return t;
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("JsonReader close inputStream close error", (Throwable)e);
            }
        }
    }
}

