/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.cms;

import org.apache.pulsar.shade.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.pulsar.shade.org.bouncycastle.cert.X509CertificateHolder;
import org.apache.pulsar.shade.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.apache.pulsar.shade.org.bouncycastle.operator.ContentVerifier;
import org.apache.pulsar.shade.org.bouncycastle.operator.ContentVerifierProvider;
import org.apache.pulsar.shade.org.bouncycastle.operator.DigestCalculator;
import org.apache.pulsar.shade.org.bouncycastle.operator.DigestCalculatorProvider;
import org.apache.pulsar.shade.org.bouncycastle.operator.OperatorCreationException;
import org.apache.pulsar.shade.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class SignerInformationVerifier {
    private ContentVerifierProvider verifierProvider;
    private DigestCalculatorProvider digestProvider;
    private SignatureAlgorithmIdentifierFinder sigAlgorithmFinder;
    private CMSSignatureAlgorithmNameGenerator sigNameGenerator;

    public SignerInformationVerifier(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, ContentVerifierProvider contentVerifierProvider, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigNameGenerator = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgorithmFinder = signatureAlgorithmIdentifierFinder;
        this.verifierProvider = contentVerifierProvider;
        this.digestProvider = digestCalculatorProvider;
    }

    public boolean hasAssociatedCertificate() {
        return this.verifierProvider.hasAssociatedCertificate();
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.verifierProvider.getAssociatedCertificate();
    }

    public ContentVerifier getContentVerifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
        String string = this.sigNameGenerator.getSignatureName(algorithmIdentifier2, algorithmIdentifier);
        AlgorithmIdentifier algorithmIdentifier3 = this.sigAlgorithmFinder.find(string);
        return this.verifierProvider.get(new AlgorithmIdentifier(algorithmIdentifier3.getAlgorithm(), algorithmIdentifier.getParameters()));
    }

    public DigestCalculator getDigestCalculator(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return this.digestProvider.get(algorithmIdentifier);
    }
}

