/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.http.RepeatableInputStreamRequestEntity;
import com.cloudera.com.amazonaws.util.FakeIOException;
import com.cloudera.com.amazonaws.util.HttpUtils;
import com.cloudera.org.apache.http.HttpEntity;
import com.cloudera.org.apache.http.client.methods.HttpDelete;
import com.cloudera.org.apache.http.client.methods.HttpGet;
import com.cloudera.org.apache.http.client.methods.HttpHead;
import com.cloudera.org.apache.http.client.methods.HttpPatch;
import com.cloudera.org.apache.http.client.methods.HttpPost;
import com.cloudera.org.apache.http.client.methods.HttpPut;
import com.cloudera.org.apache.http.client.methods.HttpRequestBase;
import com.cloudera.org.apache.http.entity.BufferedHttpEntity;
import com.cloudera.org.apache.http.entity.StringEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;

class HttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";

    HttpRequestFactory() {
    }

    HttpRequestBase createHttpRequest(Request<?> request, ClientConfiguration clientConfiguration, ExecutionContext context) throws FakeIOException {
        HttpRequestBase httpRequest;
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        boolean requestHasNoPayload = request.getContent() != null;
        boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        if (request.getHttpMethod() == HttpMethodName.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() == null && encodedParams != null) {
                postMethod.setEntity(this.newStringEntity(encodedParams));
            } else {
                postMethod.setEntity(new RepeatableInputStreamRequestEntity(request));
            }
            httpRequest = postMethod;
        } else if (request.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut putMethod;
            httpRequest = putMethod = new HttpPut(uri);
            putMethod.getParams().setParameter("http.protocol.expect-continue", true);
            if (request.getContent() != null) {
                HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    entity = this.newBufferedHttpEntity(entity);
                }
                putMethod.setEntity(entity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.PATCH) {
            HttpPatch patchMethod = new HttpPatch(uri);
            httpRequest = patchMethod;
            if (request.getContent() != null) {
                HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    entity = this.newBufferedHttpEntity(entity);
                }
                patchMethod.setEntity(entity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.GET) {
            httpRequest = new HttpGet(uri);
        } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
            httpRequest = new HttpHead(uri);
        } else {
            throw new AmazonClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
        }
        this.configureHeaders(httpRequest, request, context, clientConfiguration);
        return httpRequest;
    }

    private void configureHeaders(HttpRequestBase httpRequest, Request<?> request, ExecutionContext context, ClientConfiguration clientConfiguration) {
        URI endpoint = request.getEndpoint();
        String hostHeader = endpoint.getHost();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        httpRequest.addHeader("Host", hostHeader);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
        if (context != null && context.getContextUserAgent() != null) {
            httpRequest.addHeader("User-Agent", this.createUserAgentString(clientConfiguration, context.getContextUserAgent()));
        }
    }

    private String createUserAgentString(ClientConfiguration clientConfiguration, String contextUserAgent) {
        if (clientConfiguration.getUserAgent().contains(contextUserAgent)) {
            return clientConfiguration.getUserAgent();
        }
        return clientConfiguration.getUserAgent() + " " + contextUserAgent;
    }

    private HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    private HttpEntity newBufferedHttpEntity(HttpEntity entity) throws FakeIOException {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (FakeIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }
}

