/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.ser;

import com.cloudera.com.fasterxml.jackson.core.JsonGenerator;
import com.cloudera.com.fasterxml.jackson.core.io.SerializedString;
import com.cloudera.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.cloudera.com.fasterxml.jackson.databind.BeanProperty;
import com.cloudera.com.fasterxml.jackson.databind.JavaType;
import com.cloudera.com.fasterxml.jackson.databind.JsonMappingException;
import com.cloudera.com.fasterxml.jackson.databind.JsonNode;
import com.cloudera.com.fasterxml.jackson.databind.JsonSerializer;
import com.cloudera.com.fasterxml.jackson.databind.PropertyName;
import com.cloudera.com.fasterxml.jackson.databind.SerializerProvider;
import com.cloudera.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.cloudera.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.cloudera.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.cloudera.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.cloudera.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.cloudera.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.cloudera.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.cloudera.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.cloudera.com.fasterxml.jackson.databind.node.ObjectNode;
import com.cloudera.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.cloudera.com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanPropertyWriter;
import com.cloudera.com.fasterxml.jackson.databind.util.Annotations;
import com.cloudera.com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;

public class BeanPropertyWriter
implements BeanProperty {
    public static final Object MARKER_FOR_EMPTY = new Object();
    protected final AnnotatedMember _member;
    protected final Annotations _contextAnnotations;
    protected final JavaType _declaredType;
    protected final Method _accessorMethod;
    protected final Field _field;
    protected HashMap<Object, Object> _internalSettings;
    protected final SerializedString _name;
    protected final PropertyName _wrapperName;
    protected final JavaType _cfgSerializationType;
    protected JsonSerializer<Object> _serializer;
    protected JsonSerializer<Object> _nullSerializer;
    protected PropertySerializerMap _dynamicSerializers;
    protected final boolean _suppressNulls;
    protected final Object _suppressableValue;
    protected final Class<?>[] _includeInViews;
    protected TypeSerializer _typeSerializer;
    protected JavaType _nonTrivialBaseType;
    protected final boolean _isRequired;

    public BeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, AnnotatedMember annotatedMember, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, boolean bl, Object object) {
        this._member = annotatedMember;
        this._contextAnnotations = annotations;
        this._name = new SerializedString(beanPropertyDefinition.getName());
        this._wrapperName = beanPropertyDefinition.getWrapperName();
        this._declaredType = javaType;
        this._serializer = jsonSerializer;
        this._dynamicSerializers = jsonSerializer == null ? PropertySerializerMap.emptyMap() : null;
        this._typeSerializer = typeSerializer;
        this._cfgSerializationType = javaType2;
        this._isRequired = beanPropertyDefinition.isRequired();
        if (annotatedMember instanceof AnnotatedField) {
            this._accessorMethod = null;
            this._field = (Field)annotatedMember.getMember();
        } else if (annotatedMember instanceof AnnotatedMethod) {
            this._accessorMethod = (Method)annotatedMember.getMember();
            this._field = null;
        } else {
            throw new IllegalArgumentException("Can not pass member of type " + annotatedMember.getClass().getName());
        }
        this._suppressNulls = bl;
        this._suppressableValue = object;
        this._includeInViews = beanPropertyDefinition.findViews();
        this._nullSerializer = null;
    }

    protected BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter) {
        this(beanPropertyWriter, beanPropertyWriter._name);
    }

    protected BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, SerializedString serializedString) {
        this._name = serializedString;
        this._wrapperName = beanPropertyWriter._wrapperName;
        this._member = beanPropertyWriter._member;
        this._contextAnnotations = beanPropertyWriter._contextAnnotations;
        this._declaredType = beanPropertyWriter._declaredType;
        this._accessorMethod = beanPropertyWriter._accessorMethod;
        this._field = beanPropertyWriter._field;
        this._serializer = beanPropertyWriter._serializer;
        this._nullSerializer = beanPropertyWriter._nullSerializer;
        if (beanPropertyWriter._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(beanPropertyWriter._internalSettings);
        }
        this._cfgSerializationType = beanPropertyWriter._cfgSerializationType;
        this._dynamicSerializers = beanPropertyWriter._dynamicSerializers;
        this._suppressNulls = beanPropertyWriter._suppressNulls;
        this._suppressableValue = beanPropertyWriter._suppressableValue;
        this._includeInViews = beanPropertyWriter._includeInViews;
        this._typeSerializer = beanPropertyWriter._typeSerializer;
        this._nonTrivialBaseType = beanPropertyWriter._nonTrivialBaseType;
        this._isRequired = beanPropertyWriter._isRequired;
    }

    public BeanPropertyWriter rename(NameTransformer nameTransformer) {
        String string = nameTransformer.transform(this._name.getValue());
        if (string.equals(this._name.toString())) {
            return this;
        }
        return new BeanPropertyWriter(this, new SerializedString(string));
    }

    public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
        if (this._serializer != null && this._serializer != jsonSerializer) {
            throw new IllegalStateException("Can not override serializer");
        }
        this._serializer = jsonSerializer;
    }

    public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
        if (this._nullSerializer != null && this._nullSerializer != jsonSerializer) {
            throw new IllegalStateException("Can not override null serializer");
        }
        this._nullSerializer = jsonSerializer;
    }

    public BeanPropertyWriter unwrappingWriter(NameTransformer nameTransformer) {
        return new UnwrappingBeanPropertyWriter(this, nameTransformer);
    }

    public void setNonTrivialBaseType(JavaType javaType) {
        this._nonTrivialBaseType = javaType;
    }

    @Override
    public String getName() {
        return this._name.getValue();
    }

    @Override
    public JavaType getType() {
        return this._declaredType;
    }

    @Override
    public PropertyName getWrapperName() {
        return this._wrapperName;
    }

    @Override
    public boolean isRequired() {
        return this._isRequired;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._member.getAnnotation(clazz);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
        return this._contextAnnotations.get(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._member;
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor) throws JsonMappingException {
        if (jsonObjectFormatVisitor != null) {
            if (this.isRequired()) {
                jsonObjectFormatVisitor.property(this);
            } else {
                jsonObjectFormatVisitor.optionalProperty(this);
            }
        }
    }

    public Object getInternalSetting(Object object) {
        if (this._internalSettings == null) {
            return null;
        }
        return this._internalSettings.get(object);
    }

    public Object setInternalSetting(Object object, Object object2) {
        if (this._internalSettings == null) {
            this._internalSettings = new HashMap();
        }
        return this._internalSettings.put(object, object2);
    }

    public Object removeInternalSetting(Object object) {
        Object object2 = null;
        if (this._internalSettings != null) {
            object2 = this._internalSettings.remove(object);
            if (this._internalSettings.size() == 0) {
                this._internalSettings = null;
            }
        }
        return object2;
    }

    public SerializedString getSerializedName() {
        return this._name;
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public boolean hasNullSerializer() {
        return this._nullSerializer != null;
    }

    public boolean willSuppressNulls() {
        return this._suppressNulls;
    }

    public JsonSerializer<Object> getSerializer() {
        return this._serializer;
    }

    public JavaType getSerializationType() {
        return this._cfgSerializationType;
    }

    public Class<?> getRawSerializationType() {
        return this._cfgSerializationType == null ? null : this._cfgSerializationType.getRawClass();
    }

    public Class<?> getPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getReturnType();
        }
        return this._field.getType();
    }

    public Type getGenericPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getGenericReturnType();
        }
        return this._field.getGenericType();
    }

    public Class<?>[] getViews() {
        return this._includeInViews;
    }

    @Deprecated
    protected boolean isRequired(AnnotationIntrospector annotationIntrospector) {
        return this._isRequired;
    }

    public void depositSchemaProperty(ObjectNode objectNode, SerializerProvider serializerProvider) throws JsonMappingException {
        JavaType javaType = this.getSerializationType();
        Class<?> clazz = javaType == null ? this.getGenericPropertyType() : javaType.getRawClass();
        JsonSerializer<Object> jsonSerializer = this.getSerializer();
        if (jsonSerializer == null) {
            Class<?> clazz2 = this.getRawSerializationType();
            if (clazz2 == null) {
                clazz2 = this.getPropertyType();
            }
            jsonSerializer = serializerProvider.findValueSerializer(clazz2, (BeanProperty)this);
        }
        boolean bl = !this.isRequired();
        JsonNode jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, clazz, bl) : JsonSchema.getDefaultSchemaNode();
        objectNode.put(this.getName(), jsonNode);
    }

    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this.get(object);
        if (object2 == null) {
            if (this._nullSerializer != null) {
                jsonGenerator.writeFieldName(this._name);
                this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? jsonSerializer.isEmpty(object2) : this._suppressableValue.equals(object2))) {
            return;
        }
        if (object2 == object) {
            this._handleSelfReference(object, jsonSerializer);
        }
        jsonGenerator.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    public void serializeAsColumn(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this.get(object);
        if (object2 == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonGenerator.writeNull();
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (jsonSerializer.isEmpty(object2)) {
                    this.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                    return;
                }
            } else if (this._suppressableValue.equals(object2)) {
                this.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                return;
            }
        }
        if (object2 == object) {
            this._handleSelfReference(object, jsonSerializer);
        }
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    public void serializeAsPlaceholder(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if (this._nullSerializer != null) {
            this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeNull();
        }
    }

    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult;
        if (this._nonTrivialBaseType != null) {
            JavaType javaType = serializerProvider.constructSpecializedType(this._nonTrivialBaseType, clazz);
            serializerAndMapResult = propertySerializerMap.findAndAddSerializer(javaType, serializerProvider, (BeanProperty)this);
        } else {
            serializerAndMapResult = propertySerializerMap.findAndAddSerializer(clazz, serializerProvider, (BeanProperty)this);
        }
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    public final Object get(Object object) throws Exception {
        if (this._accessorMethod != null) {
            return this._accessorMethod.invoke(object, new Object[0]);
        }
        return this._field.get(object);
    }

    protected void _handleSelfReference(Object object, JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        if (jsonSerializer.usesObjectId()) {
            return;
        }
        throw new JsonMappingException("Direct self-reference leading to cycle");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("property '").append(this.getName()).append("' (");
        if (this._accessorMethod != null) {
            stringBuilder.append("via method ").append(this._accessorMethod.getDeclaringClass().getName()).append("#").append(this._accessorMethod.getName());
        } else {
            stringBuilder.append("field \"").append(this._field.getDeclaringClass().getName()).append("#").append(this._field.getName());
        }
        if (this._serializer == null) {
            stringBuilder.append(", no static serializer");
        } else {
            stringBuilder.append(", static serializer of type " + this._serializer.getClass().getName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

