/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.ser.std;

import com.cloudera.com.fasterxml.jackson.annotation.JsonFormat;
import com.cloudera.com.fasterxml.jackson.core.JsonGenerationException;
import com.cloudera.com.fasterxml.jackson.core.JsonGenerator;
import com.cloudera.com.fasterxml.jackson.core.JsonParser;
import com.cloudera.com.fasterxml.jackson.databind.BeanProperty;
import com.cloudera.com.fasterxml.jackson.databind.JavaType;
import com.cloudera.com.fasterxml.jackson.databind.JsonMappingException;
import com.cloudera.com.fasterxml.jackson.databind.JsonNode;
import com.cloudera.com.fasterxml.jackson.databind.JsonSerializer;
import com.cloudera.com.fasterxml.jackson.databind.SerializationFeature;
import com.cloudera.com.fasterxml.jackson.databind.SerializerProvider;
import com.cloudera.com.fasterxml.jackson.databind.introspect.Annotated;
import com.cloudera.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.cloudera.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.cloudera.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.cloudera.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.cloudera.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.cloudera.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.cloudera.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> clazz, boolean bl, DateFormat dateFormat) {
        super(clazz);
        this._useTimestamp = bl;
        this._customFormat = dateFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value;
        if (beanProperty != null && (value = serializerProvider.getAnnotationIntrospector().findFormat((Annotated)beanProperty.getMember())) != null) {
            if (value.getShape().isNumeric()) {
                return this.withFormat(true, null);
            }
            TimeZone timeZone = value.getTimeZone();
            String string = value.getPattern();
            if (string.length() > 0) {
                Locale locale = value.getLocale();
                if (locale == null) {
                    locale = serializerProvider.getLocale();
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                if (timeZone == null) {
                    timeZone = serializerProvider.getTimeZone();
                }
                simpleDateFormat.setTimeZone(timeZone);
                return this.withFormat(false, simpleDateFormat);
            }
            if (timeZone != null) {
                DateFormat dateFormat = serializerProvider.getConfig().getDateFormat();
                if (dateFormat.getClass() == StdDateFormat.class) {
                    dateFormat = StdDateFormat.getISO8601Format(timeZone);
                } else {
                    dateFormat = (DateFormat)dateFormat.clone();
                    dateFormat.setTimeZone(timeZone);
                }
                return this.withFormat(false, dateFormat);
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty(T t) {
        return t == null || this._timestamp(t) == 0L;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        boolean bl = this._useTimestamp;
        if (!bl && this._customFormat == null) {
            bl = serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return this.createSchemaNode(bl ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        boolean bl = this._useTimestamp;
        if (!bl && this._customFormat == null) {
            bl = jsonFormatVisitorWrapper.getProvider().isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        if (bl) {
            JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
            if (jsonIntegerFormatVisitor != null) {
                jsonIntegerFormatVisitor.numberType(JsonParser.NumberType.LONG);
                jsonIntegerFormatVisitor.format(JsonValueFormat.UTC_MILLISEC);
            }
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (jsonStringFormatVisitor != null) {
                jsonStringFormatVisitor.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;
}

