/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Protocol;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.services.s3.AmazonS3;
import com.cloudera.com.amazonaws.services.s3.AmazonS3Client;
import com.cloudera.com.amazonaws.services.s3.S3ClientOptions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
interface S3ClientFactory {
    public AmazonS3 createS3Client(URI var1, URI var2) throws IOException;

    public static class DefaultS3ClientFactory
    extends Configured
    implements S3ClientFactory {
        private static final Logger LOG = S3AFileSystem.LOG;

        @Override
        public AmazonS3 createS3Client(URI name, URI uri) throws IOException {
            Configuration conf = this.getConf();
            AWSCredentialProviderList credentials = S3AUtils.createAWSCredentialProviderSet(name, conf, uri);
            ClientConfiguration awsConf = new ClientConfiguration();
            DefaultS3ClientFactory.initConnectionSettings(conf, awsConf);
            DefaultS3ClientFactory.initProxySupport(conf, awsConf);
            DefaultS3ClientFactory.initUserAgent(conf, awsConf);
            return DefaultS3ClientFactory.createAmazonS3Client(conf, credentials, awsConf);
        }

        private static void initConnectionSettings(Configuration conf, ClientConfiguration awsConf) {
            awsConf.setMaxConnections(S3AUtils.intOption(conf, "fs.s3a.connection.maximum", 15, 1));
            boolean secureConnections = conf.getBoolean("fs.s3a.connection.ssl.enabled", true);
            awsConf.setProtocol(secureConnections ? Protocol.HTTPS : Protocol.HTTP);
            awsConf.setMaxErrorRetry(S3AUtils.intOption(conf, "fs.s3a.attempts.maximum", 20, 0));
            awsConf.setConnectionTimeout(S3AUtils.intOption(conf, "fs.s3a.connection.establish.timeout", 50000, 0));
            awsConf.setSocketTimeout(S3AUtils.intOption(conf, "fs.s3a.connection.timeout", 200000, 0));
            int sockSendBuffer = S3AUtils.intOption(conf, "fs.s3a.socket.send.buffer", 8192, 2048);
            int sockRecvBuffer = S3AUtils.intOption(conf, "fs.s3a.socket.recv.buffer", 8192, 2048);
            awsConf.setSocketBufferSizeHints(sockSendBuffer, sockRecvBuffer);
            String signerOverride = conf.getTrimmed("fs.s3a.signing-algorithm", "");
            if (!signerOverride.isEmpty()) {
                LOG.debug("Signer override = {}", (Object)signerOverride);
                awsConf.setSignerOverride(signerOverride);
            }
        }

        private static void initProxySupport(Configuration conf, ClientConfiguration awsConf) throws IllegalArgumentException {
            String proxyHost = conf.getTrimmed("fs.s3a.proxy.host", "");
            int proxyPort = conf.getInt("fs.s3a.proxy.port", -1);
            if (!proxyHost.isEmpty()) {
                awsConf.setProxyHost(proxyHost);
                if (proxyPort >= 0) {
                    awsConf.setProxyPort(proxyPort);
                } else if (conf.getBoolean("fs.s3a.connection.ssl.enabled", true)) {
                    LOG.warn("Proxy host set without port. Using HTTPS default 443");
                    awsConf.setProxyPort(443);
                } else {
                    LOG.warn("Proxy host set without port. Using HTTP default 80");
                    awsConf.setProxyPort(80);
                }
                String proxyUsername = conf.getTrimmed("fs.s3a.proxy.username");
                String proxyPassword = conf.getTrimmed("fs.s3a.proxy.password");
                if (proxyUsername == null != (proxyPassword == null)) {
                    String msg = "Proxy error: fs.s3a.proxy.username or fs.s3a.proxy.password set without the other.";
                    LOG.error(msg);
                    throw new IllegalArgumentException(msg);
                }
                awsConf.setProxyUsername(proxyUsername);
                awsConf.setProxyPassword(proxyPassword);
                awsConf.setProxyDomain(conf.getTrimmed("fs.s3a.proxy.domain"));
                awsConf.setProxyWorkstation(conf.getTrimmed("fs.s3a.proxy.workstation"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using proxy server {}:{} as user {} with password {} on domain {} as workstation {}", new Object[]{awsConf.getProxyHost(), awsConf.getProxyPort(), String.valueOf(awsConf.getProxyUsername()), awsConf.getProxyPassword(), awsConf.getProxyDomain(), awsConf.getProxyWorkstation()});
                }
            } else if (proxyPort >= 0) {
                String msg = "Proxy error: fs.s3a.proxy.port set without fs.s3a.proxy.host";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }

        private static void initUserAgent(Configuration conf, ClientConfiguration awsConf) {
            String userAgent = "Hadoop " + VersionInfo.getVersion();
            String userAgentPrefix = conf.getTrimmed("fs.s3a.user.agent.prefix", "");
            if (!userAgentPrefix.isEmpty()) {
                userAgent = userAgentPrefix + ", " + userAgent;
            }
            LOG.debug("Using User-Agent: {}", (Object)userAgent);
            awsConf.setUserAgent(userAgent);
        }

        private static AmazonS3 createAmazonS3Client(Configuration conf, AWSCredentialsProvider credentials, ClientConfiguration awsConf) throws IllegalArgumentException {
            AmazonS3Client s3 = new AmazonS3Client(credentials, awsConf);
            String endPoint = conf.getTrimmed("fs.s3a.endpoint", "");
            if (!endPoint.isEmpty()) {
                try {
                    s3.setEndpoint(endPoint);
                }
                catch (IllegalArgumentException e) {
                    String msg = "Incorrect endpoint: " + e.getMessage();
                    LOG.error(msg);
                    throw new IllegalArgumentException(msg, e);
                }
            }
            DefaultS3ClientFactory.enablePathStyleAccessIfRequired(s3, conf);
            return s3;
        }

        private static void enablePathStyleAccessIfRequired(AmazonS3 s3, Configuration conf) {
            boolean pathStyleAccess = conf.getBoolean("fs.s3a.path.style.access", false);
            if (pathStyleAccess) {
                LOG.debug("Enabling path style access!");
                s3.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(true));
            }
        }
    }
}

