/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.jsontype;

import com.cloudera.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.cloudera.com.fasterxml.jackson.core.JsonParser;
import com.cloudera.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.com.fasterxml.jackson.core.JsonToken;
import com.cloudera.com.fasterxml.jackson.databind.BeanProperty;
import com.cloudera.com.fasterxml.jackson.databind.DeserializationContext;
import com.cloudera.com.fasterxml.jackson.databind.JavaType;
import com.cloudera.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import java.io.IOException;

public abstract class TypeDeserializer {
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public abstract Class<?> getDefaultImpl();

    public abstract Object deserializeTypedFromObject(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public abstract Object deserializeTypedFromArray(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public abstract Object deserializeTypedFromScalar(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public abstract Object deserializeTypedFromAny(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public static Object deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) throws IOException, JsonProcessingException {
        return TypeDeserializer.deserializeIfNatural(jsonParser, deserializationContext, javaType.getRawClass());
    }

    public static Object deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext, Class<?> clazz) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            case VALUE_STRING: {
                if (!clazz.isAssignableFrom(String.class)) break;
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                if (!clazz.isAssignableFrom(Integer.class)) break;
                return jsonParser.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (!clazz.isAssignableFrom(Double.class)) break;
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                if (!clazz.isAssignableFrom(Boolean.class)) break;
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                if (!clazz.isAssignableFrom(Boolean.class)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

