/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.BasicSessionCredentials;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class TemporaryAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider";
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;

    public TemporaryAWSCredentialsProvider(URI uri, Configuration conf) {
        this.accessKey = conf.get("fs.s3a.access.key", null);
        this.secretKey = conf.get("fs.s3a.secret.key", null);
        this.sessionToken = conf.get("fs.s3a.session.token", null);
    }

    @Override
    public AWSCredentials getCredentials() {
        if (!(StringUtils.isEmpty((String)this.accessKey) || StringUtils.isEmpty((String)this.secretKey) || StringUtils.isEmpty((String)this.sessionToken))) {
            return new BasicSessionCredentials(this.accessKey, this.secretKey, this.sessionToken);
        }
        throw new CredentialInitializationException("Access key, secret key or session token is unset");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

